/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.tree;

import com.sas.dataselectors.filters.AbstractFilterLogicBaseNode;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.ConditionalRelationType;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterLogicTree;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicBaseNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.tree.LogicalConditionNode;
import com.sas.dataselectors.filters.tree.NotNode;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.MutableTreeNode;

public class StepModelToLogicTreeTransform
implements TransformInterface {
    FilterObjectFactoryInterface factory;
    FilterItemListInterface filterItemList;
    DataItem dataItem;

    public StepModelToLogicTreeTransform() {
        this(null, null);
    }

    public StepModelToLogicTreeTransform(FilterObjectFactoryInterface factory) {
        this(factory, null);
    }

    public StepModelToLogicTreeTransform(FilterObjectFactoryInterface factory, FilterItemListInterface filterItemList) {
        this.factory = factory;
        this.filterItemList = filterItemList;
    }

    public FilterObjectFactoryInterface getFactory() {
        return this.factory;
    }

    public void setFactory(FilterObjectFactoryInterface factory) {
        this.factory = factory;
    }

    public DataItem getDataItem() {
        return this.dataItem;
    }

    public void setDataItem(DataItem dataItem) {
        this.dataItem = dataItem;
    }

    public Object transform(Object o) throws TransformException {
        DefaultFilterLogicTree tree = null;
        if (o != null) {
            if (o instanceof DataItem) {
                this.setDataItem((DataItem)o);
                o = ((BaseFilterObjectFactory)this.factory).getFilterStep((DataItem)o);
            }
            if (o != null && !(o instanceof StepInterface)) {
                throw new IllegalArgumentException("Invalid class type! You must specify a StepInterface.");
            }
            CommonLoggerInterface log = LoggerRepository2.getLogger((String)this.getClass().getName(), null);
            StepInterface item = (StepInterface)o;
            log.debug("Beginning transform of StepInterface");
            AbstractFilterLogicBaseNode root = this.transformStep(item);
            log.debug("Transform complete, constructing tree...");
            boolean modifiable = true;
            tree = new DefaultFilterLogicTree((FilterLogicBaseNodeInterface)root, modifiable);
        }
        return tree;
    }

    protected AbstractFilterLogicBaseNode transformStep(StepInterface step) {
        AbstractFilterLogicBaseNode newNode = null;
        if (step instanceof CompoundStep) {
            newNode = this.transformStep((CompoundStep)step);
        } else if (step != null) {
            FilterLogicTestNodeInterface testNode = this.factory.newTestNode(this.dataItem, step, this.filterItemList);
            DefaultFilterLogicTestNode node = new DefaultFilterLogicTestNode(testNode);
            newNode = node;
        }
        return newNode;
    }

    protected AbstractFilterLogicBaseNode transformStep(CompoundStep step) {
        return this.transformStep(step, false);
    }

    protected AbstractFilterLogicBaseNode transformStep(CompoundStep step, boolean explicitlyCreated) {
        LogicalConditionNode newNode = null;
        if (step != null) {
            ArrayList<AbstractFilterLogicBaseNode> children;
            boolean isNegated = step.isNegated();
            List stepRelationTypes = step.getStepsConditions();
            List steps = step.getSteps();
            ConditionalRelationType condType = ConditionalRelationType.AND;
            if (stepRelationTypes != null && stepRelationTypes.size() > 0) {
                String typeText = stepRelationTypes.get(0).toString();
                condType = ConditionalRelationType.findType((String)typeText);
            }
            if (steps != null && steps.size() > 0) {
                children = new ArrayList<AbstractFilterLogicBaseNode>(steps.size());
                for (StepInterface childStep : steps) {
                    AbstractFilterLogicBaseNode child = this.transformStep(childStep);
                    if (child == null) continue;
                    children.add(child);
                }
            } else {
                children = null;
            }
            if (children != null && children.size() > 0) {
                LogicalConditionNode lcn = this.newLogicalConditionNode(step, condType, explicitlyCreated);
                for (AbstractFilterLogicBaseNode child : children) {
                    lcn.add((MutableTreeNode)child);
                }
                if (isNegated) {
                    newNode = new NotNode((Object)step);
                    newNode.add((MutableTreeNode)lcn);
                } else {
                    newNode = lcn;
                }
            }
        }
        return newNode;
    }

    protected LogicalConditionNode newLogicalConditionNode(Object userObject, ConditionalRelationType lc, boolean explicitlyCreated) {
        LogicalConditionNode node = new LogicalConditionNode(lc, explicitlyCreated, userObject);
        return node;
    }

    protected NotNode newNotNode(Object userObject) {
        NotNode node = new NotNode(userObject);
        return node;
    }
}

