/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased.olap;

import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeObjectMap;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.FilterableItemInterface;
import com.sas.dataselectors.filters.FilterableListModelInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.dataselectors.filters.timebased.olap.RB;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OLAPTimeFilterUtil {
    public static final String RB_KEY = "OLAPTimeFilterUtil.";
    public static String OLAP_RELATIVE_TIME_CONDITION_CLASS_NAME = "com.sas.swing.visuals.dataselectors.filters.OLAPRelativeTimeFilterPanel";

    public static List getReadableTextForTimeLevel(Object model, MetadataInterface metadata, String cubeName, String uniqueLevelName, String uniqueMemberName) {
        Locale locale = Locale.getDefault();
        return OLAPTimeFilterUtil.getReadableTextForTimeLevel(model, metadata, cubeName, uniqueLevelName, uniqueMemberName, locale);
    }

    public static List getReadableTextForTimeLevel(Object model, MetadataInterface metadata, String cubeName, String uniqueLevelName, String uniqueMemberName, Locale locale) {
        LevelInterface level = OLAPTimeFilterUtil.getLevel(model, metadata, cubeName, uniqueLevelName, uniqueMemberName);
        ArrayList<String> levelNameList = null;
        if (level != null) {
            levelNameList = new ArrayList<String>(2);
            int type = 32768;
            try {
                type = level.getType();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            switch (type) {
                case 1024: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"day.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"days.txt", (Locale)locale));
                    break;
                }
                case 64: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"halfYear.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"halfYears.txt", (Locale)locale));
                    break;
                }
                case 2048: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"hour.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"hours.txt", (Locale)locale));
                    break;
                }
                case 4096: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"minute.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"minutes.txt", (Locale)locale));
                    break;
                }
                case 256: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"month.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"months.txt", (Locale)locale));
                    break;
                }
                case 128: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"quarter.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"quarters.txt", (Locale)locale));
                    break;
                }
                case 8192: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"second.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"seconds.txt", (Locale)locale));
                    break;
                }
                case 512: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"week.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"weeks.txt", (Locale)locale));
                    break;
                }
                case 32: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"year.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"years.txt", (Locale)locale));
                    break;
                }
                case 16384: {
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"period.txt", (Locale)locale));
                    levelNameList.add(RB.getStringResource((String)RB_KEY, (String)"periods.txt", (Locale)locale));
                    break;
                }
            }
        }
        return levelNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelInterface getLevel(Object model, MetadataInterface metadata, String cubeName, String uniqueLevelName, String uniqueMemberName) {
        LevelInterface level = null;
        BusinessModel bm = null;
        if (model instanceof BusinessQuery) {
            bm = ((BusinessQuery)model).getBusinessModel();
        } else if (model instanceof BusinessQueryProviderInterface) {
            bm = ((BusinessQueryProviderInterface)model).getBusinessQuery().getBusinessModel();
        } else if (model instanceof BusinessModel) {
            bm = (BusinessModel)model;
        }
        if (uniqueLevelName == null && uniqueMemberName == null || bm == null) {
            return null;
        }
        boolean iqCreatedMetadata = false;
        try {
            if (metadata == null) {
                metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)bm);
                iqCreatedMetadata = true;
            }
            if (metadata != null) {
                if (uniqueLevelName != null) {
                    Filter filter = new Filter();
                    filter.setUniqueLevelName(uniqueLevelName);
                    filter.setCubeName(cubeName);
                    level = metadata.getLevel(filter);
                } else {
                    Filter filter = new Filter();
                    filter.setTreeOperator(Filter.SELF_TREE_OPERATOR);
                    filter.setUniqueMemberName(uniqueMemberName);
                    filter.setCubeName(cubeName);
                    MemberInterface[] members = metadata.getMembers(filter, 0, 1);
                    if (members.length > 0) {
                        level = members[0].getLevel();
                    }
                }
            }
        }
        catch (OLAPException oLAPException) {
        }
        catch (IQueryServicesException iQueryServicesException) {
        }
        finally {
            if (iqCreatedMetadata && metadata != null) {
                BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)metadata);
                metadata = null;
            }
        }
        return level;
    }

    public static String capitalize(String s) {
        return s == null || s.length() == 0 ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static boolean isOLAPRelativeTimeCondition(boolean isFullSearch, AdvancedFilterModelInterface validModel, String selectedCondition) {
        Class conditionClass = OLAPTimeFilterUtil.getConditionClass(isFullSearch, validModel, selectedCondition);
        return conditionClass != null && OLAP_RELATIVE_TIME_CONDITION_CLASS_NAME.equals(conditionClass.getName());
    }

    public static boolean isOLAPRelativeTimeCondition(FilterLogicTestNodeInterface filterLogicTestNode) {
        Class conditionClass = OLAPTimeFilterUtil.getConditionClass(filterLogicTestNode);
        return conditionClass != null && OLAP_RELATIVE_TIME_CONDITION_CLASS_NAME.equals(conditionClass.getName());
    }

    public static boolean isOLAPRelativeTimeFilterToApply(FilterableListModelInterface aModel) {
        List filterables;
        if (aModel != null && (filterables = aModel.getFilterableItems()) != null && filterables.size() > 0) {
            boolean allCommit = true;
            for (FilterableItemInterface item : filterables) {
                AdvancedFilterModelInterface filterModel = item.getFilterModel();
                Object testNodeValueObject = OLAPTimeFilterUtil.getTestNodeValueObject(filterModel);
                Class conditionClass = OLAPTimeFilterUtil.getConditionClass(filterModel);
                if (conditionClass != null) {
                    boolean isOLAPTimeBasedFilterAdapterModified;
                    boolean bl = isOLAPTimeBasedFilterAdapterModified = testNodeValueObject instanceof OLAPTimeBasedFilterAdapterInterface ? ((OLAPTimeBasedFilterAdapterInterface)testNodeValueObject).isModified() : false;
                    if (!OLAP_RELATIVE_TIME_CONDITION_CLASS_NAME.equals(conditionClass.getName()) || !isOLAPTimeBasedFilterAdapterModified) continue;
                    return true;
                }
                if (!(testNodeValueObject instanceof OLAPTimeBasedFilterAdapterInterface)) continue;
                return true;
            }
        }
        return false;
    }

    private static Object getTestNodeValueObject(AdvancedFilterModelInterface model) {
        FilterLogicTestNodeInterface filterLogicTestNode = OLAPTimeFilterUtil.getFilterLogicTestNode(model);
        return OLAPTimeFilterUtil.getTestNodeValueObject(filterLogicTestNode);
    }

    public static Object getTestNodeValueObject(FilterLogicTestNodeInterface filterLogicTestNode) {
        Object objectValue;
        List valuesList;
        Object valueObject = null;
        if (filterLogicTestNode != null && (valuesList = filterLogicTestNode.getTestValuesList()) != null && valuesList.size() == 1 && (objectValue = valuesList.get(0)) instanceof FilterValueInterface) {
            valueObject = ((FilterValueInterface)objectValue).getData();
        }
        return valueObject;
    }

    public static boolean isOLAPRetiveTimeFilterNewDefinition(AdvancedFilterModelInterface advancedFilterModel) {
        Object dataItem;
        if (advancedFilterModel != null && (dataItem = ((FilterItemInterface)advancedFilterModel.getDataSource().getFilterItemList().get(0)).getItem()) instanceof DataItem) {
            boolean isTimeDimension = false;
            try {
                isTimeDimension = IQUeryUtil.isTimeDimension(((DataItem)dataItem).getBusinessModel(), (DataItem)dataItem);
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            if (isTimeDimension) {
                if (advancedFilterModel.getSelectionCount() <= 0) {
                    return true;
                }
                Class conditionClass = OLAPTimeFilterUtil.getConditionClass(advancedFilterModel);
                if (conditionClass == null || !OLAP_RELATIVE_TIME_CONDITION_CLASS_NAME.equals(conditionClass.getName())) {
                    return true;
                }
            }
        }
        return false;
    }

    private static Class getConditionClass(boolean isFullSearch, AdvancedFilterModelInterface validModel, String selectedCondition) {
        Class conditionClass = null;
        if (validModel != null) {
            Map map;
            FilterLogicTestNodeObjectMap objectMap;
            if (selectedCondition != null && (objectMap = (FilterLogicTestNodeObjectMap)validModel.getApplicationData()) != null && (map = objectMap.getFilterConditionMap()) != null && map.containsKey(selectedCondition)) {
                Object currentCondition = map.get(selectedCondition);
                Object conditionObject = null;
                if (currentCondition instanceof FilterConditionInterface) {
                    conditionObject = ((FilterConditionInterface)currentCondition).getCondition();
                }
                if (conditionObject instanceof Class) {
                    conditionClass = (Class)conditionObject;
                }
            }
            if (conditionClass == null && isFullSearch) {
                conditionClass = OLAPTimeFilterUtil.getConditionClass(validModel);
            }
        }
        return conditionClass;
    }

    private static Class getConditionClass(AdvancedFilterModelInterface model) {
        Class conditionClass = null;
        FilterLogicTestNodeInterface filterLogicTestNode = OLAPTimeFilterUtil.getFilterLogicTestNode(model);
        if (filterLogicTestNode != null) {
            conditionClass = OLAPTimeFilterUtil.getConditionClass(filterLogicTestNode);
        }
        return conditionClass;
    }

    private static FilterLogicTestNodeInterface getFilterLogicTestNode(AdvancedFilterModelInterface model) {
        List testNodeList;
        SimpleFilterLogicTreeInterface logicTree;
        FilterLogicTestNodeInterface filterLogicTestNode = null;
        if (model != null && (logicTree = model.getSelectionTree()) != null && (testNodeList = logicTree.getUnderstoodTestNodeList()) != null && testNodeList.size() == 1) {
            filterLogicTestNode = (FilterLogicTestNodeInterface)testNodeList.get(0);
        }
        return filterLogicTestNode;
    }

    private static Class getConditionClass(FilterLogicTestNodeInterface filterLogicTestNode) {
        Object conditionObject;
        FilterConditionInterface condition;
        Class conditionClass = null;
        if (filterLogicTestNode != null && (condition = filterLogicTestNode.getCondition()) != null && (conditionObject = condition.getCondition()) instanceof Class) {
            conditionClass = (Class)conditionObject;
        }
        return conditionClass;
    }
}

