/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased.olap;

import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.OLAPMemberTreeModel;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterDataSourceInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeFilterUtil;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.strategies.sas.oma.olap.util.OLAPConnectionInfoUtil;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.ListFactory;
import com.sas.util.log.LoggerRepository2;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class OLAPTimeBasedFilterAdapterDataSource
implements OLAPTimeBasedFilterAdapterDataSourceInterface {
    private List periodTypeLabels;
    private List periodTypeList = ListFactory.newList();
    private Map periodTypeMap = new LinkedHashMap();
    BusinessQueryProviderInterface model;
    String cubeName;
    FilterBaseModelData baseModel = null;
    DataItem dataItem;
    private String periodType;
    private int periodDepth = -1;
    private DefaultTreeModel startTreeModel;
    private DefaultTreeModel endTreeModel;
    LevelInterface[] levels;

    protected OLAPTimeBasedFilterAdapterDataSource() {
    }

    public OLAPTimeBasedFilterAdapterDataSource(FilterBaseModelData baseModel) {
        this();
        this.baseModel = baseModel;
        if (baseModel != null) {
            this.setCubeName(baseModel.getModel());
        }
    }

    public OLAPTimeBasedFilterAdapterDataSource(BusinessQueryProviderInterface model) {
        this();
        this.baseModel = new FilterBaseModelData(model, null);
        this.model = model;
        this.setCubeName(model);
    }

    public OLAPTimeBasedFilterAdapterDataSource(BusinessModel model, MetadataInterface md) {
        this();
        this.baseModel = new FilterBaseModelData(model, md);
        this.setCubeName(model);
    }

    protected MetadataInterface getMetadataInterface() {
        MetadataInterface metadata = null;
        try {
            if (this.baseModel != null) {
                metadata = this.baseModel.createMetadata();
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return metadata;
    }

    public void releaseResources() {
        if (this.baseModel != null) {
            this.baseModel.releaseResources();
        }
    }

    protected void setCubeName(Object model) {
        try {
            if (model instanceof BusinessModel) {
                this.cubeName = OLAPConnectionInfoUtil.getCubeName((BusinessModel)((BusinessModel)model));
            } else if (model instanceof OLAPDataSetInterface) {
                this.cubeName = ((OLAPDataSetInterface)model).getCubeName();
            }
        }
        catch (Exception e) {
            this.cubeName = "";
        }
    }

    public void setDataItem(Object dataItem) {
        if (dataItem instanceof DataItem && dataItem != this.dataItem) {
            this.dataItem = (DataItem)dataItem;
            this.periodType = null;
            this.periodTypeList.clear();
            this.levels = null;
            this.setDefaultPeriodType();
        }
    }

    private void setDefaultPeriodType() {
        if (this.levels == null) {
            this.levels = IQUeryUtil.getLevels(this.dataItem);
        }
        this.periodTypeMap.clear();
        String periodType = null;
        for (int i = 0; i < this.levels.length; ++i) {
            try {
                if (this.levels[i].getType() == 2) continue;
                periodType = this.levels[i].getUniqueName();
                this.periodTypeMap.put(periodType, this.levels[i]);
                if (this.getPeriodType() != null) continue;
                this.setPeriodType(periodType);
                continue;
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
    }

    public String getCurrentFirstPeriod() {
        return this.periodType == null ? null : this.getPeriod(0);
    }

    public String getCurrentLastPeriod() {
        return this.periodType == null ? null : this.getPeriod(-1);
    }

    public String getCurrentFirstPeriodLabel() {
        return this.getLabel(this.getCurrentFirstPeriod());
    }

    public String getCurrentLastPeriodLabel() {
        return this.getLabel(this.getCurrentLastPeriod());
    }

    public void setPeriodType(String periodType) {
        this.periodTypeLabels = null;
        if (periodType != null && !periodType.equals(this.periodType)) {
            this.startTreeModel = null;
            this.endTreeModel = null;
        }
        this.periodType = periodType;
        try {
            LevelInterface level = (LevelInterface)this.periodTypeMap.get(periodType);
            if (level != null) {
                this.periodDepth = level.getDepth();
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public String getPeriodType(String uniqueDateMemberName) {
        LevelInterface level;
        String periodType = null;
        if (uniqueDateMemberName != null && this.dataItem != null && this.cubeName != null && (level = OLAPTimeFilterUtil.getLevel(this.dataItem.getBusinessModel(), this.getMetadataInterface(), this.cubeName, null, uniqueDateMemberName)) != null) {
            try {
                periodType = level.getUniqueName();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return periodType;
    }

    public int getPeriodLevelType(String uniqueDateLevelName) {
        LevelInterface level;
        int periodLevelType = 0;
        if (uniqueDateLevelName != null && this.dataItem != null && this.cubeName != null && (level = OLAPTimeFilterUtil.getLevel(this.dataItem.getBusinessModel(), this.getMetadataInterface(), this.cubeName, uniqueDateLevelName, null)) != null) {
            try {
                periodLevelType = level.getType();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return periodLevelType;
    }

    public List getPeriodTypes() {
        if (this.periodTypeList.isEmpty() && this.dataItem != null) {
            Iterator iter = this.periodTypeMap.values().iterator();
            while (iter.hasNext()) {
                try {
                    LevelInterface level = (LevelInterface)iter.next();
                    this.periodTypeList.add(this.getPair(level.getLabel(), level.getUniqueName()));
                }
                catch (OLAPException oLAPException) {}
            }
        }
        return this.periodTypeList;
    }

    public TreeModel getStartTreeModel() {
        if (this.dataItem != null && this.startTreeModel == null) {
            try {
                this.startTreeModel = new OLAPMemberTreeModel(this.dataItem, this.getMetadataInterface(), this.periodDepth);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.startTreeModel == null) {
            this.startTreeModel = this.getDummyTreeModel();
        }
        return this.startTreeModel;
    }

    public TreeModel getEndTreeModel() {
        if (this.dataItem != null && this.endTreeModel == null) {
            try {
                this.endTreeModel = new OLAPMemberTreeModel(this.dataItem, this.getMetadataInterface(), this.periodDepth);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.endTreeModel == null) {
            this.endTreeModel = this.getDummyTreeModel();
        }
        return this.endTreeModel;
    }

    private DefaultTreeModel getDummyTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        DefaultTreeModel model = new DefaultTreeModel(root);
        return model;
    }

    private String[] getPair(String text, String value) {
        String[] pair = new String[]{text, value};
        return pair;
    }

    public List getPeriodTypeLabels() {
        if (this.periodTypeLabels == null && this.dataItem != null && this.cubeName != null) {
            this.periodTypeLabels = OLAPTimeFilterUtil.getReadableTextForTimeLevel(this.dataItem.getBusinessModel(), this.getMetadataInterface(), this.cubeName, this.getPeriodType(), null);
        }
        return this.periodTypeLabels;
    }

    private String getPeriod(int index) {
        if (this.periodType == null) {
            return null;
        }
        MetadataInterface metadata = this.getMetadataInterface();
        if (metadata != null) {
            try {
                LevelInterface level;
                Filter filter = new Filter();
                filter.setCubeName(this.cubeName);
                filter.setUniqueLevelName(this.periodType);
                if (index == -1 && (level = metadata.getLevel(filter)).getMemberCount() > 0) {
                    index = level.getMemberCount() - 1;
                }
                try {
                    MemberInterface member = metadata.getMembers(filter, index, 1)[0];
                    if (member != null) {
                        return member.getUniqueName();
                    }
                }
                catch (OLAPException e) {
                    return index == 0 ? IQUeryUtil.getFirstLastMemberUniqueNameViaMDX(true, this.cubeName, this.periodType, metadata.getConnection()) : IQUeryUtil.getFirstLastMemberUniqueNameViaMDX(false, this.cubeName, this.periodType, metadata.getConnection());
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return null;
    }

    public String getLabel(String uniqueMemberName) {
        StringBuffer label = new StringBuffer();
        if (uniqueMemberName != null) {
            Filter filter = new Filter();
            filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
            filter.setUniqueMemberName(uniqueMemberName);
            MetadataInterface metadata = this.getMetadataInterface();
            if (metadata != null) {
                try {
                    filter.setCubeName(this.cubeName);
                    MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                    Arrays.sort(members, MemberLevelComparator.defaultInstance);
                    for (int i = 0; i < members.length; ++i) {
                        if (members[i].getType() == 2) continue;
                        String text = members[i].getLabel().trim();
                        if (label.length() > 0) {
                            label.append(".");
                        }
                        label.append(text);
                    }
                }
                catch (OLAPException oe) {
                    label = new StringBuffer(uniqueMemberName);
                }
            }
        }
        return label.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

