/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters.timebased.olap;

import com.sas.dataselectors.filters.OLAPMemberTreeNode;
import com.sas.dataselectors.filters.timebased.TimeBasedFilterAdapter;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterDataSourceInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeFilterUtil;
import com.sas.dataselectors.filters.timebased.olap.RB;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNParallelPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNParallelPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.util.ListFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OLAPTimeBasedFilterAdapter
extends TimeBasedFilterAdapter
implements OLAPTimeBasedFilterAdapterInterface {
    private Locale locale;
    private Map eventInfo = new HashMap();
    private Object filterExpression;
    private StepInterface filterStep;
    private String showOption;
    private String numberOfPeriods;
    private String selectOption;
    private String startingPeriodOption;
    private String endingPeriodOption;
    private String selectedStartingPeriod;
    private String selectedEndingPeriod;
    private String[] selectedPeriods;
    OLAPTimeBasedFilterAdapterDataSourceInterface dataSource;
    public static final String RB_KEY = "OLAPTimeBasedFilterAdapter.";
    private boolean panelVisible;
    private boolean modified;
    private boolean runtime = true;
    public static int MINIMUM_N_PERIOD_VALUE = 1;
    public static int DEFAULT_PERIOD_TYPE_INDEX = 0;

    public OLAPTimeBasedFilterAdapter(OLAPTimeBasedFilterAdapterDataSourceInterface model) {
        this.setPanelVisible(false);
        this.setModified(false);
        this.showOption = this.getDefaultShowOption();
        this.dataSource = model;
        this.setNumberOfPeriods(String.valueOf(MINIMUM_N_PERIOD_VALUE));
    }

    @Override
    public void setDataItem(Object dataItem) {
        super.setDataItem(dataItem);
        this.dataSource.setDataItem(dataItem);
    }

    public void setRuntime(boolean runtime) {
        this.runtime = runtime;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public Object getPropertiesBean() {
        return null;
    }

    public Map commit() {
        this.eventInfo.clear();
        return this.eventInfo;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFilterExpression(Object filterExpr) {
        this.filterExpression = filterExpr;
        if (this.filterExpression instanceof TimeFilterFirstLastPeriodsExpression) {
            TimeFilterFirstLastPeriodsExpression expr = (TimeFilterFirstLastPeriodsExpression)this.filterExpression;
            if (!this.isRuntime()) {
                this.setDataItem(expr.getWhatToCompare());
            }
            this.setShowOption("NPERIODS");
            this.setNumberOfPeriods("" + expr.getnPeriods());
            if ("FORWARD".equalsIgnoreCase(expr.getSearchDirection())) {
                this.setSelectOption("STARTINGPERIOD");
                this.setStartingPeriodOption("FIRSTPERIOD");
            } else {
                this.setSelectOption("ENDINGPERIOD");
                this.setEndingPeriodOption("LASTPERIOD");
            }
            this.setPeriodType(expr.getLevelName());
        } else if (this.filterExpression instanceof TimeFilterNPeriodsExpression) {
            TimeFilterNPeriodsExpression expr = (TimeFilterNPeriodsExpression)this.filterExpression;
            if (!this.isRuntime()) {
                this.setDataItem(expr.getWhatToCompare());
            }
            this.setShowOption("NPERIODS");
            this.setNumberOfPeriods("" + expr.getnPeriods());
            if ("FORWARD".equalsIgnoreCase(expr.getSearchDirection())) {
                this.setSelectOption("STARTINGPERIOD");
                if (expr.getDateMember().equals(this.getCurrentFirstPeriod())) {
                    this.setStartingPeriodOption("FIRSTPERIOD");
                } else {
                    this.setStartingPeriodOption("SELECTEDPERIOD");
                }
                this.setSelectedStartingPeriod(expr.getDateMember());
            } else {
                this.setSelectOption("ENDINGPERIOD");
                if (expr.getDateMember().equals(this.getCurrentLastPeriod())) {
                    this.setEndingPeriodOption("LASTPERIOD");
                } else {
                    this.setEndingPeriodOption("SELECTEDPERIOD");
                }
                this.setSelectedEndingPeriod(expr.getDateMember());
            }
            String level = this.dataSource.getPeriodType(expr.getDateMember());
            if (level != null) {
                this.setPeriodType(level);
            }
        } else if (this.filterExpression instanceof TimeFilterNParallelPeriodsExpression) {
            TimeFilterNParallelPeriodsExpression expr = (TimeFilterNParallelPeriodsExpression)this.filterExpression;
            this.setShowOption("ACROSS");
        } else if (this.filterExpression instanceof TimeRangeFilterExpression) {
            String level;
            TimeRangeFilterExpression expr = (TimeRangeFilterExpression)this.filterExpression;
            if (!this.isRuntime()) {
                this.setDataItem(expr.getWhatToCompare());
            }
            if ((level = expr.getLevel()) == null || "".equals(level.trim())) {
                level = this.dataSource.getPeriodType(expr.getStartDateMember());
            }
            this.setPeriodType(level);
            this.setShowOption("RANGE");
            String date = expr.getStartDateMember();
            if (date == null) {
                this.setStartingPeriodOption("FIRSTPERIOD");
            } else {
                this.setStartingPeriodOption("SELECTEDPERIOD");
            }
            this.setSelectedStartingPeriod(date);
            date = expr.getEndDateMember();
            if (date == null) {
                this.setEndingPeriodOption("LASTPERIOD");
            } else {
                this.setEndingPeriodOption("SELECTEDPERIOD");
            }
            this.setSelectedEndingPeriod(date);
        }
    }

    public Object getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterStep(Object step) {
        if (step instanceof StepInterface) {
            this.filterStep = (StepInterface)step;
        }
        if (step instanceof DataItemTimeFirstLastPeriodsFilter) {
            this.setShowOption("NPERIODS");
            DataItemTimeFirstLastPeriodsFilter filter = (DataItemTimeFirstLastPeriodsFilter)step;
            this.setPeriodType(filter.getLevelName());
            this.setNumberOfPeriods("" + filter.getnPeriods());
            if ("FORWARD".equalsIgnoreCase(filter.getSearchDirection())) {
                this.setSelectOption("STARTINGPERIOD");
                this.setStartingPeriodOption("FIRSTPERIOD");
            } else {
                this.setSelectOption("ENDINGPERIOD");
                this.setEndingPeriodOption("LASTPERIOD");
            }
            String level = filter.getLevelName();
            if (level != null) {
                this.setPeriodType(level);
            }
        } else if (step instanceof DataItemTimeNPeriodsFilter) {
            this.setShowOption("NPERIODS");
            DataItemTimeNPeriodsFilter filter = (DataItemTimeNPeriodsFilter)step;
            this.setNumberOfPeriods("" + filter.getnPeriods());
            String date = filter.getDateMember();
            if ("FORWARD".equalsIgnoreCase(filter.getSearchDirection())) {
                this.setSelectOption("STARTINGPERIOD");
                this.setStartingPeriodOption("SELECTEDPERIOD");
                this.setSelectedStartingPeriod(date);
            } else {
                this.setSelectOption("ENDINGPERIOD");
                this.setEndingPeriodOption("SELECTEDPERIOD");
                this.setSelectedEndingPeriod(date);
            }
            String level = this.dataSource.getPeriodType(date);
            if (level != null) {
                this.setPeriodType(level);
            }
        } else if (step instanceof DataItemTimeRangeFilter) {
            String level;
            this.setShowOption("RANGE");
            DataItemTimeRangeFilter filter = (DataItemTimeRangeFilter)step;
            this.setStartingPeriodOption("FIRSTPERIOD");
            this.setEndingPeriodOption("LASTPERIOD");
            String startDate = filter.getStartDateMember();
            String endDate = filter.getEndDateMember();
            if (startDate != null) {
                this.setSelectedStartingPeriod(startDate);
                this.setStartingPeriodOption("SELECTEDPERIOD");
            }
            if (endDate != null) {
                this.setSelectedEndingPeriod(endDate);
                this.setEndingPeriodOption("SELECTEDPERIOD");
            }
            if ((level = filter.getLevel()) != null) {
                this.setPeriodType(level);
            }
        } else if (step instanceof DataItemTimeNParallelPeriodsFilter) {
            this.setShowOption("ACROSS");
            DataItemTimeNParallelPeriodsFilter dataItemTimeNParallelPeriodsFilter = (DataItemTimeNParallelPeriodsFilter)step;
        }
    }

    public List getPeriodTypes() {
        return this.dataSource.getPeriodTypes();
    }

    public List getShowOptionsList() {
        return this.getShowOptionsList(true);
    }

    public List getFullShowOptionsList() {
        return this.getShowOptionsList(false);
    }

    private List getShowOptionsList(boolean topOfTimeHierarchySensitive) {
        List list = ListFactory.newList();
        String nPeriodsLabel = "";
        String rangePeriodLabel = "";
        String periodType = this.getPeriodType();
        int level = this.getPeriodType(periodType);
        switch (level) {
            case 32: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nYears.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeYears.fmt.txt", (Locale)this.locale);
                break;
            }
            case 64: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nHalfYears.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeHalfYears.txt", (Locale)this.locale);
                break;
            }
            case 128: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nQuarters.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeQuarters.fmt.txt", (Locale)this.locale);
                break;
            }
            case 256: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nMonths.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeMonths.fmt.txt", (Locale)this.locale);
                break;
            }
            case 512: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nWeeks.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeWeeks.fmt.txt", (Locale)this.locale);
                break;
            }
            case 1024: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nDays.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeDays.fmt.txt", (Locale)this.locale);
                break;
            }
            case 2048: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nHours.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeHours.fmt.txt", (Locale)this.locale);
                break;
            }
            case 4096: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nMinutes.fmt.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeMinutes.fmt.txt", (Locale)this.locale);
                break;
            }
            case 8192: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nSeconds.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangeSeconds.txt", (Locale)this.locale);
                break;
            }
            case 16384: {
                nPeriodsLabel = RB.getStringResource((String)RB_KEY, (String)"nPeriods.txt", (Locale)this.locale);
                rangePeriodLabel = RB.getStringResource((String)RB_KEY, (String)"rangePeriods.txt", (Locale)this.locale);
                break;
            }
            default: {
                nPeriodsLabel = "";
                rangePeriodLabel = "";
            }
        }
        list.add(this.getPair(nPeriodsLabel, "NPERIODS"));
        list.add(this.getPair(rangePeriodLabel, "RANGE"));
        return list;
    }

    private String[] getPair(String text, String value) {
        String[] pair = new String[]{text, value};
        return pair;
    }

    public String getShowOption() {
        return this.showOption;
    }

    public void setShowOption(String value) {
        this.showOption = value;
    }

    public String getNumberOfPeriods() {
        return this.numberOfPeriods;
    }

    public void setNumberOfPeriods(String value) {
        this.numberOfPeriods = value;
    }

    private String getSingularLocalizedPeriodType() {
        String string = null;
        List labels = this.dataSource.getPeriodTypeLabels();
        if (labels != null && labels.size() >= 1) {
            string = (String)labels.get(0);
        }
        return string;
    }

    private String getPluralLocalizedPeriodType() {
        String string = null;
        List labels = this.dataSource.getPeriodTypeLabels();
        if (labels != null && labels.size() >= 2) {
            string = (String)labels.get(1);
        }
        return string;
    }

    public String getLocalizedSelectLabelParameter() {
        return this.getPluralLocalizedPeriodType();
    }

    public String getLocalizedNPeriodsLabelParameter() {
        return this.getPluralLocalizedPeriodType();
    }

    public String getLocalizedAcrossLabelFirstParameter() {
        return OLAPTimeFilterUtil.capitalize(this.getPluralLocalizedPeriodType());
    }

    public String getLocalizedAcrossLabelSecondParameter() {
        return "years";
    }

    public String getLocalizedRangeLabelParameter() {
        return this.getPluralLocalizedPeriodType();
    }

    public String getLocalizedPeriodType() {
        return this.getSingularLocalizedPeriodType();
    }

    public List getSelectablePeriods() {
        List list = ListFactory.newList();
        list.add(this.getPair("January", "DIR_1"));
        list.add(this.getPair("February", "DIR_2"));
        list.add(this.getPair("March", "DIR_3"));
        list.add(this.getPair("April", "DIR_4"));
        list.add(this.getPair("May", "DIR_5"));
        list.add(this.getPair("June", "DIR_6"));
        list.add(this.getPair("July", "DIR_7"));
        list.add(this.getPair("August", "DIR_8"));
        list.add(this.getPair("September", "DIR_9"));
        list.add(this.getPair("October", "DIR_10"));
        list.add(this.getPair("November", "DIR_11"));
        list.add(this.getPair("December", "DIR_12"));
        return list;
    }

    public String getCurrentFirstPeriod() {
        return this.dataSource.getCurrentFirstPeriod();
    }

    public String getCurrentFirstPeriodLabel() {
        return this.dataSource.getCurrentFirstPeriodLabel();
    }

    public String getCurrentLastPeriod() {
        return this.dataSource.getCurrentLastPeriod();
    }

    public String getCurrentLastPeriodLabel() {
        return this.dataSource.getCurrentLastPeriodLabel();
    }

    public TreeModel getStartTreeModel() {
        return this.dataSource.getStartTreeModel();
    }

    public TreeModel getEndTreeModel() {
        return this.dataSource.getEndTreeModel();
    }

    public void setPanelVisible(boolean visible) {
        this.panelVisible = visible;
    }

    public boolean isPanelVisible() {
        return this.panelVisible;
    }

    public int getPeriodType(String uniquePeriodName) {
        return this.dataSource.getPeriodLevelType(uniquePeriodName);
    }

    public String getPeriodType() {
        return this.dataSource.getPeriodType();
    }

    public void setPeriodType(String value) {
        this.dataSource.setPeriodType(value);
    }

    public List getSelectOptionsList() {
        List list = ListFactory.newList();
        list.add(this.getPair(RB.getStringResource((String)RB_KEY, (String)"startingPeriod.txt", (Locale)this.locale), "STARTINGPERIOD"));
        list.add(this.getPair(RB.getStringResource((String)RB_KEY, (String)"endingPeriod.txt", (Locale)this.locale), "ENDINGPERIOD"));
        return list;
    }

    public String getSelectOption() {
        return this.selectOption;
    }

    public void setSelectOption(String value) {
        this.selectOption = value;
    }

    public String getStartingPeriodLabel() {
        String periodType = this.getPeriodType();
        int level = this.getPeriodType(periodType);
        switch (level) {
            case 32: {
                return RB.getStringResource((String)RB_KEY, (String)"startingYear.txt", (Locale)this.locale);
            }
            case 64: {
                return RB.getStringResource((String)RB_KEY, (String)"startingHalfYear.txt", (Locale)this.locale);
            }
            case 128: {
                return RB.getStringResource((String)RB_KEY, (String)"startingQuarter.txt", (Locale)this.locale);
            }
            case 256: {
                return RB.getStringResource((String)RB_KEY, (String)"startingMonth.txt", (Locale)this.locale);
            }
            case 512: {
                return RB.getStringResource((String)RB_KEY, (String)"startingWeek.txt", (Locale)this.locale);
            }
            case 1024: {
                return RB.getStringResource((String)RB_KEY, (String)"startingDay.txt", (Locale)this.locale);
            }
            case 2048: {
                return RB.getStringResource((String)RB_KEY, (String)"startingHour.txt", (Locale)this.locale);
            }
            case 4096: {
                return RB.getStringResource((String)RB_KEY, (String)"startingMinute.txt", (Locale)this.locale);
            }
            case 8192: {
                return RB.getStringResource((String)RB_KEY, (String)"startingSecond.txt", (Locale)this.locale);
            }
            case 16384: {
                return RB.getStringResource((String)RB_KEY, (String)"startingUndefinedPeriod.txt", (Locale)this.locale);
            }
        }
        return "";
    }

    public List getStartingPeriodOptionsList() {
        List list = ListFactory.newList();
        String theFirstLabel = "";
        String selectedLabel = "";
        String periodType = this.getPeriodType();
        int level = this.getPeriodType(periodType);
        switch (level) {
            case 32: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstYear.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedYear.txt", (Locale)this.locale);
                break;
            }
            case 64: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstHalfYear.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedHalfYear.txt", (Locale)this.locale);
                break;
            }
            case 128: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstQuarter.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedQuarter.txt", (Locale)this.locale);
                break;
            }
            case 256: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstMonth.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedMonth.txt", (Locale)this.locale);
                break;
            }
            case 512: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstWeek.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedWeek.txt", (Locale)this.locale);
                break;
            }
            case 1024: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstDay.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedDay.txt", (Locale)this.locale);
                break;
            }
            case 2048: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstHour.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedHour.txt", (Locale)this.locale);
                break;
            }
            case 4096: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstMinute.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedMinute.txt", (Locale)this.locale);
                break;
            }
            case 8192: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstSecond.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedSecond.txt", (Locale)this.locale);
                break;
            }
            case 16384: {
                theFirstLabel = RB.getStringResource((String)RB_KEY, (String)"theFirstPeriod.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedPeriod.txt", (Locale)this.locale);
                break;
            }
            default: {
                theFirstLabel = "";
                selectedLabel = "";
            }
        }
        list.add(this.getPair(theFirstLabel, "FIRSTPERIOD"));
        list.add(this.getPair(selectedLabel, "SELECTEDPERIOD"));
        return list;
    }

    public String getStartingPeriodOption() {
        return this.startingPeriodOption;
    }

    public void setStartingPeriodOption(String value) {
        this.startingPeriodOption = value;
    }

    public String getEndingPeriodLabel() {
        String periodType = this.getPeriodType();
        int level = this.getPeriodType(periodType);
        switch (level) {
            case 32: {
                return RB.getStringResource((String)RB_KEY, (String)"endingYear.txt", (Locale)this.locale);
            }
            case 64: {
                return RB.getStringResource((String)RB_KEY, (String)"endingHalfYear.txt", (Locale)this.locale);
            }
            case 128: {
                return RB.getStringResource((String)RB_KEY, (String)"endingQuarter.txt", (Locale)this.locale);
            }
            case 256: {
                return RB.getStringResource((String)RB_KEY, (String)"endingMonth.txt", (Locale)this.locale);
            }
            case 512: {
                return RB.getStringResource((String)RB_KEY, (String)"endingWeek.txt", (Locale)this.locale);
            }
            case 1024: {
                return RB.getStringResource((String)RB_KEY, (String)"endingDay.txt", (Locale)this.locale);
            }
            case 2048: {
                return RB.getStringResource((String)RB_KEY, (String)"endingHour.txt", (Locale)this.locale);
            }
            case 4096: {
                return RB.getStringResource((String)RB_KEY, (String)"endingMinute.txt", (Locale)this.locale);
            }
            case 8192: {
                return RB.getStringResource((String)RB_KEY, (String)"endingSecond.txt", (Locale)this.locale);
            }
            case 16384: {
                return RB.getStringResource((String)RB_KEY, (String)"endingUndefinedPeriod.txt", (Locale)this.locale);
            }
        }
        return "";
    }

    public List getEndingPeriodOptionsList() {
        List list = ListFactory.newList();
        String theLastLabel = "";
        String selectedLabel = "";
        String periodType = this.getPeriodType();
        int level = this.getPeriodType(periodType);
        switch (level) {
            case 32: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastYear.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedYear.txt", (Locale)this.locale);
                break;
            }
            case 64: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastHalfYear.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedHalfYear.txt", (Locale)this.locale);
                break;
            }
            case 128: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastQuarter.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedQuarter.txt", (Locale)this.locale);
                break;
            }
            case 256: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastMonth.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedMonth.txt", (Locale)this.locale);
                break;
            }
            case 512: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastWeek.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedWeek.txt", (Locale)this.locale);
                break;
            }
            case 1024: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastDay.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedDay.txt", (Locale)this.locale);
                break;
            }
            case 2048: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastHour.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedHour.txt", (Locale)this.locale);
                break;
            }
            case 4096: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastMinute.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedMinute.txt", (Locale)this.locale);
                break;
            }
            case 8192: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastSecond.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedSecond.txt", (Locale)this.locale);
                break;
            }
            case 16384: {
                theLastLabel = RB.getStringResource((String)RB_KEY, (String)"theLastPeriod.txt", (Locale)this.locale);
                selectedLabel = RB.getStringResource((String)RB_KEY, (String)"selectedPeriod.txt", (Locale)this.locale);
                break;
            }
            default: {
                theLastLabel = "";
                selectedLabel = "";
            }
        }
        list.add(this.getPair(theLastLabel, "LASTPERIOD"));
        list.add(this.getPair(selectedLabel, "SELECTEDPERIOD"));
        return list;
    }

    public String getEndingPeriodOption() {
        return this.endingPeriodOption;
    }

    public void setEndingPeriodOption(String value) {
        this.endingPeriodOption = value;
    }

    public String getSelectedStartingPeriod() {
        return this.selectedStartingPeriod;
    }

    public String getSelectedStartingPeriodLabel() {
        return this.dataSource.getLabel(this.selectedStartingPeriod);
    }

    public void setSelectedStartingPeriod(String value) {
        this.selectedStartingPeriod = value;
    }

    public void setSelectedStartingPeriod(TreeNode treeNode) {
        if (treeNode == null) {
            this.selectedStartingPeriod = null;
            return;
        }
        if (treeNode instanceof OLAPMemberTreeNode) {
            this.setSelectedStartingPeriod(((OLAPMemberTreeNode)treeNode).getValue());
        }
    }

    public String getSelectedEndingPeriod() {
        return this.selectedEndingPeriod;
    }

    public String getSelectedEndingPeriodLabel() {
        return this.dataSource.getLabel(this.selectedEndingPeriod);
    }

    public void setSelectedEndingPeriod(String value) {
        this.selectedEndingPeriod = value;
    }

    public void setSelectedEndingPeriod(TreeNode treeNode) {
        if (treeNode == null) {
            this.selectedEndingPeriod = null;
            return;
        }
        if (treeNode instanceof OLAPMemberTreeNode) {
            this.setSelectedEndingPeriod(((OLAPMemberTreeNode)treeNode).getValue());
        }
    }

    public String[] getSelectedPeriods() {
        return this.selectedPeriods;
    }

    public void setSelectedPeriods(String[] values) {
        this.selectedPeriods = values;
    }

    public void resetValuesToDefault() {
        List periodTypes = this.dataSource.getPeriodTypes();
        if (periodTypes != null && periodTypes.size() > DEFAULT_PERIOD_TYPE_INDEX) {
            this.dataSource.setPeriodType(((String[])periodTypes.get(DEFAULT_PERIOD_TYPE_INDEX))[1]);
        }
        this.setNumberOfPeriods(this.getDefaultNumberOfPeriods());
        this.setShowOption(this.getDefaultShowOption());
        this.setSelectOption(this.getDefaultSelectOption());
        this.setStartingPeriodOption(this.getDefaultStartingPeriodOption());
        this.setEndingPeriodOption(this.getDefaultEndingPeriodOption());
        this.setSelectedStartingPeriod((String)null);
        this.setSelectedEndingPeriod((String)null);
    }

    public String getDefaultNumberOfPeriods() {
        return String.valueOf(MINIMUM_N_PERIOD_VALUE);
    }

    public String getDefaultShowOption() {
        return "NPERIODS";
    }

    public String getDefaultSelectOption() {
        return "STARTINGPERIOD";
    }

    public String getDefaultStartingPeriodOption() {
        return "FIRSTPERIOD";
    }

    public String getDefaultEndingPeriodOption() {
        return "LASTPERIOD";
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public boolean isModified() {
        return this.modified;
    }

    public Object clone() {
        try {
            OLAPTimeBasedFilterAdapter clone = (OLAPTimeBasedFilterAdapter)super.clone();
            clone.dataSource = (OLAPTimeBasedFilterAdapterDataSourceInterface)this.dataSource.clone();
            if (clone.dataSource == null) {
                return null;
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

