/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.DataRetrievalError;
import com.sas.dataselectors.filters.DefaultFilterValueList;
import com.sas.dataselectors.filters.FilterException;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.dataselectors.filters.OLAPMemberDeferredRetrievalTreeNode;
import com.sas.dataselectors.filters.OLAPMemberTreeNode;
import com.sas.dataselectors.filters.OLAPMemberTreePathFactoryInterface;
import com.sas.dataselectors.filters.RB;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class OLAPMemberTreeModel
extends DefaultTreeModel
implements FilterValuesInterface,
OLAPMemberTreePathFactoryInterface {
    public static String RB_KEY = "OLAPMemberTreeModel.";
    protected transient String _label = RB.getStringResource((String)DefaultFilterValueList.RB_KEY, (String)"ListLabel.txt");
    protected Collection _itemValues = null;
    protected Iterator _itemValuesIterator = null;
    protected MetadataInterface _metadata = null;
    private static final Comparator _levelDepthComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            try {
                int l1 = ((MemberInterface)o1).getLevel().getDepth();
                int l2 = ((MemberInterface)o2).getLevel().getDepth();
                return l1 - l2;
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                return 0;
            }
        }
    };

    public OLAPMemberTreeModel(OLAPMemberTreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public OLAPMemberTreeModel(OLAPMemberTreeNode root) {
        this(root, false);
    }

    public OLAPMemberTreeModel(DataItem dataItem, MetadataInterface metadata) throws MetadataException {
        this(new OLAPMemberDeferredRetrievalTreeNode(dataItem, metadata), false);
        this._metadata = metadata;
    }

    public OLAPMemberTreeModel(DataItem dataItem, MetadataInterface metadata, int levelDepth) throws MetadataException {
        this(new OLAPMemberDeferredRetrievalTreeNode(dataItem, metadata, levelDepth), false);
        this._metadata = metadata;
    }

    public OLAPMemberTreeModel(DimensionInterface dimension) throws OLAPException {
        this(new OLAPMemberDeferredRetrievalTreeNode(dimension), false);
    }

    public MetadataInterface getMetadata() {
        return this._metadata;
    }

    public void setMetadata(MetadataInterface metadata) {
        this._metadata = metadata;
    }

    public boolean hasMoreValues() {
        return this._getValueIterator().hasNext();
    }

    public List getFirstValues(long lThreshold) throws DataRetrievalError {
        this._itemValuesIterator = null;
        return this.getNextValues(lThreshold);
    }

    public List getNextValues(long lThreshold) throws DataRetrievalError {
        this._itemValuesIterator = this._getValueIterator();
        ArrayList temp = new ArrayList();
        int i = 0;
        while (this._itemValuesIterator.hasNext()) {
            temp.add(this._itemValuesIterator.next());
            if (lThreshold <= 0L || (long)(++i) < lThreshold) continue;
            break;
        }
        return temp;
    }

    private Iterator _getValueIterator() {
        if (this._itemValues == null) {
            this._itemValues = Collections.singletonList(this.getRoot());
            this._itemValuesIterator = null;
        }
        if (this._itemValuesIterator == null) {
            this._itemValuesIterator = this._itemValues.iterator();
        }
        return this._itemValuesIterator;
    }

    @Override
    public void setRoot(TreeNode root) {
        super.setRoot(root);
        this._itemValues = null;
    }

    public void setListLabel(String value) {
        this._label = value;
    }

    public String getListLabel() {
        return this._label;
    }

    public String toString() {
        return this._label;
    }

    public static MemberInterface[] getMemberArrayForPathNodeList(MetadataInterface metadata, String cubeName, String memberName) throws OLAPException {
        MemberInterface[] members = null;
        Filter filter = new Filter();
        filter.setUniqueMemberName(memberName);
        filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
        filter.setCubeName(cubeName);
        members = metadata.getMembers(filter, 0, -1);
        Arrays.sort(members, 0, members.length, _levelDepthComparator);
        return members;
    }

    private static int _getStartingDepthForPathNodeList(OLAPMemberTreeModel tree) throws OLAPException {
        int start_depth = 0;
        OLAPMemberTreeNode node = (OLAPMemberTreeNode)tree.getRoot();
        if (node != null && node.getChildCount() > 0) {
            OLAPMemberTreeNode firstChild = (OLAPMemberTreeNode)node.getChildAt(0);
            if (firstChild.getData() instanceof TupleElementInterface) {
                start_depth = ((TupleElementInterface)firstChild.getData()).getLevelDepth();
            } else if (firstChild.getData() instanceof MemberInterface) {
                start_depth = ((MemberInterface)firstChild.getData()).getLevel().getDepth();
            }
        }
        return start_depth;
    }

    public static List getTreePathNodeList(OLAPMemberTreeModel tree, MetadataInterface metadata, String cubeName, String memberName) throws FilterException {
        if (tree == null || metadata == null || cubeName == null || memberName == null) {
            return null;
        }
        ArrayList<OLAPMemberTreeNode> list = new ArrayList<OLAPMemberTreeNode>();
        OLAPMemberTreeNode node = (OLAPMemberTreeNode)tree.getRoot();
        list.add(node);
        if (node.getValue().equals(memberName)) {
            return list;
        }
        try {
            MemberInterface[] members = OLAPMemberTreeModel.getMemberArrayForPathNodeList(metadata, cubeName, memberName);
            if (node.getUserObject() instanceof DimensionInterface) {
                OLAPMemberTreeModel.fillMissingNodes(list, node, members);
            }
            OLAPMemberTreeModel.getTreePathNodeList(tree, members, list);
        }
        catch (OLAPException oe) {
            throw new FilterException((Throwable)oe);
        }
        return list;
    }

    private static void fillMissingNodes(List list, OLAPMemberTreeNode node, MemberInterface[] members) throws OLAPException {
        String hierarchyName = members[0].getFilter().getUniqueHierarchyName();
        String levelName = members[0].getFilter().getUniqueLevelName();
        String[] missing = new String[]{hierarchyName, levelName};
        for (int i = 0; i < node.getChildCount(); ++i) {
            OLAPMemberTreeNode child = (OLAPMemberTreeNode)node.getChildAt(i);
            if (!hierarchyName.equals(child.getValue())) continue;
            for (int j = 0; j < child.getChildCount(); ++j) {
                OLAPMemberTreeNode child2 = (OLAPMemberTreeNode)child.getChildAt(j);
                if (!levelName.equals(child2.getValue())) continue;
                list.add(child);
                list.add(child2);
                return;
            }
        }
    }

    public static void getTreePathNodeList(OLAPMemberTreeModel tree, MemberInterface[] members, List list) throws OLAPException {
        OLAPMemberTreeNode node = (OLAPMemberTreeNode)list.get(list.size() - 1);
        int start_depth = OLAPMemberTreeModel._getStartingDepthForPathNodeList(tree);
        block0: for (int i = 0; i < members.length && node != null; ++i) {
            if (members[i].getLevel().getDepth() < start_depth) continue;
            String name = members[i].getUniqueName();
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                OLAPMemberTreeNode child = (OLAPMemberTreeNode)e.nextElement();
                if (!name.equals(child.getValue())) continue;
                list.add(child);
                node = child;
                continue block0;
            }
        }
    }

    public List getTreePathNodeList(DataItem dataItem, String memberName) throws FilterException {
        List pathList = null;
        try {
            if (dataItem != null) {
                String cubeName = BusinessQueryOLAPUtil.getCubeName((BusinessModel)dataItem.getBusinessModel(), (DataItem)dataItem);
                pathList = this.getTreePathNodeList(cubeName, memberName);
            }
        }
        catch (MetadataException e) {
            throw new FilterException((Throwable)e);
        }
        return pathList;
    }

    public List getTreePathNodeList(String cubeName, String memberName) throws FilterException {
        return OLAPMemberTreeModel.getTreePathNodeList(this, this._metadata, cubeName, memberName);
    }

    public List getTreePathNodeList(String memberName) throws FilterException {
        String cubeName;
        try {
            OLAPMemberTreeNode root = (OLAPMemberTreeNode)this.getRoot();
            if (root.getUserObject() instanceof DimensionInterface) {
                DimensionInterface dim = (DimensionInterface)root.getUserObject();
                this._metadata = dim.getMetadata();
                cubeName = dim.getCube().getName();
            } else {
                cubeName = this._getCubeNameFromRoot();
            }
        }
        catch (Exception e) {
            throw new FilterException((Throwable)e);
        }
        return OLAPMemberTreeModel.getTreePathNodeList(this, this._metadata, cubeName, memberName);
    }

    public List getTreePathNodeList(FilterItemInterface filterItem, FilterValueInterface filterValue) throws FilterException {
        List pathList = null;
        if (filterItem != null && filterValue != null) {
            try {
                String cubeName = this._getCubeNameFromFilterItem(filterItem);
                String memberName = this._getMemberNameFromFilterValue(filterValue);
                pathList = OLAPMemberTreeModel.getTreePathNodeList(this, this._metadata, cubeName, memberName);
            }
            catch (MetadataException e) {
                throw new FilterException((Throwable)e);
            }
        }
        return pathList;
    }

    public List getTreePathNodeList(FilterValueInterface filterValue) throws FilterException {
        List pathList = null;
        if (filterValue != null) {
            try {
                String cubeName = this._getCubeNameFromRoot();
                String memberName = this._getMemberNameFromFilterValue(filterValue);
                pathList = OLAPMemberTreeModel.getTreePathNodeList(this, this._metadata, cubeName, memberName);
            }
            catch (MetadataException e) {
                throw new FilterException((Throwable)e);
            }
        }
        return pathList;
    }

    private String _getCubeNameFromFilterItem(FilterItemInterface filterItem) throws MetadataException {
        if (filterItem.getItem() instanceof DataItem) {
            DataItem dataItem = (DataItem)filterItem.getItem();
            return BusinessQueryOLAPUtil.getCubeName((BusinessModel)dataItem.getBusinessModel(), (DataItem)dataItem);
        }
        return null;
    }

    private String _getCubeNameFromRoot() throws MetadataException {
        OLAPMemberTreeNode root = (OLAPMemberTreeNode)this.getRoot();
        if (root.getData() instanceof DataItem) {
            DataItem dataItem = (DataItem)root.getData();
            return BusinessQueryOLAPUtil.getCubeName((BusinessModel)dataItem.getBusinessModel(), (DataItem)dataItem);
        }
        return null;
    }

    private String _getMemberNameFromFilterValue(FilterValueInterface filterValue) {
        if (filterValue.getUnformattedValue() != null) {
            return filterValue.getUnformattedValue().toString();
        }
        return null;
    }
}

