/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.util.log.LoggerRepository2;

public class InformationMapFilterObjectFactory
extends BaseFilterObjectFactory {
    InformationMap _informationMap = null;

    public InformationMapFilterObjectFactory(FilterBaseModelData baseModel, InformationMap informationMap) {
        super(baseModel, ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
        this._informationMap = informationMap;
    }

    @Override
    public boolean updateSimpleFilterFromTestNode(FilterItem filterItem, FilterLogicTestNodeInterface testNode) {
        boolean isOk = super.updateSimpleFilterFromTestNode(filterItem, testNode);
        if (testNode.getParentLogicNode() == null) {
            boolean isVisible = testNode.getParentLogicNode() == null;
            MapFolder folder = null;
            try {
                folder = this._informationMap.getMapFolderContaining((BusinessItem)filterItem);
                if (folder == null && isVisible) {
                    folder = this._informationMap.getRootMapFolder();
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            try {
                if (folder != null) {
                    if (isVisible) {
                        folder.addBusinessItem((BusinessItem)filterItem);
                    } else {
                        folder.removeBusinessItem((BusinessItem)filterItem);
                    }
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                return false;
            }
        }
        return isOk;
    }
}

