/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.DateAndTimeUtil;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.RB;
import com.sas.datatypes.DataTypeInterface;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.entities.EntityInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.rmi.RemoteException;
import java.sql.Date;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;

public class FilterValueFormatter
extends Format {
    private boolean showUnformattedValues;
    private String unformattedValuesShownFormatString;
    private String valueTextOnlyUnformattedValue;
    private String valueTextOnlyFormattedValue;
    private String valueTextValuesSame;
    private String valueTextForNULL;
    private BusinessQuery businessQuery;
    private static Locale locale;
    private String promptFormatString;

    public static FilterValueFormatter getInstance() {
        return FilterValueFormatter.getInstance(Locale.getDefault());
    }

    public static FilterValueFormatter getInstance(Locale inLocale) {
        return FilterValueFormatter.getInstance(inLocale, false);
    }

    public static FilterValueFormatter getInstance(Locale inLocale, boolean showUnformattedValues) {
        String nullText = RB.getStringResource((String)DefaultFilterValue.RB_KEY, (String)"ValueText.ForNullValueObject.format.txt", (Locale)inLocale);
        String valuesDiffer = RB.getStringResource((String)DefaultFilterValue.RB_KEY, (String)"ValueText.ValuesDiffer.format.txt", (Locale)inLocale);
        String unformatted = RB.getStringResource((String)DefaultFilterValue.RB_KEY, (String)"ValueText.OnlyUnformattedValue.format.txt", (Locale)inLocale);
        String formatted = RB.getStringResource((String)DefaultFilterValue.RB_KEY, (String)"ValueText.OnlyFormattedValue.format.txt", (Locale)inLocale);
        String same = RB.getStringResource((String)DefaultFilterValue.RB_KEY, (String)"ValueText.ValuesSame.format.txt", (Locale)inLocale);
        String promptFormat = "{2}";
        FilterValueFormatter formatter = new FilterValueFormatter(nullText, valuesDiffer, unformatted, formatted, same, promptFormat, inLocale);
        formatter.setShowUnformattedValues(showUnformattedValues);
        return formatter;
    }

    private FilterValueFormatter(String nullText, String valuesDiffer, String unformatted, String formatted, String same, String promptFormat, Locale locale) {
        this.valueTextForNULL = nullText;
        this.unformattedValuesShownFormatString = valuesDiffer;
        this.valueTextOnlyUnformattedValue = unformatted;
        this.valueTextOnlyFormattedValue = formatted;
        this.valueTextValuesSame = same;
        this.promptFormatString = promptFormat;
        FilterValueFormatter.locale = locale;
    }

    public void setShowUnformattedValues(boolean showUnformattedValues) {
        this.showUnformattedValues = showUnformattedValues;
    }

    public void setNullValueText(String nullValueText) {
        this.valueTextForNULL = nullValueText;
    }

    public String getNullValueText() {
        return this.valueTextForNULL;
    }

    public void setPromptFormatString(String promptFormatString) {
        this.promptFormatString = promptFormatString;
    }

    public String getPromptFormatString() {
        return this.promptFormatString;
    }

    public void setUnformattedValueFormatString(String unformattedValuesShownFormatString) {
        this.unformattedValuesShownFormatString = unformattedValuesShownFormatString;
    }

    public String getUnformattedValueFormatString() {
        return this.unformattedValuesShownFormatString;
    }

    public boolean isUnformattedValuesShown() {
        return this.showUnformattedValues;
    }

    public void setBusinessQuery(BusinessQuery businessQuery) {
        this.businessQuery = businessQuery;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof FilterValueInterface) {
            FilterValueInterface value = (FilterValueInterface)obj;
            if (value.getData() == null) {
                toAppendTo.append(this.getNullValueText());
                return toAppendTo;
            }
            String formatted = value.getFormattedValue();
            Object unformatted = value.getUnformattedValue();
            int itemType = value.getDataType();
            if (unformatted instanceof Prompt) {
                String promptValues;
                formatted = promptValues = FilterValueFormatter.getPromptDescription((Prompt)unformatted, this.businessQuery, this.getPromptFormatString(), locale);
                unformatted = promptValues;
            } else if (formatted != null && ((long)itemType == 4L || (long)itemType == 5L || (long)itemType == 6L)) {
                unformatted = formatted;
            }
            Object[] values = new String[]{formatted, null};
            if (unformatted != null) {
                values[1] = unformatted.toString();
            }
            String msg = "";
            msg = this.showUnformattedValues ? (formatted == null && unformatted != null ? this.valueTextOnlyUnformattedValue : (formatted != null && unformatted == null ? this.valueTextOnlyFormattedValue : (formatted.equals(unformatted) ? this.valueTextValuesSame : this.getUnformattedValueFormatString()))) : (formatted == null && unformatted != null ? this.valueTextOnlyUnformattedValue : this.valueTextOnlyFormattedValue);
            String result = MessageFormat.format(msg, values);
            toAppendTo.append(result);
        }
        return toAppendTo;
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatDateTimeValue(int type, Object objectToFormat) {
        if (objectToFormat == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        String sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)type);
        SASFormat formatter = StringExpressionUtil.getSASFormat((String)sasFormatText, (Locale)locale);
        if (formatter instanceof SASDateTimeFormat) {
            SASDateTimeFormat dateTimeFormatter = (SASDateTimeFormat)formatter;
            Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
            synchronized (SASDateTimeFormat.class) {
                TimeZone save = dateTimeFormatter.getTimeZone();
                try {
                    dateTimeFormatter.setTimeZone(DateAndTimeUtil.GMT_ZONE);
                    buf = dateTimeFormatter.format(objectToFormat, buf, null);
                }
                finally {
                    dateTimeFormatter.setTimeZone(save);
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
            }
        }
        buf = formatter.format(objectToFormat, buf, null);
        return buf.toString();
    }

    public static String getPromptDescription(Prompt prompt, BusinessQuery businessQuery, String formatString, Locale locale) {
        PromptDefinitionInterface promptDefinition;
        PromptValuesInterface promptValues;
        String promptValueString = null;
        String promptLabel = null;
        String promptDescription = null;
        String string = formatString = formatString == null ? "{2}" : formatString;
        if (businessQuery != null && (promptValues = businessQuery.getPromptValues()) != null) {
            try {
                if (promptValues.isPromptValueAvailable(prompt.getPromptDefinition())) {
                    Object value = promptValues.getPromptValue(prompt.getPromptDefinition());
                    DataTypeInterface promptDataType = prompt.getPromptDefinition().getPromptDataType();
                    promptValueString = promptDataType.getDisplayString(value, locale);
                }
            }
            catch (PromptValueNotFoundException value) {
                // empty catch block
            }
        }
        if ((promptDefinition = prompt.getPromptDefinition()) != null) {
            promptLabel = promptDefinition.getPromptLabel(locale);
            promptDescription = promptDefinition.getPromptDescription(locale);
        }
        String promptText = Message.format((String)formatString, (Object)promptLabel, promptDescription, promptValueString);
        return promptText;
    }

    protected String getPromptValues(Prompt promptValue) {
        String promptValueString = null;
        AttributeDescriptorInterface attrDesc = promptValue.getAttributeDescriptor();
        if (this.businessQuery != null) {
            EntityInterface entity = this.businessQuery.getEntity();
            try {
                Object values = entity.getAttribute(attrDesc.getName());
                if (values instanceof List) {
                    StringBuffer buf = new StringBuffer();
                    Iterator i = ((List)values).iterator();
                    boolean hasNext = i.hasNext();
                    while (hasNext) {
                        Object o = i.next();
                        String currValue = "";
                        currValue = o instanceof Date ? this.formatDateTimeValue(promptValue.getExpressionType(), o) : String.valueOf(o);
                        buf.append(currValue);
                        hasNext = i.hasNext();
                        if (!hasNext) continue;
                        buf.append(", ");
                    }
                    promptValueString = buf.toString();
                } else if (values != null) {
                    promptValueString = values instanceof Date ? this.formatDateTimeValue(promptValue.getExpressionType(), values) : String.valueOf(values);
                }
            }
            catch (RemoteException remoteException) {
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        if (promptValueString == null) {
            Object value = attrDesc.getDefault();
            promptValueString = value != null ? (value instanceof Date ? this.formatDateTimeValue(promptValue.getExpressionType(), value) : String.valueOf(value)) : promptValue.getLabel();
        }
        return promptValueString;
    }
}

