/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.DataRetrievalError;
import com.sas.dataselectors.filters.FilterConditionListInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterLogicEditableTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicListInterface;
import com.sas.dataselectors.filters.FilterQualifierInterface;
import com.sas.dataselectors.filters.FilterQualifierListInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.dataselectors.filters.PersistentFilterInterface;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FilterLogicTestNodeObjectMap {
    protected Map _filterItemMap = null;
    protected Map _filterQualifierMap = null;
    protected Map _filterConditionMap = null;
    protected Map _filterQualifiedConditionMap = null;
    protected Map _filterValueMap = null;
    protected FilterItemInterface _valuesMappedForItem = null;
    protected Map _filterMap = null;
    protected Map _persistentFilterMap = null;
    protected FilterLogicEditableTestNodeInterface _currentTestNode = null;
    protected FilterValuesInterface filterValues = null;
    protected TransformInterface transformer;
    protected TreeNode rootNode;
    protected List filterValuesList = new ArrayList();
    private boolean onlyLeafSelectable = false;
    protected Map qualifiedMeasure;

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    public FilterValuesInterface getFilterValues() {
        return this.filterValues;
    }

    public void setTranformer(TransformInterface transform) {
        this.transformer = transform;
    }

    public TransformInterface getTransformer() {
        return this.transformer;
    }

    public Map getFilterItemMap() {
        return this._filterItemMap;
    }

    public Map getFilterQualifierMap() {
        return this._filterQualifierMap;
    }

    public Map getFilterConditionMap() {
        return this._filterConditionMap;
    }

    public Map getFilterQualifiedConditionMap() {
        return this._filterQualifiedConditionMap;
    }

    public Map getFilterValueMap() {
        return this._filterValueMap;
    }

    public Map getFilterMap() {
        return this._filterMap;
    }

    public FilterItemInterface getMappedFilterItem() {
        return this._valuesMappedForItem;
    }

    public Map getPersistentFilterMap() {
        return this._persistentFilterMap;
    }

    public void setFilterItemMap(Map map) {
        this._filterItemMap = map;
    }

    public void setFilterMap(Map map) {
        this._filterMap = map;
    }

    public void setPersistentFilterMap(Map map) {
        this._persistentFilterMap = map;
    }

    public void setFilterQualifierMap(Map map) {
        this._filterQualifierMap = map;
    }

    public void setFilterConditionMap(Map map) {
        this._filterConditionMap = map;
    }

    public void setFilterQualifiedConditionMap(Map map) {
        this._filterQualifiedConditionMap = map;
    }

    public void setFilterValueMap(Map map) {
        this._filterValueMap = map;
    }

    public void mapCondition(FilterItemInterface item) {
        if (this._filterConditionMap == null) {
            this._filterConditionMap = new HashMap();
        } else {
            this._filterConditionMap.clear();
        }
        if (this._filterQualifiedConditionMap == null) {
            this._filterQualifiedConditionMap = new HashMap();
        } else {
            this._filterQualifiedConditionMap.clear();
        }
        FilterConditionListInterface conditionListI = item.getConditionList();
        if (conditionListI != null) {
            this.mapObjectsInList(this._filterConditionMap, conditionListI.getConditionList());
        }
        FilterConditionListInterface conditionListII = null;
        if (item.getConditionList() != null && item.getConditionList().getConditionList() != null && item.getQualifierList() != null) {
            conditionListII = item.getQualifiedItem(item.getQualifierList().getFilterQualifierList()).getConditionList();
        }
        if (conditionListII != null) {
            this.mapObjectsInList(this._filterQualifiedConditionMap, conditionListII.getConditionList());
        }
    }

    public void mapQualifier(FilterItemInterface item) {
        if (this._filterQualifierMap == null) {
            this._filterQualifierMap = new HashMap();
        } else {
            this._filterQualifierMap.clear();
        }
        FilterQualifierListInterface qualifierListI = item.getQualifierList();
        if (qualifierListI != null) {
            this.mapObjectsInList(this._filterQualifierMap, qualifierListI.getFilterQualifierList());
        }
    }

    public void mapValues(FilterItemInterface filterItem, ValueProviderInterface vp, Locale locale) throws Exception {
        Object valueContainer;
        if (this._filterValueMap == null) {
            this._filterValueMap = new HashMap();
        } else {
            this._filterValueMap.clear();
        }
        this.filterValues = null;
        boolean mapped = false;
        this._valuesMappedForItem = filterItem;
        if (vp != null && (valueContainer = vp.getValues(locale)) instanceof List) {
            this.filterValuesList = (List)valueContainer;
            this.mapObjectsInList(this._filterValueMap, this.filterValuesList);
            mapped = true;
        }
        if (!mapped) {
            if (this.filterValuesList == null) {
                this.filterValuesList = new ArrayList(0);
            } else {
                this.filterValuesList.clear();
            }
        }
    }

    public void mapValues(FilterItemInterface item) throws Exception {
        if (this._filterValueMap == null) {
            this._filterValueMap = new HashMap();
        } else {
            this._filterValueMap.clear();
        }
        this.filterValues = null;
        this._valuesMappedForItem = item;
        FilterValuesInterface newActualValues = null;
        FilterValuesInterface newPossibleValues = null;
        boolean noValuesAvailable = false;
        List actualValues = null;
        List possibleValues = null;
        newActualValues = item.getActualValues();
        newPossibleValues = item.getPossibleValues();
        try {
            actualValues = newActualValues != null ? newActualValues.getFirstValues(0L) : null;
            List list = possibleValues = newPossibleValues != null ? newPossibleValues.getFirstValues(0L) : null;
            if (actualValues != null && actualValues.size() == 0) {
                newActualValues = null;
            }
            if (possibleValues != null && possibleValues.size() == 0) {
                newPossibleValues = null;
            }
        }
        catch (DataRetrievalError dre) {
            noValuesAvailable = true;
            newActualValues = null;
            newPossibleValues = null;
        }
        if (newActualValues != null) {
            this.filterValues = newActualValues;
            this.filterValuesList = actualValues;
        } else if (newPossibleValues != null) {
            this.filterValues = newPossibleValues;
            this.filterValuesList = possibleValues;
        } else {
            noValuesAvailable = true;
        }
        if (this.filterValues != null) {
            this.mapObjectsInList(this._filterValueMap, this.filterValuesList);
        } else if (this.filterValuesList != null) {
            this.filterValuesList.clear();
        }
    }

    public boolean isOnlyLeafSelectable() {
        return this.onlyLeafSelectable;
    }

    public void mapOLAPValues(FilterItemInterface item) {
        try {
            FilterValuesInterface _filterValues = item.getActualValues();
            if (_filterValues instanceof DefaultTreeModel) {
                return;
            }
            if (this._filterValueMap == null) {
                this._filterValueMap = new HashMap();
            } else {
                this._filterValueMap.clear();
            }
            this._valuesMappedForItem = item;
            this.onlyLeafSelectable = !(_filterValues instanceof FilterValueInterface);
            this.filterValues = _filterValues;
            if (this.filterValues != null) {
                this.rootNode = new DefaultMutableTreeNode();
                TransformInterface transform = this.getTransformer();
                this.rootNode = this.getAllNodes(this.filterValues, (TreeNode)transform.transform((Object)this.filterValues));
                this.mapObjectsInList(this._filterValueMap, this.filterValuesList);
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public void mapFilterItems(FilterItemListInterface filterItems) {
        if (this._filterItemMap == null) {
            this._filterItemMap = new HashMap();
        } else {
            this._filterItemMap.clear();
        }
        List itemList = filterItems.getFilterItemList();
        if (itemList != null) {
            for (FilterItemInterface item : itemList) {
                this._filterItemMap.put(FilterLogicTestNodeObjectMap.getID(item), item);
            }
        }
    }

    public void mapPersistentFilters(List persistentFilterList) {
        if (this._persistentFilterMap == null) {
            this._persistentFilterMap = new HashMap();
        } else {
            this._persistentFilterMap.clear();
        }
        if (persistentFilterList != null) {
            for (PersistentFilterInterface filter : persistentFilterList) {
                this._persistentFilterMap.put(FilterLogicTestNodeObjectMap.getID(filter.getFilterObject()), filter);
            }
        }
    }

    public boolean mapFilterItem(FilterItemInterface item) {
        String id;
        if (this._filterItemMap == null) {
            this._filterItemMap = new HashMap();
        }
        if ((id = FilterLogicTestNodeObjectMap.getID(item)) != null && !this._filterItemMap.containsKey(id)) {
            this._filterItemMap.put(id, item);
            return true;
        }
        return false;
    }

    public boolean mapFilterLogicTestNodeValues(List testNodeValues) {
        boolean mappingModified = false;
        if (testNodeValues != null) {
            for (Object obj : testNodeValues) {
                if (!(obj instanceof FilterValueInterface)) continue;
                String id = FilterLogicTestNodeObjectMap.getID((FilterValueInterface)obj);
                if (this._filterValueMap == null) {
                    this._filterValueMap = new HashMap();
                }
                if (this._filterValueMap.get(id) != null) continue;
                this._filterValueMap.put(id, obj);
                this.filterValuesList.add(obj);
                mappingModified = true;
            }
        }
        return mappingModified;
    }

    private TreeNode transformSwingNodes(TreeNode nodes, TreeNode root) {
        try {
            TransformInterface transform = this.getTransformer();
            int count = nodes.getChildCount();
            for (int i = 0; i < count; ++i) {
                TreeNode node = nodes.getChildAt(i);
                this.filterValuesList.add(node);
                int nodeCount = node.getChildCount();
                if (nodeCount > 0) {
                    ((DefaultMutableTreeNode)root).add((DefaultMutableTreeNode)this.transformSwingNodes(node, (TreeNode)transform.transform((Object)node)));
                    continue;
                }
                ((DefaultMutableTreeNode)root).add((DefaultMutableTreeNode)transform.transform((Object)node));
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return root;
    }

    private TreeNode getAllNodes(FilterValuesInterface values, TreeNode node) {
        try {
            if (values instanceof TreeModel) {
                TreeModel tree = (TreeModel)values;
                Object treeRoot = tree.getRoot();
                TransformInterface transform = this.getTransformer();
                return this.transformSwingNodes((TreeNode)treeRoot, (TreeNode)transform.transform((Object)((TreeNode)treeRoot)));
            }
            List items = values.getFirstValues(0L);
            TransformInterface transform = this.getTransformer();
            for (Object o : items) {
                if (o instanceof FilterValuesInterface) {
                    ((DefaultMutableTreeNode)node).add((DefaultMutableTreeNode)this.getAllNodes((FilterValuesInterface)o, (TreeNode)transform.transform(o)));
                    this.filterValuesList.add((FilterValuesInterface)o);
                    continue;
                }
                if (!(o instanceof FilterValueInterface)) continue;
                try {
                    ((DefaultMutableTreeNode)node).add((DefaultMutableTreeNode)transform.transform(o));
                    this.filterValuesList.add((FilterValueInterface)o);
                }
                catch (Exception e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return node;
    }

    private void mapObjectsInList(Map map, List list) {
        if (list != null && map != null) {
            for (Object item : list) {
                map.put(FilterLogicTestNodeObjectMap.getID(item), item);
            }
        }
    }

    public void mapFilterLogicList(FilterLogicListInterface flli) {
        if (flli != null) {
            if (this._filterMap == null) {
                this._filterMap = new HashMap();
            }
            this.mapObjectsInList(this._filterMap, flli.getFilterList());
        }
    }

    public static String getID(Object object) {
        String id = null;
        if (object != null) {
            id = Integer.toHexString(System.identityHashCode(object));
        }
        return id;
    }

    public static String getValueID(FilterValueInterface value) {
        String id = null;
        if (value != null) {
            id = value.getUnformattedValue() != null ? Integer.toHexString(System.identityHashCode(value.getUnformattedValue())) : (value.getData() != null ? Integer.toHexString(System.identityHashCode(value.getData())) : (value.getFormattedValue() != null ? Integer.toHexString(System.identityHashCode(value.getFormattedValue())) : Integer.toHexString(System.identityHashCode(value))));
        }
        return id;
    }

    public FilterLogicEditableTestNodeInterface getTestNode() {
        return this._currentTestNode;
    }

    public void setTestNode(FilterLogicEditableTestNodeInterface node) {
        this._currentTestNode = node;
    }

    public List getFilterValuesList() {
        return this.filterValuesList;
    }

    public Map getQualifiedMeasure() {
        return this.qualifiedMeasure;
    }

    public void setQualifiedMeasure(FilterQualifierInterface item) {
        if (this.qualifiedMeasure == null) {
            this.qualifiedMeasure = new HashMap();
        }
        this.qualifiedMeasure.put(FilterLogicTestNodeObjectMap.getID(item), item);
    }
}

