/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.MetadataProviderInterface;
import com.sas.dataselectors.filters.FilterException;
import com.sas.iquery.IQueryServicesException;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;

public class FilterBaseModelData
implements MetadataProviderInterface {
    protected Object model;
    protected MetadataInterface metadata;
    protected boolean localMetadata;

    public FilterBaseModelData(Object model) {
        this(model, null);
    }

    public FilterBaseModelData(Object model, MetadataInterface metadata) {
        this.model = model;
        this.metadata = metadata;
        this.localMetadata = false;
    }

    public Object getModel() {
        return this.model;
    }

    public void setModel(Object newModel) {
        if (newModel != this.model) {
            this.releaseResources();
            this.model = newModel;
        }
    }

    public MetadataInterface getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataInterface newMetadata) {
        if (this.metadata != newMetadata) {
            this.releaseResources();
            this.metadata = newMetadata;
        }
    }

    public boolean isLocalMetadata() {
        return this.localMetadata;
    }

    public MetadataInterface createMetadata() throws FilterException {
        if (this.metadata == null && this.model != null) {
            if (this.model instanceof OLAPDataSetInterface) {
                try {
                    this.metadata = ((OLAPDataSetInterface)this.model).getDatabaseMetadata();
                    this.localMetadata = true;
                }
                catch (OLAPException e) {
                    throw new FilterException((Throwable)e);
                }
            }
            try {
                this.metadata = BusinessQueryOLAPUtil.getMetadataInterface((Object)this.model);
                this.localMetadata = true;
            }
            catch (IQueryServicesException e) {
                throw new FilterException((Throwable)e);
            }
        }
        return this.metadata;
    }

    public boolean releaseResources() {
        boolean released = false;
        if (this.metadata != null && this.localMetadata) {
            BusinessQueryOLAPUtil.releaseMetadataInterface((MetadataInterface)this.metadata);
            released = true;
        }
        this.metadata = null;
        this.localMetadata = false;
        return released;
    }
}

