/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AdvancedFilterModelInterface;
import com.sas.dataselectors.filters.BaseAdvancedFilterObjectFactory;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.BusinessModelFilterItemToAdvancedLogicListAdapter;
import com.sas.dataselectors.filters.BusinessQueryFilterItemToAdvancedLogicListAdapter;
import com.sas.dataselectors.filters.BusinessQueryToFilterItemListAdapter;
import com.sas.dataselectors.filters.DefaultFilterItem;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.DefaultPersistentFilter;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterException;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterItemRootToAdvancedList;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeObjectMap;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.FilterQualifierInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.PersistentFilterInterface;
import com.sas.dataselectors.filters.PersistentFilterProviderModelInterface;
import com.sas.dataselectors.filters.PromptValueProviderModelInterface;
import com.sas.dataselectors.filters.SearchValueProviderModelInterface;
import com.sas.dataselectors.filters.SimpleFilterListEditorModelBase;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.dataselectors.filters.SimpleLogicListAdapterInterface;
import com.sas.dataselectors.filters.SystemVariableInterface;
import com.sas.dataselectors.filters.SystemVariableProviderInterface;
import com.sas.dataselectors.filters.Util;
import com.sas.dataselectors.filters.timebased.RelativeTimeFilterData;
import com.sas.dataselectors.filters.tree.IQUtil;
import com.sas.dataselectors.filters.tree.SimpleFilterLogicTreeAdapter;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeFactory;
import com.sas.entities.AttributeTypeInterface;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.dataservices.IQDataServicesFactory;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessModelObject;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.FilterCascadeContainerUpdater;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupList;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemRankFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.AbstractTimeValueExpression;
import com.sas.iquery.metadata.expr.ConstantExpression;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.prompts.definitions.OLAPMemberNameDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.SelectableDefinitionInterface;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.definitions.shared.SharedPromptDefinition;
import com.sas.prompts.util.iquery.PromptIQueryUtil;
import com.sas.prompts.valueprovider.dynamic.iq.DataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.IQRelationalDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.OLAPDataItemValueProvider;
import com.sas.prompts.valueprovider.dynamic.iq.RelationalDataItemValueProvider;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.prompt.PersistenceFactoryWithServices;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.storage.iquery.IQUeryUtil;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.workspace.ColumnValueProvider;
import com.sas.swing.dataselectors.editors.ExpressionValueEditorInterface;
import com.sas.swing.dataselectors.editors.FilterItemEditorInterface;
import com.sas.swing.dataselectors.editors.PromptValueEditorInterface;
import com.sas.swing.dataselectors.editors.QualifiersEditorInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DefaultAdvancedFilterModelAdapter
extends SimpleFilterListEditorModelBase
implements AdvancedFilterModelInterface,
PersistentFilterProviderModelInterface,
SystemVariableProviderInterface,
SearchValueProviderModelInterface,
PromptValueProviderModelInterface {
    private static final boolean DEBUG = false;
    protected BusinessModel _businessModel = null;
    protected BusinessQuery _businessQuery = null;
    protected Object _initialFilterObject = null;
    protected SimpleFilterLogicTreeInterface _logicTree = null;
    protected FilterObjectFactoryInterface _filterObjectFactory = null;
    protected PromptValueEditorInterface _promptValueEditor = null;
    protected ExpressionValueEditorInterface _expressionValueEditor = null;
    protected FilterItemEditorInterface _filterItemEditor = null;
    protected QualifiersEditorInterface _filterQualifierEditor = null;
    protected Map _promptMap = null;
    protected Map _systemVariableMap = null;
    protected String _filterLabel = null;
    protected String _filterDescription = null;
    protected boolean _newFilter = true;
    protected Locale _locale;
    protected Object _revertToFilterObject = null;
    protected Object rootFilterObject;
    protected int environment = 0;
    private PromptValueEditorInterface _sharedPromptSelector;
    private boolean _createCascadeRules;
    private FilterBaseModelData _baseModel;
    private Map valueProviderMap = null;
    private static StringExpressionUtil _stringExpressionUtil = StringExpressionUtil.getInstance();

    public DefaultAdvancedFilterModelAdapter() {
        this((BusinessModel)null);
    }

    public DefaultAdvancedFilterModelAdapter(BusinessModel businessModel) {
        this(businessModel, null);
    }

    public DefaultAdvancedFilterModelAdapter(BusinessModel businessModel, Object initialFilter) {
        this._setInitialFilter(initialFilter);
        this.setModel(businessModel);
    }

    public DefaultAdvancedFilterModelAdapter(BusinessQuery businessQuery) {
        this(businessQuery, null);
    }

    public DefaultAdvancedFilterModelAdapter(BusinessQuery businessQuery, Object initialFilter) {
        this(businessQuery, initialFilter, Locale.getDefault());
    }

    public DefaultAdvancedFilterModelAdapter(BusinessQuery businessQuery, Object initialFilter, Locale locale) {
        this.setLocale(locale);
        this._setInitialFilter(initialFilter);
        this.setModel(businessQuery);
    }

    public DefaultAdvancedFilterModelAdapter(BusinessQuery businessQuery, Object initialFilter, int environment) {
        this._setInitialFilter(initialFilter);
        this.setEnvironment(environment);
        this.setModel(businessQuery);
    }

    protected synchronized FilterBaseModelData getBaseModel() {
        if (this._baseModel == null) {
            this._baseModel = this._businessQuery != null ? new FilterBaseModelData(this._businessQuery) : new FilterBaseModelData(this._businessModel);
        }
        return this._baseModel;
    }

    public void setModel(BusinessModel businessModel) {
        this.setBusinessModel(businessModel);
        FilterBaseModelData bmData = this.getBaseModel();
        bmData.setModel(businessModel);
        BusinessModelFilterItemToAdvancedLogicListAdapter adapter = null;
        if (this._initialFilterObject instanceof FilterItem) {
            adapter = new BusinessModelFilterItemToAdvancedLogicListAdapter(bmData, (FilterItem)this._initialFilterObject, this.environment);
            this._newFilter = false;
        } else {
            adapter = new BusinessModelFilterItemToAdvancedLogicListAdapter(bmData, this.environment);
        }
        this._logicTree = adapter.getFilterLogicTree();
        this._filterObjectFactory = adapter.getFilterObjectFactory();
        if (this._filterObjectFactory instanceof BaseFilterObjectFactory) {
            ((BaseFilterObjectFactory)this._filterObjectFactory).setFilterBaseModelData(bmData);
        }
        this._filterObjectFactory.setLocale(this._locale);
        this.setAdapter((SimpleLogicListAdapterInterface)adapter);
    }

    public void setModel(BusinessQuery businessQuery) {
        this.setBusinessQuery(businessQuery);
        FilterBaseModelData bmData = this.getBaseModel();
        bmData.setModel(businessQuery.getBusinessModel());
        BusinessQueryFilterItemToAdvancedLogicListAdapter adapter = null;
        if (this._initialFilterObject instanceof DataItem) {
            adapter = new BusinessQueryFilterItemToAdvancedLogicListAdapter(businessQuery, bmData, (DataItem)this._initialFilterObject, this.environment);
            this._newFilter = false;
        } else {
            adapter = new BusinessQueryFilterItemToAdvancedLogicListAdapter(businessQuery, bmData, this.environment, this._locale);
        }
        this._logicTree = adapter.getFilterLogicTree();
        this._filterObjectFactory = adapter.getFilterObjectFactory();
        this.setAdapter((SimpleLogicListAdapterInterface)adapter);
    }

    public void setApplicationData(Object data) {
        super.setApplicationData(data);
        this.setEnvironment(this.getEnvironment());
    }

    private void _setInitialFilter(Object filter) {
        this._initialFilterObject = filter;
        this._revertToFilterObject = filter instanceof FilterItem || filter instanceof StepInterface ? filter : (filter instanceof DataItem ? DefaultAdvancedFilterModelAdapter.getFilterableStep((DataItem)filter) : null);
        this.setEnforcePromptCascades(this.isCascadingPrompts());
    }

    public static StepInterface getFilterableStep(DataItem item) {
        List stepList;
        StepInterface step = null;
        int index = -1;
        if (item != null && (stepList = item.getSteps()) != null) {
            for (index = stepList.size() - 1; index >= 0; --index) {
                StepInterface aStep = (StepInterface)stepList.get(index);
                if (aStep instanceof CompoundStep || aStep instanceof DataItemMemberFilter || aStep instanceof DataItemDataBasedFilter || aStep instanceof DataItemMemberPropertiesFilter || aStep instanceof DataItemTimeFilter || aStep instanceof DataItemTimeRangeFilter) {
                    step = aStep;
                    break;
                }
                if (aStep instanceof DataItemRankFilter) continue;
                step = null;
                break;
            }
        }
        return step;
    }

    public void setBusinessModel(BusinessModel model) {
        this._businessModel = model;
    }

    public BusinessModel getBusinessModel() {
        return this._businessModel;
    }

    public void setBusinessQuery(BusinessQuery model) {
        this._businessQuery = model;
        if (model != null) {
            this._businessModel = model.getBusinessModel();
        }
    }

    public BusinessQuery getBusinessQuery() {
        return this._businessQuery;
    }

    public void setSelection(FilterLogicTestNodeInterface value) {
        if (this._selectionIndex == -1) {
            if (this.addSelection(value)) {
                this._selectionIndex = this._filterLogicList.getFilterList().size() - 1;
            }
        } else {
            this._filterLogicList.getFilterList().set(this._selectionIndex, value);
            FilterLogicTestNodeInterface initialSelection = (FilterLogicTestNodeInterface)this._filterLogicList.getFilterList().get(this._selectionIndex);
            this._selectionModel = this.getChangableSelectionModel(initialSelection);
        }
    }

    public void setSelectionCursor(int index) {
        this._selectionIndex = index;
        this._selectionModel = index == -1 ? new DefaultFilterLogicTestNode() : (this._logicTree != null ? (FilterLogicTestNodeInterface)this._logicTree.getUnderstoodTestNodeList().get(this._selectionIndex) : (FilterLogicTestNodeInterface)this._filterLogicList.getFilterList().get(this._selectionIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitChanges() {
        boolean success = false;
        if (this._adapter != null) {
            DefaultAdvancedFilterModelAdapter defaultAdvancedFilterModelAdapter = this;
            synchronized (defaultAdvancedFilterModelAdapter) {
                this.rootFilterObject = null;
                success = this._adapter.commitChanges();
                if (success) {
                    Object obj;
                    this.rootFilterObject = this.getRootFilterObject();
                    this.applyFilterLabel();
                    this.applyFilterDescription();
                    Object newObject = this.getRootFilterObject();
                    if (newObject != this._initialFilterObject) {
                        FilterItem newFilterItem;
                        FilterItem oldFilterItem = this._initialFilterObject instanceof FilterItem ? (FilterItem)this._initialFilterObject : null;
                        FilterItem filterItem = newFilterItem = newObject instanceof FilterItem ? (FilterItem)newObject : null;
                        if (oldFilterItem != null && newFilterItem != null && oldFilterItem.getClass() == newFilterItem.getClass()) {
                            if (oldFilterItem instanceof CompoundFilter) {
                                CompoundFilter oldCF = (CompoundFilter)oldFilterItem;
                                CompoundFilter newCF = (CompoundFilter)newFilterItem;
                                try {
                                    oldCF.setLeftFilter(newCF.getLeftFilter());
                                    oldCF.setRightFilter(newCF.getRightFilter());
                                    oldCF.setRelationType(newCF.getRelationType());
                                    oldCF.setLabel(newCF.getLabel());
                                    oldCF.setDescription(newCF.getDescription());
                                    oldCF.setExtendedAttributes(newCF.getExtendedAttributes());
                                    oldCF.setIsHidden(newCF.isHidden());
                                    oldCF.setIsNegated(newCF.isNegated());
                                }
                                catch (MetadataException e) {
                                    success = false;
                                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                                }
                            } else {
                                try {
                                    oldFilterItem.setExpression(newFilterItem.getExpression());
                                    oldFilterItem.setLabel(newFilterItem.getLabel());
                                    oldFilterItem.setDescription(newFilterItem.getDescription());
                                    oldFilterItem.setExtendedAttributes(newFilterItem.getExtendedAttributes());
                                    oldFilterItem.setIsHidden(newFilterItem.isHidden());
                                    IQUtil.addFilterItemsToBusinessModel(this._businessModel, oldFilterItem);
                                    if (this._businessModel.contains((BusinessModelObject)newFilterItem)) {
                                        this._businessModel.removeBusinessItem((BusinessItem)newFilterItem);
                                    }
                                }
                                catch (MetadataException e) {
                                    success = false;
                                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                                }
                            }
                            this.rootFilterObject = oldFilterItem;
                        } else {
                            if (newFilterItem != null) {
                                try {
                                    IQUtil.addFilterItemsToBusinessModel(this._businessModel, newFilterItem);
                                }
                                catch (MetadataException e) {
                                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                                }
                            }
                            if (oldFilterItem != null && newObject instanceof BusinessModelObject) {
                                FilterItem bmOld = oldFilterItem;
                                BusinessModelObject bmNew = (BusinessModelObject)newObject;
                                if (!bmNew.getIntraModelID().equals(bmOld.getIntraModelID())) {
                                    this._swapIntraModelIDs((BusinessModelObject)bmOld, bmNew);
                                    List list = this.deleteFilterItemAndChildren(oldFilterItem);
                                }
                            }
                        }
                    }
                    if ((obj = this.getRootFilterObject()) instanceof FilterItem) {
                        FilterItem iqFilter = (FilterItem)obj;
                        ExpressionInterface expression = iqFilter.getExpression();
                        if (expression instanceof FilterCascadeContainerUpdater) {
                            ((FilterCascadeContainerUpdater)expression).setCascades(new ArrayList());
                        }
                        if (this.isEnforcingPromptCascades()) {
                            PromptIQueryUtil.applyCascadingFilters(iqFilter);
                        }
                    }
                }
            }
        }
        this.releaseMetadata();
        return success;
    }

    private List deleteFilterItemAndChildren(FilterItem parent) {
        ArrayList wasDeleted = new ArrayList();
        ArrayList<FilterItem> mayBeDeleted = new ArrayList<FilterItem>();
        if (parent != null) {
            mayBeDeleted.add(parent);
        }
        while (!mayBeDeleted.isEmpty()) {
            FilterItem fi;
            Object o = mayBeDeleted.remove(0);
            if (!(o instanceof FilterItem) || !(fi = (FilterItem)o).isHidden() && parent != fi || !fi.isContainedInBusinessModel() || fi.isReadOnly()) continue;
            this._filterObjectFactory.removeFilterItem(o);
            wasDeleted.add(o);
            if (!(o instanceof CompoundFilter)) continue;
            CompoundFilter cf = (CompoundFilter)o;
            if (cf.getLeftFilter() != null) {
                mayBeDeleted.add(cf.getLeftFilter());
            }
            if (cf.getRightFilter() == null) continue;
            mayBeDeleted.add(cf.getRightFilter());
        }
        return wasDeleted;
    }

    private void _swapIntraModelIDs(BusinessModelObject one, BusinessModelObject two) {
        String newID = one.getIntraModelID();
        try {
            FilterItem tempFilter = this._businessModel.newFilterItem();
            String tempID = tempFilter.getIntraModelID();
            one.setIntraModelID(tempID);
        }
        catch (MetadataException e) {
            try {
                one.setIntraModelID("old_filter");
            }
            catch (InvalidIDException e1) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e1.getMessage(), (Throwable)e1);
            }
        }
        try {
            two.setIntraModelID(newID);
        }
        catch (InvalidIDException e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized Object getRootFilterObject() {
        if (this.rootFilterObject == null && this._adapter != null) {
            return this._adapter.getRootFilterObject();
        }
        return this.rootFilterObject;
    }

    private void releaseMetadata() {
        FilterBaseModelData bmData = this.getBaseModel();
        if (bmData != null) {
            bmData.releaseResources();
        }
    }

    public void cancel() {
        if (this._logicTree != null) {
            this._logicTree.cancel(this._revertToFilterObject);
        }
        this.releaseMetadata();
    }

    public void setFilterLabel(String label) {
        this._filterLabel = label;
    }

    protected void applyFilterLabel() {
        Object rootFilter = this.getRootFilterObject();
        if (rootFilter != null && rootFilter instanceof BusinessModelObject) {
            try {
                BusinessModelObject bmObj = (BusinessModelObject)rootFilter;
                bmObj.setLabel(this._filterLabel);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getFilterLabel() {
        Object rootFilter;
        if (this._filterLabel == null && (rootFilter = this.getRootFilterObject()) != null && rootFilter instanceof BusinessModelObject) {
            this._filterLabel = ((BusinessModelObject)rootFilter).getLabel();
        }
        return this._filterLabel;
    }

    public void setFilterDescription(String value) {
        this._filterDescription = value;
    }

    protected void applyFilterDescription() {
        Object rootFilter = this.getRootFilterObject();
        if (rootFilter != null && rootFilter instanceof BusinessModelObject) {
            try {
                ((BusinessModelObject)rootFilter).setDescription(this._filterDescription);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getFilterDescription() {
        Object rootFilter;
        if (this._filterDescription == null && (rootFilter = this.getRootFilterObject()) != null && rootFilter instanceof BusinessModelObject) {
            this._filterDescription = ((BusinessModelObject)rootFilter).getDescription();
        }
        return this._filterDescription;
    }

    public boolean addSelection(FilterLogicTestNodeInterface value) {
        return this._filterLogicList.getFilterList().add(value);
    }

    public void removeSelection() {
        this._filterLogicList.getFilterList().remove(this._selectionIndex);
        this._selectionIndex = -1;
        this._selectionModel = new DefaultFilterLogicTestNode();
    }

    public SimpleFilterLogicTreeInterface getSelectionTree() {
        return this._logicTree;
    }

    public SimpleFilterLogicTreeInterface getSelectionTree(PersistentFilterInterface pFilter) {
        SimpleFilterLogicTreeInterface result = null;
        if (pFilter != null && this._logicTree instanceof SimpleFilterLogicTreeAdapter) {
            result = this._logicTree.copy();
            ((SimpleFilterLogicTreeAdapter)result).setFilterObject(pFilter.getFilterObject());
        }
        return result;
    }

    public boolean isOLAP() {
        if (this._businessModel != null) {
            return this._businessModel.getStructure().isOLAP();
        }
        if (this._businessQuery != null) {
            return this._businessQuery.getInputStructure().isOLAP();
        }
        return false;
    }

    public boolean isCascadingPrompts() {
        boolean isCascading = false;
        if (!this.isOLAP() && this._initialFilterObject instanceof FilterItem) {
            FilterItem iqFilter = (FilterItem)this._initialFilterObject;
            List cascades = iqFilter.getCascades(true);
            isCascading = cascades != null && cascades.size() > 0;
        }
        return isCascading;
    }

    private List getPrompts() {
        ArrayList<Prompt> prompts = new ArrayList<Prompt>();
        SimpleFilterLogicTreeInterface tree = this.getSelectionTree();
        if (tree != null) {
            Object[] vals = new Object[2];
            List expressionInfo = Util.getExpressionInfo((SimpleFilterLogicTreeInterface)tree, (int)1, (Locale)this.getLocale(), (boolean)true);
            if (expressionInfo != null && expressionInfo.size() >= 2) {
                for (Map infoMap : expressionInfo) {
                    Prompt prompt;
                    FilterLogicTestNodeInterface testNode;
                    List values;
                    Object node = infoMap.get("Node");
                    if (!(node instanceof FilterLogicTestNodeInterface) || (values = (testNode = (FilterLogicTestNodeInterface)node).getTestValuesList()) == null || values.size() <= 0 || (prompt = this.getPromptedValue(values.get(0))) == null) continue;
                    prompts.add(prompt);
                }
            }
        }
        return prompts;
    }

    public int isCascadable() {
        List promptList = this.getPrompts();
        int size = promptList.size();
        if (size < 2) {
            return 1;
        }
        for (int i = 0; i < size; ++i) {
            Prompt prompt = (Prompt)promptList.get(i);
            PromptDefinitionInterface definition = prompt.getPromptDefinition();
            if (!(definition instanceof ValueProviderDefinitionInterface)) continue;
            ValueProviderInterface valueProvider = ((ValueProviderDefinitionInterface)prompt.getPromptDefinition()).getValueProvider();
            if (valueProvider instanceof ColumnValueProvider) {
                return 2;
            }
            if (!(valueProvider instanceof DataItemValueProvider) || !(definition instanceof SharedPromptDefinition)) continue;
            return 4;
        }
        return 0;
    }

    private Prompt getPromptedValue(Object value) {
        if (value != null) {
            String potentialName;
            if (value instanceof FilterValueInterface) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof ConstantExpression && (value = this.getPromptedValueByName(potentialName = ((ConstantExpression)value).getValue())) != null) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof Prompt) {
                return (Prompt)value;
            }
        }
        return null;
    }

    public void setEnforcePromptCascades(boolean cascadePrompts) {
        this._createCascadeRules = cascadePrompts;
    }

    public boolean isEnforcingPromptCascades() {
        return this._createCascadeRules;
    }

    public PromptValueEditorInterface getSharedPromptSelector() {
        return this._sharedPromptSelector;
    }

    public void setSharedPromptSelector(PromptValueEditorInterface sharedPromptSelector) {
        this._sharedPromptSelector = sharedPromptSelector;
    }

    public PromptValueEditorInterface getPromptValueEditor() {
        return this._promptValueEditor;
    }

    public void setPromptValueEditor(PromptValueEditorInterface promptValueEditor) {
        this._promptValueEditor = promptValueEditor;
    }

    public ExpressionValueEditorInterface getExpressionValueEditor() {
        return this._expressionValueEditor;
    }

    public void setExpressionValueEditor(ExpressionValueEditorInterface expressionValueEditor) {
        this._expressionValueEditor = expressionValueEditor;
    }

    public FilterItemEditorInterface getFilterItemEditor() {
        return this._filterItemEditor;
    }

    public void setFilterItemEditor(FilterItemEditorInterface filterItemEditor) {
        this._filterItemEditor = filterItemEditor;
    }

    public QualifiersEditorInterface getFilterQualifierEditor() {
        this.setFilterQualifierEditorInfo(this.getSelection());
        return this._filterQualifierEditor;
    }

    protected String getFilterQualifierSkipID(Object nativeItem) throws FilterException {
        String itemID = null;
        if (nativeItem instanceof DataItem) {
            DataItem dataItem = (DataItem)nativeItem;
            try {
                itemID = dataItem.getID();
                itemID = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)this._businessModel, (DataItem)dataItem);
            }
            catch (Exception e) {
                throw new FilterException((Throwable)e);
            }
        }
        return itemID;
    }

    public void setFilterQualifierEditorInfo(FilterLogicTestNodeInterface testNode) {
        if (this._filterQualifierEditor != null && testNode != null) {
            FilterItemInterface item = testNode.getFilterItem();
            String itemID = null;
            if (item != null) {
                try {
                    itemID = this.getFilterQualifierSkipID(item.getItem());
                }
                catch (FilterException e) {
                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
            HashMap<Integer, String> selectedQualifierMap = new HashMap<Integer, String>();
            String qualifierLabel = null;
            List qualifiers = testNode.getFilterItemQualifiers();
            if (qualifiers != null && qualifiers.size() > 0) {
                FilterQualifierInterface primaryQualifier = (FilterQualifierInterface)qualifiers.get(0);
                List subQualifiers = null;
                if (primaryQualifier.getQualifier() instanceof List) {
                    qualifiers = (List)primaryQualifier.getQualifier();
                    primaryQualifier = (FilterQualifierInterface)qualifiers.get(0);
                }
                if (qualifiers.size() > 1) {
                    subQualifiers = qualifiers.subList(1, qualifiers.size());
                }
                if (subQualifiers != null) {
                    for (int i = 0; i < subQualifiers.size(); ++i) {
                        FilterQualifierInterface q = (FilterQualifierInterface)subQualifiers.get(i);
                        Object qObject = q.getQualifier();
                        String memberName = qObject instanceof ExpressionInterface ? BaseFilterObjectFactory.getExpressionUtilText((ExpressionInterface)qObject) : q.getQualifierLabel();
                        selectedQualifierMap.put(new Integer(i), memberName);
                    }
                }
                if (primaryQualifier != null) {
                    qualifierLabel = primaryQualifier.getQualifierLabel();
                }
            }
            this._filterQualifierEditor.skipItem(itemID);
            this._filterQualifierEditor.initialValues(selectedQualifierMap);
            this._filterQualifierEditor.itemName(qualifierLabel);
        }
    }

    public FilterQualifierInterface applyFilterQualifierEditorChanges(FilterLogicTestNodeInterface testNode) {
        return this.applyFilterQualifierEditorChanges(testNode, null);
    }

    public FilterQualifierInterface applyFilterQualifierEditorChanges(FilterLogicTestNodeInterface testNode, Map selectedQualifierMap) {
        FilterQualifierInterface newQualifier = null;
        if (this._filterQualifierEditor != null && testNode != null) {
            if (selectedQualifierMap == null) {
                selectedQualifierMap = this._filterQualifierEditor.selectedValues();
            }
            ArrayList<FilterQualifierInterface> qualifierList = null;
            Set entrySet = selectedQualifierMap.entrySet();
            qualifierList = new ArrayList<FilterQualifierInterface>(entrySet.size() + 1);
            List qList = testNode.getFilterItemQualifiers();
            FilterQualifierInterface primaryQualifier = null;
            while (qList != null) {
                if (!(qList.get(0) instanceof FilterQualifierInterface)) continue;
                primaryQualifier = (FilterQualifierInterface)qList.get(0);
                if (primaryQualifier.getQualifier() instanceof List) {
                    qList = (List)primaryQualifier.getQualifier();
                    continue;
                }
                qList = null;
            }
            if (primaryQualifier != null) {
                qualifierList.add(primaryQualifier);
            }
            for (Map.Entry entry : entrySet) {
                String valueUniqueName = (String)entry.getValue();
                FilterQualifierInterface qualifier = ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterQualifierFromNative(valueUniqueName);
                qualifierList.add(qualifier);
            }
            newQualifier = ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterQualifierFromNative(qualifierList);
            if (testNode instanceof DefaultFilterLogicTestNode) {
                ((DefaultFilterLogicTestNode)testNode).setFilterItemQualifiers(Collections.singletonList(newQualifier));
            }
        }
        return newQualifier;
    }

    public void setPromptValueEditorInfo(FilterLogicTestNodeInterface testNode, int valueIndex) {
        this.setPromptValueEditorInfo(testNode, valueIndex, false);
    }

    public void setPromptValueEditorInfo(FilterLogicTestNodeInterface testNode, int valueIndex, boolean isRangePrompt) {
        this.setPromptValueEditorInfo(this._promptValueEditor, testNode, valueIndex, isRangePrompt);
    }

    public void setPromptValueEditorInfo(PromptValueEditorInterface promptValueEditor, FilterLogicTestNodeInterface testNode, int valueIndex, boolean isRangePrompt) {
        if (promptValueEditor != null && testNode != null) {
            promptValueEditor.setPromptType((int)testNode.getFilterItem().getItemType());
            Object expression = null;
            List valueList = testNode.getTestValuesList();
            if (valueList != null && valueList.size() > valueIndex) {
                Object obj = valueList.get(valueIndex);
                if (obj instanceof FilterValueInterface) {
                    expression = ((FilterValueInterface)obj).getUnformattedValue();
                }
                expression = obj;
            }
            ArrayList<Object> promptData = new ArrayList<Object>();
            promptData.add(0, testNode);
            promptData.add(1, expression);
            promptData.add(2, isRangePrompt ? Boolean.TRUE : Boolean.FALSE);
            promptValueEditor.setPromptData(promptData);
        }
    }

    public FilterValueInterface applyPromptValueEditorChanges(FilterLogicTestNodeInterface testNode, int valueIndex) {
        return this.applyPromptValueEditorChanges(this._promptValueEditor, testNode, valueIndex);
    }

    public FilterValueInterface applyPromptValueEditorChanges(PromptValueEditorInterface promptValueEditor, FilterLogicTestNodeInterface testNode, int valueIndex) {
        FilterValueInterface newValue = null;
        if (promptValueEditor != null && testNode != null) {
            Object newExpression = promptValueEditor.getPromptData();
            newValue = ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative(newExpression);
            if (testNode instanceof DefaultFilterLogicTestNode) {
                ArrayList<FilterValueInterface> oldList = testNode.getTestValuesList();
                if (oldList == null) {
                    oldList = new ArrayList<FilterValueInterface>();
                }
                while (oldList.size() <= valueIndex) {
                    oldList.add(null);
                }
                oldList.set(valueIndex, newValue);
                ((DefaultFilterLogicTestNode)testNode).setTestValuesList(oldList);
            }
        }
        return newValue;
    }

    public void setExpressionValueEditorInfo(FilterLogicTestNodeInterface testNode, int valueIndex) {
        if (this._expressionValueEditor != null && testNode != null) {
            List qList = testNode.getFilterItemQualifiers();
            int eType = 0;
            eType = this.isOLAP() && qList != null && qList.size() > 0 ? (int)testNode.getFilterItem().getQualifiedItem(qList).getItemType() : (int)testNode.getFilterItem().getItemType();
            this._expressionValueEditor.setExpressionType(eType);
            Object expression = null;
            List valueList = testNode.getTestValuesList();
            if (valueList != null && valueList.size() > valueIndex) {
                FilterValueInterface value;
                Object obj = valueList.get(valueIndex);
                if (obj instanceof FilterValueInterface && (value = (FilterValueInterface)obj).getDataType() != eType) {
                    obj = value.getUnformattedValue();
                }
                expression = obj;
            }
            this._expressionValueEditor.setExpression(expression);
        }
    }

    public FilterValueInterface applyExpressionValueEditorChanges(FilterLogicTestNodeInterface testNode, int valueIndex) {
        Object newExpression;
        FilterValueInterface newValue = null;
        if (this._expressionValueEditor != null && testNode != null && (newExpression = this._expressionValueEditor.getExpression()) != null) {
            newValue = ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative(((FilterValueInterface)newExpression).getData());
            if (testNode instanceof DefaultFilterLogicTestNode) {
                ArrayList<FilterValueInterface> oldList = testNode.getTestValuesList();
                if (oldList == null) {
                    oldList = new ArrayList<FilterValueInterface>();
                }
                while (oldList.size() <= valueIndex) {
                    oldList.add(null);
                }
                oldList.set(valueIndex, newValue);
                ((DefaultFilterLogicTestNode)testNode).setTestValuesList(oldList);
            }
        }
        return newValue;
    }

    public void setFilterItemEditorInfo(FilterLogicTestNodeInterface testNode) {
        if (this._filterItemEditor != null && testNode != null) {
            Object input = null;
            if (testNode.getFilterItem() != null) {
                input = testNode.getFilterItem().getItem();
            }
            if (input instanceof DataItemReference) {
                DataItemReference ref = (DataItemReference)input;
                input = ref.getBaseDataItem();
            }
            DefaultFilterValue fvi = null;
            if (input instanceof ExpressionInterface) {
                ExpressionInterface expression;
                ExpressionInterface value = expression = (ExpressionInterface)input;
                ExpressionInterface unformattedValue = expression;
                int dataType = expression.getExpressionType();
                FilterConditionInterface condition = testNode.getCondition();
                if (condition != null && condition.getCondition() == FilterItemEditorInterface.class) {
                    Object item = testNode.getFilterItem().getItem();
                    if (item instanceof ResourceAwareStringExpression) {
                        ResourceAwareStringExpression rase = (ResourceAwareStringExpression)item;
                        try {
                            expression = StringExpressionUtil.getInstance().newExpression(this._businessModel, rase.toString(), 2, rase.getResourceScope());
                            this._filterItemEditor.setFilterItemData((Object)expression);
                        }
                        catch (MetadataException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    String formattedValue = null;
                    try {
                        formattedValue = StringExpressionUtil.getInstance().getReadableText(expression);
                    }
                    catch (MetadataException rase) {
                        // empty catch block
                    }
                    Object format = null;
                    fvi = new DefaultFilterValue((Object)value, formattedValue, dataType, format, (Object)unformattedValue);
                    this._filterItemEditor.setFilterItemData((Object)fvi);
                }
            } else {
                this._filterItemEditor.setFilterItemData(null);
            }
        }
    }

    public FilterItemInterface applyFilterItemEditorChanges(FilterLogicTestNodeInterface testNode) {
        Object data;
        FilterItemInterface newItem = null;
        if (this._filterItemEditor != null && testNode != null && (data = this._filterItemEditor.getFilterItemData()) instanceof FilterValueInterface) {
            FilterValueInterface transport = (FilterValueInterface)data;
            FilterConditionInterface condition = testNode.getCondition();
            if (condition != null && condition.getCondition() == FilterItemEditorInterface.class) {
                Object expressionData = transport.getData();
                FilterItemInterface item = testNode.getFilterItem();
                if (item instanceof DefaultFilterItem) {
                    DefaultFilterItem defaultFilterItem = (DefaultFilterItem)item;
                    defaultFilterItem.setItem(expressionData);
                    defaultFilterItem.setItemLabel(expressionData.toString());
                    newItem = item;
                }
            } else if (transport.getFormattedValue() != null && transport.getData() instanceof StringExpression) {
                String expText;
                StringExpression exp = (StringExpression)transport.getData();
                try {
                    expText = exp.getText();
                }
                catch (MetadataException e) {
                    expText = null;
                }
                if (expText != null && expText.trim().length() > 0) {
                    FilterItemInterface oldItem = testNode.getFilterItem();
                    if (oldItem == null || !this._isEquivalentExpression(transport.getData(), oldItem.getItem())) {
                        newItem = ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterItemFromNative(data, null);
                        if (testNode instanceof DefaultFilterLogicTestNode) {
                            ((DefaultFilterLogicTestNode)testNode).setFilterItem(newItem);
                        }
                    } else {
                        newItem = oldItem;
                    }
                }
            }
        }
        return newItem;
    }

    private boolean _isEquivalentExpression(Object one, Object two) {
        return one == null ? two == null : one.equals(two);
    }

    public void setFilterQualifierEditor(QualifiersEditorInterface filterQualifierEditor) {
        this._filterQualifierEditor = filterQualifierEditor;
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean commit) {
        if (this._logicTree != null) {
            this._logicTree.clear();
        }
        this.setSelectionCursor(-1);
    }

    public boolean isEditedExpressionValue(Object value) {
        if (value == null) {
            return false;
        }
        Object o = null;
        if (value instanceof FilterValueInterface) {
            Object data = ((FilterValueInterface)value).getData();
            if (data == null) {
                return false;
            }
            o = data;
        } else {
            o = value;
        }
        boolean isEdited = false;
        if (o instanceof ResourceAwareStringExpression) {
            isEdited = true;
        }
        return isEdited;
    }

    public boolean isUserCreatedValue(Object value) {
        if (value != null) {
            if (value instanceof FilterValueInterface) {
                AbstractTimeValueExpression timeVal;
                Double valueAsNumber;
                Object filterValueData = ((FilterValueInterface)value).getData();
                if (filterValueData instanceof StringExpression) {
                    return true;
                }
                if (filterValueData instanceof AbstractTimeValueExpression ? (valueAsNumber = (timeVal = (AbstractTimeValueExpression)filterValueData).getExplicitDoubleValue()) == null : ((FilterValueInterface)value).getUnformattedValue() instanceof RelativeTimeFilterData) {
                    return true;
                }
            } else if (value instanceof Date || value instanceof RelativeTimeFilterData) {
                return true;
            }
        }
        return false;
    }

    public boolean isQuotedValue(Object value) {
        return value != null && value instanceof FilterValueInterface && (long)((FilterValueInterface)value).getDataType() == 3L && (value = ((FilterValueInterface)value).getData()) instanceof ConstantExpression;
    }

    public boolean isPromptedValue(Object value) {
        if (value != null) {
            String potentialName;
            if (value instanceof FilterValueInterface) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof ConstantExpression && (value = this.getPromptedValueByName(potentialName = ((ConstantExpression)value).getValue())) != null) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof Prompt) {
                return true;
            }
        }
        return false;
    }

    public boolean isPromptedRangeValue(Object value) {
        if (value != null) {
            PromptDefinitionInterface definition;
            String potentialName;
            if (value instanceof FilterValueInterface) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof ConstantExpression && (value = this.getPromptedValueByName(potentialName = ((ConstantExpression)value).getValue())) != null) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof Prompt && BaseDefinitionRangeInterface.class.isAssignableFrom((definition = ((Prompt)value).getPromptDefinition()).getClass())) {
                return true;
            }
        }
        return false;
    }

    public Map getPromptValueMap() {
        if (this._promptMap == null) {
            this.refreshPromptValueMap();
        }
        return this._promptMap;
    }

    protected void refreshPromptValueMap() {
        List prompts;
        if (this._promptMap == null) {
            this._promptMap = new HashMap();
        }
        if (this._businessModel != null && (prompts = this._businessModel.getObjects(3, Prompt.class)) != null) {
            for (Prompt prompt : prompts) {
                if (IQUeryUtil.isSystemIdentityPrompt(prompt)) continue;
                String key = prompt.getLabel();
                if (!key.startsWith("&")) {
                    key = "&" + key;
                }
                if (this._promptMap.get(key) != null) continue;
                this._promptMap.put(key, ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative(prompt));
            }
        }
    }

    public static boolean isPromptMultipleSelection(Prompt prompt) {
        boolean isMultiValuedPrompt = false;
        if (prompt != null) {
            SelectableDefinitionInterface sdi;
            PromptDefinitionInterface promptDefinition = prompt.getPromptDefinition();
            if (promptDefinition != null && "SAS.IdentityGroups".equals(promptDefinition.getPromptName())) {
                isMultiValuedPrompt = true;
            } else if (promptDefinition instanceof SelectableDefinitionInterface && ((sdi = (SelectableDefinitionInterface)promptDefinition).getSelectionType() != 300 || sdi.getMaximumValueCount() > 1 || sdi.getMaximumValueCount() < 0)) {
                isMultiValuedPrompt = true;
            }
        }
        return isMultiValuedPrompt;
    }

    public List getPromptValueList(Object item) {
        List prompts;
        ArrayList<FilterValueInterface> promptList = new ArrayList<FilterValueInterface>();
        if (this._businessModel != null && (prompts = this._businessModel.getObjects(3, Prompt.class)) != null) {
            FilterLogicTestNodeInterface testNode = item instanceof FilterLogicTestNodeInterface ? (FilterLogicTestNodeInterface)item : null;
            for (Prompt prompt : prompts) {
                if (IQUeryUtil.isSystemIdentityPrompt(prompt)) continue;
                PromptDefinitionInterface promptDefinition = prompt.getPromptDefinition();
                if (promptDefinition instanceof SharedPromptDefinition && this._businessModel instanceof InformationMap) {
                    try {
                        InformationMap map = (InformationMap)this._businessModel;
                        SessionContextInterface sessionContext = map.getSession();
                        UserContextInterface userContext = sessionContext.getUserContext();
                        String location = ((SharedPromptDefinition)promptDefinition).getSharedPromptLocation();
                        PathUrl path = PersistenceFactoryWithServices.newPathUrlFromString((UserContextInterface)userContext, (String)location);
                        PromptsPersistUtil.getDefinitionFromFolder((PathUrl)path, (UserContextInterface)userContext);
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                if (testNode != null) {
                    if (this.isOLAP()) {
                        if (!(promptDefinition instanceof OLAPMemberNameDefinitionInterface)) {
                            continue;
                        }
                    } else {
                        boolean isMultiValuedPrompt = DefaultAdvancedFilterModelAdapter.isPromptMultipleSelection(prompt);
                        DataTypeInterface promptDataType = promptDefinition.getPromptDataType();
                        boolean isValidPrompt = true;
                        if (!this.isValidPromptType(testNode.getFilterItem(), promptDataType)) {
                            isValidPrompt = false;
                        }
                        if (isValidPrompt && promptDefinition.isDefaultValueSet()) {
                            Collection c = promptDefinition.validateDefinition(this.getLocale());
                            isValidPrompt = c.isEmpty();
                        }
                        if (isMultiValuedPrompt && testNode.getCondition().getConditionArgumentCount() != -1 || !isValidPrompt || BaseRangeDataType.class.isAssignableFrom(promptDataType.getClass())) continue;
                    }
                }
                promptList.add(((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative(prompt));
            }
        }
        return promptList;
    }

    public List getPromptRangeValueList(Object item) {
        List prompts;
        FilterLogicTestNodeInterface testNode;
        ArrayList<FilterValueInterface> promptList = new ArrayList<FilterValueInterface>();
        FilterLogicTestNodeInterface filterLogicTestNodeInterface = testNode = item instanceof FilterLogicTestNodeInterface ? (FilterLogicTestNodeInterface)item : null;
        if (this._businessModel != null && (prompts = this._businessModel.getObjects(3, Prompt.class)) != null) {
            for (Prompt prompt : prompts) {
                if (IQUeryUtil.isSystemIdentityPrompt(prompt)) continue;
                if (testNode != null) {
                    PromptDefinitionInterface promptDefinition = prompt.getPromptDefinition();
                    DataTypeInterface promptDataType = promptDefinition.getPromptDataType();
                    boolean isValidPrompt = true;
                    if (!this.isValidPromptType(testNode.getFilterItem(), promptDataType)) {
                        isValidPrompt = false;
                    }
                    if (isValidPrompt && !BaseRangeDataType.class.isAssignableFrom(promptDataType.getClass())) {
                        isValidPrompt = false;
                    }
                    if (isValidPrompt && promptDefinition.isDefaultValueSet()) {
                        Collection c = promptDefinition.validateDefinition(this.getLocale());
                        isValidPrompt = c.isEmpty();
                    }
                    if (!isValidPrompt) continue;
                }
                promptList.add(((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative(prompt));
            }
        }
        return promptList;
    }

    protected boolean isValidPromptType(FilterItemInterface filterItem, DataTypeInterface promptDataType) {
        boolean isValidPrompt = true;
        if (filterItem == null || promptDataType == null) {
            isValidPrompt = false;
        }
        int filterItemSQLType = this.getFilterItemSQLType(filterItem);
        if (isValidPrompt && promptDataType.getSQLType() != filterItemSQLType && (promptDataType.getSQLType() != 4 || 8 != filterItemSQLType)) {
            isValidPrompt = false;
        }
        return isValidPrompt;
    }

    protected int getFilterItemSQLType(FilterItemInterface item) {
        int sqlType = 2000;
        if (item != null) {
            long type = item.getItemType();
            if (type == 3L || type == 1L) {
                sqlType = 12;
            } else if (type == 2L) {
                sqlType = 8;
            } else if (type == 4L) {
                sqlType = 91;
            } else if (type == 5L) {
                sqlType = 92;
            } else if (type == 6L) {
                sqlType = 93;
            } else if (type == 9L) {
                sqlType = 16;
            }
        }
        return sqlType;
    }

    protected AttributeTypeInterface getFilterItemAttributeType(FilterItemInterface item) {
        AttributeType at = null;
        if (item != null) {
            long type = item.getItemType();
            at = type == 3L || type == 1L ? AttributeTypeFactory.STRING_ATTRIBUTE_TYPE : (type == 2L ? AttributeTypeFactory.DOUBLE_ATTRIBUTE_TYPE : (type == 4L ? AttributeTypeFactory.DATE_ATTRIBUTE_TYPE : (type == 5L ? AttributeTypeFactory.TIME_ATTRIBUTE_TYPE : (type == 6L ? AttributeTypeFactory.TIMESTAMP_ATTRIBUTE_TYPE : (type == 9L ? AttributeTypeFactory.BOOLEAN_ATTRIBUTE_TYPE : AttributeTypeFactory.OBJECT_ATTRIBUTE_TYPE)))));
        }
        return at;
    }

    public FilterValueInterface getPromptedValueByName(String name) {
        FilterValueInterface promptedValue = null;
        if (name != null) {
            Object o;
            Map pMap = this.getPromptValueMap();
            if (!name.startsWith("&")) {
                name = "&" + name;
            }
            if ((o = pMap.get(name)) == null) {
                this.refreshPromptValueMap();
                o = pMap.get(name);
            }
            if (o != null) {
                if (o instanceof FilterValueInterface) {
                    promptedValue = (FilterValueInterface)o;
                } else if (o instanceof Prompt && (promptedValue = ((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative((Prompt)o)) != null && promptedValue.getData() instanceof Prompt) {
                    Prompt prompt = (Prompt)promptedValue.getData();
                    String key = prompt.getLabel();
                    if (!key.startsWith("&")) {
                        key = "&" + key;
                    }
                    pMap.put(key, promptedValue);
                }
            }
        }
        return promptedValue;
    }

    public FilterObjectFactoryInterface getFilterObjectFactory() {
        return this._filterObjectFactory;
    }

    public void setFilterObjectFactory(FilterObjectFactoryInterface factory) {
        this._filterObjectFactory = factory;
    }

    public int getMaxOutputObservations() {
        if (this._filterObjectFactory != null) {
            return this._filterObjectFactory.getMaxOutputObservations();
        }
        return 10000;
    }

    public void setMaxOutputObservations(int max) {
        if (this._filterObjectFactory != null) {
            this._filterObjectFactory.setMaxOutputObservations(max);
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        if (locale != this._locale) {
            this._locale = locale;
            if (this._filterObjectFactory != null) {
                this._filterObjectFactory.setLocale(locale);
            }
        }
    }

    public boolean isValidFilter(FilterLogicTestNodeInterface testNode) throws FilterException {
        ExpressionInterface newExpression;
        boolean isValid = false;
        if (testNode != null && (newExpression = ((BaseAdvancedFilterObjectFactory)this._filterObjectFactory).newFilterExpression(testNode)) != null) {
            try {
                IQDataServices dataService = IQDataServicesFactory.newService();
                FilterItem filterItem = this._businessModel.newFilterItem();
                filterItem.setExpression(newExpression);
                dataService.verify((BusinessItem)filterItem);
                isValid = true;
            }
            catch (DataServicesException dse) {
                throw new FilterException((Throwable)dse);
            }
            catch (MetadataException me) {
                throw new FilterException((Throwable)me);
            }
        }
        return isValid;
    }

    public List getPersistentFilterList() {
        ArrayList<DefaultPersistentFilter> filters = null;
        if (this._businessModel != null) {
            filters = new ArrayList<DefaultPersistentFilter>();
            int flags = 0;
            if (this._businessQuery != null) {
                flags |= 1;
            }
            List sourceList = this._businessModel.getObjects(flags, FilterItem.class);
            for (FilterItem item : sourceList) {
                if (!this.isFilterImportable(item) || item.isHidden() || !item.isUsableInQuery()) continue;
                String label = item.getLabel();
                String desc = item.getDescription();
                filters.add(new DefaultPersistentFilter((Object)item, label, desc));
            }
        }
        return filters;
    }

    protected boolean isFilterImportable(FilterItem item) {
        boolean importable = true;
        if (this._businessQuery != null && this._businessQuery.getBusinessModel().getStructure().isRelational()) {
            BusinessQueryToFilterItemListAdapter list = new BusinessQueryToFilterItemListAdapter(this._filterObjectFactory, this._businessQuery);
            FilterItemRootToAdvancedList filterItemList = new FilterItemRootToAdvancedList((FilterItemListInterface)list, item, true, this._filterObjectFactory, false);
            List testNodeList = filterItemList.getFilterLogicTree().getUnderstoodTestNodeList();
            importable = this.isFilterImportable(testNodeList);
        }
        if (importable) {
            List prompts = item.getPrompts(65535);
            for (Prompt prompt : prompts) {
                if (!prompt.getPromptDefinition().isDefaultValueSet()) {
                    importable = false;
                    break;
                }
                if (!IQUeryUtil.isSystemIdentityPrompt(prompt)) continue;
                return true;
            }
        }
        return importable;
    }

    protected boolean isFilterImportable(List testNodeList) {
        boolean importable = true;
        for (FilterLogicTestNodeInterface element : testNodeList) {
            List values;
            long type = element.getFilterItem().getItemType();
            if (type != 4L && type != 6L && type != 5L) continue;
            FilterConditionInterface condition = element.getCondition();
            if (condition == null) {
                importable = false;
                break;
            }
            if (element.getCondition().getConditionArgumentCount() != -1 || (values = element.getTestValuesList()) != null && values.size() == 1) continue;
            importable = false;
            break;
        }
        return importable;
    }

    public boolean isSystemVariableValue(Object value) {
        if (value != null) {
            if (value instanceof FilterValueInterface) {
                value = ((FilterValueInterface)value).getData();
            }
            if (value instanceof SystemVariableInterface) {
                return true;
            }
        }
        return false;
    }

    public List getSystemVariableValueList(Object item) throws FilterException {
        ArrayList<FilterValueInterface> svList = new ArrayList<FilterValueInterface>();
        if (this._businessModel != null && this._businessModel instanceof InformationMap) {
            InformationMap map = (InformationMap)this._businessModel;
            List prompts = null;
            try {
                prompts = map.getIdentityDrivenPropertyPrompts();
            }
            catch (MetadataException ex) {
                throw new FilterException((Throwable)ex);
            }
            if (prompts != null) {
                FilterLogicTestNodeInterface testNode = item instanceof FilterLogicTestNodeInterface ? (FilterLogicTestNodeInterface)item : null;
                for (Prompt prompt : prompts) {
                    if (testNode != null && prompt.getPromptDefinition() != null) {
                        PromptDefinitionInterface promptDefinition = prompt.getPromptDefinition();
                        if (DefaultAdvancedFilterModelAdapter.isPromptMultipleSelection(prompt) && testNode.getCondition() != null && testNode.getCondition().getConditionArgumentCount() != -1 || !this.isValidPromptType(testNode.getFilterItem(), promptDefinition.getPromptDataType())) continue;
                    }
                    svList.add(((BaseFilterObjectFactory)this._filterObjectFactory).createFilterValueFromNative(prompt));
                }
            }
        }
        return svList;
    }

    public void setEnvironment(int environment) {
        this.environment = environment;
        if (this._filterObjectFactory != null && this._filterObjectFactory instanceof BaseFilterObjectFactory) {
            ((BaseFilterObjectFactory)this._filterObjectFactory).setEnvironment(environment);
        }
    }

    public int getEnvironment() {
        if (this.environment != 0) {
            return this.environment;
        }
        Object appData = this.getApplicationData();
        if (appData instanceof FilterLogicTestNodeObjectMap) {
            return 2;
        }
        return 1;
    }

    private synchronized Map getValueProviderMap() {
        if (this.valueProviderMap == null) {
            this.valueProviderMap = new HashMap(4);
        }
        return this.valueProviderMap;
    }

    public ValueProviderInterface getValueProvider(FilterLogicTestNodeInterface testNode, int valueIndex) {
        ValueProviderInterface provider = null;
        if (testNode != null) {
            Lookup lookup;
            Object item = testNode.getFilterItem() != null ? testNode.getFilterItem().getItem() : null;
            DataItem dataItem = null;
            if (item instanceof DataItemFormattingExpression) {
                dataItem = ((DataItemFormattingExpression)item).getDataItem();
            } else if (item instanceof DataItemReference) {
                dataItem = ((DataItemReference)item).getBaseDataItem();
            } else if (item instanceof DataItem) {
                dataItem = (DataItem)item;
            } else if (item instanceof ResourceAwareStringExpression) {
                provider = this.getValueProvider((ResourceAwareStringExpression)item);
            }
            if (dataItem != null && !((lookup = dataItem.getLookupType()) instanceof LookupNotAllowed)) {
                if (lookup instanceof LookupByDataItem) {
                    provider = this.getDynamicValueProvider(dataItem);
                } else if (lookup instanceof LookupList) {
                    provider = this.getCustomValueProvider(dataItem);
                }
            }
            if (provider != null) {
                // empty if block
            }
        }
        return provider;
    }

    private ValueProviderInterface getDynamicValueProvider(DataItem dataItem) {
        ValueProviderInterface provider = (ValueProviderInterface)this.getValueProviderMap().get(dataItem);
        if (!(provider instanceof DataItemValueProvider)) {
            if (this.isOLAP()) {
                provider = new OLAPDataItemValueProvider(dataItem);
                try {
                    FilterBaseModelData bmData = this.getBaseModel();
                    MetadataInterface metadata = bmData.createMetadata();
                    ((OLAPDataItemValueProvider)provider).setUserMetadata(metadata);
                }
                catch (FilterException e) {
                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
                ((OLAPDataItemValueProvider)provider).setThreshold(-1);
            } else {
                provider = new IQRelationalDataItemValueProvider(dataItem);
                ((IQRelationalDataItemValueProvider)provider).setValueDisplayed(true);
                ((IQRelationalDataItemValueProvider)provider).setTrimLabels(true);
                ((IQRelationalDataItemValueProvider)provider).setHonorFilters(true);
                ((IQRelationalDataItemValueProvider)provider).setThreshold(-1);
            }
            this.getValueProviderMap().put(dataItem, provider);
        }
        return provider;
    }

    private ValueProviderInterface getCustomValueProvider(DataItem dataItem) {
        ValueProviderInterface provider = (ValueProviderInterface)this.getValueProviderMap().get(dataItem);
        if (!this.isOLAP() && !(provider instanceof IQRelationalDataItemValueProvider)) {
            provider = new IQRelationalDataItemValueProvider(dataItem);
            ((IQRelationalDataItemValueProvider)provider).setValueDisplayed(true);
            ((IQRelationalDataItemValueProvider)provider).setTrimLabels(true);
            ((IQRelationalDataItemValueProvider)provider).setHonorFilters(true);
            ((IQRelationalDataItemValueProvider)provider).setThreshold(-1);
            this.getValueProviderMap().put(dataItem, provider);
        }
        return provider;
    }

    private ValueProviderInterface getValueProvider(ResourceAwareStringExpression rase) {
        ValueProviderInterface provider = null;
        if (rase != null && (provider = (ValueProviderInterface)this.getValueProviderMap().get(rase)) == null && !this.isOLAP()) {
            try {
                ExpressionInterface exp = _stringExpressionUtil.newExpression(this._businessModel, rase.getText(), rase.getExpressionType(), ResourceScope.BUSINESS_AND_PHYSICAL_SCOPE);
                provider = new RelationalDataItemValueProvider();
                ((RelationalDataItemValueProvider)provider).setDataItemExpression(this._businessModel, exp);
                ((RelationalDataItemValueProvider)provider).setValueDisplayed(true);
                this.getValueProviderMap().put(rase, provider);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        return provider;
    }
}

