/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.expr.StringExpressionUtil;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateAndTimeUtil {
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private TimeZone _targetZone = GMT_ZONE;
    private SASDateTimeFormat _timeFormatter = null;
    private SASDateTimeFormat _dateFormatter = null;
    private SASDateTimeFormat _datetimeFormatter = null;
    private Locale _locale;

    public DateAndTimeUtil() {
        this(null);
    }

    public DateAndTimeUtil(Locale locale) {
        this._locale = locale;
    }

    public void setLocale(Locale value) {
        if (this._locale != value) {
            this._locale = value;
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public synchronized SASDateTimeFormat getTimeFormatter() {
        String sasFormatText;
        SASFormat formatter;
        if (this._timeFormatter == null && (formatter = StringExpressionUtil.getSASFormat((String)(sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)5)), (Locale)this.getLocale())) instanceof SASDateTimeFormat) {
            this._timeFormatter = (SASDateTimeFormat)formatter;
        }
        return this._timeFormatter;
    }

    public synchronized SASDateTimeFormat getDateFormatter() {
        String sasFormatText;
        SASFormat formatter;
        if (this._dateFormatter == null && (formatter = StringExpressionUtil.getSASFormat((String)(sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)4)), (Locale)this.getLocale())) instanceof SASDateTimeFormat) {
            this._dateFormatter = (SASDateTimeFormat)formatter;
        }
        return this._dateFormatter;
    }

    public synchronized SASDateTimeFormat getDateTimeFormatter() {
        String sasFormatText;
        SASFormat formatter;
        if (this._datetimeFormatter == null && (formatter = StringExpressionUtil.getSASFormat((String)(sasFormatText = StringExpressionUtil.getDefaultSASFormatText((int)6)), (Locale)this.getLocale())) instanceof SASDateTimeFormat) {
            this._datetimeFormatter = (SASDateTimeFormat)formatter;
        }
        return this._datetimeFormatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date createJavaDateFromSASTime(double value) {
        Date date = new Date();
        SASDateTimeFormat formatter = this.getTimeFormatter();
        if (formatter == null) return date;
        TimeZone oldZone = formatter.getTimeZone();
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            formatter.setTimeZone(this._targetZone);
            long javaValue = SASDateTimeFormat.SASTimeToJavaDate((double)value);
            formatter.setTimeZone(oldZone);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            date.setTime(javaValue);
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date createJavaDateFromSASDate(double value) {
        Date date = new Date();
        SASDateTimeFormat formatter = this.getDateFormatter();
        if (formatter == null) return date;
        TimeZone oldZone = formatter.getTimeZone();
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            formatter.setTimeZone(this._targetZone);
            long javaValue = SASDateTimeFormat.SASDateToJavaDate((double)value);
            formatter.setTimeZone(oldZone);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            date.setTime(javaValue);
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date createJavaDateFromSASDateTime(double value) {
        Date date = new Date();
        SASDateTimeFormat formatter = this.getDateTimeFormatter();
        if (formatter == null) return date;
        TimeZone oldZone = formatter.getTimeZone();
        Class<SASDateTimeFormat> clazz = SASDateTimeFormat.class;
        synchronized (SASDateTimeFormat.class) {
            formatter.setTimeZone(this._targetZone);
            long javaValue = SASDateTimeFormat.SASDateTimeToJavaDate((double)value);
            formatter.setTimeZone(oldZone);
            // ** MonitorExit[var8_5] (shouldn't be in output)
            date.setTime(javaValue);
            return date;
        }
    }

    public static String getFilterItemSASFormatText(Object item) {
        if (item == null) {
            return null;
        }
        String result = null;
        if (item instanceof FilterItemInterface) {
            item = ((FilterItemInterface)item).getItem();
        }
        if (item instanceof DataItemFormattingExpression) {
            item = ((DataItemFormattingExpression)item).getDataItem();
        }
        if (item instanceof FilterItem) {
            item = ((FilterItem)item).getExpression();
        }
        if (item instanceof DataItem) {
            result = ((DataItem)item).getFormat();
        }
        return result;
    }
}

