/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AdvancedBusinessQueryFilterObjectFactory;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.BusinessQueryFilterItemToSimpleLogicListAdapter;
import com.sas.dataselectors.filters.BusinessQueryToFilterItemListAdapter;
import com.sas.dataselectors.filters.DefaultFilterItemList;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterItemRootToAdvancedList;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.step.CompoundStep;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemDataBasedFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberPropertiesFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeFirstLastPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeNPeriodsFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemTimeRangeFilter;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.MultipleConditionalExpression;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class BusinessQueryFilterItemToAdvancedLogicListAdapter
extends BusinessQueryFilterItemToSimpleLogicListAdapter {
    protected DataItem _dataItem = null;
    protected SimpleFilterLogicTreeInterface _filterLogicTree;
    private int _stepIndex = 0;
    private CommonLoggerInterface log = null;

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(BusinessQuery businessQuery, FilterBaseModelData baseModel) {
        this(new AdvancedBusinessQueryFilterObjectFactory(businessQuery, baseModel), businessQuery, null);
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(BusinessQuery businessQuery, FilterBaseModelData baseModel, int environment) {
        this(new AdvancedBusinessQueryFilterObjectFactory(businessQuery, baseModel), businessQuery, null, environment);
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(BusinessQuery businessQuery, FilterBaseModelData baseModel, int environment, Locale locale) {
        AdvancedBusinessQueryFilterObjectFactory objectFactory = new AdvancedBusinessQueryFilterObjectFactory(businessQuery, baseModel);
        objectFactory.setLocale(locale);
        this.log = LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null);
        this.log.debug("ObjectFactory Constructor");
        this._filterObjectFactory = objectFactory;
        this._businessQuery = businessQuery;
        this._dataItem = null;
        this.setEnvironment(environment);
        this.readFilterList();
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery) {
        this(filterObjectFactory, businessQuery, null);
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(BusinessQuery businessQuery, FilterBaseModelData baseModel, DataItem dataItem) {
        this(new AdvancedBusinessQueryFilterObjectFactory(businessQuery, baseModel, dataItem), businessQuery, dataItem);
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(BusinessQuery businessQuery, FilterBaseModelData baseModel, DataItem dataItem, int environment) {
        this(new AdvancedBusinessQueryFilterObjectFactory(businessQuery, baseModel, dataItem), businessQuery, dataItem, environment);
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery, DataItem dataItem) {
        this.log = LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null);
        this.log.debug("ObjectFactory Constructor");
        this._filterObjectFactory = filterObjectFactory;
        this._businessQuery = businessQuery;
        this._dataItem = dataItem;
        this.readFilterList();
    }

    public BusinessQueryFilterItemToAdvancedLogicListAdapter(FilterObjectFactoryInterface filterObjectFactory, BusinessQuery businessQuery, DataItem dataItem, int environment) {
        this.log = LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null);
        this.log.debug("ObjectFactory Constructor");
        this._filterObjectFactory = filterObjectFactory;
        this._businessQuery = businessQuery;
        this._dataItem = dataItem;
        this.setEnvironment(environment);
        this.readFilterList();
    }

    @Override
    void readFilterList() {
        if (this._businessQuery == null) {
            this._filterItemList = new DefaultFilterItemList();
            return;
        }
        this._filterItemList = new BusinessQueryToFilterItemListAdapter(this._filterObjectFactory, this._businessQuery);
        Object rootFilterItem = null;
        boolean useStepModel = false;
        if (this._dataItem == null) {
            List filters = this._businessQuery.getFilters();
            if (filters != null && filters.size() > 0) {
                if (filters.size() == 1) {
                    if (filters.get(0) instanceof FilterItem) {
                        rootFilterItem = filters.get(0);
                    }
                } else {
                    MultipleConditionalExpression multiFilterExpression = new MultipleConditionalExpression();
                    multiFilterExpression.setRelationType(ConditionalRelationType.AND);
                    Iterator bqFiltersIter = filters.iterator();
                    ArrayList<ExpressionInterface> expressionsList = new ArrayList<ExpressionInterface>();
                    while (bqFiltersIter.hasNext()) {
                        Object filterItem = bqFiltersIter.next();
                        if (!(filterItem instanceof FilterItem)) continue;
                        expressionsList.add(((FilterItem)filterItem).getExpression());
                    }
                    multiFilterExpression.setExpressionList(expressionsList);
                    try {
                        FilterItem multiFilterItem = this._businessQuery.getBusinessModel().newFilterItem();
                        multiFilterItem.setExpression((ExpressionInterface)multiFilterExpression);
                        rootFilterItem = multiFilterItem;
                    }
                    catch (MetadataException e) {
                        this.log.error(e.getMessage(), (Throwable)e);
                        rootFilterItem = null;
                    }
                }
            }
            if (rootFilterItem != null) {
                FilterItem item = (FilterItem)rootFilterItem;
                super.setFilterListLabel(item.getLabel());
                super.setFilterListDescription(item.getDescription());
            }
        } else {
            useStepModel = true;
            rootFilterItem = this._dataItem;
            List stepList = this._dataItem.getSteps();
            if (stepList != null && stepList.size() > 0) {
                this._stepIndex = stepList.size() - 1;
                Object step = stepList.get(this._stepIndex);
                if (!(step instanceof CompoundStep || step instanceof DataItemMemberFilter || step instanceof DataItemDataBasedFilter || step instanceof DataItemMemberPropertiesFilter || step instanceof DataItemTimeRangeFilter || step instanceof DataItemTimeNPeriodsFilter || step instanceof DataItemTimeFirstLastPeriodsFilter)) {
                    ++this._stepIndex;
                }
            }
            super.setFilterListLabel(this._dataItem.getLabel());
            super.setFilterListDescription(this._dataItem.getDescription());
        }
        this._filterItemSimpleList = new FilterItemRootToAdvancedList(this._filterItemList, rootFilterItem, true, this._filterObjectFactory, useStepModel);
        this._filterLogicTree = ((FilterItemRootToAdvancedList)this._filterItemSimpleList).getFilterLogicTree();
    }

    public SimpleFilterLogicTreeInterface getFilterLogicTree() {
        return this._filterLogicTree;
    }

    @Override
    public boolean commitChanges() {
        if (this._businessQuery == null) {
            return false;
        }
        if (this._dataItem == null) {
            return this._commitFilterItemChanges();
        }
        return this._commitStepItemChanges();
    }

    protected boolean _commitFilterItemChanges() {
        ArrayList<FilterItem> filters = this._businessQuery.getFilters();
        if (filters == null) {
            filters = new ArrayList<FilterItem>();
        }
        FilterItem newRootFilter = null;
        if (this._filterItemSimpleList != null) {
            Object obj;
            if (!this._filterItemSimpleList.commitChanges()) {
                return false;
            }
            StructureOfData sod = this._businessQuery.getInputStructure();
            if (sod != null && sod.isRelational() && (obj = this._filterItemSimpleList.getRootFilterObject()) != null) {
                if (obj instanceof FilterItem) {
                    newRootFilter = (FilterItem)obj;
                } else if (filters.size() > 0 && filters.get(0) instanceof FilterItem) {
                    newRootFilter = (FilterItem)filters.get(0);
                }
            }
        }
        if (newRootFilter != null) {
            if (filters.size() == 0) {
                filters.add(newRootFilter);
            } else {
                filters.set(0, newRootFilter);
            }
        } else if (filters.size() > 0) {
            filters.remove(0);
        }
        try {
            this._businessQuery.setFilters(filters);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    protected boolean _commitStepItemChanges() {
        if (this._dataItem != null) {
            ArrayList<StepInterface> steps = this._dataItem.getSteps();
            if (steps == null) {
                steps = new ArrayList<StepInterface>();
            }
            StepInterface newFilterStep = null;
            if (this._filterItemSimpleList != null) {
                if (!this._filterItemSimpleList.commitChanges()) {
                    return false;
                }
                Object obj = this._filterItemSimpleList.getRootFilterObject();
                if (obj != null && obj instanceof StepInterface) {
                    newFilterStep = (StepInterface)obj;
                }
            }
            if (newFilterStep != null) {
                if (this._stepIndex < steps.size() && this._stepIndex >= 0) {
                    steps.set(this._stepIndex, newFilterStep);
                } else {
                    steps.add(newFilterStep);
                }
            } else if (this._stepIndex < steps.size() && this._stepIndex >= 0) {
                steps.remove(this._stepIndex);
            }
            try {
                this._dataItem.setSteps(steps);
                return true;
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public void setEnvironment(int environment) {
        if (this._filterObjectFactory != null && this._filterObjectFactory instanceof BaseFilterObjectFactory) {
            ((BaseFilterObjectFactory)this._filterObjectFactory).setEnvironment(environment);
        }
    }
}

