/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.filters.AbstractSimpleLogicListAdapterBase;
import com.sas.dataselectors.filters.AdvancedBusinessModelFilterObjectFactory;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.DefaultFilterItemList;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterItemRootToAdvancedList;
import com.sas.dataselectors.filters.FilterObjectFactoryInterface;
import com.sas.dataselectors.filters.InformationMapToFilterItemListAdapter;
import com.sas.dataselectors.filters.SimpleFilterLogicTreeInterface;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.InformationMap;
import java.util.ArrayList;
import java.util.List;

public class BusinessModelFilterItemToAdvancedLogicListAdapter
extends AbstractSimpleLogicListAdapterBase {
    protected FilterBaseModelData _baseModel = null;
    protected FilterObjectFactoryInterface _filterObjectFactory = null;
    protected SimpleFilterLogicTreeInterface _filterLogicTree;
    boolean _useAllFilterItems = true;
    FilterItem _initialFilter = null;

    public BusinessModelFilterItemToAdvancedLogicListAdapter(FilterBaseModelData baseModel, FilterItem initialFilter, int environment) {
        this._filterObjectFactory = new AdvancedBusinessModelFilterObjectFactory(baseModel);
        this._baseModel = baseModel;
        this._initialFilter = initialFilter;
        this._useAllFilterItems = false;
        this.setEnvironment(environment);
        this.readFilterList();
    }

    public BusinessModelFilterItemToAdvancedLogicListAdapter(FilterBaseModelData baseModel, int environment) {
        this(new AdvancedBusinessModelFilterObjectFactory(baseModel), baseModel, environment);
    }

    public BusinessModelFilterItemToAdvancedLogicListAdapter(FilterObjectFactoryInterface filterObjectFactory, FilterBaseModelData baseModel, int environment) {
        this._filterObjectFactory = filterObjectFactory;
        this._baseModel = baseModel;
        this.setEnvironment(environment);
        this.readFilterList();
    }

    void readFilterList() {
        BusinessModel businessModel = this.getBusinessModel();
        if (businessModel == null) {
            this._filterItemList = new DefaultFilterItemList();
            return;
        }
        this._filterItemList = new InformationMapToFilterItemListAdapter(this._filterObjectFactory, (InformationMap)businessModel);
        List allFilters = new ArrayList<FilterItem>();
        if (this._useAllFilterItems) {
            allFilters = businessModel.getObjects(0, FilterItem.class);
        } else if (this._initialFilter != null) {
            allFilters.add(this._initialFilter);
        }
        if (allFilters == null || allFilters.isEmpty()) {
            // empty if block
        }
        this._filterItemSimpleList = new FilterItemRootToAdvancedList(this._filterItemList, this._initialFilter, true, this._filterObjectFactory, false);
        this._filterLogicTree = ((FilterItemRootToAdvancedList)this._filterItemSimpleList).getFilterLogicTree();
    }

    public SimpleFilterLogicTreeInterface getFilterLogicTree() {
        return this._filterLogicTree;
    }

    public boolean commitChanges() {
        if (this._baseModel == null) {
            return false;
        }
        return this._filterItemSimpleList == null || this._filterItemSimpleList.commitChanges();
    }

    public BusinessModel getBusinessModel() {
        if (this._baseModel != null && this._baseModel.model instanceof BusinessModel) {
            return (BusinessModel)this._baseModel.model;
        }
        return null;
    }

    public void setBusinessModel(BusinessModel businessModel) {
        if (this._baseModel == null) {
            this._baseModel = new FilterBaseModelData(businessModel);
        } else {
            this._baseModel.setModel(businessModel);
        }
    }

    public FilterObjectFactoryInterface getFilterObjectFactory() {
        return this._filterObjectFactory;
    }

    public void setFilterObjectFactory(FilterObjectFactoryInterface filterObjectFactory) {
        this._filterObjectFactory = filterObjectFactory;
    }

    public void setEnvironment(int environment) {
        if (this._filterObjectFactory != null && this._filterObjectFactory instanceof BaseFilterObjectFactory) {
            ((BaseFilterObjectFactory)this._filterObjectFactory).setEnvironment(environment);
        }
    }
}

