/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.filters;

import com.sas.dataselectors.calculateditems.BaseCalculatedItemAdapter;
import com.sas.dataselectors.filters.AbstractFilterItemListBase;
import com.sas.dataselectors.filters.BaseFilterObjectFactory;
import com.sas.dataselectors.filters.DataRetrievalError;
import com.sas.dataselectors.filters.DateAndTimeUtil;
import com.sas.dataselectors.filters.DefaultAdvancedFilterCondition;
import com.sas.dataselectors.filters.DefaultAdvancedFilterModelAdapter;
import com.sas.dataselectors.filters.DefaultFilterConditionList;
import com.sas.dataselectors.filters.DefaultFilterItem;
import com.sas.dataselectors.filters.DefaultFilterLogicTestNode;
import com.sas.dataselectors.filters.DefaultFilterQualifier;
import com.sas.dataselectors.filters.DefaultFilterQualifierList;
import com.sas.dataselectors.filters.DefaultFilterValue;
import com.sas.dataselectors.filters.DefaultFilterValueList;
import com.sas.dataselectors.filters.FilterBaseModelData;
import com.sas.dataselectors.filters.FilterConditionInterface;
import com.sas.dataselectors.filters.FilterConditionListInterface;
import com.sas.dataselectors.filters.FilterItemInterface;
import com.sas.dataselectors.filters.FilterItemListInterface;
import com.sas.dataselectors.filters.FilterItemLookupInterface;
import com.sas.dataselectors.filters.FilterLogicTestNodeInterface;
import com.sas.dataselectors.filters.FilterQualifierInterface;
import com.sas.dataselectors.filters.FilterQualifierListInterface;
import com.sas.dataselectors.filters.FilterValueInterface;
import com.sas.dataselectors.filters.FilterValuesInterface;
import com.sas.dataselectors.filters.OLAPFilterItem;
import com.sas.dataselectors.filters.OLAPLevelMemberTreeModel;
import com.sas.dataselectors.filters.OLAPMemberValueAndTreeModel;
import com.sas.dataselectors.filters.RB;
import com.sas.dataselectors.filters.SystemVariableInterface;
import com.sas.dataselectors.filters.timebased.IQRelativeTimeFilterUtil;
import com.sas.dataselectors.filters.timebased.TimeCondition;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapter;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterDataSource;
import com.sas.dataselectors.filters.timebased.olap.OLAPTimeBasedFilterAdapterInterface;
import com.sas.entities.AttributeType;
import com.sas.entities.AttributeTypeFactory;
import com.sas.iquery.dataservices.DataServicesException;
import com.sas.iquery.dataservices.IQDataServices;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.CompoundFilter;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.FilterItem;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupByDataItem;
import com.sas.iquery.metadata.business.LookupList;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import com.sas.iquery.metadata.business.LookupValue;
import com.sas.iquery.metadata.business.Prompt;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.expr.ComparisonOperator;
import com.sas.iquery.metadata.expr.CompoundConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalExpression;
import com.sas.iquery.metadata.expr.ConditionalRelationType;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.ExpressionUtil;
import com.sas.iquery.metadata.expr.FunctionCall;
import com.sas.iquery.metadata.expr.ResourceAwareStringExpression;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.metadata.expr.StringExpression;
import com.sas.iquery.metadata.expr.olap.DataBasedFilterExpression;
import com.sas.iquery.metadata.expr.olap.MemberFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterFirstLastPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeFilterNPeriodsExpression;
import com.sas.iquery.metadata.expr.olap.TimeRangeFilterExpression;
import com.sas.iquery.metadata.expr.relational.DataItemFormattingExpression;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Between;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Comparison;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Contains;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_In;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_Like;
import com.sas.iquery.metadata.expr.relational.SimpleConditionalExpression_TestForNull;
import com.sas.iquery.metadata.physical.Column;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionNameID;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import com.sas.prompts.definitions.BaseDefinitionRangeInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.swing.dataselectors.editors.FilterItemEditorInterface;
import com.sas.swing.visuals.dataselectors.filters.OLAPRelativeTimeFilterPanel;
import com.sas.util.ValueItem;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.fs.ServicesLogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public class BaseAdvancedFilterObjectFactory
extends BaseFilterObjectFactory {
    protected BusinessQuery _businessQuery = null;
    protected OLAPTimeBasedFilterAdapter olapTimeBasedFilterAdapter;
    private CommonLoggerInterface log;
    private static FilterItemInterface _defaultQualifiedItem = null;
    private static FilterItemInterface _defaultCharacterQualifiedItem = null;
    private static FilterItemInterface _defaultNumericQualifiedItem = null;
    public static final String RB_KEY = "BaseAdvancedFilterObjectFactory.";
    public static final String RB_KEY2 = "DefaultAdvancedFilterCondition.";
    public FilterConditionInterface OLAP_EQUAL_TO = BaseAdvancedFilterObjectFactory.getConditionFromRB("BaseAdvancedFilterObjectFactory.OLAP_EQUAL_TO", (Object)ComparisonOperator.COMPARE_EQ, false, true);
    public FilterConditionInterface OLAP_IS_NOT_EQUAL_TO = BaseAdvancedFilterObjectFactory.getConditionFromRB("BaseAdvancedFilterObjectFactory.OLAP_IS_NOT_EQUAL_TO", (Object)ComparisonOperator.COMPARE_EQ, true, true);
    public FilterConditionInterface IS_IN_LIST_OR_EQUAL_TO = BaseAdvancedFilterObjectFactory.getConditionFromRB("BaseAdvancedFilterObjectFactory.IS_IN_LIST_OR_EQUAL_TO", SimpleConditionalExpression_In.class, false);
    public FilterConditionInterface IS_NOT_IN_LIST_OR_EQUAL_TO = BaseAdvancedFilterObjectFactory.getConditionFromRB("BaseAdvancedFilterObjectFactory.IS_NOT_IN_LIST_OR_EQUAL_TO", SimpleConditionalExpression_In.class, true);
    public FilterConditionInterface CONTAINS = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.CONTAINS", FunctionNameID.CONTAINS, false, true, false, true, null);
    public FilterConditionInterface DOES_NOT_CONTAIN = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.DOES_NOT_CONTAIN", FunctionNameID.CONTAINS, true, true, false, true, null);
    public FilterConditionInterface LIKE = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.LIKE", FunctionNameID.LIKE, false, true, false, true, null);
    public FilterConditionInterface ALT_CONTAINS = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.CONTAINS", SimpleConditionalExpression_Contains.class, false, true, false, true, null);
    public FilterConditionInterface ALT_NOT_CONTAINS = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.DOES_NOT_CONTAIN", SimpleConditionalExpression_Contains.class, true, true, false, true, null);
    public FilterConditionInterface ALT_LIKE = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.LIKE", SimpleConditionalExpression_Like.class, false, true, false, true, null);
    public FilterConditionInterface ALT_NOT_LIKE = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.IS_NOT_LIKE", SimpleConditionalExpression_Like.class, true, true, false, true, null);
    public FilterConditionInterface OLAP_RELATIVE_TIME = BaseAdvancedFilterObjectFactory.getConditionFromRB("BaseAdvancedFilterObjectFactory.OLAP_RELATIVE_TIME", OLAPRelativeTimeFilterPanel.class, false, false);
    public FilterConditionInterface IS_BETWEEN_TIME = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.IS_BETWEEN_TIME", (Object)TimeCondition.CONDITION_RANGE, false, true);
    public FilterConditionInterface YEAR_TO_DATE = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.YEAR_TO_DATE", TimeCondition.CONDITION_YEAR_TO_DATE, false, false, false, true, null);
    public FilterConditionInterface MONTH_TO_DATE = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.MONTH_TO_DATE", TimeCondition.CONDITION_MONTH_TO_DATE, false, false, false, true, null);
    public FilterConditionInterface LAST_N_PERIODS = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.LAST_N_PERIODS", TimeCondition.CONDITION_LAST_N_PERIODS, false, false, false, true, null);
    public FilterConditionInterface NEXT_N_PERIODS = BaseAdvancedFilterObjectFactory.getConditionFromRB("DefaultAdvancedFilterCondition.NEXT_N_PERIODS", TimeCondition.CONDITION_NEXT_N_PERIODS, false, false, false, true, null);

    public BaseAdvancedFilterObjectFactory(FilterBaseModelData baseModel) {
        super(baseModel, ResourceScope.BUSINESS_SCOPE);
        ServicesLogFactory f = new ServicesLogFactory(this._businessModel.getSession());
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)f);
        this.log.debug("_DEBUG_:BusinessModel only Constructor");
    }

    public BaseAdvancedFilterObjectFactory(FilterBaseModelData baseModel, ResourceScope scope) {
        super(baseModel, scope);
        ServicesLogFactory f = new ServicesLogFactory(this._businessModel.getSession());
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)f);
        this.log.debug("_DEBUG_:BusinessModel and Scope Constructor");
    }

    public BaseAdvancedFilterObjectFactory(BusinessQuery businessQuery, FilterBaseModelData baseModel, ResourceScope scope) {
        this(baseModel, scope);
        this._businessQuery = businessQuery;
        ServicesLogFactory f = new ServicesLogFactory(this._businessModel.getSession());
        this.log = LoggerRepository2.getLogger((String)this.getClass().getName(), (LoggerFactoryInterface)f);
        this.log.debug("_DEBUG_:BusinessQuery and Scope Constructor");
    }

    public List getEligibleFilterItems(boolean includeBaseModels) {
        this.log.debug("_DEBUG_:getEligibleFilterItems: ENTERing method...");
        List items = null;
        if (this._businessModel != null && (items = this._businessModel.getObjects(includeBaseModels ? 1 : 0, DataItem.class)) != null) {
            for (int i = items.size() - 1; i >= 0; --i) {
                if (items.get(i) instanceof DataItemReference) {
                    items.remove(i);
                    continue;
                }
                if (!((DataItem)items.get(i)).isUsableInQuery()) {
                    items.remove(i);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                DataItem di = (DataItem)items.get(i);
                DataItemActionType aType = di.getUsage();
                this.log.debug("_DEBUG_: DataItem[" + di.getLabel() + "] usage: " + aType.getPersistentForm());
            }
        }
        return items;
    }

    @Override
    public FilterQualifierListInterface getQualifiers(List itemList) {
        ArrayList<DefaultFilterQualifier> listOfItems = new ArrayList<DefaultFilterQualifier>();
        if (itemList != null) {
            for (DataItem dataItem : itemList) {
                if (dataItem == null || !dataItem.getStructure().isOLAP()) continue;
                String itemName = dataItem.getLabel();
                DefaultFilterQualifier qualifier = new DefaultFilterQualifier(itemName, (Object)dataItem);
                listOfItems.add(qualifier);
            }
        }
        if (listOfItems.size() == 0) {
            return null;
        }
        DefaultFilterQualifierList result = new DefaultFilterQualifierList(listOfItems);
        return result;
    }

    @Override
    public List getFilterableItems(boolean includeBaseModels, Map filterItemLookup) {
        ArrayList<FilterItemInterface> listOfItems = new ArrayList<FilterItemInterface>();
        if (this._businessModel == null) {
            return listOfItems;
        }
        List items = this.getEligibleFilterItems(includeBaseModels);
        if (items == null) {
            return listOfItems;
        }
        FilterQualifierListInterface qualifiers = this.getQualifiers(items);
        for (DataItem dataItem : items) {
            if (dataItem == null) continue;
            FilterItemInterface filterItem = null;
            filterItem = this.convertToFilterableItem(dataItem, qualifiers);
            if (filterItem != null) {
                listOfItems.add(filterItem);
                if (filterItemLookup == null) continue;
                filterItemLookup.put(dataItem, filterItem);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.warn("_DEBUG_:### Could not convert DataItem to FilterItemInterface (class = " + dataItem.getClass().getName() + " for " + dataItem.getLabel() + " [" + dataItem + "])");
        }
        return listOfItems;
    }

    @Override
    public FilterItemInterface convertToFilterableItem(StringExpression stringExpression, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        List dataValues;
        if (this.log.isDebugEnabled()) {
            boolean isOlap = false;
            if (this._businessModel != null && this._businessModel.getStructure() != null) {
                isOlap = this._businessModel.getStructure().isOLAP();
            }
            String msg = isOlap ? "<OLAP - StringExpression>" : "<Relational - StringExpression>";
            this.log.debug("_DEBUG_:   " + msg + " Name = " + BaseAdvancedFilterObjectFactory.getExpressionUtilText((ExpressionInterface)stringExpression));
        }
        DefaultFilterItem filterItem = null;
        FilterConditionListInterface conditions = dataItem == null && stringExpression instanceof ResourceAwareStringExpression ? this.getRelationalConditions((ExpressionInterface)stringExpression, false) : this.getConditionList(dataItem);
        filterItem = new DefaultFilterItem(itemName, conditions, true, (List)null, dataValues = this.getDataServiceValues(dataItem));
        if (filterItem != null) {
            if (dataItem != null) {
                filterItem.setItem((Object)dataItem);
            } else {
                filterItem.setItem((Object)stringExpression);
            }
            if (qualifiers != null) {
                filterItem.setQualifierList(qualifiers);
                FilterItemInterface qualifiedItem = this.getQualifiedItem(dataItem, (FilterItemInterface)filterItem, qualifiers);
                if (qualifiedItem != null) {
                    filterItem.setQualifiedItem(qualifiedItem);
                }
            }
        }
        return filterItem;
    }

    public FilterItemInterface convertToFilterableItem(DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        String label = dataItem.getLabel();
        FilterConditionListInterface conditions = this.getConditionList(dataItem);
        boolean allowUserValues = true;
        if (dataItem.getStructure().isOLAP()) {
            ArrayList<OLAPTimeBasedFilterAdapterInterface> possibleValuesList = null;
            if (this.isTimeDimension(dataItem)) {
                possibleValuesList = new ArrayList<OLAPTimeBasedFilterAdapterInterface>();
                possibleValuesList.add(this.getOLAPTimeBasedFilterAdapter());
            }
            OLAPFilterItem olapFilterItem = new OLAPFilterItem(label, conditions, allowUserValues, possibleValuesList, (List)null);
            olapFilterItem.setCharacterQualifiedItem(this.getCharacterQualifiedItem());
            olapFilterItem.setNumericQualifiedItem(this.getNumericQualifiedItem());
            filterItem = olapFilterItem;
        } else {
            filterItem = new DefaultFilterItem(label, conditions, allowUserValues, (List)null, (List)null);
        }
        if (filterItem != null) {
            FilterValuesInterface possibleValues;
            filterItem.setItem((Object)dataItem);
            this.setFilterItemProperties((FilterItemInterface)filterItem, dataItem);
            if (qualifiers != null) {
                filterItem.setQualifierList(qualifiers);
                FilterItemInterface qualifiedItem = this.getQualifiedItem(dataItem, (FilterItemInterface)filterItem, qualifiers);
                if (qualifiedItem != null) {
                    filterItem.setQualifiedItem(qualifiedItem);
                }
            }
            DataItemActionType actionType = dataItem.getUsage();
            Lookup lookup = dataItem.getLookupType();
            if (lookup instanceof LookupNotAllowed) {
                filterItem.setUserValueAllowed(true);
            } else if (lookup instanceof LookupByDataItem) {
                FilterValuesInterface actualValues = this.getActualFilterValues(dataItem);
                if (actualValues != null) {
                    filterItem.setActualValues(actualValues);
                }
            } else if (lookup instanceof LookupList && (possibleValues = this._getPossibleFilterValues((LookupList)lookup, dataItem)) != null) {
                filterItem.setPossibleValues(possibleValues);
            }
        }
        return filterItem;
    }

    @Override
    public FilterItemInterface convertToFilterableItem(Column columnItem, String itemName, DataItem dataItem, FilterQualifierListInterface qualifiers) {
        DefaultFilterItem filterItem = null;
        List dataValues = null;
        filterItem = new DefaultFilterItem(itemName, this.getRelationalConditions((ExpressionInterface)columnItem), true, (List)null, dataValues);
        if (filterItem != null) {
            FilterValuesInterface possibleValues;
            filterItem.setItem((Object)dataItem);
            filterItem.setQualifierList(qualifiers);
            Lookup lookup = dataItem.getLookupType();
            if (lookup instanceof LookupNotAllowed) {
                filterItem.setUserValueAllowed(true);
            } else if (lookup instanceof LookupByDataItem) {
                FilterValuesInterface actualValues = this.getActualFilterValues(dataItem);
                if (actualValues != null) {
                    filterItem.setActualValues(actualValues);
                }
            } else if (lookup instanceof LookupList && (possibleValues = this._getPossibleFilterValues((LookupList)lookup, dataItem)) != null) {
                filterItem.setPossibleValues(possibleValues);
            }
        }
        return filterItem;
    }

    private FilterValuesInterface _getPossibleFilterValues(LookupList lookup, DataItem dataItem) {
        DefaultFilterValueList values = null;
        String listLabel = null;
        LookupDeferredRetrievalList possibleValues = new LookupDeferredRetrievalList(lookup, dataItem);
        values = new DefaultFilterValueList((Collection)possibleValues);
        if (listLabel != null) {
            values.setListLabel(listLabel);
        }
        return values;
    }

    public synchronized FilterItemInterface getQualifiedItem(DataItem dataItem, FilterItemInterface filterItem, FilterQualifierListInterface qualifiers) {
        if (qualifiers == null || qualifiers.getFilterQualifierList() == null || qualifiers.getFilterQualifierList().size() == 0) {
            return filterItem;
        }
        if (_defaultQualifiedItem == null) {
            String label = null;
            DefaultFilterConditionList conditions = new DefaultFilterConditionList(Arrays.asList(this.getDefaultOLAPMeasureConditions()));
            boolean allowUserValues = true;
            List possibleValues = null;
            List actualValues = null;
            _defaultQualifiedItem = new DefaultFilterItem(label, (FilterConditionListInterface)conditions, allowUserValues, possibleValues, actualValues);
            long type = this._getQualifiedItemType(qualifiers);
            ((DefaultFilterItem)_defaultQualifiedItem).setItemType(type);
        }
        return _defaultQualifiedItem;
    }

    public synchronized FilterItemInterface getCharacterQualifiedItem() {
        if (_defaultCharacterQualifiedItem == null) {
            Object[] conditionArray = new Object[]{this.IS_EQUALS, this.IS_NOT_EQUALS};
            String label = null;
            DefaultFilterConditionList conditions = new DefaultFilterConditionList(Arrays.asList(conditionArray));
            boolean allowUserValues = true;
            List possibleValues = null;
            List actualValues = null;
            _defaultCharacterQualifiedItem = new DefaultFilterItem(label, (FilterConditionListInterface)conditions, allowUserValues, possibleValues, actualValues);
            ((DefaultFilterItem)_defaultCharacterQualifiedItem).setItemType(3L);
        }
        return _defaultCharacterQualifiedItem;
    }

    public synchronized FilterItemInterface getNumericQualifiedItem() {
        if (_defaultNumericQualifiedItem == null) {
            String label = null;
            DefaultFilterConditionList conditions = new DefaultFilterConditionList(Arrays.asList(this.getDefaultOLAPMeasureConditions()));
            boolean allowUserValues = true;
            List possibleValues = null;
            List actualValues = null;
            _defaultNumericQualifiedItem = new DefaultFilterItem(label, (FilterConditionListInterface)conditions, allowUserValues, possibleValues, actualValues);
            ((DefaultFilterItem)_defaultNumericQualifiedItem).setItemType(2L);
        }
        return _defaultNumericQualifiedItem;
    }

    private long _getQualifiedItemType(FilterQualifierListInterface qualifiers) {
        long type = 2L;
        Object o = this._getPrimaryQualifier(qualifiers);
        if (o instanceof FilterQualifierInterface) {
            o = ((FilterQualifierInterface)o).getQualifier();
        }
        if (o instanceof ExpressionInterface) {
            type = ((ExpressionInterface)o).getExpressionType();
        }
        return type;
    }

    private Object _getPrimaryQualifier(FilterQualifierListInterface qList) {
        if (qList != null) {
            return this._getPrimaryQualifier(qList.getFilterQualifierList());
        }
        return null;
    }

    private Object _getPrimaryQualifier(List qualifiers) {
        Object qualifier = null;
        if (qualifiers != null && qualifiers.size() > 0 && (qualifier = (Object)qualifiers.get(0)) instanceof List) {
            qualifier = this._getPrimaryQualifier((List)qualifier);
        }
        return qualifier;
    }

    public FilterValuesInterface getActualFilterValues(DataItem item) {
        String listLabel = null;
        List list = null;
        Object result = null;
        if (item != null) {
            StructureOfDataItem itemStructure = item.getStructure();
            if (itemStructure == StructureOfDataItem.STRUCTURE_COLUMN) {
                list = this.getDataServiceValues(item);
            } else if (itemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
                this.log.debug("_DEBUG_:Skipping measure data item " + item.getLabel());
            } else {
                if (itemStructure == StructureOfDataItem.STRUCTURE_DIMENSION || itemStructure == StructureOfDataItem.STRUCTURE_HIERARCHY) {
                    try {
                        result = new OLAPMemberValueAndTreeModel(item, this.getMetadataInterface());
                    }
                    catch (Exception e) {
                        throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt", (Locale)this._locale), (Throwable)e);
                    }
                }
                if (itemStructure == StructureOfDataItem.STRUCTURE_LEVEL) {
                    try {
                        result = new OLAPLevelMemberTreeModel(item, this.getMetadataInterface());
                    }
                    catch (Exception e) {
                        throw new DataRetrievalError(RB.getStringResource((String)"BaseFilterObjectFactory.", (String)"ErrorGettingValues.txt", (Locale)this._locale), (Throwable)e);
                    }
                }
            }
        }
        if (result == null && list != null) {
            result = new DefaultFilterValueList(list);
            if (listLabel != null) {
                result.setListLabel(listLabel);
            }
        }
        return result;
    }

    public List getMembersForOLAPItem(DataItem item) {
        return this.getMembersForOLAPItem(item, -1);
    }

    public List getMembersForOLAPItem(DataItem item, int step) {
        IQDataServices dataService = BaseAdvancedFilterObjectFactory.initDataService(item.getBusinessModel());
        List list = null;
        if (item.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) {
            try {
                list = dataService.getMembers(item, step);
            }
            catch (DataServicesException dse) {
                this.log.error(dse.getMessage(), (Throwable)dse);
            }
        }
        return list;
    }

    public ExpressionInterface newRelationalFilterExpression(FilterLogicTestNodeInterface testNode, Object itemObject, int exprType, Object conditionObject, boolean conditionNegated, List valueObjects) {
        ExpressionInterface expression = null;
        if (itemObject == null || conditionObject == null) {
            return null;
        }
        if (conditionObject instanceof FunctionNameID) {
            if (!(itemObject instanceof ExpressionInterface)) {
                throw new IllegalArgumentException();
            }
            expression = this.newConditionalFunctionExpression((ExpressionInterface)itemObject, exprType, (FunctionNameID)conditionObject, conditionNegated, valueObjects);
        } else if (conditionObject == FilterItemEditorInterface.class) {
            if (!(itemObject instanceof ExpressionInterface)) {
                throw new IllegalArgumentException();
            }
            expression = (ExpressionInterface)itemObject;
        } else {
            expression = this.newConditionalExpression(testNode, itemObject, exprType, conditionObject, conditionNegated, valueObjects);
        }
        return expression;
    }

    public ExpressionInterface newConditionalFunctionExpression(ExpressionInterface item, int exprType, FunctionNameID functionName, boolean functionNegated, List valueObjects) {
        ExpressionInterface expression = null;
        if (item == null || functionName == null) {
            return null;
        }
        try {
            ServerProperties srvProps = this._businessModel.getServerProperties();
            Function function = srvProps.getFunctionByNameID(functionName);
            if (function != null) {
                ArrayList<ExpressionInterface> functionArgs = new ArrayList<ExpressionInterface>();
                functionArgs.add(item);
                for (int i = 0; i < valueObjects.size(); ++i) {
                    Object obj = valueObjects.get(i);
                    ExpressionInterface valueExpr = BaseAdvancedFilterObjectFactory.newConstantExpression(exprType);
                    if (obj instanceof ExpressionInterface) {
                        valueExpr = (ExpressionInterface)obj;
                    } else if (obj != null) {
                        valueExpr = (ExpressionInterface)obj;
                    }
                    functionArgs.add(valueExpr);
                }
                expression = this.newConditionalFunctionExpression(function, functionArgs, functionNegated);
            }
        }
        catch (MetadataException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return expression;
    }

    public ExpressionInterface newConditionalFunctionExpression(Function function, List functionArgs, boolean functionNegated) {
        FunctionCall expression = new FunctionCall(function, functionArgs);
        if (functionNegated) {
            CompoundConditionalExpression negate = new CompoundConditionalExpression();
            negate.setIsNegated(true);
            negate.setLeftExpression((ExpressionInterface)expression);
            expression = negate;
        }
        return expression;
    }

    @Override
    public ConditionalExpression newConditionalExpression(FilterLogicTestNodeInterface testNode) {
        FilterConditionInterface condition = testNode.getCondition();
        FilterItemInterface item = testNode.getFilterItem();
        List qualifiers = testNode.getFilterItemQualifiers();
        List values = testNode.getTestValuesList();
        if (item == null) {
            return null;
        }
        if (condition == null) {
            return null;
        }
        Object itemObject = item.getItem();
        int exprType = 0;
        if (itemObject instanceof ExpressionInterface) {
            exprType = ((ExpressionInterface)itemObject).getExpressionType();
        }
        if (itemObject instanceof DataItem) {
            DataItem di = (DataItem)itemObject;
            exprType = di.getExpressionTypeIgnoringFormattingForced();
        }
        Object conditionObject = condition.getCondition();
        boolean conditionNegated = condition.isConditionObjectNegated();
        List valueObjects = this._getExpressionListForValues(values, exprType);
        return this.newConditionalExpression(testNode, itemObject, exprType, conditionObject, conditionNegated, valueObjects);
    }

    private ConditionalExpression newConditionalExpression(FilterLogicTestNodeInterface testNode, Object itemObject, int exprType, Object conditionObject, boolean conditionNegated, List valueObjects) {
        ExpressionInterface rightExpr;
        SimpleConditionalExpression_In expression = null;
        if (conditionObject == SimpleConditionalExpression_In.class && valueObjects.size() == 1) {
            boolean useEquals = true;
            Object val = valueObjects.get(0);
            if (val instanceof FilterValueInterface) {
                val = ((FilterValueInterface)val).getData();
            }
            if (val instanceof Prompt) {
                boolean bl = useEquals = !DefaultAdvancedFilterModelAdapter.isPromptMultipleSelection((Prompt)val);
            }
            if (useEquals) {
                conditionObject = ComparisonOperator.COMPARE_EQ;
            }
        }
        if (conditionObject instanceof ComparisonOperator) {
            DataItem di;
            ExpressionInterface leftExpr = (ExpressionInterface)itemObject;
            rightExpr = valueObjects != null && valueObjects.size() > 0 ? (ExpressionInterface)valueObjects.get(0) : BaseAdvancedFilterObjectFactory.newConstantExpression(exprType);
            SimpleConditionalExpression_Comparison compExpr = new SimpleConditionalExpression_Comparison();
            compExpr.setComparisonOperator((ComparisonOperator)conditionObject);
            compExpr.setIsNegated(conditionNegated);
            compExpr.setLeftExpression(leftExpr);
            compExpr.setRightExpression(rightExpr);
            if (leftExpr instanceof DataItem && (di = (DataItem)leftExpr).isFormattingForced()) {
                compExpr.setFormattingForcedOverridden(true);
                compExpr.setFormattingForcedOverrideValue(false);
            }
            expression = compExpr;
        } else if (conditionObject == SimpleConditionalExpression_In.class) {
            DataItem di;
            SimpleConditionalExpression_In inExpr = new SimpleConditionalExpression_In();
            inExpr.setIsNegated(conditionNegated);
            inExpr.setWhatToCompare((ExpressionInterface)itemObject);
            inExpr.setComparisonList(valueObjects);
            if (itemObject instanceof DataItem && (di = (DataItem)itemObject).isFormattingForced()) {
                inExpr.setFormattingForcedOverridden(true);
                inExpr.setFormattingForcedOverrideValue(false);
            }
            expression = inExpr;
        } else if (conditionObject == SimpleConditionalExpression_Between.class) {
            DataItem di;
            ExpressionInterface leftExpr = BaseAdvancedFilterObjectFactory.newConstantExpression(exprType);
            rightExpr = BaseAdvancedFilterObjectFactory.newConstantExpression(exprType);
            if (valueObjects != null) {
                if (valueObjects.size() > 0 && (leftExpr = (ExpressionInterface)valueObjects.get(0)) instanceof Prompt && BaseDefinitionRangeInterface.class.isAssignableFrom(((Prompt)leftExpr).getPromptDefinition().getClass())) {
                    rightExpr = null;
                }
                if (valueObjects.size() > 1) {
                    rightExpr = (ExpressionInterface)valueObjects.get(1);
                }
                if (leftExpr instanceof Prompt && BaseDefinitionRangeInterface.class.isAssignableFrom(((Prompt)leftExpr).getPromptDefinition().getClass())) {
                    rightExpr = null;
                }
            }
            SimpleConditionalExpression_Between betweenExpr = new SimpleConditionalExpression_Between();
            betweenExpr.setIsNegated(conditionNegated);
            betweenExpr.setWhatToCompare((ExpressionInterface)itemObject);
            betweenExpr.setLeftExpression(leftExpr);
            betweenExpr.setRightExpression(rightExpr);
            if (itemObject instanceof DataItem && (di = (DataItem)itemObject).isFormattingForced()) {
                betweenExpr.setFormattingForcedOverridden(true);
                betweenExpr.setFormattingForcedOverrideValue(false);
            }
            expression = betweenExpr;
        } else if (conditionObject == SimpleConditionalExpression_TestForNull.class) {
            DataItem di;
            ExpressionInterface whatToCompare = (ExpressionInterface)itemObject;
            SimpleConditionalExpression_TestForNull nullExpr = new SimpleConditionalExpression_TestForNull();
            nullExpr.setIsNegated(conditionNegated);
            nullExpr.setWhatToCompare(whatToCompare);
            if (itemObject instanceof DataItem && (di = (DataItem)itemObject).isFormattingForced()) {
                nullExpr.setFormattingForcedOverridden(true);
                nullExpr.setFormattingForcedOverrideValue(false);
            }
            expression = nullExpr;
        } else if (conditionObject == SimpleConditionalExpression_Contains.class) {
            ExpressionInterface whatToCompare = (ExpressionInterface)itemObject;
            ExpressionInterface whatToContain = valueObjects != null && valueObjects.size() > 0 ? (ExpressionInterface)valueObjects.get(0) : BaseAdvancedFilterObjectFactory.newConstantExpression(exprType);
            try {
                DataItem di;
                SimpleConditionalExpression_Contains containsExpr = new SimpleConditionalExpression_Contains(this._businessModel);
                containsExpr.setIsNegated(conditionNegated);
                containsExpr.setWhatToCompare(whatToCompare);
                containsExpr.setWhatToContain(whatToContain);
                if (itemObject instanceof DataItem && (di = (DataItem)itemObject).isFormattingForced()) {
                    containsExpr.setFormattingForcedOverridden(true);
                    containsExpr.setFormattingForcedOverrideValue(false);
                }
                expression = containsExpr;
            }
            catch (MetadataException e) {
                expression = null;
            }
        } else if (conditionObject == SimpleConditionalExpression_Like.class) {
            DataItem di;
            ExpressionInterface whatToCompare = (ExpressionInterface)itemObject;
            ExpressionInterface patternExpr = valueObjects != null && valueObjects.size() > 0 ? (ExpressionInterface)valueObjects.get(0) : BaseAdvancedFilterObjectFactory.newConstantExpression(exprType);
            SimpleConditionalExpression_Like likeExpr = new SimpleConditionalExpression_Like();
            likeExpr.setIsNegated(conditionNegated);
            likeExpr.setWhatToCompare(whatToCompare);
            likeExpr.setPatternExpression(patternExpr);
            if (itemObject instanceof DataItem && (di = (DataItem)itemObject).isFormattingForced()) {
                likeExpr.setFormattingForcedOverridden(true);
                likeExpr.setFormattingForcedOverrideValue(false);
            }
            expression = likeExpr;
        } else if (conditionObject instanceof TimeCondition) {
            TimeCondition timeCondition = (TimeCondition)conditionObject;
            expression = IQRelativeTimeFilterUtil.newFilterExpression(testNode, (ExpressionInterface)itemObject, timeCondition, valueObjects, exprType);
        } else {
            expression = null;
        }
        return expression;
    }

    private ExpressionInterface newOLAPFilterExpression(FilterLogicTestNodeInterface testNode, Object itemObject, int exprType, Object conditionObject, boolean conditionNegated, List valueObjects) {
        if (itemObject == null) {
            return null;
        }
        if (conditionObject == null) {
            return null;
        }
        MemberFilterExpression expression = null;
        List qualifiers = testNode.getFilterItemQualifiers();
        if (qualifiers != null && qualifiers.size() > 0) {
            DataBasedFilterExpression filterExpression = new DataBasedFilterExpression();
            filterExpression.setWhatToFilter((ExpressionInterface)itemObject);
            filterExpression.setIsNegated(conditionNegated);
            List memberValues = valueObjects;
            List memberNames = this.getMemberListFromTestNodeQualifiers(testNode);
            filterExpression.setLeftExpression(memberNames);
            filterExpression.setRightExpression(memberValues);
            if (conditionObject instanceof ComparisonOperator) {
                filterExpression.setComparisonOperator((ComparisonOperator)conditionObject);
                expression = filterExpression;
            } else {
                expression = filterExpression;
            }
        } else {
            MemberFilterExpression memberExpression = new MemberFilterExpression();
            memberExpression.setWhatToCompare((ExpressionInterface)itemObject);
            memberExpression.setIsNegated(conditionNegated);
            List members = this.getExpressionListFromTestNodeValues(testNode);
            try {
                memberExpression.setMemberNames(members, (DataItem)itemObject);
            }
            catch (MetadataException e) {
                memberExpression.setMemberNames(members);
            }
            expression = memberExpression;
        }
        return expression;
    }

    private List _getExpressionListForValues(List values, int expressionType) {
        if (values == null) {
            return null;
        }
        ArrayList valueObjects = new ArrayList();
        for (int i = 0; i < values.size(); ++i) {
            Object value = values.get(i);
            int state = -1;
            if (value instanceof ValueItem) {
                ValueItem vi = (ValueItem)value;
                DefaultFilterValue fv = new DefaultFilterValue((Object)vi, vi.getLabel().toString(), expressionType, null, vi.getValue());
                value = fv;
                state = 0;
            }
            if (value instanceof FilterValueInterface) {
                FilterValueInterface filterValue = (FilterValueInterface)value;
                Object data = filterValue.getData();
                if (data instanceof ExpressionInterface) {
                    value = data;
                } else if (data instanceof SystemVariableInterface) {
                    value = ((SystemVariableInterface)data).getData();
                } else if (data instanceof TupleElementInterface) {
                    TupleElementInterface tuple = (TupleElementInterface)data;
                    try {
                        value = BaseAdvancedFilterObjectFactory.newStringExpression(tuple.getName());
                    }
                    catch (OLAPException e) {
                        value = BaseAdvancedFilterObjectFactory.newStringExpression(filterValue.getUnformattedValue().toString());
                    }
                } else if (data instanceof MemberInterface) {
                    MemberInterface member = (MemberInterface)data;
                    try {
                        value = BaseAdvancedFilterObjectFactory.newStringExpression(member.getUniqueName());
                    }
                    catch (OLAPException e) {
                        value = BaseAdvancedFilterObjectFactory.newStringExpression(filterValue.getUnformattedValue().toString());
                    }
                } else {
                    value = filterValue.getUnformattedValue();
                }
            }
            if (!(value instanceof ExpressionInterface)) {
                switch (state) {
                    case 0: {
                        value = this.createExpressionFromNative(value, expressionType, false);
                        break;
                    }
                    case 1: {
                        value = this.createExpressionFromNative(value, expressionType, true);
                        break;
                    }
                    default: {
                        value = this.createExpressionFromNative(value, expressionType);
                    }
                }
            }
            valueObjects.add(value);
        }
        return valueObjects;
    }

    private AttributeType getAttrbuteType(int expressionType) {
        Vector jdbcTypes = ExpressionUtil.getJdbcTypes((int)expressionType);
        if (jdbcTypes == null) {
            return AttributeTypeFactory.STRING_ATTRIBUTE_TYPE;
        }
        int last = jdbcTypes.size() - 1;
        Integer bestType = (Integer)jdbcTypes.get(last);
        int jdbcType = bestType;
        boolean isOlap = false;
        if (this._businessModel != null && this._businessModel.getStructure() != null) {
            isOlap = this._businessModel.getStructure().isOLAP();
        }
        String labelType = BaseCalculatedItemAdapter.getExpressionTypeLabel(expressionType, isOlap);
        return new AttributeType(labelType, jdbcType);
    }

    public ExpressionInterface newFilterExpression(FilterLogicTestNodeInterface testNode) {
        ConditionalExpression expression = null;
        FilterConditionInterface condition = testNode.getCondition();
        FilterItemInterface item = testNode.getFilterItem();
        if (item != null && condition != null) {
            List values = testNode.getTestValuesList();
            Object itemObject = item.getItem();
            int exprType = (int)this.getItemType(testNode);
            if (exprType == 0 && itemObject instanceof ExpressionInterface) {
                exprType = ((ExpressionInterface)itemObject).getExpressionType();
            }
            Object conditionObject = condition.getCondition();
            boolean conditionNegated = condition.isConditionObjectNegated();
            if (this._businessModel != null) {
                if (this._businessModel.getStructure().isOLAP()) {
                    expression = condition == this.OLAP_RELATIVE_TIME ? this.newOLAPTimeFilterExpression(itemObject, values) : this.newOLAPFilterExpression(testNode, itemObject, exprType, conditionObject, conditionNegated, null);
                } else if (this._businessModel.getStructure().isRelational()) {
                    List valueObjects = this._getExpressionListForValues(values, exprType);
                    expression = this.newRelationalFilterExpression(testNode, itemObject, exprType, conditionObject, conditionNegated, valueObjects);
                }
            }
            if (expression == null) {
                expression = super.newConditionalExpression(testNode);
            }
        }
        return expression;
    }

    private ExpressionInterface newOLAPTimeFilterExpression(Object itemObject, List values) {
        for (Object value : values) {
            FilterValueInterface fvi;
            if (value instanceof FilterValueInterface && (fvi = (FilterValueInterface)value).getData() instanceof OLAPTimeBasedFilterAdapterInterface) {
                value = fvi.getData();
            }
            if (!(value instanceof OLAPTimeBasedFilterAdapterInterface)) continue;
            OLAPTimeBasedFilterAdapterInterface adapter = (OLAPTimeBasedFilterAdapterInterface)value;
            String showOption = adapter.getShowOption();
            if (showOption.equals("NPERIODS")) {
                boolean lastPeriod;
                boolean firstPeriod = adapter.getSelectOption() == "STARTINGPERIOD" && adapter.getStartingPeriodOption().equals("FIRSTPERIOD");
                boolean bl = lastPeriod = adapter.getSelectOption() == "ENDINGPERIOD" && adapter.getEndingPeriodOption().equals("LASTPERIOD");
                if (firstPeriod || lastPeriod) {
                    TimeFilterFirstLastPeriodsExpression expr = new TimeFilterFirstLastPeriodsExpression();
                    expr.setWhatToCompare((ExpressionInterface)itemObject);
                    expr.setnPeriods(Integer.parseInt(adapter.getNumberOfPeriods()));
                    expr.setLevelName(adapter.getPeriodType());
                    expr.setSearchDirection(firstPeriod ? "FORWARD" : "BACKWARD");
                    return expr;
                }
                TimeFilterNPeriodsExpression expr = new TimeFilterNPeriodsExpression();
                expr.setWhatToCompare((ExpressionInterface)itemObject);
                expr.setnPeriods(Integer.parseInt(adapter.getNumberOfPeriods()));
                if (adapter.getSelectOption() == "STARTINGPERIOD") {
                    expr.setSearchDirection("FORWARD");
                    expr.setDateMember(adapter.getSelectedStartingPeriod());
                } else {
                    expr.setSearchDirection("BACKWARD");
                    expr.setDateMember(adapter.getSelectedEndingPeriod());
                }
                return expr;
            }
            if (showOption.equals("ACROSS") || !showOption.equals("RANGE")) continue;
            TimeRangeFilterExpression expr = new TimeRangeFilterExpression();
            expr.setWhatToCompare((ExpressionInterface)itemObject);
            if (!adapter.getStartingPeriodOption().equals("FIRSTPERIOD")) {
                expr.setStartDateMember(adapter.getSelectedStartingPeriod());
            }
            if (!adapter.getEndingPeriodOption().equals("LASTPERIOD")) {
                expr.setEndDateMember(adapter.getSelectedEndingPeriod());
            }
            expr.setLevel(adapter.getPeriodType());
            return expr;
        }
        return null;
    }

    @Override
    public boolean updateSimpleFilterFromTestNode(FilterItem filterItem, FilterLogicTestNodeInterface testNode) {
        String name = testNode.getFilterLabel();
        String description = testNode.getFilterDescription();
        ExpressionInterface result = null;
        result = this.newFilterExpression(testNode);
        if (result == null) {
            return false;
        }
        if (filterItem != null && !this.updateSimpleFilter(filterItem, name, description, result)) {
            return false;
        }
        if (this._businessModel != null) {
            this.addFilterItem(filterItem);
        }
        return true;
    }

    @Override
    public boolean updateCompoundFilter(FilterItem filterItem, FilterItem left, FilterItem right, ConditionalRelationType relationType, boolean isNegated) {
        if (!(filterItem instanceof CompoundFilter)) {
            throw new IllegalArgumentException();
        }
        CompoundFilter compoundFilter = (CompoundFilter)filterItem;
        compoundFilter.setLeftFilter(left);
        compoundFilter.setRightFilter(right);
        compoundFilter.setIsNegated(isNegated);
        if (left == null || right == null) {
            compoundFilter.setRelationType(null);
        } else {
            compoundFilter.setRelationType(relationType);
        }
        if (this._businessModel != null) {
            this.addFilterItem((FilterItem)compoundFilter);
        }
        return true;
    }

    public FilterConditionListInterface getConditionList(DataItem item) {
        if (item == null) {
            return null;
        }
        if (item.getStructure().isOLAP()) {
            return this.getOLAPConditions(item);
        }
        return this.getRelationalConditions((ExpressionInterface)item, false);
    }

    @Override
    public FilterConditionListInterface getRelationalConditions(ExpressionInterface expression, boolean forcedFormatting) {
        DefaultFilterConditionList model = new DefaultFilterConditionList();
        if (expression != null) {
            boolean useForcedFormattingConditionSet;
            int exprType;
            FilterConditionInterface[] conditions = null;
            if (!forcedFormatting && expression instanceof DataItem && ((DataItem)expression).isFormattingForced()) {
                exprType = ((DataItem)expression).getExpressionTypeIgnoringFormattingForced();
                useForcedFormattingConditionSet = true;
            } else {
                exprType = expression.getExpressionType();
                useForcedFormattingConditionSet = false;
            }
            this.log.debug("_DEBUG_:Expression type: " + exprType);
            switch (exprType) {
                case 3: {
                    conditions = this.getRelationalCharacterConditions(useForcedFormattingConditionSet);
                    break;
                }
                case 0: {
                    conditions = this.getRelationalConditions(useForcedFormattingConditionSet);
                    break;
                }
                case 4: 
                case 6: {
                    conditions = this.getRelationalTimeBasedConditions();
                    break;
                }
                case 5: {
                    conditions = this.getRelationalTimeConditions();
                    break;
                }
                default: {
                    conditions = this.getRelationalNumericConditions(useForcedFormattingConditionSet);
                }
            }
            model.setConditionList(Arrays.asList(conditions));
        }
        return model;
    }

    @Override
    public FilterConditionInterface[] getRelationalConditions(boolean forcedFormatting) {
        FilterConditionInterface[] conditions = new FilterConditionInterface[]{this.IS_IN_LIST_OR_EQUAL_TO, this.IS_NOT_IN_LIST_OR_EQUAL_TO, this.IS_IN_LIST, this.IS_NOT_IN_LIST, this.IS_LESS_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN, this.IS_GREATER_THAN_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN, this.IS_NULL, this.IS_NOT_NULL};
        return conditions;
    }

    @Override
    public FilterConditionInterface[] getRelationalCharacterConditions(boolean forcedFormatting) {
        FilterConditionInterface[] conditions = new FilterConditionInterface[]{this.IS_IN_LIST_OR_EQUAL_TO, this.IS_NOT_IN_LIST_OR_EQUAL_TO, this.IS_LESS_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN, this.IS_GREATER_THAN_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN, this.CONTAINS, this.LIKE, this.IS_NULL, this.IS_NOT_NULL};
        return conditions;
    }

    @Override
    public FilterConditionInterface[] getRelationalNumericConditions(boolean forcedFormatting) {
        FilterConditionInterface[] conditions = new FilterConditionInterface[]{this.IS_IN_LIST_OR_EQUAL_TO, this.IS_NOT_IN_LIST_OR_EQUAL_TO, this.IS_LESS_THAN, this.IS_GREATER_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN, this.IS_NULL, this.IS_NOT_NULL};
        return conditions;
    }

    public FilterConditionInterface[] getRelationalTimeConditions() {
        FilterConditionInterface[] conditions = new FilterConditionInterface[]{this.IS_IN_LIST_OR_EQUAL_TO, this.IS_NOT_IN_LIST_OR_EQUAL_TO, this.IS_BEFORE, this.IS_AFTER, this.IS_BEFORE_OR_EQUAL, this.IS_AFTER_OR_EQUAL, this.IS_BETWEEN, this.IS_NOT_BETWEEN, this.IS_NULL, this.IS_NOT_NULL};
        return conditions;
    }

    public FilterConditionInterface[] getRelationalTimeBasedConditions() {
        FilterConditionInterface[] conditions = new FilterConditionInterface[]{this.IS_EQUALS, this.IS_NOT_EQUALS, this.IS_BEFORE, this.IS_AFTER, this.IS_BEFORE_OR_EQUAL, this.IS_AFTER_OR_EQUAL, this.YEAR_TO_DATE, this.MONTH_TO_DATE, this.IS_BETWEEN_TIME, this.LAST_N_PERIODS, this.NEXT_N_PERIODS, this.IS_NULL, this.IS_NOT_NULL};
        return conditions;
    }

    public Object[] getDefaultOLAPNonMeasureConditions() {
        return new Object[]{this.OLAP_EQUAL_TO, this.OLAP_IS_NOT_EQUAL_TO};
    }

    public Object[] getOLAPTimeBasedConditions() {
        return new Object[]{this.OLAP_EQUAL_TO, this.OLAP_IS_NOT_EQUAL_TO, this.OLAP_RELATIVE_TIME};
    }

    public Object[] getDefaultOLAPMeasureConditions() {
        return new Object[]{this.IS_EQUALS, this.IS_NOT_EQUALS, this.IS_LESS_THAN, this.IS_GREATER_THAN, this.IS_LESS_THAN_OR_EQUAL, this.IS_GREATER_THAN_OR_EQUAL};
    }

    public FilterConditionListInterface getOLAPConditions(DataItem item) {
        DefaultFilterConditionList model = new DefaultFilterConditionList();
        if (item != null) {
            Object[] conditions = null;
            this.log.debug("_DEBUG_:OLAP Item structure: " + item.getStructure());
            if (item.getStructure() == StructureOfDataItem.STRUCTURE_DIMENSION || item.getStructure() == StructureOfDataItem.STRUCTURE_HIERARCHY || item.getStructure() == StructureOfDataItem.STRUCTURE_LEVEL) {
                conditions = this.isTimeDimension(item) && (this.environment != 1 || this._businessQuery == null) ? this.getOLAPTimeBasedConditions() : this.getDefaultOLAPNonMeasureConditions();
            } else if (item.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                conditions = this.getDefaultOLAPMeasureConditions();
            }
            if (conditions == null) {
                conditions = new Object[]{this.OLAP_EQUAL_TO, this.OLAP_IS_NOT_EQUAL_TO};
            }
            model.setConditionList(Arrays.asList(conditions));
        }
        return model;
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, Object item, Object conditionObject, boolean isNegated, List values, FilterItemListInterface filterItemList) {
        Object value;
        List<Object> altConditions;
        DefaultFilterConditionList fcli;
        Object dataItem;
        if (item instanceof DataItemFormattingExpression) {
            dataItem = ((DataItemFormattingExpression)item).getDataItem();
            item = dataItem;
        } else {
            dataItem = item instanceof DataItem ? (DataItem)item : null;
        }
        FilterItemInterface filterLogicItem = this.findMatchingFilterItem(filterItemList, item);
        if (filterLogicItem == null) {
            if (item instanceof FunctionCall) {
                FunctionCall func = (FunctionCall)item;
                List args = func.getArguments();
                if (func.getFunction().getFunctionNameID() == FunctionNameID.STRIP || func.getFunction().getFunctionNameID() == FunctionNameID.UPCASE) {
                    FilterLogicTestNodeInterface newNode;
                    if (args.get(0) instanceof FunctionCall) {
                        FunctionCall fc = (FunctionCall)args.get(0);
                        args = fc.getArguments();
                    }
                    if (args != null && args.get(0) instanceof DataItemFormattingExpression) {
                        newNode = this.newTestNode(name, desc, args.get(0), conditionObject, isNegated, values, filterItemList);
                        return newNode;
                    }
                    newNode = this.newTestNode(name, desc, args.get(0), conditionObject, isNegated, values, filterItemList);
                    return newNode;
                }
            }
            filterLogicItem = this.convertToFilterItem(item, (DataItem)dataItem, filterItemList);
        }
        if (filterLogicItem == null) {
            return null;
        }
        List filterLogicQualifiers = null;
        FilterConditionInterface filterLogicCondition = null;
        if (!this._businessModel.getStructure().isOLAP() && conditionObject == ComparisonOperator.COMPARE_EQ) {
            filterLogicCondition = this.findMatchingConditionObject(filterLogicItem, SimpleConditionalExpression_In.class, isNegated);
            if (filterLogicCondition == null) {
                filterLogicCondition = this.findMatchingConditionObject(filterLogicItem, conditionObject, isNegated);
            }
        } else {
            filterLogicCondition = this.findMatchingConditionObject(filterLogicItem, conditionObject, isNegated);
        }
        if (filterLogicCondition == null && (filterLogicCondition = this.findMatchingConditionObject(conditionObject, isNegated, (FilterConditionListInterface)(fcli = new DefaultFilterConditionList(altConditions = Arrays.asList(this.ALT_CONTAINS, this.ALT_NOT_CONTAINS, this.ALT_LIKE, this.ALT_NOT_LIKE, this.IS_NOT_EQUALS, this.IS_EQUALS, this.CODE_BLOCK, this.IS_BETWEEN))))) == null) {
            return null;
        }
        if ((conditionObject instanceof SimpleConditionalExpression_Between || conditionObject == SimpleConditionalExpression_Between.class) && values.size() > 0 && values.get(0) instanceof Prompt && BaseDefinitionRangeInterface.class.isAssignableFrom(((Prompt)(value = values.get(0))).getPromptDefinition().getClass())) {
            filterLogicCondition.setConditionMessageFormat(RB.getStringResource((String)"DefaultFilterCondition.", (String)"IS_BETWEEN_RANGEPROMPT.Format.notrans.txt"));
        }
        long type = BaseAdvancedFilterObjectFactory.getAdjustedFilterItemType(filterLogicItem);
        String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(filterLogicItem);
        ArrayList valuesList = null;
        if (values != null) {
            valuesList = new ArrayList(values.size());
            for (Object v : values) {
                if (v instanceof ValueItem) {
                    valuesList.add(v);
                    continue;
                }
                FilterValueInterface filterValue = dataItem != null && dataItem.isFormattingForced() ? this.createFilterValueFromNative(v, type, sasFormatText, false) : this.createFilterValueFromNative(v, type, sasFormatText);
                valuesList.add(filterValue);
            }
        }
        DefaultFilterLogicTestNode testNode = new DefaultFilterLogicTestNode(filterLogicItem, filterLogicQualifiers, filterLogicCondition, valuesList);
        if (name != null) {
            testNode.setFilterLabel(name);
        }
        if (desc != null) {
            testNode.setFilterDescription(desc);
        }
        return testNode;
    }

    @Override
    public FilterItemInterface convertToFilterItem(Object item, DataItem dataItem, FilterItemListInterface filterItemList) {
        FilterItemInterface newItem = null;
        if (item instanceof ResourceAwareStringExpression || item instanceof DataItem || item instanceof FunctionCall || item instanceof DataItemFormattingExpression) {
            ExpressionInterface expression = (ExpressionInterface)item;
            String label = null;
            if (item instanceof DataItem) {
                label = ((DataItem)item).getLabel();
                item = ((DataItem)item).getExpression();
            } else {
                label = BaseAdvancedFilterObjectFactory.getExpressionUtilText(expression);
            }
            if (dataItem != null) {
                newItem = this.convertToFilterableItem(dataItem, null);
            } else {
                if (item instanceof DataItemFormattingExpression) {
                    dataItem = ((DataItemFormattingExpression)item).getDataItem();
                }
                newItem = this.convertToFilterableItem((ExpressionInterface)item, label, dataItem, null);
            }
            if (filterItemList != null) {
                this.log.debug("_DEBUG_:Adding new filter item to list: " + label);
                filterItemList.getFilterItemList().add(newItem);
                if (filterItemList instanceof AbstractFilterItemListBase) {
                    if (dataItem != null) {
                        ((AbstractFilterItemListBase)filterItemList).addFilterItemToLookup((Object)dataItem, (Object)newItem);
                    } else {
                        ((AbstractFilterItemListBase)filterItemList).addFilterItemToLookup(item, (Object)newItem);
                    }
                }
            }
        }
        return newItem;
    }

    @Override
    public FilterItemInterface findMatchingFilterItem(FilterItemListInterface fili, Object itemObject) {
        FilterItemInterface found = null;
        if (itemObject instanceof DataItemFormattingExpression) {
            DataItem dataItem = ((DataItemFormattingExpression)itemObject).getDataItem();
            itemObject = dataItem;
        }
        if (fili instanceof FilterItemLookupInterface) {
            found = ((FilterItemLookupInterface)fili).lookupFilterItem(itemObject);
        }
        if (found == null && itemObject instanceof DataItem && fili != null) {
            if (!(itemObject instanceof DataItemReference)) {
                List itemList = fili.getFilterItemList();
                for (FilterItemInterface filterItem : itemList) {
                    Object o = filterItem.getItem();
                    if (o instanceof DataItemReference && itemObject.equals(((DataItemReference)o).getBaseDataItem())) {
                        DataItemReference ref = (DataItemReference)o;
                        DataItem item = (DataItem)itemObject;
                        if (!ref.isEquivalentToParent()) continue;
                        found = filterItem;
                    } else {
                        String id2;
                        if (!(o instanceof DataItem)) continue;
                        DataItem d1 = (DataItem)itemObject;
                        DataItem d2 = (DataItem)o;
                        String id1 = d1.getIntraModelID();
                        if (id1 != (id2 = d2.getIntraModelID()) && (id1 == null || !id1.equals(id2))) continue;
                        found = filterItem;
                    }
                    break;
                }
            } else {
                found = this.convertToFilterItem(itemObject, (DataItem)itemObject, fili);
            }
        }
        return found;
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, Object item, List qualifiers, Object conditionObject, boolean isNegated, List values, FilterItemListInterface filterItemList) {
        FilterItemInterface filterLogicItem = this.findMatchingFilterItem(filterItemList, item);
        if (filterLogicItem == null) {
            if (item instanceof ResourceAwareStringExpression || item instanceof DataItem) {
                ExpressionInterface expression = (ExpressionInterface)item;
                DataItem dataItem = null;
                String label = null;
                if (item instanceof DataItem) {
                    dataItem = (DataItem)item;
                    label = dataItem.getLabel();
                    item = dataItem.getExpression();
                } else {
                    label = BaseAdvancedFilterObjectFactory.getExpressionUtilText(expression);
                }
                DefaultFilterQualifierList qList = null;
                if (qualifiers != null) {
                    qList = new DefaultFilterQualifierList(qualifiers);
                }
                FilterItemInterface newItem = this.convertToFilterableItem((ExpressionInterface)item, label, dataItem, (FilterQualifierListInterface)qList);
                if (filterItemList != null) {
                    filterItemList.getFilterItemList().add(newItem);
                }
                filterLogicItem = newItem;
            } else {
                return null;
            }
        }
        FilterConditionInterface filterLogicCondition = null;
        filterLogicCondition = !this._businessModel.getStructure().isOLAP() && conditionObject == ComparisonOperator.COMPARE_EQ ? this.findMatchingConditionObject(filterLogicItem, SimpleConditionalExpression_In.class, isNegated, qualifiers) : this.findMatchingConditionObject(filterLogicItem, conditionObject, isNegated, qualifiers);
        if (filterLogicCondition == null) {
            return null;
        }
        long type = BaseAdvancedFilterObjectFactory.getAdjustedFilterItemType(filterLogicItem);
        String sasFormatText = DateAndTimeUtil.getFilterItemSASFormatText(filterLogicItem);
        ArrayList<FilterValueInterface> valuesList = null;
        if (values != null) {
            valuesList = new ArrayList<FilterValueInterface>(values.size());
            for (Object v : values) {
                valuesList.add(this.createFilterValueFromNative(v, type, sasFormatText));
            }
            values = null;
        }
        DefaultFilterLogicTestNode testNode = new DefaultFilterLogicTestNode(filterLogicItem, qualifiers, filterLogicCondition, valuesList);
        if (name != null) {
            testNode.setFilterLabel(name);
        }
        if (desc != null) {
            testNode.setFilterDescription(desc);
        }
        return testNode;
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(DataItem dataItem, StepInterface filterObject, FilterItemListInterface filterItemList) {
        return this.newTestNode(this._businessQuery, dataItem, filterObject, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, TimeFilterExpression filterExpression, FilterItemListInterface filterItemList) {
        ExpressionInterface item = filterExpression.getWhatToCompare();
        FilterItemInterface filterItem = this.findMatchingFilterItem(filterItemList, item);
        Class<OLAPRelativeTimeFilterPanel> conditionObject = OLAPRelativeTimeFilterPanel.class;
        boolean isNegated = filterExpression.isNegated();
        ArrayList<OLAPTimeBasedFilterAdapterInterface> values = new ArrayList<OLAPTimeBasedFilterAdapterInterface>();
        OLAPTimeBasedFilterAdapterInterface adapter = this.getOLAPTimeBasedFilterAdapter();
        adapter.setFilterExpression((Object)filterExpression);
        values.add(adapter);
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    @Override
    public FilterLogicTestNodeInterface newTestNode(String name, String desc, TimeRangeFilterExpression filterExpression, FilterItemListInterface filterItemList) {
        ExpressionInterface item = filterExpression.getWhatToCompare();
        FilterItemInterface filterItem = this.findMatchingFilterItem(filterItemList, item);
        Class<OLAPRelativeTimeFilterPanel> conditionObject = OLAPRelativeTimeFilterPanel.class;
        boolean isNegated = filterExpression.isNegated();
        ArrayList<OLAPTimeBasedFilterAdapterInterface> values = new ArrayList<OLAPTimeBasedFilterAdapterInterface>();
        OLAPTimeBasedFilterAdapterInterface adapter = this.getOLAPTimeBasedFilterAdapter();
        adapter.setFilterExpression((Object)filterExpression);
        values.add(adapter);
        return this.newTestNode(name, desc, item, conditionObject, isNegated, values, filterItemList);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object nativeObject, boolean isNegated) {
        return BaseAdvancedFilterObjectFactory.getConditionFromRB(key, nativeObject, isNegated, null);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object nativeObject, boolean isNegated, boolean promptsAllowed) {
        return BaseAdvancedFilterObjectFactory.getConditionFromRB(key, nativeObject, isNegated, promptsAllowed, null);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object nativeObject, boolean isNegated, Locale locale) {
        return BaseAdvancedFilterObjectFactory.getConditionFromRB(key, nativeObject, isNegated, true, locale);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object nativeObject, boolean isNegated, boolean promptsAllowed, Locale locale) {
        return DefaultAdvancedFilterCondition.getAdvancedConditionFromRB((String)key, (Object)nativeObject, (boolean)isNegated, (boolean)promptsAllowed, (Locale)locale);
    }

    public static FilterConditionInterface getConditionFromRB(String key, Object nativeObject, boolean isNegated, boolean promptsAllowed, boolean isValueListAllowed, boolean isUserValueAllowed, Locale locale) {
        DefaultAdvancedFilterCondition condition = (DefaultAdvancedFilterCondition)DefaultAdvancedFilterCondition.getAdvancedConditionFromRB((String)key, (Object)nativeObject, (boolean)isNegated, (boolean)promptsAllowed, (Locale)locale);
        condition.setValueListAllowed(isValueListAllowed);
        condition.setUserValueAllowed(isUserValueAllowed);
        return condition;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        FilterConditionInterface[] conditions = new FilterConditionInterface[]{this.IS_IN_LIST_OR_EQUAL_TO, this.IS_NOT_IN_LIST_OR_EQUAL_TO, this.OLAP_EQUAL_TO, this.OLAP_IS_NOT_EQUAL_TO, this.OLAP_RELATIVE_TIME, this.CONTAINS, this.LIKE};
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i].setLocale(locale);
        }
    }

    public OLAPTimeBasedFilterAdapterInterface getOLAPTimeBasedFilterAdapter() {
        if (this.olapTimeBasedFilterAdapter == null) {
            OLAPTimeBasedFilterAdapterDataSource dataSource = new OLAPTimeBasedFilterAdapterDataSource(this._baseModel);
            this.olapTimeBasedFilterAdapter = new OLAPTimeBasedFilterAdapter(dataSource);
            this.olapTimeBasedFilterAdapter.setRuntime(this.getEnvironment() == 2);
        }
        return this.olapTimeBasedFilterAdapter;
    }

    private class LookupDeferredRetrievalList
    extends BaseFilterObjectFactory.DeferredRetrievalList {
        protected LookupList _lookup;

        public LookupDeferredRetrievalList(LookupList lookup, DataItem dataItem) {
            super(BaseAdvancedFilterObjectFactory.this, null, dataItem);
            this._lookup = lookup;
        }

        @Override
        public void retrieve() throws DataRetrievalError {
            if (this.isRetrieved()) {
                return;
            }
            this._isRetrieved = true;
            List lookupValues = this._lookup.getValuesList();
            if (lookupValues != null) {
                this._retrievedValues = new ArrayList(lookupValues.size());
                BaseAdvancedFilterObjectFactory.this.log.debug("_DEBUG_: Number of actual values for  " + this._dataItem.getLabel() + " = " + lookupValues.size());
                Iterator it = lookupValues.iterator();
                LookupValue fvalue = null;
                while (it.hasNext()) {
                    fvalue = (LookupValue)it.next();
                    FilterValueInterface foo = BaseAdvancedFilterObjectFactory.this.newFilterDataValue(fvalue, this._dataItem);
                    this._retrievedValues.add(foo);
                }
            } else {
                this._retrievedValues = new ArrayList();
                BaseAdvancedFilterObjectFactory.this.log.warn("_DEBUG_:### No support for values of " + this._dataItem.getLabel());
            }
        }
    }
}

