/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.exceptionhighlighting;

import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingSelectorBQAdapter;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.HierarchyInterface;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.log.LoggerRepository2;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;

public class OLAPExceptionHighlightingSelectorBQAdapter
extends ExceptionHighlightingSelectorBQAdapter {
    protected OLAPDataSetInterface odsi;

    public void setOLAPDataSetInterface(OLAPDataSetInterface odsi) {
        this.odsi = odsi;
    }

    public OLAPDataSetInterface getOLAPDataSetInterface() {
        return this.odsi;
    }

    @Override
    public Map getMeasureNames() {
        HashMap<String, String> measures = new HashMap<String, String>();
        for (DataItem dataItem : ((BusinessQuery)this.getModel()).getResultItems()) {
            if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) continue;
            measures.put(dataItem.getResultSetID(), dataItem.getLabel());
        }
        return measures;
    }

    protected String getMostDetailedVisibleLevelForHierarchy(HierarchyInterface hierarchy) {
        String uniqueLevelName = "";
        try {
            int i;
            AxisInterface rowAxis = this.getOLAPDataSetInterface().getResultSetMetadata().getAxes(1, 1)[0];
            AxisInterface columnAxis = this.getOLAPDataSetInterface().getResultSetMetadata().getAxes(0, 1)[0];
            String[] hiers = rowAxis.getHierarchyNames();
            String[] levs = rowAxis.getUniqueLevelNames();
            for (i = 0; i < hiers.length; ++i) {
                if (!hiers[i].equalsIgnoreCase(hierarchy.getUniqueName())) continue;
                uniqueLevelName = levs[i];
            }
            if ("".equals(uniqueLevelName)) {
                hiers = columnAxis.getHierarchyNames();
                levs = columnAxis.getUniqueLevelNames();
                for (i = 0; i < hiers.length; ++i) {
                    if (!hiers[i].equalsIgnoreCase(hierarchy.getUniqueName())) continue;
                    uniqueLevelName = levs[i];
                }
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return uniqueLevelName;
    }

    @Override
    public TreeModel getLevelTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("root");
        Map hierarchies = this.getHierarchies();
        for (String hierarchyKey : hierarchies.keySet()) {
            HierarchyInterface hierarchy = (HierarchyInterface)hierarchies.get(hierarchyKey);
            String defaultLevel = this.getMostDetailedVisibleLevelForHierarchy(hierarchy);
            DefaultMutableTreeNode dimensionNode = null;
            try {
                dimensionNode = new DefaultMutableTreeNode(hierarchy.getDimension().getLabel());
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            try {
                LevelInterface[] levels = hierarchy.getLevels();
                for (int i = 0; i < levels.length; ++i) {
                    LevelInterface level = levels[i];
                    if (level.getType() == 2) continue;
                    DefaultMutableTreeNode levelNode = new DefaultMutableTreeNode();
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put("Text", level.getLabel());
                    map.put("Value", hierarchy.getUniqueName() + ".[" + level.getName() + "]");
                    if (defaultLevel.equalsIgnoreCase(level.getUniqueName())) {
                        map.put("Default", new Boolean(true));
                    } else {
                        map.put("Default", new Boolean(false));
                    }
                    levelNode.setUserObject(map);
                    dimensionNode.add(levelNode);
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            rootNode.add(dimensionNode);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        return treeModel;
    }

    @Override
    public boolean isOLAP() {
        return true;
    }

    protected Map getHierarchies() {
        HierarchyInterface[] hiers = new HierarchyInterface[]{};
        try {
            Filter filter = new Filter();
            filter.setCubeName(this.getOLAPDataSetInterface().getCubeName());
            hiers = this.getOLAPDataSetInterface().getDatabaseMetadata().getHierarchies(filter);
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        HashMap<String, HierarchyInterface> hierarchies = new HashMap<String, HierarchyInterface>();
        block6: for (DataItem dataItem : ((BusinessQuery)this.getModel()).getResultItems()) {
            if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) continue;
            String hierarchyName = null;
            try {
                hierarchyName = BusinessQueryOLAPUtil.getHierarchyName((BusinessModel)dataItem.getBusinessModel(), (DataItem)dataItem);
            }
            catch (MetadataException e1) {
                e1.printStackTrace();
            }
            if (hierarchyName == null || hierarchies.containsKey(hierarchyName)) continue;
            for (int i = 0; i < hiers.length; ++i) {
                HierarchyInterface hier = hiers[i];
                try {
                    if (!hier.getUniqueName().equalsIgnoreCase(hierarchyName)) continue;
                    hierarchies.put(hierarchyName, hier);
                    continue block6;
                }
                catch (OLAPException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return hierarchies;
    }
}

