/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.exceptionhighlighting;

import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExpressionUtil;
import com.sas.rpf.expr.SerializationException;
import com.sas.util.log.LoggerRepository2;

public class ExceptionHighlightingRule
implements ExceptionHighlightingRuleInterface {
    protected String id;
    protected String label;
    protected String measure;
    protected boolean isMeasure;
    protected String value;
    protected boolean valueUserDefined;
    protected String minValue;
    protected boolean minValueUserDefined;
    protected String maxValue;
    protected boolean maxValueUserDefined;
    protected String assignment;
    protected String condition;
    protected String outlineColor;
    protected String fillColor;
    protected String fontColor;
    protected String font;
    protected String fontSize;
    protected boolean bold;
    protected boolean italic;
    protected boolean underline;
    protected boolean addImage;
    protected boolean addText;
    protected String imageTextPosition;
    protected String textFont;
    protected String textFontColor;
    protected String textFontSize;
    protected boolean textBold;
    protected boolean textItalic;
    protected boolean textUnderline;
    protected String text;
    protected String image;

    public void setToDefaults() {
        this.setMeasure("");
        this.setCondition("");
        this.setValue("");
        this.setAssignment("");
        this.setFont("DEFAULT");
        this.setFontSize("DEFAULT");
        this.setFontColor("");
        this.setFillColor("");
        this.setOutlineColor("");
        this.setBold(true);
        this.setUnderline(false);
        this.setItalic(false);
        this.setIsMeasure(true);
        this.setImageTextPosition("RIGHT");
        this.setAddImage(false);
        this.setImage("");
        this.setAddText(false);
        this.setText("");
        this.setTextFont("DEFAULT");
        this.setTextFontSize("DEFAULT");
        this.setTextFontColor("");
        this.setTextBold(false);
        this.setTextUnderline(false);
        this.setTextItalic(false);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getExpression();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getExpression() {
        String expression = null;
        boolean isMeasure = this.isMeasure();
        if (this.getCondition().equals("between")) {
            String expMeasure = "$" + this.getMeasure();
            String expMin = this.getMinValue();
            String expMax = this.getMaxValue();
            if (!this.isMinValueUserDefined()) {
                expMin = "$" + expMin;
            }
            if (!this.isMaxValueUserDefined()) {
                expMax = "$" + expMax;
            }
            try {
                expression = ExpressionUtil.betweenExpression(expMeasure, expMin, expMax).getExpressionString();
            }
            catch (SerializationException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        } else {
            String expMeasure = "$" + this.getMeasure();
            String expValue = this.getValue();
            if (!this.isValueUserDefined()) {
                expValue = "$" + expValue;
            }
            if (this.getCondition().equals("==missing")) {
                expValue = "";
            }
            try {
                expression = ExpressionUtil.simpleExpression(expMeasure, this.getCondition(), expValue, null, isMeasure).getExpressionString();
            }
            catch (SerializationException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return expression;
    }

    public String getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(String outlineColor) {
        this.outlineColor = outlineColor;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
    }

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
    }

    public boolean isAddImage() {
        return this.addImage;
    }

    public void setAddImage(boolean addImage) {
        this.addImage = addImage;
    }

    public boolean isAddText() {
        return this.addText;
    }

    public void setAddText(boolean addText) {
        this.addText = addText;
    }

    public String getImageTextPosition() {
        return this.imageTextPosition;
    }

    public void setImageTextPosition(String imageTextPosition) {
        this.imageTextPosition = imageTextPosition;
    }

    public boolean isTextBold() {
        return this.textBold;
    }

    public void setTextBold(boolean textBold) {
        this.textBold = textBold;
    }

    public String getTextFont() {
        return this.textFont;
    }

    public void setTextFont(String textFont) {
        this.textFont = textFont;
    }

    public String getTextFontColor() {
        return this.textFontColor;
    }

    public void setTextFontColor(String textFontColor) {
        this.textFontColor = textFontColor;
    }

    public String getTextFontSize() {
        return this.textFontSize;
    }

    public void setTextFontSize(String textFontSize) {
        this.textFontSize = textFontSize;
    }

    public boolean isTextItalic() {
        return this.textItalic;
    }

    public void setTextItalic(boolean textItalic) {
        this.textItalic = textItalic;
    }

    public boolean isTextUnderline() {
        return this.textUnderline;
    }

    public void setTextUnderline(boolean textUnderline) {
        this.textUnderline = textUnderline;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public boolean isMaxValueUserDefined() {
        return this.maxValueUserDefined;
    }

    public void setMaxValueUserDefined(boolean maxValueUserDefined) {
        this.maxValueUserDefined = maxValueUserDefined;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public boolean isMinValueUserDefined() {
        return this.minValueUserDefined;
    }

    public void setMinValueUserDefined(boolean minValueUserDefined) {
        this.minValueUserDefined = minValueUserDefined;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isValueUserDefined() {
        return this.valueUserDefined;
    }

    public void setValueUserDefined(boolean valueUserDefined) {
        this.valueUserDefined = valueUserDefined;
    }

    public String getAssignment() {
        return this.assignment;
    }

    public void setAssignment(String assignment) {
        this.assignment = assignment;
    }

    public boolean isMeasure() {
        return this.isMeasure;
    }

    public void setIsMeasure(boolean isMeasure) {
        this.isMeasure = isMeasure;
    }
}

