/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.exceptionhighlighting;

import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingOLAPRule;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingOLAPRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingRule;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingSelectorInterface;
import com.sas.datatypes.DoubleType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ExceptionHighlightingRemoteScriptingHandler {
    protected ExceptionHighlightingSelectorInterface adapter = null;
    protected String remoteAction;
    protected String remoteRuleId;
    protected String remoteMeasure;
    protected String remoteMeasureText;
    protected String remoteCondition;
    protected String remoteConditionText;
    protected String remoteAssignment;
    protected String remoteAssignmentText;
    protected String remoteValue;
    protected String remoteValueText;
    protected String remoteMinValue;
    protected String remoteMinValueText;
    protected String remoteMaxValue;
    protected String remoteMaxValueText;
    protected String remoteIsMeasure;
    protected String remoteIsMeasureText;
    protected String[] remoteSelectedLevels;
    protected String remoteOutlineColor;
    protected String remoteFillColor;
    protected String remoteFontColor;
    protected String remoteFont;
    protected String remoteFontSize;
    protected String remoteBold;
    protected String remoteItalic;
    protected String remoteUnderline;
    protected String remoteAddImageText;
    protected String remoteAddImageTextSelectedIndex;
    protected String remoteImageTextPosition;
    protected String remoteImage;
    protected String remoteText;
    protected String remoteTextFontColor;
    protected String remoteTextFont;
    protected String remoteTextFontSize;
    protected String remoteTextBold;
    protected String remoteTextItalic;
    protected String remoteTextUnderline;
    protected String remoteApplyToSelectedIndex;

    public ExceptionHighlightingRemoteScriptingHandler(ExceptionHighlightingSelectorInterface adapter) {
        this.adapter = adapter;
    }

    protected ExceptionHighlightingRuleInterface getNewRule() {
        ExceptionHighlightingRule rule = null;
        rule = this.adapter.isOLAP() ? new ExceptionHighlightingOLAPRule() : new ExceptionHighlightingRule();
        return rule;
    }

    public Map process() {
        HashMap<String, Object> eventInfo = new HashMap<String, Object>();
        String remoteAction = this.getRemoteAction();
        if (remoteAction.equalsIgnoreCase("ADDRULE")) {
            ExceptionHighlightingRuleInterface rule = this.getNewRule();
            rule.setId("" + System.currentTimeMillis());
            this.setupRule(rule);
            this.adapter.addRule(rule);
            eventInfo.put("remoteRule", rule);
        } else if (remoteAction.equalsIgnoreCase("DELETERULE")) {
            this.adapter.removeRule(this.getRemoteRuleId());
        } else if (remoteAction.equalsIgnoreCase("UPDATERULE")) {
            ExceptionHighlightingRuleInterface rule = (ExceptionHighlightingRuleInterface)this.adapter.getRules().get(this.getRemoteRuleId());
            this.setupRule(rule);
            eventInfo.put("remoteRule", rule);
        } else if (remoteAction.equalsIgnoreCase("LOADRULE")) {
            ExceptionHighlightingRuleInterface rule = (ExceptionHighlightingRuleInterface)this.adapter.getRules().get(this.getRemoteRuleId());
            eventInfo.put("remoteRule", rule);
        }
        eventInfo.put("remoteAction", remoteAction);
        return eventInfo;
    }

    private void setupRule(ExceptionHighlightingRuleInterface rule) {
        rule.setMeasure(this.getRemoteMeasure());
        rule.setCondition(this.getRemoteCondition());
        if (this.getRemoteCondition().equals("between")) {
            String maxLabel;
            String minLabel;
            String englishLocaleValue;
            rule.setValue("");
            rule.setMinValue(this.getRemoteMinValue());
            if ("".equals(this.getRemoteMinValueText())) {
                englishLocaleValue = ExceptionHighlightingRemoteScriptingHandler.convertLocaleValue(this.getRemoteMinValue(), this.adapter.getLocale(), Locale.ENGLISH);
                rule.setMinValue(englishLocaleValue);
                rule.setMinValueUserDefined(true);
                minLabel = ExceptionHighlightingRemoteScriptingHandler.convertLocaleValue(this.getRemoteMinValue(), this.adapter.getLocale(), this.adapter.getLocale());
            } else {
                rule.setMinValueUserDefined(false);
                minLabel = this.getRemoteMinValueText();
            }
            rule.setMaxValue(this.getRemoteMaxValue());
            if ("".equals(this.getRemoteMaxValueText())) {
                englishLocaleValue = ExceptionHighlightingRemoteScriptingHandler.convertLocaleValue(this.getRemoteMaxValue(), this.adapter.getLocale(), Locale.ENGLISH);
                rule.setMaxValue(englishLocaleValue);
                rule.setMaxValueUserDefined(true);
                maxLabel = ExceptionHighlightingRemoteScriptingHandler.convertLocaleValue(this.getRemoteMaxValue(), this.adapter.getLocale(), this.adapter.getLocale());
            } else {
                rule.setMaxValueUserDefined(false);
                maxLabel = this.getRemoteMaxValueText();
            }
            rule.setLabel(this.getRemoteMeasureText() + " " + this.getRemoteConditionText() + " " + minLabel + " - " + maxLabel);
        } else {
            rule.setMinValue("");
            rule.setMaxValue("");
            rule.setValue(this.getRemoteValue());
            if ("".equals(this.getRemoteValueText())) {
                String englishLocaleValue = ExceptionHighlightingRemoteScriptingHandler.convertLocaleValue(this.getRemoteValue(), this.adapter.getLocale(), Locale.ENGLISH);
                rule.setValue(englishLocaleValue);
                rule.setValueUserDefined(true);
                String labelValue = ExceptionHighlightingRemoteScriptingHandler.convertLocaleValue(this.getRemoteValue(), this.adapter.getLocale(), this.adapter.getLocale());
                rule.setLabel(this.getRemoteMeasureText() + " " + this.getRemoteConditionText() + " " + labelValue);
            } else {
                rule.setValueUserDefined(false);
                rule.setLabel(this.getRemoteMeasureText() + " " + this.getRemoteConditionText() + " " + this.getRemoteValueText());
            }
        }
        if (this.adapter.isOLAP()) {
            ((ExceptionHighlightingOLAPRuleInterface)rule).setApplyToSelectedIndex(this.getRemoteApplyToSelectedIndex());
            ((ExceptionHighlightingOLAPRuleInterface)rule).setSelectedLevels(this.getRemoteSelectedLevels());
        }
        rule.setIsMeasure(new Boolean(this.getRemoteIsMeasure()).booleanValue());
        rule.setAssignment(this.getRemoteAssignment());
        rule.setOutlineColor(this.getRemoteOutlineColor());
        rule.setFillColor(this.getRemoteFillColor());
        rule.setFontColor(this.getRemoteFontColor());
        rule.setFont(this.getRemoteFont());
        rule.setFontSize(this.getRemoteFontSize());
        rule.setBold(new Boolean(this.getRemoteBold()).booleanValue());
        rule.setItalic(new Boolean(this.getRemoteItalic()).booleanValue());
        rule.setUnderline(new Boolean(this.getRemoteUnderline()).booleanValue());
        rule.setAddImage(false);
        rule.setAddText(false);
        if (new Boolean(this.getRemoteAddImageText()).booleanValue()) {
            if (this.getRemoteAddImageTextSelectedIndex().equals("0")) {
                rule.setAddText(true);
            } else {
                rule.setAddImage(true);
            }
        }
        rule.setImageTextPosition(this.getRemoteImageTextPosition());
        rule.setImage(this.getRemoteImage());
        rule.setText(this.getRemoteText());
        rule.setTextFontColor(this.getRemoteTextFontColor());
        rule.setTextFont(this.getRemoteTextFont());
        rule.setTextFontSize(this.getRemoteTextFontSize());
        rule.setTextBold(new Boolean(this.getRemoteTextBold()).booleanValue());
        rule.setTextItalic(new Boolean(this.getRemoteTextItalic()).booleanValue());
        rule.setTextUnderline(new Boolean(this.getRemoteTextUnderline()).booleanValue());
    }

    public static String convertLocaleValue(String value, Locale dataLocale, Locale endLocale) {
        if (dataLocale == null || endLocale == null) {
            return value;
        }
        try {
            Object doubleValue = DoubleType.DEFAULT_INSTANCE_TRUNCATE_NO_ERROR.coerceValue((Object)value, dataLocale);
            if (doubleValue instanceof Double) {
                return DoubleType.DEFAULT_INSTANCE_TRUNCATE_NO_ERROR.getDisplayString(doubleValue, endLocale, 0);
            }
            return value;
        }
        catch (IllegalArgumentException e) {
            return value;
        }
    }

    public void setRemoteAction(String value) {
        this.remoteAction = value;
    }

    public String getRemoteAction() {
        return this.remoteAction;
    }

    public String getRemoteMeasure() {
        return this.remoteMeasure;
    }

    public void setRemoteMeasure(String value) {
        this.remoteMeasure = value;
    }

    public String getRemoteCondition() {
        return this.remoteCondition;
    }

    public void setRemoteCondition(String value) {
        this.remoteCondition = value;
    }

    public String getRemoteValue() {
        return this.remoteValue;
    }

    public void setRemoteValue(String value) {
        this.remoteValue = value;
    }

    public String getRemoteRuleId() {
        return this.remoteRuleId;
    }

    public void setRemoteRuleId(String remoteRuleId) {
        this.remoteRuleId = remoteRuleId;
    }

    public String getRemoteApplyToSelectedIndex() {
        return this.remoteApplyToSelectedIndex;
    }

    public void setRemoteApplyToSelectedIndex(String remoteApplyToSelectedIndex) {
        this.remoteApplyToSelectedIndex = remoteApplyToSelectedIndex;
    }

    public String getRemoteOutlineColor() {
        return this.remoteOutlineColor;
    }

    public void setRemoteOutlineColor(String remoteOutlineColor) {
        this.remoteOutlineColor = remoteOutlineColor;
    }

    public String getRemoteFillColor() {
        return this.remoteFillColor;
    }

    public void setRemoteFillColor(String remoteFillColor) {
        this.remoteFillColor = remoteFillColor;
    }

    public String getRemoteFontColor() {
        return this.remoteFontColor;
    }

    public void setRemoteFontColor(String remoteFontColor) {
        this.remoteFontColor = remoteFontColor;
    }

    public String getRemoteFont() {
        return this.remoteFont;
    }

    public void setRemoteFont(String remoteFont) {
        this.remoteFont = remoteFont;
    }

    public String getRemoteFontSize() {
        return this.remoteFontSize;
    }

    public void setRemoteFontSize(String remoteFontSize) {
        this.remoteFontSize = remoteFontSize;
    }

    public String getRemoteBold() {
        return this.remoteBold;
    }

    public void setRemoteBold(String remoteBold) {
        this.remoteBold = remoteBold;
    }

    public String getRemoteItalic() {
        return this.remoteItalic;
    }

    public void setRemoteItalic(String remoteItalic) {
        this.remoteItalic = remoteItalic;
    }

    public String getRemoteUnderline() {
        return this.remoteUnderline;
    }

    public void setRemoteUnderline(String remoteUnderline) {
        this.remoteUnderline = remoteUnderline;
    }

    public String getRemoteConditionText() {
        return this.remoteConditionText;
    }

    public void setRemoteConditionText(String remoteConditionText) {
        this.remoteConditionText = remoteConditionText;
    }

    public String getRemoteMeasureText() {
        return this.remoteMeasureText;
    }

    public void setRemoteMeasureText(String remoteMeasureText) {
        this.remoteMeasureText = remoteMeasureText;
    }

    public String getRemoteValueText() {
        return this.remoteValueText;
    }

    public void setRemoteValueText(String remoteValueText) {
        this.remoteValueText = remoteValueText;
    }

    public String getRemoteAddImageText() {
        return this.remoteAddImageText;
    }

    public void setRemoteAddImageText(String remoteAddImageText) {
        this.remoteAddImageText = remoteAddImageText;
    }

    public String getRemoteAddImageTextSelectedIndex() {
        return this.remoteAddImageTextSelectedIndex;
    }

    public void setRemoteAddImageTextSelectedIndex(String remoteAddImageTextSelectedIndex) {
        this.remoteAddImageTextSelectedIndex = remoteAddImageTextSelectedIndex;
    }

    public String getRemoteImage() {
        return this.remoteImage;
    }

    public void setRemoteImage(String remoteImage) {
        this.remoteImage = remoteImage;
    }

    public String getRemoteImageTextPosition() {
        return this.remoteImageTextPosition;
    }

    public void setRemoteImageTextPosition(String remoteImageTextPosition) {
        this.remoteImageTextPosition = remoteImageTextPosition;
    }

    public String getRemoteText() {
        return this.remoteText;
    }

    public void setRemoteText(String remoteText) {
        this.remoteText = remoteText;
    }

    public String getRemoteTextBold() {
        return this.remoteTextBold;
    }

    public void setRemoteTextBold(String remoteTextBold) {
        this.remoteTextBold = remoteTextBold;
    }

    public String getRemoteTextFont() {
        return this.remoteTextFont;
    }

    public void setRemoteTextFont(String remoteTextFont) {
        this.remoteTextFont = remoteTextFont;
    }

    public String getRemoteTextFontColor() {
        return this.remoteTextFontColor;
    }

    public void setRemoteTextFontColor(String remoteTextFontColor) {
        this.remoteTextFontColor = remoteTextFontColor;
    }

    public String getRemoteTextFontSize() {
        return this.remoteTextFontSize;
    }

    public void setRemoteTextFontSize(String remoteTextFontSize) {
        this.remoteTextFontSize = remoteTextFontSize;
    }

    public String getRemoteTextItalic() {
        return this.remoteTextItalic;
    }

    public void setRemoteTextItalic(String remoteTextItalic) {
        this.remoteTextItalic = remoteTextItalic;
    }

    public String getRemoteTextUnderline() {
        return this.remoteTextUnderline;
    }

    public void setRemoteTextUnderline(String remoteTextUnderline) {
        this.remoteTextUnderline = remoteTextUnderline;
    }

    public void setRemoteSelectedLevels(String[] selectedLevels) {
        this.remoteSelectedLevels = selectedLevels;
    }

    public String[] getRemoteSelectedLevels() {
        return this.remoteSelectedLevels;
    }

    public String getRemoteMaxValue() {
        return this.remoteMaxValue;
    }

    public void setRemoteMaxValue(String remoteMaxValue) {
        this.remoteMaxValue = remoteMaxValue;
    }

    public String getRemoteMaxValueText() {
        return this.remoteMaxValueText;
    }

    public void setRemoteMaxValueText(String remoteMaxValueText) {
        this.remoteMaxValueText = remoteMaxValueText;
    }

    public String getRemoteMinValue() {
        return this.remoteMinValue;
    }

    public void setRemoteMinValue(String remoteMinValue) {
        this.remoteMinValue = remoteMinValue;
    }

    public String getRemoteMinValueText() {
        return this.remoteMinValueText;
    }

    public void setRemoteMinValueText(String remoteMinValueText) {
        this.remoteMinValueText = remoteMinValueText;
    }

    public String getRemoteAssignmentText() {
        return this.remoteAssignmentText;
    }

    public void setRemoteAssignmentText(String remoteAssignmentText) {
        this.remoteAssignmentText = remoteAssignmentText;
    }

    public String getRemoteAssignment() {
        return this.remoteAssignment;
    }

    public void setRemoteAssignment(String remoteAssignment) {
        this.remoteAssignment = remoteAssignment;
    }

    public String getRemoteIsMeasure() {
        return this.remoteIsMeasure;
    }

    public void setRemoteIsMeasure(String remoteIsMeasure) {
        this.remoteIsMeasure = remoteIsMeasure;
    }
}

