/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.exceptionhighlighting;

import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingRuleInterface;
import com.sas.dataselectors.exceptionhighlighting.ExceptionHighlightingSelectorInterface;
import com.sas.dataselectors.exceptionhighlighting.RB;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.TreeModel;

public abstract class BaseExceptionHighlightingSelectorAdapter
implements ExceptionHighlightingSelectorInterface {
    protected String RB_KEY = "ExceptionHighlightingAdapter.";
    protected Locale locale = null;
    protected boolean isOLAP = false;
    protected Map rules = new LinkedHashMap();
    protected boolean addAutomaticToFontInfo = true;

    public Map getSupportedConditions() {
        LinkedHashMap<String, String> conditions = new LinkedHashMap<String, String>();
        conditions.put("==", RB.getStringResource((String)this.RB_KEY, (String)"Condition.Equal.txt", (Locale)this.getLocale()));
        conditions.put("!=", RB.getStringResource((String)this.RB_KEY, (String)"Condition.NotEqual.txt", (Locale)this.getLocale()));
        conditions.put("<", RB.getStringResource((String)this.RB_KEY, (String)"Condition.LessThan.txt", (Locale)this.getLocale()));
        conditions.put("<=", RB.getStringResource((String)this.RB_KEY, (String)"Condition.LessThanOrEqual.txt", (Locale)this.getLocale()));
        conditions.put(">", RB.getStringResource((String)this.RB_KEY, (String)"Condition.GreaterThan.txt", (Locale)this.getLocale()));
        conditions.put(">=", RB.getStringResource((String)this.RB_KEY, (String)"Condition.GreaterThanOrEqual.txt", (Locale)this.getLocale()));
        conditions.put("between", RB.getStringResource((String)this.RB_KEY, (String)"Condition.Between.txt", (Locale)this.getLocale()));
        conditions.put("==missing", RB.getStringResource((String)this.RB_KEY, (String)"Condition.IsMissingValue.txt", (Locale)this.getLocale()));
        return conditions;
    }

    public Map getRules() {
        return this.rules;
    }

    public void addRule(ExceptionHighlightingRuleInterface rule) {
        this.rules.put(rule.getId(), rule);
    }

    public void removeRule(String ruleId) {
        this.rules.remove(ruleId);
    }

    public List getColors() {
        ArrayList colors = new ArrayList();
        return colors;
    }

    public List getFontSizes() {
        ArrayList<KeyValueItem> fontSizes = new ArrayList<KeyValueItem>();
        if (this.isAddAutomaticToFontInfo()) {
            KeyValueItem automatic = new KeyValueItem("DEFAULT", RB.getStringResource((String)this.RB_KEY, (String)"default.txt", (Locale)this.getLocale()));
            fontSizes.add(automatic);
        }
        fontSizes.add(new KeyValueItem("8pt", "8"));
        fontSizes.add(new KeyValueItem("9pt", "9"));
        fontSizes.add(new KeyValueItem("10pt", "10"));
        fontSizes.add(new KeyValueItem("12pt", "12"));
        fontSizes.add(new KeyValueItem("14pt", "14"));
        fontSizes.add(new KeyValueItem("16pt", "16"));
        fontSizes.add(new KeyValueItem("18pt", "18"));
        fontSizes.add(new KeyValueItem("20pt", "20"));
        fontSizes.add(new KeyValueItem("22pt", "22"));
        fontSizes.add(new KeyValueItem("24pt", "24"));
        return fontSizes;
    }

    public List getFonts() {
        return null;
    }

    public TreeModel getLevelTreeModel() {
        return null;
    }

    public List getImages() {
        ArrayList<String> images = new ArrayList<String>();
        images.add("YellowSmiley.gif");
        images.add("YellowNeutral.gif");
        images.add("YellowFrown.gif");
        images.add("BlueSmiley.gif");
        images.add("BlueNeutral.gif");
        images.add("BlueFrown.gif");
        images.add("GreenSmiley.gif");
        images.add("GreenNeutral.gif");
        images.add("GreenFrown.gif");
        images.add("RedSmiley.gif");
        images.add("RedNeutral.gif");
        images.add("RedFrown.gif");
        images.add("GreenDiamond.gif");
        images.add("YellowDiamond.gif");
        images.add("RedDiamond.gif");
        images.add("GreenCheck.gif");
        images.add("YellowCheck.gif");
        images.add("RedCheck.gif");
        images.add("GreenBall.gif");
        images.add("YellowBall.gif");
        images.add("RedBall.gif");
        images.add("GreenUp.gif");
        images.add("YellowSideways.gif");
        images.add("RedDown.gif");
        images.add("GreenStar.gif");
        images.add("YellowStar.gif");
        images.add("RedStar.gif");
        images.add("GreenSquare.gif");
        images.add("YellowSquare.gif");
        images.add("RedSquare.gif");
        images.add("ThumbsUp1.gif");
        images.add("ThumbsDown1.gif");
        images.add("ThumbsUp2.gif");
        images.add("ThumbsDown2.gif");
        images.add("Critical.gif");
        images.add("Warning.gif");
        images.add("Frown.gif");
        images.add("Smiley.gif");
        images.add("WeatherPartiallyCloudy.gif");
        images.add("WeatherStormy.gif");
        images.add("WeatherSunny.gif");
        return images;
    }

    public boolean isOLAP() {
        return false;
    }

    public boolean isCompleteImagePath() {
        return false;
    }

    public boolean isAddAutomaticToFontInfo() {
        return this.addAutomaticToFontInfo;
    }

    public void setAddAutomaticToFontInfo(boolean addAutomaticToFontInfo) {
        this.addAutomaticToFontInfo = addAutomaticToFontInfo;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getDefaultFont() {
        if (this.getFonts() != null) {
            return ((KeyValueItem)this.getFonts().get(0)).getKey();
        }
        return null;
    }

    public String getDefaultFontSize() {
        return ((KeyValueItem)this.getFontSizes().get(0)).getKey();
    }

    public List getResultItems() {
        return ((BusinessQuery)this.getModel()).getResultItems();
    }

    public Map getResultItemMap() {
        HashMap<DataItem, Boolean> riMap = new HashMap<DataItem, Boolean>();
        Map measureMap = this.getMeasureNames();
        for (DataItem dataItem : ((BusinessQuery)this.getModel()).getResultItems()) {
            if (measureMap.containsKey(dataItem.getResultSetID())) {
                riMap.put(dataItem, false);
                continue;
            }
            riMap.put(dataItem, !dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE));
        }
        return riMap;
    }

    public class KeyValueItem
    implements ExceptionHighlightingSelectorInterface.KeyValueItemInterface {
        private String key = null;
        private String value = null;

        public KeyValueItem(String keyValue) {
            this.setKey(keyValue);
            this.setDisplayValue(keyValue);
        }

        public KeyValueItem(String key, String value) {
            this.setKey(key);
            this.setDisplayValue(value);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getDisplayValue() {
            return this.value;
        }

        public void setDisplayValue(String value) {
            this.value = value;
        }
    }
}

