/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.dataitems;

import com.sas.dataselectors.dataitems.BusinessModelTreeModelFactory;
import com.sas.dataselectors.dataitems.DataItemTreeNodeInfo;
import com.sas.dataselectors.dataitems.TableRoles;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.impl.Utils;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.util.RoleInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreeModel;

public class OLAPTableRoles
extends TableRoles {
    public static final String ROW = "row";
    public static final String PAGE = "page";
    public static final String CHAPTER = "chapter";
    public static final String SECTION = "section";
    public static final String BOOK = "book";

    public OLAPTableRoles(BusinessQuery businessQuery) {
        super(businessQuery);
    }

    public OLAPTableRoles(BusinessQuery businessQuery, InformationMap imap) {
        super(businessQuery, imap);
    }

    @Override
    public boolean hasValidRoles() {
        RoleInterface[] roles = this.getRoles();
        if (roles.length == 0) {
            return true;
        }
        boolean minMaxRulesValid = super.hasValidRoles();
        ArrayList measuresInfo = new ArrayList();
        this.getDimensionsUsed(roles, measuresInfo);
        return minMaxRulesValid;
    }

    @Override
    protected boolean isValidRole(String name) {
        return super.isValidRole(name) || ROW.equals(name) || PAGE.equals(name) || CHAPTER.equals(name) || SECTION.equals(name) || BOOK.equals(name);
    }

    @Override
    public TreeModel getAvailableTreeModel(TransformInterface transform, String selectedRole) {
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List allItems = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class);
        allItems = this.removeNotUsableItems(allItems);
        allItems = this.resetReferenceItems(allItems);
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole) && !rolesUsed[i].getRoleLabel().equalsIgnoreCase(selectedRole)) continue;
            availableItems = rolesUsed[i].getAvailableRoleItems();
            break;
        }
        if (this.originalItemList == null) {
            this.setOriginalItemList(allItems);
        }
        availableItems = this.removeDuplicateItems(availableItems);
        TreeModel tm = BusinessModelTreeModelFactory.getTreeModel(allItems, availableItems, transform, true, this.getLocale(), null, this.iMap);
        return tm;
    }

    @Override
    public List getAvailableItemInfoList(String selectedRole) {
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List dataItemRefList = null;
        ArrayList allDataItemRefs = new ArrayList();
        List allItems = Utils.filterObjects((BusinessModel)this._businessModel, (boolean)true, DataItem.class);
        allItems = this.removeNotUsableItems(allItems);
        allItems = this.removeCalculatedItemBaseItems(allItems);
        allItems = this.removeDuplicateItems(allItems);
        this.setOriginalItemList(allItems);
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            dataItemRefList = ((TableRoles.Role)rolesUsed[i]).getDataItemReferenceList();
            allDataItemRefs.addAll(dataItemRefList);
            if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole) && !rolesUsed[i].getRoleLabel().equalsIgnoreCase(selectedRole)) continue;
            availableItems = rolesUsed[i].getAvailableRoleItems();
        }
        availableItems = this.removeCalculatedItemBaseItems(availableItems);
        availableItems = this.removeDuplicateItems(availableItems);
        ArrayList<DataItemTreeNodeInfo> availableItemInfo = new ArrayList<DataItemTreeNodeInfo>();
        DataItem thisitem = null;
        String thisid = null;
        boolean enabled = false;
        String category = null;
        Object iconSrc = null;
        int numberOfItems = allItems.size();
        for (int i = 0; i < numberOfItems; ++i) {
            thisitem = (DataItem)allItems.get(i);
            if (allDataItemRefs.contains(thisitem)) {
                thisitem = ((DataItemReference)thisitem).getBaseDataItem();
            }
            enabled = true;
            if (!availableItems.contains(thisitem)) {
                enabled = false;
            }
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            DataItemTreeNodeInfo iteminfo = new DataItemTreeNodeInfo(thisid, thisitem.getLabel(), thisitem.getLabel());
            StructureOfDataItem sodi = thisitem.getStructure();
            if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
                category = "Hierarchies";
                iteminfo.setDefaultImage("OLAPHierarchy.gif");
                iteminfo.setDisabledImage("OLAPHierarchy_disabled.gif");
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
                category = "Hierarchies";
                iteminfo.setDefaultImage("OLAPDimension.gif");
                iteminfo.setDisabledImage("OLAPDimension_disabled.gif");
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
                category = "Levels";
                iteminfo.setDefaultImage("OLAPLevel.gif");
                iteminfo.setDisabledImage("OLAPLevel_disabled.gif");
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                category = "Measures";
                iteminfo.setDefaultImage("OLAPMeasure.gif");
                iteminfo.setDisabledImage("OLAPMeasure_disabled.gif");
            }
            iteminfo.setEnabled(enabled);
            iteminfo.setCategory(category);
            iteminfo.setItemDescription(thisitem.getDescription());
            availableItemInfo.add(iteminfo);
        }
        return availableItemInfo;
    }

    @Override
    public List getSelectedItemInfoList(String selectedRole) {
        RoleInterface[] rolesUsed = this.getRoles();
        List selectedItems = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole)) continue;
            selectedItems = rolesUsed[i].getRoleItems();
            break;
        }
        ArrayList<DataItemTreeNodeInfo> selectedItemInfo = new ArrayList<DataItemTreeNodeInfo>();
        DataItem thisitem = null;
        String thisid = null;
        boolean enabled = false;
        String category = null;
        Object iconSrc = null;
        for (int i = 0; i < selectedItems.size(); ++i) {
            thisitem = (DataItem)selectedItems.get(i);
            enabled = true;
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            DataItemTreeNodeInfo iteminfo = new DataItemTreeNodeInfo(thisid, thisitem.getLabel(), thisitem.getLabel());
            StructureOfDataItem sodi = thisitem.getStructure();
            if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
                category = "Hierarchies";
                iteminfo.setDefaultImage("OLAPHierarchy.gif");
                iteminfo.setDisabledImage("OLAPHierarchy_disabled.gif");
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
                category = "Hierarchies";
                iteminfo.setDefaultImage("OLAPDimension.gif");
                iteminfo.setDisabledImage("OLAPDimension_disabled.gif");
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
                category = "Levels";
                iteminfo.setDefaultImage("OLAPLevel.gif");
                iteminfo.setDisabledImage("OLAPLevel_disabled.gif");
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                category = "Measures";
                iteminfo.setDefaultImage("OLAPMeasure.gif");
                iteminfo.setDisabledImage("OLAPMeasure_disabled.gif");
            }
            iteminfo.setEnabled(enabled);
            iteminfo.setCategory(category);
            iteminfo.setItemDescription(thisitem.getDescription());
            selectedItemInfo.add(iteminfo);
        }
        return selectedItemInfo;
    }

    @Override
    public List getAvailableEnabledNodeIds(String selectedRole) {
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List roleDataItemRefList = null;
        List selectedItems = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole)) continue;
            availableItems = rolesUsed[i].getAvailableRoleItems();
            selectedItems = rolesUsed[i].getRoleItems();
            availableItems = this.removeDuplicateItems(availableItems);
            roleDataItemRefList = ((TableRoles.Role)rolesUsed[i]).getDataItemReferenceList();
            break;
        }
        ArrayList<String> availableIds = new ArrayList<String>();
        DataItem thisitem = null;
        String thisid = null;
        for (int i = 0; i < availableItems.size(); ++i) {
            thisitem = (DataItem)availableItems.get(i);
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
            availableIds.add(thisid);
        }
        return availableIds;
    }

    private List resetReferenceItems(List listofitems) {
        int j;
        ArrayList newItemList = new ArrayList();
        RoleInterface[] rolesUsed = this.getRoles();
        List roleDataItemRefList = null;
        ArrayList calcItemReferences = new ArrayList();
        ArrayList allReferences = new ArrayList();
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            roleDataItemRefList = ((TableRoles.Role)rolesUsed[i]).getDataItemReferenceList();
            allReferences.addAll(roleDataItemRefList);
        }
        for (j = 0; j < listofitems.size(); ++j) {
            Object thisitem = listofitems.get(j);
            if (allReferences.contains(thisitem)) {
                DataItemReference thisref = (DataItemReference)allReferences.get(allReferences.indexOf(thisitem));
                DataItem refbaseItem = thisref.getBaseDataItem();
                thisitem = refbaseItem;
            }
            if (thisitem instanceof DataItemReference && ((DataItem)thisitem).isCalculatedItem()) {
                calcItemReferences.add(thisitem);
            }
            if (newItemList.contains(thisitem)) continue;
            newItemList.add(thisitem);
        }
        for (j = 0; j < calcItemReferences.size(); ++j) {
            DataItem baseitem = ((DataItemReference)calcItemReferences.get(j)).getBaseDataItem();
            if (!newItemList.contains(baseitem)) continue;
            newItemList.remove(baseitem);
        }
        return newItemList;
    }

    @Override
    protected List getAvailableRoleItems(RoleInterface role) {
        boolean isFilterRole = "filter".equals(role.getRoleName());
        List allRoleItems = this.getRoleItems(isFilterRole);
        ArrayList availableRoleItems = new ArrayList();
        List currentRoleItems = role.getRoleItems();
        if (role.getMaxRoleItemCount() != 0 && currentRoleItems.size() == role.getMaxRoleItemCount()) {
            return availableRoleItems;
        }
        RoleInterface[] roles = this.getRoles();
        int count = roles.length;
        for (int i = 0; i < count; ++i) {
            List roleItems = roles[i].getRoleItems();
            int count2 = roleItems.size();
            for (int j = 0; j < count2; ++j) {
                DataItem thisbaseitem;
                Object thisitem = roleItems.get(j);
                if (thisitem instanceof DataItemReference && allRoleItems.contains(thisbaseitem = ((DataItemReference)thisitem).getBaseDataItem())) {
                    allRoleItems.remove(thisbaseitem);
                }
                if (!allRoleItems.contains(thisitem)) continue;
                allRoleItems.remove(thisitem);
            }
        }
        ArrayList measureInformation = new ArrayList();
        List dimensionsUsed = this.getDimensionsUsed(roles, measureInformation);
        if (measureInformation.size() > 0) {
            RoleInterface measureRole = (RoleInterface)measureInformation.get(0);
            String measureDimensionName = (String)measureInformation.get(1);
            if (measureRole == role && !"slicer".equals(role.getRoleName())) {
                dimensionsUsed.remove(measureDimensionName);
                List roleItems = role.getRoleItems();
                int count2 = roleItems.size();
                for (int i = 0; i < count2; ++i) {
                    allRoleItems.remove(roleItems.get(i));
                }
            }
        }
        int count3 = allRoleItems.size();
        for (int i = 0; i < count3; ++i) {
            Object obj = allRoleItems.get(i);
            String dimensionName = this.getDimensionName(allRoleItems.get(i));
            if (dimensionsUsed.contains(dimensionName)) continue;
            availableRoleItems.add(allRoleItems.get(i));
        }
        return availableRoleItems;
    }

    private String getDimensionName(Object obj) {
        String dimensionName = null;
        if (obj instanceof DataItem) {
            DataItem di = (DataItem)obj;
            ExpressionInterface exp = di.getExpression();
            try {
                dimensionName = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)this._businessModel, (DataItem)di);
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return dimensionName;
    }

    private List getDimensionsUsed(RoleInterface[] roles, List measuresInformation) {
        ArrayList<String> dimensions = new ArrayList<String>();
        int count = roles.length;
        for (int i = 0; i < count; ++i) {
            List roleItems = roles[i].getRoleItems();
            int count2 = roleItems.size();
            for (int j = 0; j < count2; ++j) {
                if (!(roleItems.get(j) instanceof DataItem)) continue;
                DataItem di = (DataItem)roleItems.get(j);
                ExpressionInterface exp = di.getExpression();
                String dimension = null;
                try {
                    dimension = BusinessQueryOLAPUtil.getDimensionName((BusinessModel)this._businessModel, (DataItem)di);
                    if (dimension != null && measuresInformation.size() == 0 && BusinessQueryOLAPUtil.isInMeasureDimension((BusinessModel)this._businessModel, (DataItem)di)) {
                        measuresInformation.add(roles[i]);
                        measuresInformation.add(dimension);
                    }
                }
                catch (MetadataException e) {
                    LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
                if (dimension == null || dimensions.contains(dimension)) continue;
                dimensions.add(dimension);
            }
        }
        return dimensions;
    }
}

