/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.dataitems;

import com.sas.dataselectors.dataitems.BaseDataItemSelectorModel;
import com.sas.dataselectors.dataitems.DataItemSelectorModel;
import com.sas.dataselectors.dataitems.RB;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.util.RoleInterface;
import java.util.ArrayList;
import java.util.List;

public class DataItemSelectorModelOLAPTable
extends DataItemSelectorModel {
    public static final String ROLE_COLUMN = "Column";
    public static final String ROLE_ROW = "Row";
    public static final String RB_KEY = "DataItemSelectorModelOLAPTable.";
    protected BaseDataItemSelectorModel.Role _columnRole;
    protected BaseDataItemSelectorModel.Role _rowRole;

    public DataItemSelectorModelOLAPTable(BusinessQuery businessQuery) {
        this(businessQuery, null);
    }

    public DataItemSelectorModelOLAPTable(BusinessQuery businessQuery, InformationMap infoMap) {
        super(businessQuery, infoMap);
    }

    @Override
    protected String getRoleLabel(String role) {
        String label = super.getRoleLabel(role);
        if (label != null) {
            return label;
        }
        if (role.equalsIgnoreCase(ROLE_ROW)) {
            return RB.getStringResource(RB_KEY, "rows.txt", this._locale);
        }
        if (role.equalsIgnoreCase(ROLE_COLUMN)) {
            return RB.getStringResource(RB_KEY, "columns.txt", this._locale);
        }
        return null;
    }

    @Override
    public List getMoveTargetRoles() {
        List rolesList = super.getMoveTargetRoles();
        String[] highlightedItems = this.getSelectedItems();
        int highlightedMeasureCount = 0;
        for (int i = 0; i < highlightedItems.length; ++i) {
            Object item = this.getItemFromItemMap(highlightedItems[i]);
            if (item == null || !this.isMeasure(item)) continue;
            ++highlightedMeasureCount;
        }
        if (highlightedMeasureCount >= 1) {
            List items;
            RoleInterface role;
            int i;
            boolean atLeastOneMeasureFound = false;
            int size = rolesList.size();
            for (i = 0; i < size; ++i) {
                role = (RoleInterface)rolesList.get(i);
                items = role.getRoleItems();
                int itemsSize = items.size();
                for (int j = 0; j < itemsSize; ++j) {
                    if (!this.isMeasure(items.get(j))) continue;
                    atLeastOneMeasureFound = true;
                    break;
                }
                if (atLeastOneMeasureFound) break;
            }
            if (atLeastOneMeasureFound) {
                for (i = 0; i < size; ++i) {
                    role = (RoleInterface)rolesList.get(i);
                    items = role.getRoleItems();
                    boolean measureFound = false;
                    int itemsSize = items.size();
                    for (int j = 0; j < itemsSize; ++j) {
                        if (!this.isMeasure(items.get(j))) continue;
                        measureFound = true;
                        break;
                    }
                    if (measureFound) continue;
                    rolesList.remove(role);
                    --size;
                }
            }
        }
        return rolesList;
    }

    @Override
    protected void createRoles() {
        this._rolesList = new ArrayList();
        this._rolesList.add(this.createRowRole());
        this._rolesList.add(this.createColumnRole());
    }

    protected RoleInterface createColumnRole() {
        this._columnRole = new BaseDataItemSelectorModel.Role(ROLE_COLUMN, this.getRoleLabel(ROLE_COLUMN), this.getRoleLabel(ROLE_COLUMN), 1, 0);
        this._columnRole.setRoleClosedIcon("crosstab_columns.gif");
        return this._columnRole;
    }

    protected RoleInterface createRowRole() {
        this._rowRole = new BaseDataItemSelectorModel.Role(ROLE_ROW, this.getRoleLabel(ROLE_ROW), this.getRoleLabel(ROLE_ROW), 1, 0);
        this._rowRole.setRoleClosedIcon("crosstab_rows.gif");
        return this._rowRole;
    }
}

