/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.dataitems;

import com.sas.dataselectors.dataitems.DataItemTreeNodeInfo;
import com.sas.iquery.metadata.InvalidIDException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.InformationMap;
import com.sas.iquery.metadata.business.MapFolder;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.swing.visuals.dataselectors.dataitems.DisabledNode;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BusinessModelTreeModelFactory {
    public static final String HIERARCHIES = "Hierarchies";
    public static final String LEVELS = "Levels";
    public static final String MEASURES = "Measures";
    public static final String DIMENSIONS = "Dimensions";
    public static final String COLUMNS = "Columns";
    public static final String RB_KEY = "BusinessModelTreeModelFactory.";
    private static final String MEASURE_ITEM_IMAGE = "MeasureItemType.gif";
    private static final String MEASURE_ITEM_DISABLED_IMAGE = "MeasureItemType_disabled.gif";
    private static final String CATEGORY_ITEM_IMAGE = "CategoryItemType.gif";
    private static final String CATEGORY_ITEM_DISABLED_IMAGE = "CategoryItemType_disabled.gif";
    private static final String OLAP_MEASURE_ITEM_IMAGE = "OLAPMeasure.gif";
    private static final String OLAP_MEASURE_ITEM_DISABLED_IMAGE = "OLAPMeasure_disabled.gif";
    private static final String LEVEL_ITEM_IMAGE = "OLAPLevel.gif";
    private static final String LEVEL_ITEM_DISABLED_IMAGE = "OLAPLevel_disabled.gif";
    private static final String DIMENSION_ITEM_IMAGE = "OLAPDimension.gif";
    private static final String DIMENSION_ITEM_DISABLED_IMAGE = "OLAPDimension_disabled.gif";
    private static final String HIERARCHY_ITEM_IMAGE = "OLAPHierarchy.gif";
    private static final String HIERARCHY_ITEM_DISABLED_IMAGE = "OLAPHierarchy_disabled.gif";
    private static final String IMAGE_PATH = "GIF_16/";

    public static TreeModel getTreeModel(List allItems, List availableItems, TransformInterface transform, boolean groupitems, Locale locale, String rootName, InformationMap infomap) {
        if (rootName == null) {
            rootName = "rootnode";
        }
        DataItemTreeNodeInfo rootinfo = new DataItemTreeNodeInfo("rootnode", rootName, "rootnode");
        Object availableRootNode = new DisabledNode((Object)rootinfo);
        availableRootNode = BusinessModelTreeModelFactory._transformNode(transform, (DisabledNode)availableRootNode);
        MapFolder rootMapFolder = null;
        try {
            rootMapFolder = infomap.getRootMapFolder();
        }
        catch (MetadataException e2) {
            LoggerRepository2.getLogger((String)BusinessModelTreeModelFactory.class.getName(), null).error(e2.getMessage(), (Throwable)e2);
        }
        HashMap<MapFolder, Object> allFolders = new HashMap<MapFolder, Object>();
        if (rootMapFolder != null) {
            List folderList = rootMapFolder.getSubfolders();
            allFolders.put(rootMapFolder, availableRootNode);
            BusinessModelTreeModelFactory.createFolderNodes(folderList, (DefaultMutableTreeNode)availableRootNode, availableItems, transform, allFolders);
        }
        BusinessModelTreeModelFactory.addDataItems(allItems, availableItems, transform, allFolders, infomap, (DefaultMutableTreeNode)availableRootNode);
        List itemsNotInFolder = null;
        try {
            itemsNotInFolder = infomap.getBusinessItemsNotInMapFolders();
            int itemsSize = itemsNotInFolder.size();
            for (int i = 0; i < itemsSize; ++i) {
                if (!(itemsNotInFolder.get(i) instanceof MutableTreeNode)) continue;
                ((DefaultMutableTreeNode)availableRootNode).add((MutableTreeNode)itemsNotInFolder.get(i));
            }
        }
        catch (MetadataException itemsSize) {
            // empty catch block
        }
        DefaultTreeModel availableModel = new DefaultTreeModel((TreeNode)availableRootNode);
        availableModel.setAsksAllowsChildren(true);
        return availableModel;
    }

    private static void createFolderNodes(List folderList, DefaultMutableTreeNode addToNode, List availableItems, TransformInterface transform, Map folderMap) {
        DefaultMutableTreeNode newNode = null;
        int folderListSize = folderList.size();
        for (int i = 0; i < folderListSize; ++i) {
            MapFolder thisfolder = (MapFolder)folderList.get(i);
            List subfolders = thisfolder.getSubfolders();
            newNode = BusinessModelTreeModelFactory._newBranch(transform, thisfolder.getLabel());
            folderMap.put(thisfolder, newNode);
            addToNode.add(newNode);
            if (subfolders.size() <= 0) continue;
            BusinessModelTreeModelFactory.createFolderNodes(subfolders, newNode, availableItems, transform, folderMap);
        }
    }

    private static void addDataItems(List itemlist, List availableItems, TransformInterface transform, Map folderMap, InformationMap infomap, DefaultMutableTreeNode rootnode) {
        String thisid = null;
        for (int j = 0; j < itemlist.size(); ++j) {
            DataItem thisitem;
            DataItem baseItem = thisitem = (DataItem)itemlist.get(j);
            while (baseItem instanceof DataItemReference) {
                baseItem = ((DataItemReference)thisitem).getBaseDataItem();
            }
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                LoggerRepository2.getLogger((String)BusinessModelTreeModelFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            MapFolder folder = null;
            try {
                folder = infomap.getMapFolderContaining((BusinessItem)baseItem);
            }
            catch (MetadataException e1) {
                LoggerRepository2.getLogger((String)BusinessModelTreeModelFactory.class.getName(), null).error(e1.getMessage(), (Throwable)e1);
            }
            DefaultMutableTreeNode addToNode = null;
            addToNode = folder == null ? rootnode : (DefaultMutableTreeNode)folderMap.get(folder);
            boolean itemenabled = true;
            if (!availableItems.contains(thisitem)) {
                itemenabled = false;
            }
            DataItemTreeNodeInfo iteminfo = new DataItemTreeNodeInfo(thisid, thisitem.getLabel(), thisitem.getLabel());
            iteminfo.setEnabled(itemenabled);
            iteminfo.setItemDescription(thisitem.getDescription());
            StructureOfDataItem sodi = thisitem.getStructure();
            DataItemActionType itemusage = thisitem.getUsage();
            BusinessModelTreeModelFactory.setItemInfoProperties(iteminfo, sodi, itemusage);
            Object newNode = new DisabledNode((Object)iteminfo);
            newNode.setEnabled(itemenabled);
            newNode.setAllowsChildren(false);
            if (transform != null && (newNode = BusinessModelTreeModelFactory._transformNode(transform, newNode)) == null) continue;
            newNode.setAllowsChildren(false);
            addToNode.add((MutableTreeNode)newNode);
        }
    }

    private static void setItemInfoProperties(DataItemTreeNodeInfo iteminfo, StructureOfDataItem sodi, DataItemActionType usage) {
        iteminfo.setImagePath(IMAGE_PATH);
        if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
            iteminfo.setDefaultImage(HIERARCHY_ITEM_IMAGE);
            iteminfo.setDisabledImage(HIERARCHY_ITEM_DISABLED_IMAGE);
            iteminfo.setCategory(HIERARCHIES);
        } else if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
            iteminfo.setDefaultImage(DIMENSION_ITEM_IMAGE);
            iteminfo.setDisabledImage(DIMENSION_ITEM_DISABLED_IMAGE);
            iteminfo.setCategory(DIMENSIONS);
        } else if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
            iteminfo.setDefaultImage(LEVEL_ITEM_IMAGE);
            iteminfo.setDisabledImage(LEVEL_ITEM_DISABLED_IMAGE);
            iteminfo.setCategory(LEVELS);
        } else if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
            iteminfo.setDefaultImage(OLAP_MEASURE_ITEM_IMAGE);
            iteminfo.setDisabledImage(OLAP_MEASURE_ITEM_DISABLED_IMAGE);
            iteminfo.setCategory(MEASURES);
        } else if (sodi.equals(StructureOfDataItem.STRUCTURE_COLUMN)) {
            if (usage == DataItemActionType.USAGE_AGGREGATE) {
                iteminfo.setDefaultImage(MEASURE_ITEM_IMAGE);
                iteminfo.setDisabledImage(MEASURE_ITEM_DISABLED_IMAGE);
            } else {
                iteminfo.setDefaultImage(CATEGORY_ITEM_IMAGE);
                iteminfo.setDisabledImage(CATEGORY_ITEM_DISABLED_IMAGE);
            }
            iteminfo.setCategory(COLUMNS);
        }
    }

    private static DefaultMutableTreeNode _transformNode(TransformInterface transform, DisabledNode oldNode) {
        if (oldNode == null) {
            return null;
        }
        Object node = oldNode;
        if (transform != null) {
            try {
                node = transform.transform((Object)oldNode);
            }
            catch (TransformException e) {
                System.out.println("Error transforming node: " + oldNode);
                return null;
            }
        }
        if (node instanceof DefaultMutableTreeNode) {
            return (DefaultMutableTreeNode)node;
        }
        return null;
    }

    private static DefaultMutableTreeNode _newBranch(TransformInterface transform, String label) {
        DataItemTreeNodeInfo branchNodeInfo = new DataItemTreeNodeInfo(label, label, label, true, true);
        DisabledNode node = new DisabledNode((Object)branchNodeInfo);
        return BusinessModelTreeModelFactory._transformNode(transform, node);
    }

    public static TreeNode getSelectedModelNode(String roleLabel, String roleName, List selectedItems, TransformInterface transform, String selectedRole) {
        int numItems = selectedItems.size();
        DataItemTreeNodeInfo rootinfo = new DataItemTreeNodeInfo(roleName, roleLabel, roleLabel);
        if (roleName.equalsIgnoreCase(selectedRole)) {
            rootinfo.setExpanded(true);
        }
        Object rolenode = new DisabledNode((Object)rootinfo);
        ((DefaultMutableTreeNode)rolenode).setAllowsChildren(true);
        if (transform != null) {
            rolenode = BusinessModelTreeModelFactory._transformNode(transform, (DisabledNode)rolenode);
        }
        for (int j = 0; j < numItems; ++j) {
            DataItem thisitem = (DataItem)selectedItems.get(j);
            String thisid = null;
            try {
                thisid = thisitem.getID();
            }
            catch (InvalidIDException e) {
                LoggerRepository2.getLogger((String)BusinessModelTreeModelFactory.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
            DataItemTreeNodeInfo iteminfo = new DataItemTreeNodeInfo(thisid, thisitem.getLabel(), thisitem.getLabel());
            StructureOfDataItem sodi = thisitem.getStructure();
            DataItemActionType usage = thisitem.getUsage();
            iteminfo.setImagePath(IMAGE_PATH);
            String category = null;
            if (sodi.equals(StructureOfDataItem.STRUCTURE_HIERARCHY)) {
                category = HIERARCHIES;
                iteminfo.setDefaultImage(HIERARCHY_ITEM_IMAGE);
                iteminfo.setDisabledImage(HIERARCHY_ITEM_DISABLED_IMAGE);
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_DIMENSION)) {
                category = HIERARCHIES;
                iteminfo.setDefaultImage(DIMENSION_ITEM_IMAGE);
                iteminfo.setDisabledImage(DIMENSION_ITEM_DISABLED_IMAGE);
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_LEVEL)) {
                category = LEVELS;
                iteminfo.setDefaultImage(LEVEL_ITEM_IMAGE);
                iteminfo.setDisabledImage(LEVEL_ITEM_DISABLED_IMAGE);
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_MEASURE)) {
                category = MEASURES;
                iteminfo.setDefaultImage(OLAP_MEASURE_ITEM_IMAGE);
                iteminfo.setDisabledImage(OLAP_MEASURE_ITEM_DISABLED_IMAGE);
            } else if (sodi.equals(StructureOfDataItem.STRUCTURE_COLUMN)) {
                if (usage == DataItemActionType.USAGE_AGGREGATE) {
                    iteminfo.setDefaultImage(MEASURE_ITEM_IMAGE);
                    iteminfo.setDisabledImage(MEASURE_ITEM_DISABLED_IMAGE);
                } else {
                    iteminfo.setDefaultImage(CATEGORY_ITEM_IMAGE);
                    iteminfo.setDisabledImage(CATEGORY_ITEM_DISABLED_IMAGE);
                }
                category = COLUMNS;
            }
            iteminfo.setCategory(category);
            iteminfo.setItemDescription(thisitem.getDescription());
            iteminfo.setEnabled(true);
            Object newNode = new DisabledNode((Object)iteminfo);
            newNode.setAllowsChildren(false);
            if (transform != null) {
                newNode = BusinessModelTreeModelFactory._transformNode(transform, newNode);
            }
            ((DefaultMutableTreeNode)rolenode).add((MutableTreeNode)newNode);
        }
        return rolenode;
    }
}

