/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.dataitems;

import com.sas.dataselectors.SelectorCommitInterface;
import com.sas.dataselectors.SelectorProcessInterface;
import com.sas.dataselectors.dataitems.DataItemSelectorInterface;
import com.sas.dataselectors.dataitems.DataItemTreeNodeInfo;
import com.sas.dataselectors.dataitems.RB;
import com.sas.swing.visuals.dataselectors.dataitems.DisabledNode;
import com.sas.util.RoleInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.transforms.StringArrayToVectorTransform;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public abstract class BaseDataItemSelectorModel
implements DataItemSelectorInterface,
SelectorProcessInterface,
SelectorCommitInterface {
    protected ArrayList _rolesList;
    protected Map _dataItemMap = new HashMap();
    protected Locale _locale;
    protected String queryType;
    protected List originalItemList;
    protected String action;
    protected String data;
    protected String positionToMoveTo;
    protected String role;
    protected String[] selectedItems;
    protected String[] unselectedItems;
    public static final String RB_KEY = "BaseDataItemSelectorModel.";
    public static final String SHOW_MODE = "SHOW";
    public static final String PROCESS_MODE = "PROCESS";
    public static final String CANCEL_MODE = "CANCEL";
    public static final String COMMIT_MODE = "COMMIT";
    public static final String UPDATE_ITEMS = "updateitems";
    public static final String SORT_ITEMS = "sortitems";
    public static final String MOVE_ITEMS = "moveitems";
    public static final String CHANGE_ROLE = "changerole";
    public static final String MOVE_ITEM_UP = "moveitemup";
    public static final String MOVE_ITEM_DOWN = "moveitemdown";
    public static final String MOVE_ITEM_TO_POSITION = "moveitemtoposition";
    public static final String CHANGE_QUERY_TYPE = "changequerytype";
    public static final String COMMIT = "commit";

    public void setAction(String actionstr) {
        this.action = actionstr;
    }

    public String getAction() {
        return this.action;
    }

    public void setData(String datastr) {
        this.data = datastr;
    }

    public String getData() {
        return this.data;
    }

    public void setPositionToMoveTo(String datastr) {
        this.positionToMoveTo = datastr;
    }

    public String getPositionToMoveTo() {
        return this.positionToMoveTo;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public void setSelectedItems(String[] items) {
        this.selectedItems = items;
    }

    public String[] getSelectedItems() {
        return this.selectedItems;
    }

    public void setUnselectedItems(String[] items) {
        this.unselectedItems = items;
    }

    public String[] getUnselectedItems() {
        return this.unselectedItems;
    }

    public RoleInterface[] getRoles() {
        if (this._rolesList == null) {
            this._rolesList = new ArrayList();
        }
        return (RoleInterface[])this._rolesList.toArray();
    }

    public abstract List getRoleItems();

    public TreeModel getAvailableTreeModel(TransformInterface transform, String selectedRole) {
        String querytype;
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List allItems = this.getRoleItems();
        allItems = this.removeNotUsableItems(allItems);
        allItems = this.removeDuplicateItems(allItems);
        if (this.originalItemList == null) {
            this.setOriginalItemList(allItems);
        }
        if (selectedRole != null) {
            int count = rolesUsed.length;
            for (int i = 0; i < count; ++i) {
                if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole) && !rolesUsed[i].getRoleLabel().equalsIgnoreCase(selectedRole)) continue;
                availableItems = rolesUsed[i].getAvailableRoleItems();
                break;
            }
        } else {
            availableItems = rolesUsed[0].getAvailableRoleItems();
        }
        if ((querytype = this.getQueryType()) != null && querytype.equalsIgnoreCase("detail")) {
            availableItems = this.removeItemsNotSupportingDetail(availableItems);
        }
        return this.getAvailableTreeModel(allItems, availableItems, transform);
    }

    public List getAvailableEnabledNodeIds(String selectedRole) {
        RoleInterface[] rolesUsed = this.getRoles();
        List availableItems = null;
        List allRolesAvailableItems = new ArrayList();
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            availableItems = rolesUsed[i].getAvailableRoleItems();
            allRolesAvailableItems.addAll(availableItems);
        }
        allRolesAvailableItems = this.removeDuplicateItems(allRolesAvailableItems);
        String queryType = this.getQueryType();
        if (queryType.equalsIgnoreCase("detail")) {
            allRolesAvailableItems = this.removeItemsNotSupportingDetail(allRolesAvailableItems);
        }
        ArrayList<String> availableIds = new ArrayList<String>();
        for (int i = 0; i < allRolesAvailableItems.size(); ++i) {
            availableIds.add(this.getItemID(allRolesAvailableItems.get(i)));
        }
        return availableIds;
    }

    public List getAllAvailableNodeIds(boolean useOriginalIds) {
        List allItems = this.getRoleItems();
        allItems = this.removeNotUsableItems(allItems);
        ArrayList<String> allIds = new ArrayList<String>();
        ArrayList calcItemRefList = new ArrayList();
        String thisid = null;
        for (int i = 0; i < allItems.size(); ++i) {
            Object thisitem = allItems.get(i);
            thisid = this.getItemID(thisitem);
            if (useOriginalIds) {
                thisid = this.getIdFromDataItemRefList(thisid);
            }
            if (this.isItemAReference(thisitem) && this.isCalculatedItem(thisitem)) {
                calcItemRefList.add(thisitem);
            }
            allIds.add(thisid);
        }
        for (int j = 0; j < calcItemRefList.size(); ++j) {
            Object baseitem = this.getBaseItem(calcItemRefList.get(j));
            thisid = this.getItemID(baseitem);
            if (!allIds.contains(thisid)) continue;
            allIds.remove(thisid);
        }
        return allIds;
    }

    public List getAvailableItemInfoList(String selectedRole) {
        return null;
    }

    public List getSelectedItemInfoList(String selectedRole) {
        RoleInterface[] rolesUsed = this.getRoles();
        List selectedItems = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            if (!rolesUsed[i].getRoleName().equalsIgnoreCase(selectedRole)) continue;
            selectedItems = rolesUsed[i].getRoleItems();
            break;
        }
        ArrayList<DataItemTreeNodeInfo> selectedItemInfo = new ArrayList<DataItemTreeNodeInfo>();
        for (int i = 0; i < selectedItems.size(); ++i) {
            Object item = selectedItems.get(i);
            String label = this.getItemLabel(item);
            DataItemTreeNodeInfo iteminfo = new DataItemTreeNodeInfo(this.getItemID(item), label, label);
            iteminfo.setEnabled(true);
            iteminfo.setCategory(this.getItemCategory(item));
            iteminfo.setItemDescription(this.getItemDescription(item));
            iteminfo.setDefaultImage(this.getItemDefaultImage(item));
            iteminfo.setDisabledImage(this.getItemDisabledImage(item));
            selectedItemInfo.add(iteminfo);
        }
        return selectedItemInfo;
    }

    public TreeModel getSelectedTreeModel(TransformInterface transform, String selectedRole) {
        DataItemTreeNodeInfo rootinfo = new DataItemTreeNodeInfo("selected_rootnode", "selected_rootnode", "selected_rootnode");
        Object selectedRootNode = new DisabledNode((Object)rootinfo);
        if (transform != null) {
            try {
                selectedRootNode = (DefaultMutableTreeNode)transform.transform(selectedRootNode);
            }
            catch (TransformException e) {
                LoggerRepository2.getLogger((String)BaseDataItemSelectorModel.class.getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        RoleInterface[] availableRoles = this.getRoles();
        int numRoles = availableRoles.length;
        for (int i = 0; i < numRoles; ++i) {
            TreeNode rolenode = this.getSelectedTreeNode(availableRoles[i], transform, selectedRole);
            if (numRoles > 1) {
                ((DefaultMutableTreeNode)selectedRootNode).add((DefaultMutableTreeNode)rolenode);
                continue;
            }
            int numberOfChildren = rolenode.getChildCount();
            for (int j = 0; j < numberOfChildren; ++j) {
                ((DefaultMutableTreeNode)selectedRootNode).add((DefaultMutableTreeNode)rolenode.getChildAt(0));
            }
        }
        return new DefaultTreeModel((TreeNode)selectedRootNode);
    }

    public Map getDataItemMap() {
        return this._dataItemMap;
    }

    public void setDataItemMap(Map map) {
        this._dataItemMap = map;
    }

    public boolean hasValidRoles() {
        RoleInterface[] roles = this.getRoles();
        int count = roles.length;
        for (int i = 0; i < count; ++i) {
            List roleItems = roles[i].getRoleItems();
            int roleMinCount = roles[i].getMinRoleItemCount();
            int roleMaxCount = roles[i].getMaxRoleItemCount();
            if (!(roleItems.size() == 0 ? roleMinCount != 0 : roleItems.size() < roleMinCount || roleItems.size() > roleMaxCount && roleMaxCount != 0)) continue;
            return false;
        }
        return true;
    }

    public void cleanUp(String mode) {
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
        RoleInterface[] allRoles = this.getRoles();
        for (int i = 0; i < allRoles.length; ++i) {
            RoleInterface role = allRoles[i];
            ((Role)role).setRoleLabel(this.getRoleLabel(role.getRoleName()));
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public Object getItemFromItemMap(String itemid) {
        Object itemFromMap = null;
        Map itemmap = this.getDataItemMap();
        Collection valueSet = itemmap.values();
        for (Object item : valueSet) {
            Object baseItem = this.getBaseItem(item);
            if (baseItem.equals(item) || !itemid.equals(this.getItemID(baseItem))) continue;
            itemFromMap = item;
        }
        if (itemFromMap == null) {
            itemFromMap = itemmap.get(itemid);
        }
        return itemFromMap;
    }

    public String getBaseItemId(String itemid) {
        Object itemFromMap = null;
        Map itemmap = this.getDataItemMap();
        Collection valueSet = itemmap.values();
        for (Object item : valueSet) {
            if (!itemid.equals(this.getItemID(item))) continue;
            Object baseItem = this.getBaseItem(item);
            return this.getItemID(baseItem);
        }
        return null;
    }

    public boolean isThisItemAReferenceInItemMap(String itemid) {
        Map itemmap = this.getDataItemMap();
        Collection valueSet = itemmap.values();
        for (Object item : valueSet) {
            String id = this.getItemID(item);
            if (!id.equalsIgnoreCase(itemid) || !this.isItemAReference(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisItemInAvailableList(String itemid, RoleInterface role) {
        List availableItems = role.getAvailableRoleItems();
        Iterator iter = availableItems.iterator();
        while (iter.hasNext()) {
            if (!this.getItemID(iter.next()).equalsIgnoreCase(itemid)) continue;
            return true;
        }
        return false;
    }

    public boolean isThisItemInRoleRefList(String itemid, RoleInterface role) {
        List reflist = ((Role)role).getDataItemReferenceList();
        Iterator iter = reflist.iterator();
        while (iter.hasNext()) {
            if (!this.getItemID(iter.next()).equalsIgnoreCase(itemid)) continue;
            return true;
        }
        return false;
    }

    public boolean isCalculatedItemSelected() {
        RoleInterface[] rolesUsed = this.getRoles();
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            List selectedItems = rolesUsed[i].getRoleItems();
            int count2 = selectedItems.size();
            for (int j = 0; j < count2; ++j) {
                if (!this.isCalculatedItem(selectedItems.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean queryItemsSupportDetailUsage() {
        RoleInterface[] rolesUsed = this.getRoles();
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            List selectedItems = rolesUsed[i].getRoleItems();
            int count2 = selectedItems.size();
            for (int j = 0; j < count2; ++j) {
                if (this.isDetailUsageSupported(selectedItems.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allQueryItemsAreDetailUsage() {
        RoleInterface[] rolesUsed = this.getRoles();
        List selectedItems = null;
        boolean returnValue = true;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            selectedItems = rolesUsed[i].getRoleItems();
            if (selectedItems.size() == 0) {
                return false;
            }
            if (selectedItems.size() == 0) {
                returnValue = false;
            }
            int count2 = selectedItems.size();
            for (int j = 0; j < count2; ++j) {
                if (this.isItemUsageDetail(selectedItems.get(j))) continue;
                returnValue = false;
                break;
            }
            if (!returnValue) break;
        }
        return returnValue;
    }

    public void setSelectedItemsQueryType(String queryType) {
        RoleInterface[] rolesUsed = this.getRoles();
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            RoleInterface thisrole = rolesUsed[i];
            List selecteditems = thisrole.getRoleItems();
            int count2 = selecteditems.size();
            for (int j = 0; j < count2; ++j) {
                Object item = selecteditems.get(i);
                if (!this.isItemActionSupported(item, queryType)) continue;
                this.setItemUsage(item, queryType);
            }
        }
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public boolean isItemMoveUpValid() {
        String[] highlightedItems = this.getSelectedItems();
        if (highlightedItems.length == 0) {
            return false;
        }
        for (int i = 0; i < highlightedItems.length; ++i) {
            Object item = this.getItemFromItemMap(highlightedItems[i]);
            if (!this.isItemFirstInRole(item)) continue;
            return false;
        }
        return true;
    }

    public boolean isItemMoveDownValid() {
        String[] highlightedItems = this.getSelectedItems();
        if (highlightedItems.length == 0) {
            return false;
        }
        for (int i = 0; i < highlightedItems.length; ++i) {
            Object item = this.getItemFromItemMap(highlightedItems[i]);
            if (!this.isItemLastInRole(item)) continue;
            return false;
        }
        return true;
    }

    public String getStatusMessage() {
        if (!this.hasValidRoles()) {
            return RB.getStringResource(RB_KEY, "invalidRole.txt", this._locale);
        }
        return null;
    }

    public List getMoveTargetRoles() {
        return Arrays.asList(this.getRoles());
    }

    public List getDropTargetRoles() {
        return this.getMoveTargetRoles();
    }

    public Map process() {
        HashMap<String, String> eventInfo = new HashMap<String, String>(2);
        String selectorData = this.getData();
        eventInfo.put("action", this.getAction());
        eventInfo.put("data", selectorData);
        RoleInterface workingRole = null;
        Object deleteRole = null;
        RoleInterface[] availableRoles = this.getRoles();
        int numRoles = availableRoles.length;
        int i = 0;
        Map itemmap = this.getDataItemMap();
        String action = this.getAction();
        Vector itemVector = null;
        Object obj = null;
        if (action.equalsIgnoreCase(UPDATE_ITEMS) || action.equalsIgnoreCase(MOVE_ITEMS) || action.equalsIgnoreCase(MOVE_ITEM_TO_POSITION) || action.equalsIgnoreCase(MOVE_ITEM_UP) || action.equalsIgnoreCase(MOVE_ITEM_DOWN)) {
            StringArrayToVectorTransform itemTransform = new StringArrayToVectorTransform();
            String[] selectedItems = this.getSelectedItems();
            String[] unselectedItems = this.getUnselectedItems();
            if (selectedItems != null) {
                obj = itemTransform.transform((Object)selectedItems);
            } else if (unselectedItems != null) {
                obj = itemTransform.transform((Object)unselectedItems);
            }
            itemVector = (Vector)obj;
        }
        if (action.equalsIgnoreCase(UPDATE_ITEMS)) {
            workingRole = this.getRoleInterface(this.role);
            eventInfo.put("role", (String)workingRole);
            if (this.selectedItems != null) {
                List addItemsList = this.createAddItemsList(itemVector, itemmap);
                List badItems = workingRole.addRoleItems(addItemsList);
                if (badItems != null) {
                    System.out.println("badItems contains " + badItems.size() + " items");
                }
            } else {
                workingRole = this.getRoleInterface(selectorData);
                List deleteItemsList = this.createAddItemsList(itemVector, itemmap);
                int numItems = deleteItemsList.size();
                for (i = 0; i < numItems; ++i) {
                    workingRole.removeRoleItem(deleteItemsList.get(i));
                }
            }
        } else if (action.equalsIgnoreCase(MOVE_ITEMS)) {
            RoleInterface targetRole = null;
            for (i = 0; i < numRoles; ++i) {
                if (!availableRoles[i].getRoleDetailedLabel().equalsIgnoreCase(selectorData)) continue;
                targetRole = availableRoles[i];
            }
            Object targetAvailable = null;
            if (this.selectedItems != null) {
                List itemsList = this.createAddItemsList(itemVector, itemmap);
                this.moveItemsToRole(itemsList, targetRole);
                if (this.getPositionToMoveTo() != null) {
                    int position = Integer.parseInt(this.getPositionToMoveTo());
                    this.moveItemsToPosition(itemsList, position);
                }
            }
        } else if (action.equalsIgnoreCase(MOVE_ITEM_UP) || action.equalsIgnoreCase(MOVE_ITEM_DOWN)) {
            List itemsList = this.createAddItemsList(itemVector, itemmap);
            if (action.equalsIgnoreCase(MOVE_ITEM_UP)) {
                this.moveItemsUpDown(itemsList, -1);
            } else if (action.equalsIgnoreCase(MOVE_ITEM_DOWN)) {
                this.moveItemsUpDown(itemsList, 1);
            }
        } else if (action.equalsIgnoreCase(MOVE_ITEM_TO_POSITION)) {
            if (this.selectedItems != null) {
                int position = Integer.parseInt(selectorData);
                List itemsList = this.createAddItemsList(itemVector, itemmap);
                this.moveItemsToPosition(itemsList, position);
            }
        } else if (action.equalsIgnoreCase(CHANGE_QUERY_TYPE)) {
            this.setSelectedItemsQueryType(this.data);
        }
        return eventInfo;
    }

    public Object getPropertiesBean() {
        return this;
    }

    public Map commit() {
        HashMap<String, Object> eventInfo;
        block6: {
            eventInfo = new HashMap<String, Object>(2);
            HashMap oldResultItemsMap = new HashMap();
            try {
                eventInfo.put("action", COMMIT);
                RoleInterface[] rolesUsed = this.getRoles();
                String qType = this.getQueryType();
                if (qType == null) {
                    qType = this.getQueryType();
                }
                this.deleteResultItemsFromQuery(rolesUsed, oldResultItemsMap);
                this.addResultItemsToQuery(rolesUsed, qType);
                if (!this.isQueryValid()) {
                    List reasonsNotValid = this.getReasonsQueryNotValid();
                    if (reasonsNotValid.size() > 0) {
                        eventInfo.put("data", this.getReason(reasonsNotValid.get(0)));
                    }
                    this.deleteResultItemsFromQuery(rolesUsed, null);
                    this.rollBackQuery(oldResultItemsMap);
                } else {
                    this.deleteSortCriteriaFromQuery();
                }
            }
            catch (Exception ex) {
                if (eventInfo.get("EXCEPTION_OCCURRED") != null) break block6;
                eventInfo.put("EXCEPTION_OCCURRED", ex);
            }
        }
        return eventInfo;
    }

    protected TreeModel getAvailableTreeModel(List allItems, List availableItems, TransformInterface transform) {
        return null;
    }

    protected TreeNode getSelectedTreeNode(RoleInterface role, TransformInterface transform, String selectedRole) {
        return null;
    }

    protected List removeNotUsableItems(List allDataItems) {
        return allDataItems;
    }

    protected List removeDuplicateItems(List allItems) {
        return allItems;
    }

    protected List removeItemsNotSupportingDetail(List items) {
        return items;
    }

    protected void setOriginalItemList(List allItems) {
        this.originalItemList = new ArrayList();
        Object thisid = null;
        for (int i = 0; i < allItems.size(); ++i) {
            this.originalItemList.add(this.getItemID(allItems.get(i)));
        }
    }

    protected String getItemID(Object item) {
        return null;
    }

    protected String getItemLabel(Object item) {
        return null;
    }

    protected String getItemDescription(Object item) {
        return null;
    }

    protected String getItemCategory(Object item) {
        return null;
    }

    protected String getItemDefaultImage(Object item) {
        return null;
    }

    protected String getItemDisabledImage(Object item) {
        return null;
    }

    protected boolean isCalculatedItem(Object item) {
        return false;
    }

    protected boolean isDetailUsageSupported(Object item) {
        return false;
    }

    protected boolean isItemUsageDetail(Object item) {
        return false;
    }

    protected boolean isItemActionSupported(Object item, String queryType) {
        return false;
    }

    protected void setItemUsage(Object item, String queryType) {
    }

    protected boolean isItemAReference(Object item) {
        return false;
    }

    protected String getIdFromDataItemRefList(String itemid) {
        RoleInterface[] rolesUsed = this.getRoles();
        List roleDataItemRefList = null;
        int count = rolesUsed.length;
        for (int i = 0; i < count; ++i) {
            roleDataItemRefList = ((Role)rolesUsed[i]).getDataItemReferenceList();
            Iterator iter = roleDataItemRefList.iterator();
            String refid = null;
            while (iter.hasNext()) {
                Object ref = iter.next();
                refid = this.getItemID(ref);
                if (!refid.equals(itemid)) continue;
                Object baseitem = this.getBaseItem(ref);
                return this.getItemID(baseitem);
            }
        }
        return itemid;
    }

    protected Object getBaseItem(Object item) {
        return item;
    }

    public void mapDataSource() {
        if (this._dataItemMap == null) {
            this._dataItemMap = new HashMap();
        } else {
            this._dataItemMap.clear();
        }
        List allItems = this.getRoleItems();
        for (Object item : allItems) {
            this._dataItemMap.put(this.getItemID(item), item);
            Object baseItem = this.getBaseItem(item);
            if (baseItem.equals(item)) continue;
            this._dataItemMap.put(this.getItemID(baseItem), baseItem);
        }
    }

    protected String getRoleLabel(String role) {
        return role;
    }

    protected String getRoleDetailedLabel(String role) {
        return role;
    }

    protected List getAvailableRoleItems(RoleInterface role) {
        List allAvailableRoleItems = this.getRoleItems();
        List currentRoleItems = role.getRoleItems();
        if (role.getMaxRoleItemCount() != 0 && currentRoleItems.size() == role.getMaxRoleItemCount()) {
            allAvailableRoleItems.clear();
            return allAvailableRoleItems;
        }
        RoleInterface[] roles = this.getRoles();
        if (roles.length > 1) {
            int count = roles.length;
            for (int i = 0; i < count; ++i) {
                List roleItems = roles[i].getRoleItems();
                int count2 = roleItems.size();
                for (int j = 0; j < count2; ++j) {
                    if (!allAvailableRoleItems.contains(roleItems.get(j))) continue;
                    allAvailableRoleItems.remove(roleItems.get(j));
                }
            }
        }
        return allAvailableRoleItems;
    }

    protected void addItemToRole(Object item, RoleInterface role, List roleList, Map itemMap) {
        roleList.add(item);
        itemMap.put(this.getItemID(item), item);
    }

    protected void removeItemFromRole(Object item, List roleList, List refList) {
        roleList.remove(item);
    }

    public String getReason(Object reason) {
        return null;
    }

    protected RoleInterface findRoleForItem(Object thisitem) {
        RoleInterface[] availableRoles = this.getRoles();
        int numRoles = availableRoles.length;
        int i = 0;
        for (i = 0; i < numRoles; ++i) {
            RoleInterface thisrole = availableRoles[i];
            List selectedItems = thisrole.getRoleItems();
            if (!selectedItems.contains(thisitem)) continue;
            return thisrole;
        }
        return null;
    }

    private RoleInterface getRoleInterface(String roleString) {
        RoleInterface[] availableRoles = this.getRoles();
        int numRoles = availableRoles.length;
        for (int i = 0; i < numRoles; ++i) {
            if (!availableRoles[i].getRoleName().equalsIgnoreCase(roleString)) continue;
            return availableRoles[i];
        }
        return null;
    }

    protected void addResultItemsToQuery(RoleInterface[] rolesUsed, String queryType) throws Exception {
    }

    public void deleteResultItemsFromQuery(RoleInterface[] rolesUsed, Map oldResultItemsMap) {
    }

    protected boolean isQueryActionSupported() {
        return false;
    }

    protected boolean isMeasure(Object object) {
        return false;
    }

    protected Object getItemFromReference(Object object) {
        return null;
    }

    protected List createAddItemsList(Vector itemVector, Map itemmap) {
        return null;
    }

    public boolean isQueryValid() {
        return true;
    }

    public List getReasonsQueryNotValid() {
        return null;
    }

    public void rollBackQuery(Map itemMap) {
    }

    public void deleteSortCriteriaFromQuery() {
    }

    protected int getItemPositionInRole(Object item) {
        RoleInterface role = this.findRoleForItem(item);
        if (role == null) {
            return -1;
        }
        List roleItems = role.getRoleItems();
        if (roleItems == null) {
            return -1;
        }
        for (int i = 0; i < roleItems.size(); ++i) {
            if (!item.equals(roleItems.get(i))) continue;
            return i;
        }
        return -1;
    }

    protected Object getItemInRolePosition(RoleInterface role, int pos) {
        List roleItems = role.getRoleItems();
        if (roleItems == null) {
            return null;
        }
        if (pos >= roleItems.size()) {
            return null;
        }
        return roleItems.get(pos);
    }

    protected boolean isItemFirstInRole(Object item) {
        return this.getItemPositionInRole(item) == 0;
    }

    protected boolean isItemLastInRole(Object item) {
        RoleInterface role = this.findRoleForItem(item);
        if (role == null) {
            return false;
        }
        List roleItems = role.getRoleItems();
        if (roleItems == null) {
            return false;
        }
        return this.getItemPositionInRole(item) == roleItems.size() - 1;
    }

    protected void moveItemsToRole(List items, RoleInterface targetRole) {
        int numItems = items.size();
        for (int i = 0; i < numItems; ++i) {
            Object thisitem = items.get(i);
            RoleInterface currentRole = this.findRoleForItem(thisitem);
            currentRole.removeRoleItem(thisitem);
            targetRole.addRoleItem(thisitem);
        }
    }

    protected int adjustMoveToPosition(List items, int positionIndex) {
        int adjustedPosition = 0;
        RoleInterface currentRole = items.get(0) == null ? null : this.findRoleForItem(items.get(0));
        List roleItems = currentRole.getRoleItems();
        for (Object dataItem : roleItems) {
            if (this.getItemPositionInRole(dataItem) == positionIndex) {
                return adjustedPosition;
            }
            if (items.contains(dataItem)) continue;
            ++adjustedPosition;
        }
        return adjustedPosition;
    }

    protected void moveItemsToPosition(List items, int positionIndex) {
        List sortedItems = this.sortItemListByRolePosition(items);
        RoleInterface currentRole = sortedItems.get(0) == null ? null : this.findRoleForItem(sortedItems.get(0));
        int adjustedMoveToPosition = this.adjustMoveToPosition(sortedItems, positionIndex);
        List tempRoleItems = currentRole.getRoleItems();
        Iterator iter = sortedItems.iterator();
        while (iter.hasNext()) {
            tempRoleItems.remove(iter.next());
        }
        tempRoleItems.addAll(adjustedMoveToPosition, items);
        currentRole.removeAllRoleItems();
        currentRole.addRoleItems(tempRoleItems);
    }

    protected void moveItemsUpDown(List items, int offset) {
        List sortedItems = this.sortItemListByRolePosition(items);
        int numItems = sortedItems.size();
        if (offset < 0) {
            for (int i = 0; i < numItems; ++i) {
                Object thisitem = sortedItems.get(i);
                RoleInterface currentRole = this.findRoleForItem(thisitem);
                currentRole.moveRoleItem(thisitem, offset);
            }
        } else {
            for (int i = numItems - 1; i >= 0; --i) {
                Object thisitem = sortedItems.get(i);
                RoleInterface currentRole = this.findRoleForItem(thisitem);
                currentRole.moveRoleItem(thisitem, offset);
            }
        }
    }

    protected List sortItemListByRolePosition(List items) {
        int numItems = items.size();
        HashMap map = new HashMap();
        for (int i = 0; i < numItems; ++i) {
            Object item = items.get(i);
            int pos = this.getItemPositionInRole(item);
            map.put(item, new Integer(pos));
        }
        ArrayList sortedItems = new ArrayList();
        int numSortedItems = 0;
        for (int i = 0; i < numItems; ++i) {
            Object item = items.get(i);
            Integer itemPosInt = (Integer)map.get(item);
            int itemPos = itemPosInt;
            if (numSortedItems == 0) {
                sortedItems.add(item);
                ++numSortedItems;
                continue;
            }
            for (int j = 0; j < numSortedItems; ++j) {
                Object sortedItem = sortedItems.get(j);
                Integer sortedItemPos = (Integer)map.get(sortedItem);
                if (itemPos > sortedItemPos) continue;
                sortedItems.add(j, item);
                ++numSortedItems;
                break;
            }
            if (numSortedItems != i) continue;
            sortedItems.add(item);
            ++numSortedItems;
        }
        return sortedItems;
    }

    protected class Role
    implements RoleInterface {
        private String _name;
        private String _label;
        private String _detailedLabel;
        private String _description;
        private int _minCount;
        private int _maxCount;
        private ArrayList _roleItems;
        private List dataItemRefList;
        private String iconOpened;
        private String iconClosed;
        private String iconDisabled;

        public Role(String name, String label, String description, int minCount, int maxCount) throws IllegalArgumentException {
            if (name == null) {
                throw new IllegalArgumentException(RB.getStringResource(BaseDataItemSelectorModel.RB_KEY, "nullRoleName.txt", BaseDataItemSelectorModel.this._locale));
            }
            this._name = name;
            if (label == null) {
                throw new IllegalArgumentException(RB.getStringResource(BaseDataItemSelectorModel.RB_KEY, "nullRoleLabel.txt", BaseDataItemSelectorModel.this._locale));
            }
            this._label = label;
            this._description = description == null ? this._label : description;
            if (minCount < 0) {
                throw new IllegalArgumentException(RB.getStringResource(BaseDataItemSelectorModel.RB_KEY, "negativeMinimumCount.txt", BaseDataItemSelectorModel.this._locale));
            }
            this._minCount = minCount;
            if (maxCount < 0) {
                throw new IllegalArgumentException(RB.getStringResource(BaseDataItemSelectorModel.RB_KEY, "negativeMaximumCount.txt", BaseDataItemSelectorModel.this._locale));
            }
            this._maxCount = maxCount;
            this._roleItems = new ArrayList();
            this.dataItemRefList = new ArrayList();
            this.iconOpened = null;
            this.iconClosed = null;
            this.iconDisabled = null;
        }

        public List getDataItemReferenceList() {
            return this.dataItemRefList;
        }

        public String getRoleName() {
            return this._name;
        }

        public String getRoleLabel() {
            return this._label;
        }

        public void setRoleLabel(String label) {
            this._label = label;
        }

        public String getRoleDetailedLabel() {
            return this._detailedLabel;
        }

        public void setRoleDetailedLabel(String detailedLabel) {
            this._detailedLabel = detailedLabel;
        }

        public String getRoleDescription() {
            return this._description;
        }

        public int getMinRoleItemCount() {
            return this._minCount;
        }

        public int getMaxRoleItemCount() {
            return this._maxCount;
        }

        public String getRoleOpenedIcon() {
            return this.iconOpened;
        }

        public void setRoleOpenedIcon(String iconOpened) {
            this.iconOpened = iconOpened;
        }

        public String getRoleClosedIcon() {
            return this.iconClosed;
        }

        public void setRoleClosedIcon(String iconClosed) {
            this.iconClosed = iconClosed;
        }

        public String getRoleDisabledIcon() {
            return this.iconDisabled;
        }

        public void setRoleDisabledIcon(String iconDisabled) {
            this.iconDisabled = iconDisabled;
        }

        public List getAvailableRoleItems() {
            return BaseDataItemSelectorModel.this.getAvailableRoleItems(this);
        }

        public List getRoleItems() {
            ArrayList items = new ArrayList();
            int count = this._roleItems.size();
            for (int i = 0; i < count; ++i) {
                items.add(this._roleItems.get(i));
            }
            return items;
        }

        public void moveRoleItem(Object item, int offset) {
            int moveindex;
            int currentItemIndex = this._roleItems.indexOf(item);
            if (currentItemIndex >= 0 && offset != 0 && (moveindex = currentItemIndex + offset) >= 0 && moveindex <= this._roleItems.size()) {
                int absoluteOffset = Math.abs(offset);
                int direction = offset < 0 ? -1 : 1;
                for (int shifter = 1; shifter <= absoluteOffset; ++shifter) {
                    Collections.swap(this._roleItems, this._roleItems.indexOf(item), this._roleItems.indexOf(item) + direction);
                }
            }
        }

        public void addRoleItem(Object item) {
            this.addRoleItem(item, null);
        }

        public void addRoleItem(Object item, List availableRoleItems) {
            if (availableRoleItems == null) {
                availableRoleItems = BaseDataItemSelectorModel.this.getAvailableRoleItems(this);
            }
            if (!availableRoleItems.contains(item)) {
                throw new IllegalArgumentException(RB.getStringResource(BaseDataItemSelectorModel.RB_KEY, "itemNotAvailable.txt", BaseDataItemSelectorModel.this._locale));
            }
            BaseDataItemSelectorModel.this.addItemToRole(item, this, this._roleItems, BaseDataItemSelectorModel.this._dataItemMap);
        }

        public List addRoleItems(List items) {
            List availableRoleItems = BaseDataItemSelectorModel.this.getAvailableRoleItems(this);
            ArrayList itemsNotAdded = new ArrayList();
            int count = items.size();
            for (int i = 0; i < count; ++i) {
                try {
                    this.addRoleItem(items.get(i), availableRoleItems);
                    continue;
                }
                catch (Exception e) {
                    itemsNotAdded.add(items.get(i));
                }
            }
            if (itemsNotAdded.size() == 0) {
                return null;
            }
            return itemsNotAdded;
        }

        public void removeRoleItem(Object item) {
            BaseDataItemSelectorModel.this.removeItemFromRole(item, this._roleItems, this.getDataItemReferenceList());
            BaseDataItemSelectorModel.this.mapDataSource();
        }

        public void removeAllRoleItems() {
            this._roleItems.clear();
        }

        public String toString() {
            return " name= " + this.getRoleName() + " label= " + this.getRoleLabel() + " description= " + this.getRoleDescription() + " minRoleItemCount= " + this.getMinRoleItemCount() + " maxRoleItemCount= " + this.getMaxRoleItemCount() + " has " + this.getRoleItems().size() + " role items";
        }
    }
}

