/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculations.percent;

import com.sas.dataselectors.calculations.percent.FractionalItemInfo;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorDataSourceInterface;
import com.sas.dataselectors.calculations.percent.RB;
import com.sas.iquery.dataservices.DataRetrievalUtil;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.RootDataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PercentCalculationsSelectorDataSource
implements PercentCalculationsSelectorDataSourceInterface {
    private String RB_KEY = "PercentCalculationsSelectorDataSource.";
    private boolean dirty = true;
    private List currentState;
    private Locale locale;
    protected BusinessQueryProviderInterface model;

    public PercentCalculationsSelectorDataSource() {
        this(null);
    }

    public PercentCalculationsSelectorDataSource(BusinessQueryProviderInterface model) {
        this.setModel(model);
    }

    protected void setModel(BusinessQueryProviderInterface model) {
        this.model = model;
    }

    protected BusinessQueryProviderInterface getModel() {
        return this.model;
    }

    public boolean isOLAP() {
        return false;
    }

    public Map getNumerators() {
        LinkedHashMap<String, String> numerators = new LinkedHashMap<String, String>();
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        if (model.getBusinessQuery() instanceof DataSelection) {
            DataSelection ds = (DataSelection)model.getBusinessQuery();
            for (DataItem dataItem : ds.getResultItems()) {
                if (!PercentCalculationsSelectorDataSource.isValidNumerator(dataItem, ds)) continue;
                numerators.put(dataItem.getIntraModelID(), dataItem.getLabel());
            }
        }
        return numerators;
    }

    public static boolean isValidNumerator(DataItem dataItem, DataSelection dataSelection) {
        boolean summarizableItem = DataRetrievalUtil.isItemToSummarize((DataItem)dataItem);
        return summarizableItem && !(dataItem.getExpression() instanceof FractionOfTotalExpression);
    }

    public Map getDenominators() {
        LinkedHashMap<Integer, String> denominators = new LinkedHashMap<Integer, String>();
        denominators.put(new Integer(1), RB.getStringResource((String)this.RB_KEY, (String)"columnTotal.txt", (Locale)this.getLocale()));
        return denominators;
    }

    public List getFractionalItems() {
        if (!this.dirty) {
            return this.currentState;
        }
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        this.currentState = new ArrayList();
        for (DataItem dataItem : model.getBusinessQuery().getBusinessModel().getObjects(true, DataItem.class)) {
            if (!(dataItem.getExpression() instanceof FractionOfTotalExpression)) continue;
            this.currentState.add(this.createFractionalItemInfo(dataItem));
        }
        this.dirty = false;
        return this.currentState;
    }

    protected FractionalItemInfo createFractionalItemInfo(DataItem dataItem) {
        if (dataItem == null) {
            return null;
        }
        FractionalItemInfo itemInfo = new FractionalItemInfo();
        itemInfo.setId(dataItem.getIntraModelID());
        itemInfo.setLabel(dataItem.getLabel());
        FractionOfTotalExpression expression = (FractionOfTotalExpression)dataItem.getExpression();
        itemInfo.setNumeratorId(expression.getNumerator().getIntraModelID());
        itemInfo.setNumeratorLabel(expression.getNumerator().getLabel());
        DataItem denominator = expression.getDenominator();
        if (denominator != null) {
            itemInfo.setDenominatorId(denominator.getIntraModelID());
            itemInfo.setDenominatorLabel(denominator.getLabel());
            itemInfo.setDenominatorType(0);
        } else {
            int denominatorType = expression.getDenominatorType();
            itemInfo.setDenominatorType(denominatorType);
            itemInfo.setDenominatorLabel(RB.getStringResource((String)this.RB_KEY, (String)this.getResourceKeyForDenominatorType(denominatorType), (Locale)this.getLocale()));
        }
        return itemInfo;
    }

    protected String getResourceKeyForDenominatorType(int denominatorType) {
        return "columnTotal.txt";
    }

    public void removeItem(FractionalItemInfo itemInfo) {
        this.dirty = true;
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        BusinessQuery businessQuery = model.getBusinessQuery();
        if (!(businessQuery instanceof DataSelection)) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"invalidModel.txt", (Locale)this.getLocale()));
        }
        DataSelection ds = (DataSelection)businessQuery;
        try {
            List businessItems = model.getBusinessQuery().getBusinessModel().getObjects(true, DataItem.class);
            DataItem dataItem = PercentCalculationsSelectorDataSource.getDataItem(businessItems, itemInfo.getId());
            ds.removeResultItem(dataItem);
            ds.removeBusinessItem((BusinessItem)dataItem);
        }
        catch (MetadataException me) {
            throw new RuntimeException(me);
        }
    }

    public void addItem(FractionalItemInfo itemInfo) {
        this.dirty = true;
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        try {
            List businessItems = model.getBusinessQuery().getBusinessModel().getObjects(true, DataItem.class);
            DataItem numerator = PercentCalculationsSelectorDataSource.getDataItem(businessItems, itemInfo.getNumeratorId());
            this.addFractionOfTotalItem(numerator, null, itemInfo.getDenominatorType(), itemInfo.getLabel());
        }
        catch (MetadataException me) {
            throw new RuntimeException(me);
        }
    }

    public void updateItem(FractionalItemInfo existingItemInfo, FractionalItemInfo newItemInfo) {
        this.dirty = true;
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        try {
            List businessItems = model.getBusinessQuery().getBusinessModel().getObjects(true, DataItem.class);
            DataItem dataItem = PercentCalculationsSelectorDataSource.getDataItem(businessItems, existingItemInfo.getId());
            dataItem.setLabel(newItemInfo.getLabel());
        }
        catch (MetadataException me) {
            throw new RuntimeException(me);
        }
    }

    public void removeAllItems() {
        this.dirty = true;
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        BusinessQuery businessQuery = model.getBusinessQuery();
        if (!(businessQuery instanceof DataSelection)) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"invalidModel.txt", (Locale)this.getLocale()));
        }
        DataSelection ds = (DataSelection)businessQuery;
        for (DataItem dataItem : model.getBusinessQuery().getBusinessModel().getObjects(true, DataItem.class)) {
            if (!(dataItem.getExpression() instanceof FractionOfTotalExpression)) continue;
            try {
                ds.removeResultItem(dataItem);
                ds.removeBusinessItem((BusinessItem)dataItem);
            }
            catch (MetadataException me) {
                throw new RuntimeException(me);
            }
        }
    }

    public void commit() {
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        BusinessQuery businessQuery = model.getBusinessQuery();
        try {
            model.refreshBusinessQuery(businessQuery);
        }
        catch (IntelligentQueryException iqe) {
            throw new RuntimeException(iqe);
        }
    }

    private DataItem addFractionOfTotalItem(DataItem numeratorMeasure, DataItem denominatorCategory, int denominatorType, String label) throws MetadataException {
        BusinessQueryProviderInterface model = this.getModel();
        if (model == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullModel.txt", (Locale)this.getLocale()));
        }
        BusinessQuery businessQuery = model.getBusinessQuery();
        if (!(businessQuery instanceof DataSelection)) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"invalidModel.txt", (Locale)this.getLocale()));
        }
        DataSelection ds = (DataSelection)businessQuery;
        if (this.isOLAP()) {
            this.updateTotalTypes(ds, denominatorType);
        }
        RootDataItem comparisonItem = ds.newDataItem();
        ds.addBusinessItem((BusinessItem)comparisonItem);
        ds.addResultItem((DataItem)comparisonItem, businessQuery.getResultItemRole(numeratorMeasure));
        FractionOfTotalExpression fractionExpression = new FractionOfTotalExpression();
        fractionExpression.setNumerator(numeratorMeasure);
        fractionExpression.setDenominatorType(denominatorType);
        comparisonItem.setExpression((ExpressionInterface)fractionExpression);
        comparisonItem.setFormat("PERCENT10.2");
        comparisonItem.setUsage(DataItemActionType.USAGE_AGGREGATE);
        comparisonItem.setLabel(label);
        return comparisonItem;
    }

    private void updateTotalTypes(DataSelection ds, int denominatorType) {
        try {
            if (denominatorType == 3 || denominatorType == 2) {
                Role role = denominatorType == 3 ? Role.ROW : Role.COLUMN;
                String totalType = ds.getTotalType(role);
                if (totalType == BusinessQuery.TOTAL_NONE) {
                    ds.setTotalType(BusinessQuery.AXISTOTAL, role);
                } else if (totalType == BusinessQuery.SUBTOTAL) {
                    ds.setTotalType(BusinessQuery.ALLTOTAL, role);
                }
            } else if (denominatorType == 5 || denominatorType == 4) {
                Role role = denominatorType == 5 ? Role.ROW : Role.COLUMN;
                String totalType = ds.getTotalType(role);
                if (totalType == BusinessQuery.TOTAL_NONE) {
                    ds.setTotalType(BusinessQuery.SUBTOTAL, role);
                } else if (totalType == BusinessQuery.AXISTOTAL) {
                    ds.setTotalType(BusinessQuery.ALLTOTAL, role);
                }
            } else if (denominatorType == 1) {
                String totalType = ds.getTotalType(Role.COLUMN);
                if (totalType == BusinessQuery.TOTAL_NONE) {
                    ds.setTotalType(BusinessQuery.AXISTOTAL, Role.COLUMN);
                } else if (totalType == BusinessQuery.SUBTOTAL) {
                    ds.setTotalType(BusinessQuery.ALLTOTAL, Role.COLUMN);
                }
                totalType = ds.getTotalType(Role.ROW);
                if (totalType == BusinessQuery.TOTAL_NONE) {
                    ds.setTotalType(BusinessQuery.AXISTOTAL, Role.ROW);
                } else if (totalType == BusinessQuery.SUBTOTAL) {
                    ds.setTotalType(BusinessQuery.ALLTOTAL, Role.ROW);
                }
            }
        }
        catch (MetadataException mde) {
            throw new RuntimeException(mde);
        }
    }

    private static DataItem getDataItem(List resultItems, String id) {
        if (resultItems == null || id == null) {
            return null;
        }
        for (DataItem dataItem : resultItems) {
            if (!id.equals(dataItem.getIntraModelID())) continue;
            return dataItem;
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

