/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculations.percent;

import com.sas.dataselectors.calculations.percent.FractionalItemInfo;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorDataSourceInterface;
import com.sas.dataselectors.calculations.percent.PercentCalculationsSelectorInterface;
import com.sas.dataselectors.calculations.percent.RB;
import com.sas.util.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class BasePercentCalculationsSelectorAdapter
implements PercentCalculationsSelectorInterface {
    private String RB_KEY = "BasePercentCalculationsSelectorAdapter.";
    private Locale locale;
    private Map eventInfo = new HashMap();
    protected PercentCalculationsSelectorDataSourceInterface dataSource;
    protected List fractionalItems;

    public BasePercentCalculationsSelectorAdapter() {
        this(null);
    }

    public BasePercentCalculationsSelectorAdapter(PercentCalculationsSelectorDataSourceInterface dataSource) {
        this.setDataSource(dataSource);
    }

    protected void setDataSource(PercentCalculationsSelectorDataSourceInterface dataSource) {
        this.dataSource = dataSource;
    }

    protected PercentCalculationsSelectorDataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public Map getNumerators() {
        PercentCalculationsSelectorDataSourceInterface dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
        }
        return dataSource.getNumerators();
    }

    public Map getDenominators() {
        PercentCalculationsSelectorDataSourceInterface dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
        }
        return dataSource.getDenominators();
    }

    public boolean isOLAP() {
        return false;
    }

    public List getFractionalItems() {
        PercentCalculationsSelectorDataSourceInterface dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
        }
        return dataSource.getFractionalItems();
    }

    public void setFractionalItems(List items) {
        this.fractionalItems = this.transformIfNecessary(items);
    }

    private List transformIfNecessary(List newItems) {
        if (newItems == null) {
            return null;
        }
        if (newItems.size() == 0 || newItems.get(0) instanceof FractionalItemInfo) {
            return newItems;
        }
        return this.parseItems(newItems);
    }

    public Map commit() {
        block5: {
            this.eventInfo.clear();
            PercentCalculationsSelectorDataSourceInterface dataSource = this.getDataSource();
            if (dataSource == null) {
                throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"nullDataSource.txt", (Locale)this.getLocale()));
            }
            try {
                if (this.fractionalItems == null) {
                    dataSource.removeAllItems();
                } else {
                    this.removeExistingItemsIfNotInNewState(this.fractionalItems);
                    this.addOrUpdateItems(this.fractionalItems);
                }
                dataSource.commit();
            }
            catch (RuntimeException rte) {
                if (this.eventInfo.containsKey("EXCEPTION_OCCURRED")) break block5;
                this.eventInfo.put("EXCEPTION_OCCURRED", rte);
            }
        }
        return this.eventInfo;
    }

    private void addOrUpdateItems(List newItemsInfo) {
        int size = newItemsInfo.size();
        for (int i = 0; i < size; ++i) {
            FractionalItemInfo newItemInfo = (FractionalItemInfo)newItemsInfo.get(i);
            boolean update = false;
            List existingFractionalItems = this.dataSource.getFractionalItems();
            int num = existingFractionalItems.size();
            for (int j = 0; j < num; ++j) {
                FractionalItemInfo existingItemInfo = (FractionalItemInfo)existingFractionalItems.get(j);
                if (!newItemInfo.equals(existingItemInfo)) continue;
                this.getDataSource().updateItem(existingItemInfo, newItemInfo);
                update = true;
            }
            if (update) continue;
            this.getDataSource().addItem(newItemInfo);
        }
    }

    private void removeExistingItemsIfNotInNewState(List newItemsInfo) {
        PercentCalculationsSelectorDataSourceInterface dataSource = this.getDataSource();
        List currentItems = dataSource.getFractionalItems();
        if (currentItems == null) {
            return;
        }
        int size = currentItems.size();
        for (int i = 0; i < size; ++i) {
            FractionalItemInfo currentItemInfo = (FractionalItemInfo)currentItems.get(i);
            if (this.isItemInNewState(currentItemInfo, newItemsInfo)) continue;
            this.getDataSource().removeItem(currentItemInfo);
        }
    }

    private boolean isItemInNewState(FractionalItemInfo itemInfo, List newItemsInfo) {
        if (itemInfo == null || newItemsInfo == null) {
            return false;
        }
        int size = newItemsInfo.size();
        for (int i = 0; i < size; ++i) {
            FractionalItemInfo newItemInfo = (FractionalItemInfo)newItemsInfo.get(i);
            if (!itemInfo.equals(newItemInfo)) continue;
            return true;
        }
        return false;
    }

    private List parseItems(List items) {
        ArrayList<FractionalItemInfo> itemsInfo = new ArrayList<FractionalItemInfo>();
        if (items == null) {
            return itemsInfo;
        }
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            String item = (String)items.get(i);
            if (item == null || item.equals("")) {
                return null;
            }
            itemsInfo.add(this.parseItem((String)items.get(i)));
        }
        return itemsInfo;
    }

    private FractionalItemInfo parseItem(String item) {
        String[] tokens = Strings.split((String)item, (String)"<<", (String)">><<", (String)">>");
        FractionalItemInfo itemInfo = new FractionalItemInfo();
        itemInfo.setNumeratorId(tokens[0]);
        if (tokens[1] != null && tokens[1].length() != 0 && !tokens[1].equals("null")) {
            itemInfo.setDenominatorId(tokens[1]);
        }
        itemInfo.setLabel(tokens[2]);
        if (tokens[3] != null && tokens[3].length() != 0 && !tokens[3].equals("null")) {
            itemInfo.setDenominatorType(Integer.parseInt(tokens[3]));
        }
        return itemInfo;
    }

    public Object getPropertiesBean() {
        return null;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.getDataSource() != null) {
            this.getDataSource().setLocale(locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }
}

