/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.expressions.visuals.DefaultFunctionTree;
import com.sas.expressions.visuals.FunctionFormat;
import com.sas.expressions.visuals.FunctionFormatInterface;
import com.sas.expressions.visuals.FunctionNode;
import com.sas.iquery.metadata.serverprop.Category;
import com.sas.iquery.metadata.serverprop.Function;
import com.sas.iquery.metadata.serverprop.FunctionSignature;
import com.sas.iquery.metadata.serverprop.Parameter;
import com.sas.iquery.metadata.serverprop.ParameterType;
import com.sas.iquery.metadata.serverprop.ServerProperties;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class ServerPropertiesFunctionTree
extends DefaultFunctionTree {
    ServerProperties _serverProperties = null;

    public ServerPropertiesFunctionTree(ServerProperties serverProperties) {
        this._serverProperties = serverProperties;
        this.buildTree();
    }

    private void buildTree() {
        FunctionNode root = new FunctionNode("root", "All functions", "All functions", "All functions");
        this.setRoot((TreeNode)root);
        if (this._serverProperties != null) {
            List categoryList = this._serverProperties.getCategories();
            Category category2 = null;
            FunctionNode categoryNode = null;
            for (Category category2 : categoryList) {
                categoryNode = new FunctionNode(category2.getLabel(), category2.getLabel(), category2.getDescription(), category2.getDescription());
                root.add((MutableTreeNode)categoryNode);
                List functionList = this._serverProperties.getFunctions(category2);
                Function function2 = null;
                FunctionFormat functionFormat = null;
                for (Function function2 : functionList) {
                    List signatures = function2.getSignatures();
                    FunctionSignature signature2 = null;
                    for (FunctionSignature signature2 : signatures) {
                        List argTypes = signature2.getParameters();
                        functionFormat = new FunctionFormat(function2.getID(), function2.getLabel(), function2.getDescription(), function2.getToolTip(), signature2.getDefaultSyntaxTemplate(), argTypes);
                        categoryNode.addFunctionToCategory((FunctionFormatInterface)functionFormat);
                    }
                }
            }
        }
    }

    private void printCategoryNodes(FunctionNode root) {
        System.out.println("root: " + root);
        System.out.println("root.getChildCount():" + root.getChildCount());
        for (int i = 0; i < root.getChildCount(); ++i) {
            System.out.println("category: " + root.getChildAt(i));
        }
    }

    private void printFunction(Function function) {
        System.out.println("printFunction(), function: " + function);
        System.out.println("\t argumentCount: " + function.getArgumentCount());
        System.out.println("\t category: " + function.getCategory());
        System.out.println("\t ** categoryName: " + function.getCategory().getLabel());
        System.out.println("\t description: " + function.getDescription());
        System.out.println("\t displayName: " + function.getLabel());
        System.out.println("\t id: " + function.getID());
        System.out.println("\t id: " + function.getNameID());
        List signatures = function.getSignatures();
        FunctionSignature signature2 = null;
        for (FunctionSignature signature2 : signatures) {
            List argTypes = signature2.getParameters();
            ParameterType returnType = signature2.getReturnType();
            System.out.println("\t syntaxTemplate: " + signature2.getDefaultSyntaxTemplate());
            System.out.println("\t FS return type name: " + returnType.toString());
            System.out.println("\t FS return type desc: " + returnType.getDescription());
            for (Parameter p : argTypes) {
                ParameterType pt = p.getType();
                System.out.println("\t\t ParameterType name: " + pt.getLabel());
                System.out.println("\t\t ParameterType desc: " + pt.getDescription());
                System.out.println("\t\t Parameter isEnumerated: " + p.isEnumerated());
                System.out.println("\t\t Parameter getEnumerationList " + p.getEnumerationList());
                System.out.println("\t\t Parameter isVarying: " + p.isVarying());
                System.out.println("\t\t Parameter toString " + p.toString());
            }
        }
        System.out.println("\t syntaxToken: " + function.getSyntaxToken());
        System.out.println("\t toolTip: " + function.getToolTip());
    }

    private class ServerFunctionFormat
    extends FunctionFormat {
        public ServerFunctionFormat(String name, String displayName, String description, String toolTip, String fmtString, List args) {
            super(name, displayName, description, toolTip, fmtString, args);
        }

        protected String getArgDisplayName(Object obj) {
            String text = "";
            if (obj instanceof ParameterType) {
                ParameterType parameterType = (ParameterType)obj;
                text = parameterType.getLabel();
            } else {
                text = super.getArgDisplayName(obj);
            }
            return text;
        }
    }
}

