/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.NodeInfo;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;

public class MemberNodeInfo
extends NodeInfo {
    MemberInterface member;
    int count;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)MemberNodeInfo.class.getName(), null);

    public MemberNodeInfo(MemberInterface member) {
        this.member = member;
        this.count = -1;
        try {
            this.text = member.getLabel();
            this.uniqueName = member.getUniqueName();
        }
        catch (OLAPException oe) {
            this.log.error(oe.getMessage(), (Throwable)oe);
        }
    }

    @Override
    public synchronized boolean populateChildren() {
        try {
            if (this.getChildCount() > 0) {
                MemberInterface[] members = this.member.getChildren();
                for (int j = 0; j < members.length; ++j) {
                    super.insert(new MemberNodeInfo(members[j]), j);
                }
            }
            return true;
        }
        catch (Exception oe) {
            this.log.error(oe.getMessage(), (Throwable)oe);
            return false;
        }
    }

    @Override
    public int getChildCount() {
        try {
            if (this.count == -1) {
                this.count = this.member.getChildCount();
            }
        }
        catch (OLAPException oe) {
            this.count = 0;
            this.log.error(oe.getMessage(), (Throwable)oe);
        }
        return this.count;
    }
}

