/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.MemberNodeInfo;
import com.sas.dataselectors.calculateditems.NodeInfo;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;

public class LevelNodeInfo
extends NodeInfo {
    LevelInterface level;
    int count;
    private CommonLoggerInterface log = LoggerRepository2.getLogger((String)LevelNodeInfo.class.getName(), null);

    public LevelNodeInfo(LevelInterface level) {
        this.level = level;
        this.count = -1;
        try {
            this.text = level.getLabel();
            this.uniqueName = level.getUniqueName();
        }
        catch (OLAPException oe) {
            this.log.error(oe.getMessage(), (Throwable)oe);
        }
    }

    @Override
    public synchronized boolean populateChildren() {
        try {
            if (this.getChildCount() > 0) {
                MemberInterface[] members = this.level.getMembers();
                this.count = members.length;
                for (int j = 0; j < members.length; ++j) {
                    MemberNodeInfo m = new MemberNodeInfo(members[j]);
                    super.insert(m, j);
                }
            }
            this.log.debug(this.children.toString());
            return true;
        }
        catch (Exception oe) {
            this.log.error(oe.getMessage(), (Throwable)oe);
            return false;
        }
    }

    @Override
    public int getChildCount() {
        try {
            if (this.count == -1) {
                this.count = this.level.getMemberCount();
            }
        }
        catch (OLAPException oe) {
            this.count = 0;
        }
        return this.count;
    }
}

