/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.CalculatedObjectFactoryInterface;
import com.sas.dataselectors.calculateditems.RB;
import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Lookup;
import com.sas.iquery.metadata.business.LookupNotAllowed;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class DataSourceTreeNode
implements DataSourceNodeInterface {
    public static final String RB_KEY = "DataSourceTreeNode.";
    protected String DISPLAY_NAME_EMPTY = RB.getStringResource((String)"DataSourceTreeNode.", (String)"DISPLAY_NAME_EMPTY.txt");
    protected CalculatedObjectFactoryInterface _factory = null;
    protected DataSourceTreeNode _parent = null;
    protected Object _orig = null;
    protected boolean _init = false;
    protected boolean _loaded = false;
    protected boolean _dviLoaded = false;
    protected boolean _readValues = false;
    protected String _name = null;
    protected String _displayName = null;
    protected String _description = null;
    protected String _toolTip = null;
    protected String _insertName = null;
    protected DistinctValuesInterface _distinctValuesInterface = null;
    protected List _values = null;
    protected boolean _canHaveChildren = true;
    protected List _children = new ArrayList();
    protected Map _distinctValuesMap = null;
    protected List _dataSourceList = null;
    protected boolean _isCube = false;
    protected String _imageNameExpanded = null;
    protected String _imageNameCollapsed = null;
    Map _iconMap = new HashMap();

    public DataSourceTreeNode(String name, String desc, CalculatedObjectFactoryInterface factory, boolean physicalData) {
        this._factory = factory;
        this._dataSourceList = physicalData ? this._factory.getDataSources(true) : this._factory.getDataItemsAndFolders(true);
        this._isCube = this._factory.getLevelHasMembers();
        this._parent = null;
        this._orig = this._dataSourceList;
        this.init();
        this._name = name;
        this._description = desc;
        this._displayName = this.getDisplayName(this._name);
        this._toolTip = desc;
        if (this._toolTip != null && this._toolTip.trim().length() == 0) {
            this._toolTip = null;
        }
        this._dviLoaded = true;
    }

    public DataSourceTreeNode(CalculatedObjectFactoryInterface factory, DataSourceTreeNode parent, Object value) {
        this._factory = factory;
        this._parent = parent;
        this._orig = value;
        this._dataSourceList = parent._dataSourceList;
    }

    public DataSourceTreeNode(CalculatedObjectFactoryInterface factory, DataSourceTreeNode parent, Object value, List children) {
        this._factory = factory;
        this._parent = parent;
        this._orig = value;
        this._dataSourceList = children;
    }

    public DataSourceTreeNode(String name, String desc, List children) {
        this._orig = children;
        this._parent = null;
        this._dataSourceList = null;
        this._init = true;
        this._name = name;
        this._description = desc;
        this._displayName = this.getDisplayName(this._name);
        this._toolTip = desc;
        if (this._toolTip != null && this._toolTip.trim().length() == 0) {
            this._toolTip = null;
        }
        this._canHaveChildren = children != null;
        this._loaded = true;
        this._children = children;
        this._dviLoaded = true;
    }

    public Object getOriginalObject() {
        return this._orig;
    }

    void init() {
        if (this._init) {
            return;
        }
        this._init = true;
        this._children = new Vector();
        Object orig = this.getOriginalObject();
        Object item = orig instanceof DataSourceTreeNode ? ((DataSourceTreeNode)orig).getOriginalObject() : orig;
        String text = this._factory.getBusinessObjectDisplayName(item);
        if (text == null) {
            text = orig.toString();
        }
        String tipText = this._factory.getBusinessObjectTipText(item);
        this._canHaveChildren = this._factory.canBusinessModelObjectHaveChildren(item);
        this._name = text;
        this._description = this._factory.getBusinessObjectDescription(item);
        this._displayName = this.getDisplayName(this._name);
        this._description = this._description == null ? "" : this._description.trim();
        this._toolTip = tipText;
        if (this._toolTip != null && this._toolTip.trim().length() == 0) {
            this._toolTip = null;
        }
        this._imageNameExpanded = this._factory.getBusinessModelObjectImageName(item, true);
        this._imageNameCollapsed = this._factory.getBusinessModelObjectImageName(item, false);
    }

    void load() {
        List children;
        this.init();
        if (this._loaded) {
            return;
        }
        this._loaded = true;
        if (this._parent == null) {
            children = this._dataSourceList;
        } else {
            Object orig = this.getOriginalObject();
            children = this._factory.getBusinessModelObjectChildren(orig);
        }
        if (children != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                Object child = children.get(i);
                if (child == null) continue;
                DataSourceTreeNode item = null;
                item = child instanceof DataSourceTreeNode ? (DataSourceTreeNode)child : new DataSourceTreeNode(this._factory, this, child);
                this._children.add(item);
            }
        }
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public TreeNode getChildAt(int index) {
        this.load();
        return (TreeNode)this._children.get(index);
    }

    public int getChildCount() {
        this.load();
        return this._children.size();
    }

    public int getIndex(TreeNode value) {
        this.load();
        return this._children.indexOf(value);
    }

    public boolean getAllowsChildren() {
        this.load();
        return true;
    }

    public boolean isLeaf() {
        if (this._parent == null) {
            return false;
        }
        this.init();
        return !this._canHaveChildren;
    }

    public Enumeration children() {
        this.load();
        Enumeration kids = new Enumeration(){
            int i = 0;

            @Override
            public boolean hasMoreElements() {
                return this.i < DataSourceTreeNode.this._children.size();
            }

            public Object nextElement() {
                return DataSourceTreeNode.this._children.get(this.i++);
            }
        };
        return kids;
    }

    public String toString() {
        this.init();
        return this._displayName;
    }

    public String getName() {
        this.init();
        return this._name;
    }

    public String getDisplayName() {
        this.init();
        return this._displayName;
    }

    public String getDescription() {
        this.init();
        return this._description;
    }

    public String getToolTip() {
        this.init();
        return this._toolTip;
    }

    public Icon getImageIcon(boolean expanded) {
        this.init();
        String imageName = this.getImageName(expanded);
        if (this._iconMap.containsKey(imageName)) {
            return (ImageIcon)this._iconMap.get(imageName);
        }
        if (this._factory == null) {
            return null;
        }
        Icon imageIcon = this._factory.getImageIconFromIqVisualsBundle(imageName);
        this._iconMap.put(imageName, imageIcon);
        return imageIcon;
    }

    public String getImageName(boolean expanded) {
        this.init();
        if (expanded) {
            return this._imageNameExpanded;
        }
        return this._imageNameCollapsed;
    }

    public String getInsertName() {
        if (this._parent == null) {
            return null;
        }
        this.init();
        if (this._factory == null) {
            return null;
        }
        Object orig = this.getOriginalObject();
        this._insertName = this._factory.getBusinessObjectInsertName(orig);
        return this._insertName;
    }

    public DistinctValuesInterface getDistinctValuesInterface() {
        this.init();
        if (!this._dviLoaded) {
            DataItem dataItem;
            Lookup lookupType;
            this._dviLoaded = true;
            if (this._factory == null) {
                return null;
            }
            Object orig = this.getOriginalObject();
            if (!this._factory.canBusinessModelObjectHaveValues(orig)) {
                return null;
            }
            boolean lookupValues = true;
            if (orig instanceof DataItem && (lookupType = (dataItem = (DataItem)orig).getLookupType()) instanceof LookupNotAllowed) {
                lookupValues = false;
            }
            this._distinctValuesInterface = null;
            if (lookupValues) {
                this._distinctValuesInterface = new DistinctValuesInterface(){

                    public boolean supportsDistinctValues() {
                        return true;
                    }

                    public int getDataType() {
                        return 0;
                    }

                    public int getLength() {
                        return 0;
                    }

                    public boolean isNullable() {
                        return false;
                    }

                    public List getDistinctValueSet(int nSetSize) {
                        return this.getDistinctValues();
                    }

                    public boolean isThereAnotherDistinctValue() {
                        return false;
                    }

                    public List getNextDistinctValueSet(int nSetSize) {
                        return new Vector();
                    }

                    public List getDistinctValues() {
                        DataSourceTreeNode.this.load();
                        if (!DataSourceTreeNode.this._readValues) {
                            Object orig = DataSourceTreeNode.this.getOriginalObject();
                            DataSourceTreeNode.this._values = DataSourceTreeNode.this._factory.getBusinessModelObjectValues(orig);
                            DataSourceTreeNode.this._readValues = DataSourceTreeNode.this._values != null;
                        }
                        return DataSourceTreeNode.this._values;
                    }

                    public String getInsertValue(Object distinctValue) {
                        return DataSourceTreeNode.this._factory.getBusinessModelObjectValuesToInsert(distinctValue);
                    }
                };
            }
        }
        return this._distinctValuesInterface;
    }

    public DataValuesInterface getDataValuesInterface() {
        this.init();
        return null;
    }

    public FormattedValuesInterface getFormattedValuesInterface() {
        this.init();
        return null;
    }

    protected String getDisplayName(String name) {
        String displayName = this.DISPLAY_NAME_EMPTY;
        if (name != null && name.length() > 0) {
            displayName = name;
        }
        return displayName;
    }
}

