/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.BaseCalculatedObjectFactory;
import com.sas.dataselectors.calculateditems.BusinessQueryToCalculatedItemAdapter;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedObjectFactoryInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.expr.ResourceScope;
import com.sas.iquery.util.BusinessQueryOLAPUtil;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class BusinessQueryCalculatedObjectFactory
extends BaseCalculatedObjectFactory {
    BusinessQuery _businessQuery = null;
    private CommonLoggerInterface log = null;
    Role _defaultRole = Role.COLUMN;

    public BusinessQueryCalculatedObjectFactory(BusinessQuery businessQuery) {
        super((BusinessModel)businessQuery, ResourceScope.BUSINESS_SCOPE);
        this._businessQuery = businessQuery;
        this.log = LoggerRepository2.getLogger((String)BusinessQueryCalculatedObjectFactory.class.getName(), null);
    }

    public BusinessQueryCalculatedObjectFactory(BusinessQuery businessQuery, Locale locale) {
        super((BusinessModel)businessQuery, ResourceScope.BUSINESS_SCOPE, locale);
        this._businessQuery = businessQuery;
        super.setLocale(locale);
        this.log = LoggerRepository2.getLogger((String)BusinessQueryCalculatedObjectFactory.class.getName(), null);
    }

    public BusinessQueryCalculatedObjectFactory(BusinessQuery businessQuery, CalculatedObjectFactoryInterface.ImageIconFactoryInterface imageIconFactory) {
        this(businessQuery);
        this.setImageIconFactory(imageIconFactory);
    }

    @Override
    public CalculatedItemInterface newCalculatedItemFromBusinessObject(Object bmObject) {
        return new BusinessQueryToCalculatedItemAdapter((CalculatedObjectFactoryInterface)this, bmObject);
    }

    @Override
    public Object newBusinessModelCalculatedItemObject(CalculatedItemInterface item) {
        Object bmObject = super.newBusinessModelCalculatedItemObject(item);
        if (bmObject instanceof DataItem) {
            DataItem dataItem = (DataItem)bmObject;
            try {
                BusinessModel queryBusinessModel = this._businessQuery.getBusinessModel();
                BusinessModel itemBusinessModel = dataItem.getBusinessModel();
                if (itemBusinessModel == queryBusinessModel) {
                    this.addResultItem(dataItem);
                } else {
                    this.addBusinessItemRef(dataItem);
                }
            }
            catch (MetadataException e) {
                this.log.error("", (Throwable)e);
                super.removeBusinessModelCalculatedItemObject(dataItem);
                return null;
            }
        }
        return bmObject;
    }

    protected void addBusinessItemRef(DataItem dataItem) throws MetadataException {
        BusinessModel queryBusinessModel = this._businessQuery.getBusinessModel();
        DataItemReference dataItemRef = queryBusinessModel.newDataItemReference(dataItem);
        String format = dataItem.getFormat();
        String dirFormat = dataItemRef.getFormat();
        if (dirFormat == null || dirFormat.length() == 0) {
            if (format == null || format.length() == 0) {
                format = this.getFormatFromResources(dataItem);
            }
            if (format != null) {
                BusinessQueryCalculatedObjectFactory.setFormat((DataItem)dataItemRef, format);
            }
        }
        queryBusinessModel.addBusinessItem((BusinessItem)dataItemRef);
        try {
            this.addResultItem((DataItem)dataItemRef);
        }
        catch (MetadataException e) {
            queryBusinessModel.removeBusinessItem((BusinessItem)dataItemRef);
            throw e;
        }
    }

    @Override
    public void removeBusinessModelCalculatedItemObject(Object bmObject) {
        if (bmObject instanceof DataItem) {
            DataItem deleteItem = (DataItem)bmObject;
            this.deleteAddedResultItem(deleteItem);
            this.deleteAddedResultItemRef(deleteItem);
            this.deleteAddedBusinessItemRef(deleteItem);
        }
        super.removeBusinessModelCalculatedItemObject(bmObject);
    }

    void deleteAddedResultItem(DataItem dataItem) {
        try {
            this._businessQuery.removeResultItem(dataItem);
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
        }
    }

    void deleteAddedResultItemRef(DataItem dataItem) {
        DataItemReference deleteItem = null;
        List resultItems = this._businessQuery.getResultItems();
        for (DataItem resultItem : resultItems) {
            DataItemReference dataItemRef;
            if (!(resultItem instanceof DataItemReference) || !(dataItemRef = (DataItemReference)resultItem).getBaseDataItem().equals((Object)dataItem)) continue;
            deleteItem = dataItemRef;
            break;
        }
        if (deleteItem == null) {
            return;
        }
        try {
            this._businessQuery.removeResultItem(deleteItem);
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
        }
    }

    void deleteAddedBusinessItemRef(DataItem dataItem) {
        DataItemReference deleteItem = null;
        BusinessModel queryBusinessModel = this._businessQuery.getBusinessModel();
        List dataItemRefs = queryBusinessModel.getObjects(0, DataItemReference.class);
        for (DataItemReference dataItemRef : dataItemRefs) {
            if (!dataItemRef.getBaseDataItem().equals((Object)dataItem)) continue;
            deleteItem = dataItemRef;
            break;
        }
        if (deleteItem == null) {
            return;
        }
        try {
            queryBusinessModel.removeBusinessItem(deleteItem);
        }
        catch (MetadataException e) {
            this.log.error("", (Throwable)e);
        }
    }

    public Role getDefaultRoleForNewItems() {
        return this._defaultRole;
    }

    public void setDefaultRoleForNewItems(Role role) {
        this._defaultRole = role;
    }

    void addResultItem(DataItem dataItem) throws MetadataException {
        BusinessModel queryBusinessModel = this._businessQuery.getBusinessModel();
        ArrayList<String> resultSetIDs = new ArrayList<String>();
        List resultItems = this._businessQuery.getResultItems();
        if (resultItems != null) {
            for (Object resultItem : resultItems) {
                if (!(resultItem instanceof DataItem)) continue;
                DataItem resultDataItem = (DataItem)resultItem;
                String resultSetID = resultDataItem.getResultSetID();
                resultSetIDs.add(resultSetID);
            }
        }
        String newResultSetID = dataItem.getResultSetID();
        boolean updateResultSetID = false;
        if (resultSetIDs.contains(newResultSetID)) {
            while (resultSetIDs.contains(newResultSetID)) {
                newResultSetID = queryBusinessModel.newDataItem().getResultSetID();
            }
            updateResultSetID = true;
        }
        if (updateResultSetID) {
            dataItem.setResultSetID(newResultSetID);
        }
        Role role = this.getDefaultRoleForNewItems();
        if (this._businessQuery.getInputStructure().isOLAP()) {
            DataItem fixupOldBackgroundMeasure = null;
            for (Object resultItem : resultItems) {
                Role dataItemRole;
                DataItem resultDataItem;
                StructureOfDataItem structure;
                if (!(resultItem instanceof DataItem) || !(structure = (resultDataItem = (DataItem)resultItem).getStructure()).equals(StructureOfDataItem.STRUCTURE_MEASURE) || (dataItemRole = this._businessQuery.getResultItemRole(resultDataItem)) == null) continue;
                if (dataItemRole.equals(Role.COLUMN)) {
                    role = Role.COLUMN;
                    break;
                }
                if (dataItemRole.equals(Role.ROW)) {
                    role = Role.ROW;
                    break;
                }
                if (!dataItemRole.equals(Role.BACKGROUND)) continue;
                fixupOldBackgroundMeasure = resultDataItem;
                break;
            }
            if (fixupOldBackgroundMeasure != null) {
                if (role == null) {
                    role = Role.COLUMN;
                }
                this._businessQuery.setResultItemRole(fixupOldBackgroundMeasure, role);
            }
        } else if (role != Role.COLUMN) {
            role = Role.COLUMN;
        }
        this._businessQuery.addResultItem(dataItem, role);
        if (this._businessQuery.getInputStructure().isOLAP()) {
            try {
                BusinessQueryOLAPUtil.cleanUpNullRolesInQuery((BusinessQuery)this._businessQuery);
            }
            catch (MetadataException e) {
                this._businessQuery.removeResultItem(dataItem);
                throw e;
            }
        }
    }

    protected void printResultItems() {
        List resultItems = this._businessQuery.getResultItems();
        if (resultItems == null) {
            System.err.println("no result items");
        } else {
            System.err.println("# result items = " + resultItems.size());
            int i = 0;
            for (Object resultItem : resultItems) {
                System.err.println("Result item: " + i + " " + resultItem.toString() + ", " + resultItem.getClass().getName() + ", HashCode=" + resultItem.hashCode());
                if (resultItem instanceof DataItem) {
                    DataItem dataItem = (DataItem)resultItem;
                    Role role = null;
                    try {
                        role = this._businessQuery.getResultItemRole(dataItem);
                    }
                    catch (MetadataException metadataException) {
                        // empty catch block
                    }
                    System.err.println("                role=" + role.toString());
                    this.printDataItem("                ", dataItem);
                    continue;
                }
                ++i;
            }
        }
    }

    protected void printCalcItems() {
        List calcItems = this.getBusinessModelCalculatedItemObjects(false);
        if (calcItems == null) {
            System.err.println("no calc items");
        } else {
            System.err.println("# calc items = " + calcItems.size());
            for (int k = 0; k < calcItems.size(); ++k) {
                Object calcItem = calcItems.get(k);
                System.err.println("Calc item: " + k + " " + calcItem.toString() + ", " + calcItem.getClass().getName() + ", HashCode=" + calcItem.hashCode());
                if (!(calcItem instanceof DataItem)) continue;
                DataItem dataItem = (DataItem)calcItem;
                this.printDataItem("              ", dataItem);
            }
        }
    }

    protected void printDataItem(String tag, DataItem dataItem) {
        System.err.println(tag + "id=" + dataItem.getIntraModelID() + " (" + dataItem.getLabel() + "), " + dataItem.getExpression() + ", resultid=" + dataItem.getResultSetID());
        if (dataItem instanceof DataItemReference) {
            DataItemReference diRefer = (DataItemReference)dataItem;
            DataItem referencedDataItem = diRefer.getBaseDataItem();
            System.err.println(tag + "Reference To: " + referencedDataItem.toString() + ", " + referencedDataItem.getClass().getName() + ", HashCode=" + referencedDataItem.hashCode());
            System.err.println(tag + "id=" + referencedDataItem.getIntraModelID() + " (" + referencedDataItem.getLabel() + "), " + referencedDataItem.getExpression() + ", resultid=" + referencedDataItem.getResultSetID());
        }
    }

    @Override
    public boolean canRemoveAllCalculatedItems() {
        boolean isOk = super.canRemoveAllCalculatedItems();
        if (!isOk) {
            return false;
        }
        List resultItems = this._businessQuery.getResultItems();
        if (resultItems == null) {
            return false;
        }
        boolean isRowsOk = !this.getLevelHasMembers();
        boolean isColumnsOk = false;
        List calcItems = this.getBusinessModelCalculatedItemObjects(false);
        for (Object resultItem : resultItems) {
            if (!(resultItem instanceof DataItem)) continue;
            DataItem dataItem = (DataItem)resultItem;
            Role role = null;
            try {
                role = this._businessQuery.getResultItemRole(dataItem);
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
            DataItem referencedDataItem = null;
            if (resultItem instanceof DataItemReference) {
                DataItemReference diRefer = (DataItemReference)resultItem;
                referencedDataItem = diRefer.getBaseDataItem();
            }
            if (calcItems.contains(dataItem) || referencedDataItem != null && calcItems.contains(referencedDataItem)) continue;
            if (role.equals(Role.COLUMN)) {
                isColumnsOk = true;
            } else if (role.equals(Role.ROW)) {
                isRowsOk = true;
            }
            if (!isColumnsOk || !isRowsOk) continue;
            break;
        }
        isOk = isColumnsOk && isRowsOk;
        return isOk;
    }
}

