/*
 * Decompiled with CFR 0.152.
 */
package com.sas.dataselectors.calculateditems;

import com.sas.dataselectors.calculateditems.BaseCalculatedObjectFactory;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemV2Interface;
import com.sas.dataselectors.calculateditems.CalculatedObjectFactoryInterface;
import com.sas.dataselectors.calculateditems.RB;
import com.sas.dataselectors.calculateditems.TimeFunctions;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.FunctionTreeInterface;
import com.sas.expressions.visuals.OperationListInterface;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.util.Strings;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class BaseCalculatedItemAdapter
implements CalculatedItemV2Interface {
    public static final String RB_KEY = "BaseCalculatedItemAdapter.";
    protected CalculatedObjectFactoryInterface objectFactory;
    protected Object businessModelObject;
    protected String id;
    protected String label;
    protected String description;
    protected int expressionType;
    protected String expression;
    protected String format;
    protected String function;
    protected Object measureExpression;
    protected String basePeriod;
    protected boolean isTimeBasedItem;
    protected ExpressionInterface timeExpressionMeasure;
    private boolean cumulativeTimeFunction;
    private TimeFunctions timeFunction;
    private Locale locale;
    protected boolean validateCalculationEnabled = true;
    public static String ERROR_INVALIDEXPR = RB.getStringResource((String)"BaseCalculatedItemAdapter.", (String)"ErrorMessage.InvalidExpr.txt");

    public BaseCalculatedItemAdapter(CalculatedObjectFactoryInterface factory, Object businessObject) {
        this.objectFactory = factory;
        this.businessModelObject = businessObject;
        if (this.businessModelObject != null) {
            this.objectFactory.updateCalculatedItemFromBusinessModelObject((CalculatedItemInterface)this, this.businessModelObject);
        }
    }

    public BaseCalculatedItemAdapter(CalculatedObjectFactoryInterface factory) {
        this(factory, null);
    }

    public BaseCalculatedItemAdapter(CalculatedObjectFactoryInterface factory, String id, String label, String description, int type, String expr) {
        this(factory, (Object)null);
        factory.updateCalculatedItemFromExprValues((CalculatedItemInterface)this, id, label, description, type, expr);
    }

    public BaseCalculatedItemAdapter(CalculatedObjectFactoryInterface factory, String id, String label, String description, int type, String expr, String format) {
        this(factory, id, label, description, type, expr);
        this.setFormat(format);
    }

    public BaseCalculatedItemAdapter(CalculatedObjectFactoryInterface factory, ExpressionInterface expression) {
        this(factory, (Object)null);
        String text = "";
        int exprType = 0;
        if (expression != null) {
            exprType = expression.getExpressionType();
            text = factory.getExpressionUtilText(expression);
        }
        factory.updateCalculatedItemFromExprValues((CalculatedItemInterface)this, null, "Temp", "", exprType, text);
        this.setFormat(null);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Map getLevelNameMap(boolean includeHierarchyName) {
        return this.objectFactory.getLevelNameMap(includeHierarchyName);
    }

    public Map getMeasureNameMap() {
        return this.objectFactory.getMeasureNameMap();
    }

    public String[] getLevelNames(boolean includeHierarchyName) {
        return this.objectFactory.getLevelNames(includeHierarchyName);
    }

    public String[] getMeasureNames() {
        return this.objectFactory.getMeasureNames();
    }

    public String[] getMemberNames(String levelName) {
        return this.objectFactory.getMemberNames(levelName);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.label;
    }

    public void setName(String name) {
        this.label = name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expr) {
        this.expression = expr;
    }

    public boolean getLevelHasMembers() {
        return this.objectFactory.getLevelHasMembers();
    }

    public int getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(int type) {
        this.expressionType = type;
    }

    public String getTimeFunction() {
        return this.function;
    }

    public void setTimeFunction(String functionLabel) {
        String none = RB.getStringResource((String)"TimeFunctions.", (String)"TimeFunction_None.txt", (Locale)this.getLocale());
        if (functionLabel != null && functionLabel.length() > 0 && !functionLabel.equals(none)) {
            this.isTimeBasedItem = true;
        }
        if (this.timeFunction == null) {
            this.timeFunction = new TimeFunctions(this.getLocale());
        }
        this.function = this.timeFunction.getTimeFunction(functionLabel);
    }

    public boolean isTimeBasedItem() {
        String none = RB.getStringResource((String)"TimeFunctions.", (String)"TimeFunction_None.txt", (Locale)this.getLocale());
        return this.function != null && this.function.length() > 0 && !this.function.equalsIgnoreCase(none) && !this.function.equals("NONE");
    }

    public Object getMeasureExpression() {
        return this.measureExpression;
    }

    public void setMeasureExpression(Object measure) {
        if (measure instanceof String) {
            String exp = (String)measure;
            this.measureExpression = null;
            String measureName = this.findMeasureLabel2(exp);
            if (measureName != null) {
                List dataItems = this.objectFactory.getDataItems(true);
                for (DataItem dataItem : dataItems) {
                    if (!dataItem.getLabel().equals(measureName)) continue;
                    this.measureExpression = dataItem;
                }
            }
        } else if (measure instanceof DataItem) {
            this.measureExpression = measure;
        }
    }

    private String findMeasureLabel2(String exp) {
        int endIndex;
        int index;
        String measureName = null;
        StringBuffer tempStrBuffer = new StringBuffer(exp);
        boolean found = false;
        while (!found && (index = tempStrBuffer.reverse().toString().indexOf(40, 0)) >= 0 && (endIndex = exp.lastIndexOf(41)) > 0) {
            String measureInExpression = exp.substring(exp.length() - index, endIndex);
            Map measureMap = this.objectFactory.getMeasureNameMap();
            Set es = measureMap.entrySet();
            for (Map.Entry me : es) {
                String label = (String)me.getKey();
                if (!measureInExpression.equals(label)) continue;
                measureName = label;
                found = true;
                break;
            }
            if (found) continue;
            exp = measureInExpression;
        }
        return measureName;
    }

    public String getBasePeriod() {
        return this.basePeriod;
    }

    public void setBasePeriod(String basePeriod) {
        this.basePeriod = basePeriod;
        if (basePeriod != null && basePeriod.length() > 0) {
            this.cumulativeTimeFunction = true;
            this.function = "CUMULATIVE";
        }
    }

    public String getExpressionAreaString() {
        String expressionAreaString = "";
        String tempFunction = this.function;
        if (this.cumulativeTimeFunction) {
            tempFunction = "CUMULATIVE_BASE_PERIOD";
        }
        expressionAreaString = this.timeFunction.getTimeExpression(tempFunction);
        String defaultMeasure = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"selectedMeasure.txt", (Locale)this.locale);
        String defaultBasePeriod = RB.getStringResource((String)"BaseCalculatedObjectFactory.", (String)"selectedPeriod.txt", (Locale)this.locale);
        expressionAreaString = Strings.replace((String)expressionAreaString, (int)0, (int)-1, (String)defaultMeasure, (String)((DataItem)this.measureExpression).getLabel());
        if (this.basePeriod != null && this.basePeriod.length() > 0) {
            expressionAreaString = Strings.replace((String)expressionAreaString, (int)0, (int)-1, (String)defaultBasePeriod, (String)this.basePeriod);
        }
        return expressionAreaString;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("IntraModelID: ");
        buffer.append(this.getId());
        buffer.append(", Name: ");
        buffer.append(this.getName());
        buffer.append(", Label: ");
        buffer.append(this.getLabel());
        buffer.append(", Description: ");
        buffer.append(this.getDescription());
        buffer.append(", Expression: ");
        buffer.append(this.getExpression());
        buffer.append(", Type: ");
        buffer.append(Integer.toString(this.getExpressionType()));
        buffer.append(", Format: ");
        buffer.append(this.getFormat());
        return buffer.toString();
    }

    public boolean commitChanges() {
        if (this.objectFactory == null) {
            return false;
        }
        boolean ok = false;
        if (this.businessModelObject == null) {
            this.businessModelObject = this.objectFactory.newBusinessModelCalculatedItemObject((CalculatedItemInterface)this);
            ok = this.businessModelObject != null;
        } else {
            ok = this.objectFactory.updateBusinessModelObjectFromCalculatedItem(this.businessModelObject, (CalculatedItemInterface)this);
        }
        return ok;
    }

    public Object getBusinessModelObject() {
        return this.businessModelObject;
    }

    public DataSourceTreeInterface getDataSourceTree() {
        if (this.expressionType == -3) {
            return this.objectFactory.getPhysicalDataSourceTree();
        }
        return this.objectFactory.getDataSourceTree();
    }

    public DataSourceTreeInterface getPhysicalDataSourceTree() {
        return this.objectFactory.getPhysicalDataSourceTree();
    }

    public DataSourceTreeInterface getBusinessDataSourceTree() {
        return this.objectFactory.getBusinessDataSourceTree();
    }

    public DataSourceTreeInterface getPromptDataSourceTree() {
        return this.objectFactory.getPromptDataSourceTree();
    }

    public FunctionTreeInterface getFunctionListTree() {
        return this.objectFactory.getFunctionListTree();
    }

    public OperationListInterface getOperationList() {
        return this.objectFactory.getOperationList();
    }

    public String[] getValidExpressionTypeNames() {
        return this.objectFactory.getExpressionTypeNames();
    }

    public int[] getValidExpressionTypeValues() {
        return this.objectFactory.getExpressionTypeValues();
    }

    public int convertToCalcItemType(int expressionType, boolean isOLAP) {
        return BaseCalculatedItemAdapter._convertToCalcItemType(expressionType, isOLAP);
    }

    public int convertToExpressionType(int calculatedItemType, boolean isOLAP) {
        return BaseCalculatedItemAdapter._convertToExpressionType(calculatedItemType, isOLAP);
    }

    private static int _convertToCalcItemType(int expressionType, boolean isOLAP) {
        return BaseCalculatedObjectFactory.convertToCalcItemType(expressionType, isOLAP);
    }

    public static String getExpressionTypeLabel(int expressionType, boolean isOlap) {
        return BaseCalculatedObjectFactory.getExpressionTypeLabel(expressionType, isOlap);
    }

    private static int _convertToExpressionType(int calculatedItemType, boolean isOLAP) {
        return BaseCalculatedObjectFactory.convertToExpressionType(calculatedItemType, isOLAP);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String newFormat) {
        this.format = newFormat;
    }

    public void setValidateCalculationEnabled(boolean enableCalculation) {
        this.validateCalculationEnabled = enableCalculation;
    }

    public boolean isValidateCalculationEnabled() {
        return this.validateCalculationEnabled;
    }

    public boolean validate() {
        boolean itemValid = this.objectFactory.validateCalculatedItem((CalculatedItemInterface)this, this.validateCalculationEnabled);
        return itemValid;
    }

    public boolean validate(boolean includeCalculation) {
        boolean itemValid = this.objectFactory.validateCalculatedItem((CalculatedItemInterface)this, includeCalculation);
        return itemValid;
    }

    public boolean validateCalculation() {
        boolean itemValid = this.objectFactory.validateItemCalculation((CalculatedItemInterface)this);
        return itemValid;
    }

    public String getLastInvalidCalculatedItemMessage() {
        return this.objectFactory.getLastInvalidCalculatedItemMessage();
    }

    public Exception getLastInvalidExpressionException() {
        return this.objectFactory.getLastInvalidExpressionException();
    }

    public int getMaxOutputObservations() {
        if (this.objectFactory != null) {
            return this.objectFactory.getMaxOutputObservations();
        }
        return BaseCalculatedObjectFactory.DEFAULT_GOVERNING_LIMIT;
    }

    public void setMaxOutputObservations(int max) {
        if (this.objectFactory != null) {
            this.objectFactory.setMaxOutputObservations(max);
        }
    }
}

