/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.commands.olap.OLAPCommandUtil;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ShiftCommand
extends BaseTupleElementCommand {
    public static int MOVE_IN = 0;
    public static int MOVE_OUT = 1;
    private int moveType;

    public ShiftCommand(String name) {
        super(name);
    }

    public ShiftCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            OLAPCommandUtil.joinMeasures(businessQuery);
            DataItem dataItem = this.getDataItem();
            Role currentRole = businessQuery.getResultItemRole(dataItem);
            List list = businessQuery.getResultItems(currentRole);
            int index = list.indexOf(dataItem);
            Iterator iter = list.iterator();
            int startIndex = -1;
            int endIndex = -1;
            while (iter.hasNext()) {
                DataItem di = (DataItem)iter.next();
                if (di.getStructure() != StructureOfDataItem.STRUCTURE_MEASURE) continue;
                if (startIndex == -1) {
                    endIndex = startIndex = list.indexOf(di);
                    continue;
                }
                ++endIndex;
            }
            boolean moveDoesNotAffectMeasures = true;
            if (startIndex >= 0) {
                ArrayList measureList = new ArrayList(list.subList(startIndex, endIndex + 1));
                int size = measureList.size();
                if (index >= startIndex && index <= endIndex) {
                    list.removeAll(measureList);
                    if (this.moveType == MOVE_IN) {
                        list.addAll(startIndex + 1, measureList);
                    } else {
                        list.addAll(startIndex - 1, measureList);
                    }
                    moveDoesNotAffectMeasures = false;
                } else if (index == startIndex - 1 && this.moveType == MOVE_IN) {
                    list.remove(index);
                    list.add(index + size, dataItem);
                    moveDoesNotAffectMeasures = false;
                } else if (index == endIndex + 1 && this.moveType == MOVE_OUT) {
                    list.remove(index);
                    list.add(index - size, dataItem);
                    moveDoesNotAffectMeasures = false;
                }
            }
            if (startIndex < 0 || moveDoesNotAffectMeasures) {
                list.remove(index);
                if (this.moveType == MOVE_IN) {
                    list.add(index + 1, dataItem);
                } else {
                    list.add(index - 1, dataItem);
                }
            }
            businessQuery.removeResultItems(list);
            businessQuery.addResultItems(list, currentRole);
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, BusinessQueryActionType.RESULT_ITEM)) {
            return false;
        }
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                uniqueLevelName = tupleElement.getUniqueLevelName();
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        if (uniqueLevelName != null) {
            return this.isMoveable((OLAPDataSetInterface)actionFilter.getAttribute("model"), uniqueLevelName);
        }
        return false;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, BusinessQueryActionType.RESULT_ITEM)) {
            return 1;
        }
        String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
                uniqueLevelName = tupleElement.getUniqueLevelName();
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        Object model = filter.getAttribute("model");
        if (uniqueLevelName != null) {
            return this.getMoveableStatus((OLAPDataSetInterface)model, uniqueLevelName);
        }
        return 16;
    }

    protected boolean isMoveable(OLAPDataSetInterface model, String levelName) {
        try {
            AxisInterface axis = super.getAxis(model, levelName);
            int levelIndex = super.getLevelIndex(model, levelName);
            String[] dimNames = axis.getDimensionNames();
            String dimName = dimNames[levelIndex];
            List dims = this.removeDuplicates(dimNames);
            int index = dims.indexOf(dimName);
            int size = dims.size();
            return size > 1 && (index != size - 1 || this.moveType != MOVE_IN) && (index != 0 || this.moveType != MOVE_OUT);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected int getMoveableStatus(OLAPDataSetInterface model, String uniqueLevelName) {
        try {
            AxisInterface axis = super.getAxis(model, uniqueLevelName);
            int levelIndex = super.getLevelIndex(model, uniqueLevelName);
            String[] dimNames = axis.getDimensionNames();
            String dimName = dimNames[levelIndex];
            List dims = this.removeDuplicates(dimNames);
            int index = dims.indexOf(dimName);
            int size = dims.size();
            if (size <= 1 || index == size - 1 && this.moveType == MOVE_IN || index == 0 && this.moveType == MOVE_OUT) {
                return 8;
            }
            return 0;
        }
        catch (Exception exception) {
            return 16;
        }
    }

    public void setMoveType(int moveType) {
        this.moveType = moveType;
    }

    public int getMoveType() {
        return this.moveType;
    }

    protected List removeDuplicates(String[] dims) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < dims.length; ++i) {
            if (l.contains(dims[i])) continue;
            l.add(dims[i]);
        }
        return l;
    }

    private static void printDataItemsInList(List dataItemList) {
        for (DataItem di : dataItemList) {
            System.out.print(" ===" + di.getLabel() + "   ");
        }
        System.out.println();
    }

    private static void printDataSelection(BusinessQuery ds) throws MetadataException {
        List dia = ds.getResultItems();
        Iterator iterator = dia.iterator();
        boolean i = false;
        while (iterator.hasNext()) {
            DataItem dataItem = (DataItem)iterator.next();
        }
    }

    @Override
    public boolean isIQSupported(ActionSupportFilter actionFilter, BusinessQueryActionType actionType) {
        Object model;
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                if (tupleElement != null) {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        if ((model = actionFilter.getAttribute("model")) instanceof BusinessQueryProviderInterface && model instanceof OLAPDataSetInterface && uniqueLevelName != null) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            this._dataItem = this.getDataItem(actionFilter);
            DataItem dataItem = this._dataItem;
            if (dataItem != null) {
                return businessQuery.isActionSupported(actionType);
            }
        }
        return false;
    }
}

