/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.Role;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import java.util.List;

public class RotateCommand
extends BaseTupleElementCommand {
    public RotateCommand(String name) {
        super(name);
    }

    public RotateCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            List dataItems = businessQuery.getResultItems();
            for (DataItem dataItem : dataItems) {
                Role currentRole = businessQuery.getResultItemRole(dataItem);
                if (currentRole == Role.ROW) {
                    businessQuery.setResultItemRole(dataItem, Role.COLUMN);
                    continue;
                }
                if (currentRole != Role.COLUMN) continue;
                businessQuery.setResultItemRole(dataItem, Role.ROW);
            }
            String rowTotalType = businessQuery.getTotalType(Role.ROW);
            String rowTotalLabel = null;
            String rowSubtotalLabel = null;
            String colTotalType = businessQuery.getTotalType(Role.COLUMN);
            String colTotalLabel = null;
            String colSubtotalLabel = null;
            if (!BusinessQuery.TOTAL_NONE.equals(rowTotalType)) {
                rowTotalLabel = businessQuery.getTotalLabel(Role.ROW, rowTotalType);
                if (rowTotalType == BusinessQuery.ALLTOTAL) {
                    rowTotalLabel = businessQuery.getTotalLabel(Role.ROW, BusinessQuery.GRANDTOTAL);
                    rowSubtotalLabel = businessQuery.getTotalLabel(Role.ROW, BusinessQuery.SUBTOTAL);
                }
            }
            if (!BusinessQuery.TOTAL_NONE.equals(colTotalType)) {
                colTotalLabel = businessQuery.getTotalLabel(Role.COLUMN, colTotalType);
                if (colTotalType == BusinessQuery.ALLTOTAL) {
                    colTotalLabel = businessQuery.getTotalLabel(Role.COLUMN, BusinessQuery.GRANDTOTAL);
                    colSubtotalLabel = businessQuery.getTotalLabel(Role.COLUMN, BusinessQuery.SUBTOTAL);
                }
            }
            if (rowTotalLabel != null) {
                businessQuery.setTotalLabel(rowTotalLabel, Role.COLUMN, rowTotalType);
            }
            if (rowSubtotalLabel != null) {
                businessQuery.setTotalLabel(rowSubtotalLabel, Role.COLUMN, BusinessQuery.SUBTOTAL);
            }
            businessQuery.setTotalType(rowTotalType, Role.COLUMN);
            if (colTotalLabel != null) {
                businessQuery.setTotalLabel(colTotalLabel, Role.ROW, colTotalType);
            }
            if (colSubtotalLabel != null) {
                businessQuery.setTotalLabel(colSubtotalLabel, Role.ROW, BusinessQuery.SUBTOTAL);
            }
            businessQuery.setTotalType(colTotalType, Role.ROW);
            List col = businessQuery.getSortCriteria(Role.COLUMN);
            List row = businessQuery.getSortCriteria(Role.ROW);
            businessQuery.setSortCriteria(col, Role.ROW);
            businessQuery.setSortCriteria(row, Role.COLUMN);
            BusinessQueryActionType colSortDirection = businessQuery.getSortDirection(Role.COLUMN);
            BusinessQueryActionType rowSortDirection = businessQuery.getSortDirection(Role.ROW);
            businessQuery.setSortDirection(colSortDirection, Role.ROW);
            businessQuery.setSortDirection(rowSortDirection, Role.COLUMN);
            List columnSteps = businessQuery.getSteps(Role.COLUMN);
            List rowSteps = businessQuery.getSteps(Role.ROW);
            businessQuery.setSteps(columnSteps, Role.ROW);
            businessQuery.setSteps(rowSteps, Role.COLUMN);
            this.executeQuery(businessQuery);
            this.eventInfo.put("ROW_COLUMN", "EXCHANGE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        OLAPDataSetInterface odsi = (OLAPDataSetInterface)actionFilter.getAttribute("model");
        return this.isMoveable(odsi);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        OLAPDataSetInterface odsi = (OLAPDataSetInterface)filter.getAttribute("model");
        return this.getMoveableStatus(odsi);
    }

    protected boolean isMoveable(OLAPDataSetInterface olapModel) {
        try {
            AxisInterface[] axes = olapModel.getResultSetMetadata().getAxes(0, -1);
            if (axes.length > 2) {
                return true;
            }
            if (axes.length == 2 && axes[1].getAxisNumber() != -1) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected int getMoveableStatus(OLAPDataSetInterface olapModel) {
        try {
            AxisInterface[] axes = olapModel.getResultSetMetadata().getAxes(0, -1);
            if (axes.length > 2) {
                return 0;
            }
            if (axes.length == 2 && axes[1].getAxisNumber() != -1) {
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }
}

