/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.ShiftCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import java.util.List;

public class PreventMeasureMoveShiftCommand
extends ShiftCommand {
    public PreventMeasureMoveShiftCommand(String name) {
        super(name);
    }

    public PreventMeasureMoveShiftCommand(String name, boolean swing) {
        super(name, swing);
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, BusinessQueryActionType.RESULT_ITEM)) {
            return false;
        }
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                uniqueLevelName = tupleElement.getUniqueLevelName();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return this.isMoveable(uniqueLevelName, actionFilter);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, BusinessQueryActionType.RESULT_ITEM)) {
            return 1;
        }
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                uniqueLevelName = tupleElement.getUniqueLevelName();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return this.getMoveableStatus(uniqueLevelName, actionFilter);
    }

    protected boolean isMoveable(String uniqueLevelName, ActionSupportFilter filter) {
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        boolean moveable = this.isMoveable(model, uniqueLevelName);
        if (moveable) {
            try {
                DataItem nextDataItem;
                if (!(model instanceof BusinessQueryProviderInterface)) {
                    return false;
                }
                BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                DataItem di = this.getDataItem();
                Role currentRole = bq.getResultItemRole(di);
                List list = bq.getResultItems(currentRole);
                int index = list.indexOf(di);
                if (this.isMeasure(di)) {
                    return false;
                }
                if (this.getMoveType() == MOVE_IN && index + 1 < list.size() && (nextDataItem = (DataItem)list.get(index + 1)) != null && this.isMeasure(nextDataItem)) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return moveable;
    }

    protected int getMoveableStatus(String uniqueLevelName, ActionSupportFilter filter) {
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        int status = this.getMoveableStatus(model, uniqueLevelName);
        if (status == 0) {
            try {
                DataItem nextDataItem;
                if (!(model instanceof BusinessQueryProviderInterface)) {
                    return 1;
                }
                BusinessQuery bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                DataItem di = this.getDataItem();
                Role currentRole = bq.getResultItemRole(di);
                List list = bq.getResultItems(currentRole);
                int index = list.indexOf(di);
                if (this.isMeasure(di)) {
                    return 4;
                }
                if (this.getMoveType() == MOVE_IN && index + 1 < list.size() && (nextDataItem = (DataItem)list.get(index + 1)) != null && this.isMeasure(nextDataItem)) {
                    return 2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return status;
    }

    private boolean isMeasure(DataItem dataItem) {
        StructureOfDataItem dataItemStructure = dataItem.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && dataItem.getExpressionType() == 2 && dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }
}

