/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.commands.olap.OLAPCommandUtil;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import java.util.ArrayList;
import java.util.List;

public class MoveCommand
extends BaseTupleElementCommand {
    public MoveCommand(String name) {
        super(name);
    }

    public MoveCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            StructureOfData structure = businessQuery.getBusinessModel().getStructure();
            if (structure.isOLAP()) {
                OLAPCommandUtil.joinMeasures(businessQuery);
            }
            DataItem dataItem = this.getDataItem();
            Role currentRole = businessQuery.getResultItemRole(dataItem);
            if (this.isMeasure(dataItem)) {
                List list = businessQuery.getResultItems(currentRole);
                ArrayList<DataItem> l = new ArrayList<DataItem>();
                int index = list.indexOf(dataItem);
                for (DataItem di : list) {
                    if (this.isMeasure(di)) {
                        l.add(di);
                    }
                    businessQuery.removeResultItems(l);
                    if (currentRole == Role.ROW) {
                        businessQuery.addResultItems(l, Role.COLUMN);
                        continue;
                    }
                    if (currentRole != Role.COLUMN) continue;
                    businessQuery.addResultItems(l, Role.ROW);
                }
            } else if (currentRole == Role.ROW) {
                List list = businessQuery.getResultItems(Role.COLUMN);
                businessQuery.removeResultItem(dataItem);
                list.add(0, dataItem);
                businessQuery.removeResultItems(list);
                businessQuery.addResultItems(list, Role.COLUMN);
            } else if (currentRole == Role.COLUMN) {
                List list = businessQuery.getResultItems(Role.ROW);
                businessQuery.removeResultItem(dataItem);
                list.add(0, dataItem);
                businessQuery.removeResultItems(list);
                businessQuery.addResultItems(list, Role.ROW);
            }
            if (businessQuery.isActionSupported(BusinessQueryActionType.SORT_CRITERIA)) {
                businessQuery.setSortCriteria(new ArrayList(), Role.ROW);
                businessQuery.setSortCriteria(new ArrayList(), Role.COLUMN);
            }
            if (businessQuery.isActionSupported(BusinessQueryActionType.SORT_NONE)) {
                businessQuery.setSortDirection(BusinessQueryActionType.SORT_NONE, Role.ROW);
                businessQuery.setSortDirection(BusinessQueryActionType.SORT_NONE, Role.COLUMN);
            }
            this.executeQuery(businessQuery);
            this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, BusinessQueryActionType.RESULT_ITEM)) {
            return false;
        }
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                if (tupleElement != null) {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        if (uniqueLevelName != null) {
            return this.isMoveable(uniqueLevelName, actionFilter.getAttribute("model"));
        }
        return false;
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, BusinessQueryActionType.RESULT_ITEM)) {
            return 1;
        }
        String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
                if (tupleElement != null) {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
            }
            catch (OLAPException tupleElement) {
                // empty catch block
            }
        }
        Object model = filter.getAttribute("model");
        if (uniqueLevelName != null) {
            return this.getMoveableStatus(uniqueLevelName, model);
        }
        return 16;
    }

    protected boolean isMoveable(String uniqueLevelName, Object model) {
        return uniqueLevelName != null && model != null;
    }

    protected int getMoveableStatus(String uniqueLevelName, Object model) {
        try {
            if (uniqueLevelName != null && model != null && model instanceof BusinessQueryProviderInterface && model instanceof OLAPDataSetInterface) {
                DataItem di;
                Role role;
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
                List list = businessQuery.getResultItems(role = businessQuery.getResultItemRole(di = this.getDataItem()));
                if (this.singleDataItem(list)) {
                    return 4;
                }
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 16;
    }

    private boolean singleDataItem(List list) {
        int size = list.size();
        int i = 0;
        int uniqueItem = 0;
        int isMeasure = 0;
        while (i < size) {
            DataItem di;
            if (!this.isMeasure(di = (DataItem)list.get(i++))) {
                ++uniqueItem;
                continue;
            }
            isMeasure = 1;
        }
        return uniqueItem + isMeasure <= 1;
    }

    private boolean isMeasure(DataItem di) {
        StructureOfDataItem dataItemStructure = di.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && di.getExpressionType() == 2 && di.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }

    @Override
    public boolean isIQSupported(ActionSupportFilter actionFilter, BusinessQueryActionType actionType) {
        Object model;
        String uniqueLevelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
                if (tupleElement != null) {
                    uniqueLevelName = tupleElement.getUniqueLevelName();
                }
            }
            catch (OLAPException tupleElement) {
                // empty catch block
            }
        }
        if ((model = actionFilter.getAttribute("model")) instanceof BusinessQueryProviderInterface && model instanceof OLAPDataSetInterface && uniqueLevelName != null) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            this._dataItem = this.getDataItem(actionFilter);
            DataItem dataItem = this._dataItem;
            if (dataItem != null) {
                return businessQuery.isActionSupported(actionType);
            }
        }
        return false;
    }
}

