/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.iquery.metadata.business.step.olap.utility.DrillUtil;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import java.util.List;

public class DrillUpCommand
extends BaseTupleElementCommand {
    boolean showAllEnabled = false;

    public DrillUpCommand(String name) {
        super(name);
    }

    public DrillUpCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            DrillUtil.drillUp((DataItem)dataItem);
            int axisNumber = this.getAxisIndex();
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "INITIALIZE");
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "INITIALIZE");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, DataItemActionType.STEP_NAVIGATE)) {
            return false;
        }
        return this.isDrillUp(this.getUniqueLevelName(actionFilter), actionFilter);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, DataItemActionType.STEP_NAVIGATE)) {
            return 1;
        }
        return this.getDrillUpStatus(this.getUniqueLevelName(filter), filter);
    }

    protected boolean isDrillUp(String uniqueLevelName, ActionSupportFilter filter) {
        try {
            if (!this.showAllEnabled && this.getLevel(filter).getDepth() <= 1) {
                return false;
            }
            List steps = this.getSteps(filter);
            if (!this.isLastStepDrillDown(steps)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected int getDrillUpStatus(String uniqueLevelName, ActionSupportFilter filter) {
        try {
            int levelDepth = this.getLevel(filter).getDepth();
            if (!this.showAllEnabled && levelDepth <= 1) {
                return 4;
            }
            List steps = this.getSteps(filter);
            if (!this.isLastStepDrillDown(steps)) {
                return 4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private boolean isLastStepDrillDown(List steps) {
        int lastStepIndex;
        StepInterface lastStep;
        return steps != null && steps.size() > 0 && (lastStep = (StepInterface)steps.get(lastStepIndex = steps.size() - 1)) instanceof DataItemNavigationFilter && ((StepFilterInterface)lastStep).getActionType() == 0;
    }

    private List getSteps(ActionSupportFilter filter) {
        DataItem di = this.getDataItem();
        if (di != null) {
            return di.getSteps();
        }
        return null;
    }

    private String getUniqueLevelName(ActionSupportFilter filter) {
        String uniqueLevelName = (String)filter.getAttribute("uniqueLevelName");
        if (uniqueLevelName == null) {
            try {
                TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
                uniqueLevelName = tupleElement.getUniqueLevelName();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return uniqueLevelName;
    }

    private LevelInterface getLevel(ActionSupportFilter filter) {
        String uniqueLevelName = this.getUniqueLevelName(filter);
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        if (uniqueLevelName != null && model != null) {
            try {
                MetadataInterface metadata = model.getDatabaseMetadata();
                String cubeName = model.getCubeName();
                Filter metaFilter = new Filter();
                metaFilter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                metaFilter.setUniqueLevelName(uniqueLevelName);
                metaFilter.setCubeName(cubeName);
                LevelInterface[] levels = metadata.getLevels(metaFilter);
                if (levels != null) {
                    return levels[0];
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
        return null;
    }
}

