/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseTupleElementCommand;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.List;
import java.util.Vector;

public class CollapseCommand
extends BaseTupleElementCommand {
    public CollapseCommand(String name) {
        super(name);
    }

    public CollapseCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        this.getModel();
        if (this.model == null) {
            throw new IllegalStateException();
        }
        try {
            int stepIndex;
            List steps;
            int size;
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
            DataItem dataItem = this.getDataItem();
            if (dataItem != null && (size = (steps = dataItem.getSteps()).size()) > 0 && (stepIndex = this.isExpandPresent(steps, this.getTupleElement().getName())) >= 0) {
                dataItem.removeStep(stepIndex);
            }
            int axisNumber = this.getAxisIndex();
            Vector<String> tplElements = null;
            if (this.tupleElement != null) {
                TupleInterface tuple = this.tupleElement.getTuple();
                AxisInterface axis = tuple.getAxis();
                String[] dimNames = axis.getDimensionNames();
                TupleElementInterface[] tupleElements = tuple.getElements(0, -1);
                String[] tupleDimension = new String[tupleElements.length];
                int tupleIndex = this.tupleElement.getTupleElementIndex();
                int span = 0;
                String compareToDimension = null;
                tplElements = new Vector<String>();
                for (int i = 0; i < tupleElements.length; ++i) {
                    tupleDimension[i] = dimNames[span];
                    if (i == tupleIndex) {
                        compareToDimension = dimNames[span];
                        tplElements.add(tupleElements[i].getName());
                    } else if (i > tupleIndex && !dimNames[span].equals(compareToDimension) || i < tupleIndex) {
                        tplElements.add(tupleElements[i].getName());
                    }
                    span += tupleElements[i].getSpan();
                }
            }
            this.executeQuery(businessQuery);
            if (axisNumber == 1) {
                this.eventInfo.put("ROW", "REFRESH");
                if (tplElements != null) {
                    this.eventInfo.put("TUPLE", tplElements);
                }
            } else if (axisNumber == 0) {
                this.eventInfo.put("COLUMN", "REFRESH");
                if (tplElements != null) {
                    this.eventInfo.put("TUPLE", tplElements);
                }
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isSupported(ActionSupportFilter actionFilter) {
        if (!this.isIQSupported(actionFilter, DataItemActionType.STEP_NAVIGATE)) {
            return false;
        }
        OLAPDataSetInterface model = (OLAPDataSetInterface)actionFilter.getAttribute("model");
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        return this.isCollapseable(model, tupleElement);
    }

    @Override
    public int getCommandStatus(ActionSupportFilter filter) {
        if (!this.isIQSupported(filter, DataItemActionType.STEP_NAVIGATE)) {
            return 1;
        }
        OLAPDataSetInterface model = (OLAPDataSetInterface)filter.getAttribute("model");
        TupleElementInterface tupleElement = (TupleElementInterface)filter.getAttribute("tupleElement");
        return this.getCollapseableStatus(model, tupleElement);
    }

    protected boolean isCollapseable(OLAPDataSetInterface model, TupleElementInterface tupleElement) {
        try {
            List steps;
            if (tupleElement.isContextual() && this.isExpandPresent(steps = this.getSteps(model, tupleElement), tupleElement.getName()) < 0) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    protected int getCollapseableStatus(OLAPDataSetInterface model, TupleElementInterface tupleElement) {
        try {
            List steps;
            if (tupleElement.isContextual() && this.isExpandPresent(steps = this.getSteps(model, tupleElement), tupleElement.getName()) >= 0) {
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 4;
    }

    private List getSteps(OLAPDataSetInterface model, TupleElementInterface tupleElement) {
        DataItem di = this.getDataItem();
        if (di != null) {
            return di.getSteps();
        }
        return null;
    }
}

