/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.olap;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.BaseOLAPCommand;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.StructureOfData;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.business.step.StepFilterInterface;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.iquery.metadata.business.step.olap.DataItemNavigationFilter;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.util.log.LoggerRepository2;
import java.util.HashMap;
import java.util.List;

public abstract class BaseTupleElementCommand
extends BaseOLAPCommand {
    protected TupleElementInterface tupleElement;
    protected Integer tupleElementIndex;
    protected int levelIndex;
    protected boolean debug = false;
    protected Integer tupleIndex;
    protected Integer axisIndex;
    protected DataItem _dataItem;
    protected String uniqueLevelName;
    protected AxisInterface axis;
    private BusinessModel lastBusinessModel;
    private boolean isOLAP;
    private boolean dataItemExplicitlySet = false;

    public BaseTupleElementCommand(String name) {
        super(name);
    }

    public BaseTupleElementCommand(String name, boolean swing) {
        super(name, swing);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseTupleElementCommand clone = (BaseTupleElementCommand)((Object)super.clone());
        if (!this.dataItemExplicitlySet) {
            clone.setDataItem(null);
        }
        return clone;
    }

    public void executeQuery(BusinessQuery businessQuery) throws OLAPException {
        try {
            QueryConnector connector = new QueryConnector();
            String modelID = businessQuery.getID();
            if (modelID == null) {
                throw new IllegalStateException();
            }
            if (!(this.model instanceof BusinessQueryProviderInterface)) {
                throw new IllegalStateException();
            }
            ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(businessQuery);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("tupleElement", this.tupleElement);
            this.setEventSource(this.model);
        }
        catch (Exception e) {
            throw new OLAPException();
        }
    }

    public boolean isIQSupported(ActionSupportFilter actionFilter, DataItemActionType actionType) {
        Object model = actionFilter.getAttribute("model");
        TupleElementInterface tupleElement = (TupleElementInterface)actionFilter.getAttribute("tupleElement");
        String levelName = (String)actionFilter.getAttribute("uniqueLevelName");
        if (model instanceof BusinessQueryProviderInterface && (tupleElement != null || levelName != null)) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel == null) {
                return false;
            }
            if (businessModel != this.lastBusinessModel) {
                this.isOLAP = businessModel.getStructure().isOLAP();
                this.lastBusinessModel = businessModel;
            }
            if (this.isOLAP) {
                this._dataItem = this.getDataItem(actionFilter);
                if (this._dataItem != null) {
                    return this._dataItem.isActionSupported(actionType);
                }
            }
        }
        return false;
    }

    public boolean isIQSupported(ActionSupportFilter actionFilter, BusinessQueryActionType actionType) {
        Object model = actionFilter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel == null) {
                return false;
            }
            if (businessModel != this.lastBusinessModel) {
                this.isOLAP = businessModel.getStructure().isOLAP();
                this.lastBusinessModel = businessModel;
            }
            if (this.isOLAP) {
                this._dataItem = this.getDataItem(actionFilter);
                return businessQuery.isActionSupported(actionType);
            }
        }
        return false;
    }

    protected DataItem getDataItem(ActionSupportFilter actionFilter) {
        DataItem di = (DataItem)actionFilter.getAttribute("dataItem");
        if (di != null) {
            return di;
        }
        return this._getDataItem();
    }

    protected DataItem _getDataItem() {
        DataItem di = null;
        if (this.model != null && this.model instanceof BusinessQueryProviderInterface) {
            String levelName = this.getUniqueLevelName();
            if (levelName != null) {
                di = this.findDataItem((BusinessQueryProviderInterface)this.model, levelName);
            }
            if (di == null) {
                this.tupleElement = this.getTupleElement();
                if (this.tupleElement != null) {
                    di = this.findDataItem((BusinessQueryProviderInterface)this.model, this.tupleElement);
                }
            }
        }
        return di;
    }

    private static boolean isMeasure(DataItem dataItem) {
        StructureOfDataItem dataItemStructure = dataItem.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && dataItem.getExpressionType() == 2 && dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }

    private DataItem findDataItem(BusinessQueryProviderInterface model, String uniqueLevelName) {
        DataItem dataItem = null;
        try {
            BusinessQuery businessQuery = model.getBusinessQuery();
            BusinessModel businessModel = businessQuery.getBusinessModel();
            if (businessModel == null) {
                return null;
            }
            StructureOfData structure = businessModel.getStructure();
            if (structure.isOLAP()) {
                dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem(businessQuery, (OLAPDataSetInterface)model, uniqueLevelName, 3);
            } else if (structure.isRelational()) {
                AxisInterface axis = this.getAxis((OLAPDataSetInterface)model, uniqueLevelName);
                int relativeIndex = this.getLevelIndex((OLAPDataSetInterface)model, uniqueLevelName);
                String[] dimensionNames = axis.getDimensionNames();
                HashMap dimensionNameMap = new HashMap();
                int nDimensions = 0;
                for (int i = 0; i <= relativeIndex; ++i) {
                    if (dimensionNameMap.containsKey(dimensionNames[i])) continue;
                    dimensionNameMap.put(dimensionNames[i], null);
                    ++nDimensions;
                }
                Role role = Role.COLUMN;
                if (axis.getAxisNumber() == 1) {
                    role = Role.ROW;
                }
                List resultItems = businessQuery.getResultItems(role);
                if (nDimensions > 0) {
                    boolean measuresFound = false;
                    for (int i = 0; i < resultItems.size(); ++i) {
                        DataItem di = (DataItem)resultItems.get(i);
                        if (BaseTupleElementCommand.isMeasure(di)) {
                            if (measuresFound) continue;
                            measuresFound = true;
                        }
                        if (--nDimensions != 0) continue;
                        return di;
                    }
                }
            }
        }
        catch (OLAPException oLAPException) {
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return dataItem;
    }

    protected DataItem findDataItem(BusinessQueryProviderInterface model, TupleElementInterface tupleElement) {
        DataItem dataItem;
        block7: {
            dataItem = null;
            try {
                String label;
                BusinessQuery businessQuery = model.getBusinessQuery();
                BusinessModel businessModel = businessQuery.getBusinessModel();
                if (businessModel == null) {
                    return null;
                }
                StructureOfData structure = businessModel.getStructure();
                if (structure.isOLAP()) {
                    dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem(businessQuery, null, tupleElement, 1);
                    break block7;
                }
                if (!structure.isRelational()) break block7;
                AxisInterface axis = tupleElement.getTuple().getAxis();
                Role role = Role.COLUMN;
                if (axis.getAxisNumber() == 1) {
                    role = Role.ROW;
                }
                if ((label = tupleElement.getLabel()) == null) break block7;
                List resultItems = businessQuery.getResultItems(role);
                int size = resultItems.size();
                for (int i = 0; i < size; ++i) {
                    DataItem di = (DataItem)resultItems.get(i);
                    if (!label.equals(di.getLabel())) continue;
                    dataItem = di;
                    break;
                }
            }
            catch (OLAPException oLAPException) {
            }
            catch (MetadataException metadataException) {
                // empty catch block
            }
        }
        return dataItem;
    }

    public DataItem getDataItem() {
        if (this._dataItem == null) {
            this._dataItem = this._getDataItem();
        }
        return this._dataItem;
    }

    public void setDataItem(DataItem di) {
        this._dataItem = di;
        if (this._dataItem != null) {
            this.dataItemExplicitlySet = true;
        }
    }

    public void setUniqueLevelName(String uniqueLevelName) {
        this.uniqueLevelName = uniqueLevelName;
    }

    public String getUniqueLevelName() {
        return this.uniqueLevelName;
    }

    public void setTupleElement(TupleElementInterface tupleElement) {
        this.tupleElement = tupleElement;
    }

    public TupleElementInterface getTupleElement() {
        if (this.tupleElement == null && !this.isSwing() && this.getTupleIndex() >= 0) {
            try {
                if (this.model != null && this.model instanceof OLAPDataSetInterface) {
                    ResultSetMetadataInterface rsm = this.model.getResultSetMetadata();
                    TupleElementInterface[] tupleElements = rsm.getElements(this.axisIndex.intValue(), this.tupleIndex.intValue(), this.tupleElementIndex.intValue(), 1);
                    this.tupleElement = tupleElements[0];
                }
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return this.tupleElement;
    }

    public void setTupleElementIndex(Integer tupleElementIndex) {
        this.tupleElementIndex = tupleElementIndex;
    }

    public Integer getTupleElementIndex() {
        return this.tupleElementIndex;
    }

    public void setTupleIndex(Integer tupleIndex) {
        this.tupleIndex = tupleIndex;
    }

    public Integer getTupleIndex() {
        return this.tupleIndex;
    }

    public void setAxisIndex(Integer axisIndex) {
        this.axisIndex = axisIndex;
    }

    public Integer getAxisIndex() {
        try {
            this.model = this.getModel();
            this.uniqueLevelName = this.getUniqueLevelName();
            if (this.uniqueLevelName != null) {
                this.getLevelIndex(this.model, this.uniqueLevelName);
            }
            if (this.axisIndex == null && this.isSwing()) {
                this.tupleElement = this.getTupleElement();
                if (this.tupleElement != null) {
                    this.axisIndex = new Integer(this.tupleElement.getTuple().getAxis().getAxisNumber());
                }
            }
        }
        catch (OLAPException e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        return this.axisIndex;
    }

    protected AxisInterface getAxis(OLAPDataSetInterface model, String uniqueLevelName) {
        this.extractInfo(model, uniqueLevelName);
        return this.axis;
    }

    protected int getLevelIndex(OLAPDataSetInterface model, String uniqueLevelName) {
        this.extractInfo(model, uniqueLevelName);
        return this.levelIndex;
    }

    private void extractInfo(OLAPDataSetInterface model, String uniqueLevelName) {
        block5: {
            try {
                this.levelIndex = -1;
                if (this.isSwing()) {
                    this.axisIndex = null;
                }
                if (uniqueLevelName == null) break block5;
                ResultSetMetadataInterface rsm = model.getResultSetMetadata();
                AxisInterface[] axes = rsm.getAxes(0, -1);
                for (int i = 0; i < axes.length; ++i) {
                    String[] uniqueLevelNames = axes[i].getUniqueLevelNames();
                    for (int j = 0; j < uniqueLevelNames.length; ++j) {
                        if (!uniqueLevelName.equals(uniqueLevelNames[j])) continue;
                        this.levelIndex = j;
                        break;
                    }
                    if (this.levelIndex < 0) continue;
                    this.axisIndex = new Integer(i);
                    this.axis = axes[i];
                    break;
                }
            }
            catch (OLAPException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected boolean isAllMemberNotSupported(TupleElementInterface tupleElement) throws OLAPException {
        return tupleElement.getLevelDepth() == 0 && tupleElement.getTuple().getAxis().getTupleCount() > 1;
    }

    private boolean isSameElement(TupleElementInterface tupleElement, TupleInterface prevTuple) throws OLAPException {
        AxisInterface axis;
        int cnt;
        int maxCoordinate;
        int i = 0;
        boolean goToNext = true;
        if (prevTuple != null) {
            int depth = prevTuple.getTupleDepth();
            while (i < depth) {
                TupleElementInterface nextElement;
                if (!(nextElement = prevTuple.getElement(i++)).getName().equals(tupleElement.getName())) continue;
                if (nextElement.isContextual() && !tupleElement.isContextual()) {
                    return true;
                }
                if (!nextElement.isContextual() && !tupleElement.isContextual() && tupleElement.getLevelDepth() == 0) {
                    return true;
                }
                goToNext = false;
            }
        }
        if (goToNext && (maxCoordinate = tupleElement.getMaximumCoordinate()) < (cnt = (axis = tupleElement.getTuple().getAxis()).getTupleCount()) - 1 && maxCoordinate >= 0) {
            TupleInterface nextTuple = axis.getTuple(maxCoordinate + 1);
            int depth = nextTuple.getTupleDepth();
            i = 0;
            while (i < depth) {
                TupleElementInterface nextElement;
                if (!(nextElement = nextTuple.getElement(i++)).getName().equals(tupleElement.getName())) continue;
                if (nextElement.isContextual() && !tupleElement.isContextual()) {
                    return true;
                }
                if (nextElement.isContextual() || tupleElement.isContextual() || tupleElement.getLevelDepth() != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isPreSummarizedTotal(TupleElementInterface tupleElement) throws OLAPException {
        int minCoordinate = tupleElement.getMinimumCoordinate();
        AxisInterface axis = tupleElement.getTuple().getAxis();
        int cnt = axis.getTupleCount();
        if (minCoordinate >= 0 && minCoordinate < cnt) {
            TupleInterface prevTuple = null;
            if (minCoordinate > 0) {
                prevTuple = axis.getTuple(minCoordinate - 1);
            }
            return this.isSameElement(tupleElement, prevTuple);
        }
        return false;
    }

    protected int isExpandPresent(TupleElementInterface tupleElement) throws OLAPException {
        List steps;
        DataItem di = this.getDataItem();
        if (di != null && (steps = di.getSteps()) != null && steps.size() > 0) {
            int lastStepIndex;
            for (int i = lastStepIndex = steps.size() - 1; i >= 0; --i) {
                StepInterface lastStep = (StepInterface)steps.get(i);
                if (!(lastStep instanceof DataItemNavigationFilter)) continue;
                int actionType = ((StepFilterInterface)lastStep).getActionType();
                if (((DataItemNavigationFilter)lastStep).getNavigationFilterType() == 4 && actionType == 6 && tupleElement.getName().equals(((DataItemNavigationFilter)lastStep).getNavigationName())) {
                    return i;
                }
                if (actionType == 0) break;
            }
        }
        return -1;
    }

    protected int isExpandPresent(List steps, String elementName) {
        if (steps != null && steps.size() > 0) {
            int lastStepIndex;
            for (int i = lastStepIndex = steps.size() - 1; i >= 0; --i) {
                StepInterface lastStep = (StepInterface)steps.get(i);
                if (!(lastStep instanceof DataItemNavigationFilter)) continue;
                int actionType = ((StepFilterInterface)lastStep).getActionType();
                if (((DataItemNavigationFilter)lastStep).getNavigationFilterType() == 4 && actionType == 6 && elementName.equals(((DataItemNavigationFilter)lastStep).getNavigationName())) {
                    return i;
                }
                if (actionType == 0) break;
            }
        }
        return -1;
    }

    protected int isExpandPresentForExpandAll(List steps, String elementName) {
        if (steps != null && steps.size() > 0) {
            int lastStepIndex;
            for (int i = lastStepIndex = steps.size() - 1; i >= 0; --i) {
                StepInterface lastStep = (StepInterface)steps.get(i);
                if (lastStep instanceof DataItemNavigationFilter) {
                    int actionType = ((StepFilterInterface)lastStep).getActionType();
                    if (((DataItemNavigationFilter)lastStep).getNavigationFilterType() == 4 && actionType == 6 && elementName.equals(((DataItemNavigationFilter)lastStep).getNavigationName())) {
                        return i;
                    }
                    if (actionType != 0) continue;
                    break;
                }
                if (lastStep instanceof DataItemMemberFilter) break;
            }
        }
        return -1;
    }
}

