/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.totals.OLAPTotalsSelectorInterface;
import com.sas.dataselectors.totals.RelationalTotalsSelectorInterface;
import com.sas.dataselectors.totals.TotalsSelectorAdapterFactory;
import com.sas.dataselectors.totals.TotalsSelectorInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.BusinessQueryTotalLocationType;
import com.sas.iquery.metadata.business.BusinessQueryTotalModeType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.expr.ExpressionInterface;
import com.sas.iquery.metadata.expr.FractionOfTotalExpression;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import java.io.IOException;
import java.util.List;

public class TotalsCommand
extends BaseSelectorCommand
implements CommandSupportedInterface {
    private Object adapter = null;
    public String rowTotals;
    public String rowSubtotals;
    public String columnTotals;
    public String columnSubtotals;
    public String expandedTotals;
    public String totalsType;
    public String totalsPosition;
    public static final String TOTALS_SELECTOR_COMMAND_COMMITTED = "TOTALS_SELECTOR_COMMAND_COMMITTED";
    private boolean isJSP;

    public TotalsCommand() {
        this.initializeFlags(true);
    }

    public TotalsCommand(boolean isJSP) {
        this.initializeFlags(isJSP);
    }

    public TotalsCommand(String name) {
        super(name);
        this.initializeFlags(true);
    }

    public TotalsCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    private void initializeFlags(boolean isJSP) {
        this.isJSP = isJSP;
        this.rowTotals = "0";
        this.rowSubtotals = "0";
        this.columnTotals = "0";
        this.columnSubtotals = "0";
        this.expandedTotals = "0";
        this.totalsPosition = "T";
        this.totalsType = "U";
    }

    protected void show(Object o) {
        BusinessQuery dataModel = this.getDataModel(this.model);
        this.adapter = dataModel.getInputStructure().isOLAP() || this.model instanceof OLAPDataSetInterface ? TotalsSelectorAdapterFactory.getOLAPAdapter(dataModel) : TotalsSelectorAdapterFactory.getRelationalAdapter(dataModel);
        ((TotalsSelectorInterface)this.adapter).valuesFromDataModel(true);
        this.setSelectorModel(this.adapter);
        this.selector.setSelectorModel(this.adapter);
        super.show(o);
    }

    protected void commit(Object o) throws IOException {
        this.adapter = this.selectorModel != null ? this.selectorModel : this.getSelector().getSelectorModel();
        ((TotalsSelectorInterface)this.adapter).valuesFromDataModel(false);
        if (this.isJSP) {
            this.updateAdapter();
        }
        BusinessQuery dataModel = this.getDataModel(this.model);
        try {
            if (this.adapter instanceof OLAPTotalsSelectorInterface) {
                if (!(((OLAPTotalsSelectorInterface)this.adapter).rowTotals() && ((OLAPTotalsSelectorInterface)this.adapter).rowSubtotals() || dataModel.getTotalType(Role.COLUMN) == BusinessQuery.TOTAL_NONE)) {
                    this.validateCellSorts(Role.ROW, dataModel);
                }
                if (!(((OLAPTotalsSelectorInterface)this.adapter).columnTotals() && ((OLAPTotalsSelectorInterface)this.adapter).columnSubtotals() || dataModel.getTotalType(Role.ROW) == BusinessQuery.TOTAL_NONE)) {
                    this.validateCellSorts(Role.COLUMN, dataModel);
                }
            }
            dataModel.setTotalType(BusinessQuery.TOTAL_NONE, Role.ROW);
            dataModel.setTotalType(BusinessQuery.TOTAL_NONE, Role.COLUMN);
            if (this.adapter instanceof RelationalTotalsSelectorInterface) {
                if (((TotalsSelectorInterface)this.adapter).columnTotals()) {
                    dataModel.setTotalType(BusinessQuery.GRANDTOTAL, Role.COLUMN);
                }
            } else {
                if (((OLAPTotalsSelectorInterface)this.adapter).isGoingToRemovePercentOfTotal()) {
                    this.synchPercentOfTotals(dataModel);
                }
                if (((OLAPTotalsSelectorInterface)this.adapter).rowTotals() && !((OLAPTotalsSelectorInterface)this.adapter).rowSubtotals()) {
                    dataModel.setTotalType(BusinessQuery.AXISTOTAL, Role.COLUMN);
                } else if (!((OLAPTotalsSelectorInterface)this.adapter).rowTotals() && ((OLAPTotalsSelectorInterface)this.adapter).rowSubtotals()) {
                    dataModel.setTotalType(BusinessQuery.SUBTOTAL, Role.COLUMN);
                } else if (((OLAPTotalsSelectorInterface)this.adapter).rowTotals() && ((OLAPTotalsSelectorInterface)this.adapter).rowSubtotals()) {
                    dataModel.setTotalType(BusinessQuery.ALLTOTAL, Role.COLUMN);
                }
                if (((OLAPTotalsSelectorInterface)this.adapter).columnTotals() && !((OLAPTotalsSelectorInterface)this.adapter).columnSubtotals()) {
                    dataModel.setTotalType(BusinessQuery.AXISTOTAL, Role.ROW);
                } else if (!((OLAPTotalsSelectorInterface)this.adapter).columnTotals() && ((OLAPTotalsSelectorInterface)this.adapter).columnSubtotals()) {
                    dataModel.setTotalType(BusinessQuery.SUBTOTAL, Role.ROW);
                } else if (((OLAPTotalsSelectorInterface)this.adapter).columnTotals() && ((OLAPTotalsSelectorInterface)this.adapter).columnSubtotals()) {
                    dataModel.setTotalType(BusinessQuery.ALLTOTAL, Role.ROW);
                }
                BusinessQueryTotalModeType bqtmt = "U".equals(((OLAPTotalsSelectorInterface)this.adapter).getTotalsType()) ? BusinessQueryTotalModeType.CUBE_VALUES : BusinessQueryTotalModeType.VISUAL_VALUES;
                dataModel.setTotalMode(bqtmt);
                BusinessQueryTotalLocationType bqtlt = "T".equals(((OLAPTotalsSelectorInterface)this.adapter).getTotalsPosition()) ? BusinessQueryTotalLocationType.TOTAL_TOTAL_ROW_TOP_COLUMN_LEFT : BusinessQueryTotalLocationType.TOTAL_ROW_BOTTOM_COLUMN_RIGHT;
                dataModel.setTotalLocation(bqtlt);
                dataModel.setAxisValuesCoalesced(!((OLAPTotalsSelectorInterface)this.adapter).isExpandedTotals());
            }
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        try {
            if (this.model instanceof BusinessQueryProviderInterface) {
                ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(dataModel);
                this.initializeFlags(this.isJSP);
                this.eventSource = this.model;
                this.contentsChanged = true;
                this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
                this.eventInfo.put(TOTALS_SELECTOR_COMMAND_COMMITTED, TOTALS_SELECTOR_COMMAND_COMMITTED);
            }
        }
        catch (IntelligentQueryException intelligentQueryException) {
            // empty catch block
        }
        super.commit(o);
    }

    private void validateCellSorts(Role role, BusinessQuery businessQuery) {
        List sortCriteria = businessQuery.getSortCriteria(role);
        for (Object member : sortCriteria) {
            if (member instanceof String) {
                if (!(this.model instanceof OLAPDataSetInterface)) continue;
                try {
                    MetadataInterface metadata = null;
                    metadata = ((OLAPDataSetInterface)this.model).getDatabaseMetadata();
                    if (metadata == null) continue;
                    Filter filter = new Filter();
                    filter.setCubeName(((OLAPDataSetInterface)this.model).getCubeName());
                    filter.setUniqueMemberName((String)member);
                    try {
                        metadata.getMembers(filter, 0, -1);
                    }
                    catch (OLAPException ex) {
                        businessQuery.setSortDirection(BusinessQueryActionType.SORT_NONE, role);
                        businessQuery.setSortCriteria(null, role);
                    }
                }
                catch (OLAPException metadata) {
                }
                catch (MetadataException metadata) {}
                continue;
            }
            if (!(member instanceof String[])) continue;
            int arraySize = ((String[])member).length;
            for (int i = 0; i < arraySize; ++i) {
                String memberString = ((String[])member)[i];
                if (!(this.model instanceof OLAPDataSetInterface)) continue;
                try {
                    MetadataInterface metadata = ((OLAPDataSetInterface)this.model).getDatabaseMetadata();
                    if (metadata == null) continue;
                    Filter filter = new Filter();
                    filter.setCubeName(((OLAPDataSetInterface)this.model).getCubeName());
                    filter.setUniqueMemberName(memberString);
                    try {
                        metadata.getMembers(filter, 0, -1);
                    }
                    catch (OLAPException ex) {
                        businessQuery.setSortDirection(BusinessQueryActionType.SORT_NONE, role);
                        businessQuery.setSortCriteria(null, Role.ROW);
                    }
                    continue;
                }
                catch (OLAPException oLAPException) {
                    continue;
                }
                catch (MetadataException metadataException) {
                    // empty catch block
                }
            }
        }
    }

    private void synchPercentOfTotals(BusinessQuery dataModel) {
        if (dataModel != null) {
            for (DataItem dataItem : dataModel.getBusinessModel().getObjects(true, DataItem.class)) {
                ExpressionInterface exp = dataItem.getExpression();
                if (!(exp instanceof FractionOfTotalExpression)) continue;
                switch (((FractionOfTotalExpression)exp).getDenominatorType()) {
                    case 5: {
                        if (((OLAPTotalsSelectorInterface)this.adapter).columnSubtotals()) break;
                        this.removeDataItem(dataModel, dataItem);
                        break;
                    }
                    case 3: {
                        if (((OLAPTotalsSelectorInterface)this.adapter).columnTotals()) break;
                        this.removeDataItem(dataModel, dataItem);
                        break;
                    }
                    case 1: {
                        if (((OLAPTotalsSelectorInterface)this.adapter).columnTotals() && ((OLAPTotalsSelectorInterface)this.adapter).rowTotals()) break;
                        this.removeDataItem(dataModel, dataItem);
                        break;
                    }
                    case 4: {
                        if (((OLAPTotalsSelectorInterface)this.adapter).rowSubtotals()) break;
                        this.removeDataItem(dataModel, dataItem);
                        break;
                    }
                    case 2: {
                        if (((OLAPTotalsSelectorInterface)this.adapter).rowTotals()) break;
                        this.removeDataItem(dataModel, dataItem);
                        break;
                    }
                }
            }
        }
    }

    private void removeDataItem(BusinessQuery dataModel, DataItem dataItem) {
        if (dataModel != null && dataItem != null) {
            try {
                ((DataSelection)dataModel).removeResultItem(dataItem);
                ((DataSelection)dataModel).removeBusinessItem((BusinessItem)dataItem);
            }
            catch (MetadataException me) {
                throw new RuntimeException(me);
            }
        }
    }

    private BusinessQuery getDataModel(Object model) {
        BusinessQuery dataModel = null;
        if (model instanceof BusinessQueryProviderInterface) {
            dataModel = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        }
        return dataModel;
    }

    private void updateAdapter() {
        if (this.adapter != null) {
            ((TotalsSelectorInterface)this.adapter).columnTotals(this.columnTotals.equalsIgnoreCase("1"));
            if (this.adapter instanceof OLAPTotalsSelectorInterface) {
                ((OLAPTotalsSelectorInterface)this.adapter).rowSubtotals(this.rowSubtotals.equalsIgnoreCase("1"));
                ((OLAPTotalsSelectorInterface)this.adapter).rowTotals(this.rowTotals.equalsIgnoreCase("1"));
                ((OLAPTotalsSelectorInterface)this.adapter).columnSubtotals(this.columnSubtotals.equalsIgnoreCase("1"));
                ((OLAPTotalsSelectorInterface)this.adapter).setExpandedTotals(this.expandedTotals.equalsIgnoreCase("1"));
                ((OLAPTotalsSelectorInterface)this.adapter).setTotalsPosition(this.totalsPosition);
                ((OLAPTotalsSelectorInterface)this.adapter).setTotalsType(this.totalsType);
            }
        }
    }

    public void cancel() {
        super.cancel();
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        BusinessQuery bq;
        Object dataModel = actionFilter.getAttribute("model");
        if (dataModel instanceof BusinessQueryProviderInterface && (bq = ((BusinessQueryProviderInterface)dataModel).getBusinessQuery()) != null) {
            return bq.isActionSupported(BusinessQueryActionType.TOTAL);
        }
        return false;
    }

    public String getRowTotals() {
        return this.rowTotals;
    }

    public void setRowTotals(String value) {
        this.rowTotals = value;
    }

    public String getRowSubtotals() {
        return this.rowSubtotals;
    }

    public void setRowSubtotals(String value) {
        this.rowSubtotals = value;
    }

    public String getColumnTotals() {
        return this.columnTotals;
    }

    public void setColumnTotals(String value) {
        this.columnTotals = value;
    }

    public String getColumnSubtotals() {
        return this.columnSubtotals;
    }

    public void setColumnSubtotals(String value) {
        this.columnSubtotals = value;
    }

    public String getExpandedTotals() {
        return this.expandedTotals;
    }

    public void setExpandedTotals(String value) {
        this.expandedTotals = value;
    }

    public String getTotalsType() {
        return this.totalsType;
    }

    public void setTotalsType(String value) {
        this.totalsType = value;
    }

    public String getTotalsPosition() {
        return this.totalsPosition;
    }

    public void setTotalsPosition(String value) {
        this.totalsPosition = value;
    }
}

