/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.calculateditems.BusinessQueryToCalculatedItemListAdapter;
import com.sas.dataselectors.calculateditems.CalculatedItemInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemListInterface;
import com.sas.dataselectors.calculateditems.CalculatedItemV2Interface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.swing.visuals.dataselectors.format.FormatTypeAdapterInterface;
import com.sas.util.UncheckedException;
import com.sas.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SimpleCalculatedItemSelectorCommand
extends BaseSelectorCommand
implements CommandStatusInterface {
    private static final boolean debug = false;
    public static final String RB_KEY = "SimpleCalculatedItemSelectorCommand.";
    public static final String INVALID_ITEM_KEY = "invalidItem";
    protected CalculatedItemListInterface calculatedItemList;
    protected String nameEntry;
    protected String descriptionEntry;
    protected String expressionArea;
    protected String[] nameList;
    protected String[] descriptionList;
    protected String[] expressionList;
    protected String[] stateList;
    protected String[] idList;
    protected String[] formatList;
    private String formatEntry;
    protected List invalidItemList = new ArrayList();
    protected String[] functionList;
    protected String[] measureItems;
    protected String[] basePeriodList;
    public static final String ADD_STATE = "add";
    public static final String UPDATE_STATE = "update";
    public static final String DELETE_STATE = "delete";
    public static final String REPLACE_STATE = "replace";
    private Locale locale;

    public SimpleCalculatedItemSelectorCommand() {
        this.setDefaultLocale();
    }

    public SimpleCalculatedItemSelectorCommand(String name) {
        super(name);
        this.setDefaultLocale();
    }

    public SimpleCalculatedItemSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.setDefaultLocale();
    }

    private void setDefaultLocale() {
        this.locale = super.getLocale();
    }

    private Locale getDefaultLocale() {
        this.locale = super.getLocale();
        return this.locale;
    }

    protected void show(Object o) {
        this.model = this.getModel();
        if (this.model != null) {
            this.calculatedItemList = this.getAdapter(this.model);
            DataSelectorInterface calcSelector = this.getSelector();
            calcSelector.setSelectorModel((Object)this.calculatedItemList);
            calcSelector.setVisible(true);
        }
        this.setComplete(false);
    }

    protected void process(Object o) {
        super.process(o);
        this.eventInfo.clear();
        this.eventInfo.put("request", this.getAttribute("request"));
        this.eventInfo.put("response", this.getAttribute("response"));
        if (this.calculatedItemList.getFormatAdapter() instanceof FormatTypeAdapterInterface) {
            ((FormatTypeAdapterInterface)this.calculatedItemList.getFormatAdapter()).setFormat(this.getFormatEntry());
        }
        this.setComplete(false);
    }

    protected void commit(Object o) throws IOException {
        this.calculatedItemList = (CalculatedItemListInterface)this.getSelector().getSelectorModel();
        this.invalidItemList = null;
        this.invalidItemList = new ArrayList();
        this.processCalculatedItems();
        boolean invalidItems = true;
        if (this.invalidItemList.isEmpty()) {
            invalidItems = false;
            boolean listChangesCommitted = this.calculatedItemList.commitChanges();
            this.model = this.getModel();
            if (this.model != null) {
                BusinessQueryProviderInterface bqpinterface = (BusinessQueryProviderInterface)this.model;
                BusinessQuery bquery = bqpinterface.getBusinessQuery();
                try {
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(bquery);
                }
                catch (IntelligentQueryException e) {
                    throw new UncheckedException((Throwable)e, null);
                }
            }
        }
        this.contentsChanged = true;
        this.eventSource = this.getModel();
        this.eventInfo.clear();
        this.eventInfo.put("request", this.getAttribute("request"));
        this.eventInfo.put("response", this.getAttribute("response"));
        if (!invalidItems) {
            super.commit(o);
            if (this.calculatedItemList.getLevelHasMembers()) {
                if (this.getHasMeasuresOnRow()) {
                    this.eventInfo.put("ROW", "INITIALIZE");
                } else {
                    this.eventInfo.put("COLUMN", "INITIALIZE");
                }
            }
            this.closeSelector();
        } else {
            this.eventInfo.put(INVALID_ITEM_KEY, this.invalidItemList);
        }
        this.nameList = null;
        this.descriptionList = null;
        this.expressionList = null;
        this.stateList = null;
        this.idList = null;
        this.formatList = null;
        this.functionList = null;
        this.basePeriodList = null;
    }

    public DataItem getMeasureItem(String measureName, CalculatedItemV2Interface item) {
        DataItem measure = null;
        this.model = this.getModel();
        if (this.model instanceof BusinessQueryProviderInterface && this.model instanceof OLAPDataSetInterface) {
            BusinessQueryProviderInterface businessQueryProvider = (BusinessQueryProviderInterface)this.model;
            BusinessQuery businessQuery = businessQueryProvider.getBusinessQuery();
            String key = null;
            measureName = measureName.trim();
            Map m = item.getMeasureNameMap();
            if (m.containsKey(measureName)) {
                key = measureName;
            } else {
                for (Map.Entry me : m.entrySet()) {
                    String value = (String)me.getValue();
                    if (Util.equal((Object)value, (Object)measureName)) {
                        key = (String)me.getKey();
                        break;
                    }
                    key = null;
                }
            }
            if (key != null) {
                List dataItems = businessQuery.getBusinessModel().getObjects(true, DataItem.class);
                for (DataItem dataItem : dataItems) {
                    if (!dataItem.getLabel().equals(key)) continue;
                    return dataItem;
                }
            }
        }
        return measure;
    }

    public CalculatedItemListInterface getAdapter(Object model) {
        BusinessQueryToCalculatedItemListAdapter adapter = null;
        BusinessQuery businessQuery = null;
        if (model != null) {
            if (model instanceof BusinessQueryProviderInterface) {
                BusinessQueryProviderInterface businessQueryProvider = (BusinessQueryProviderInterface)model;
                businessQuery = businessQueryProvider.getBusinessQuery();
                adapter = new BusinessQueryToCalculatedItemListAdapter(businessQueryProvider, this.getDefaultLocale());
            } else {
                throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"invalidModelType.txt"));
            }
        }
        return adapter;
    }

    public String getNameEntry() {
        return this.nameEntry;
    }

    public void setNameEntry(String name) {
        this.nameEntry = name;
    }

    public String getDescriptionEntry() {
        return this.descriptionEntry;
    }

    public void setDescriptionEntry(String description) {
        this.descriptionEntry = description;
    }

    public String getExpressionArea() {
        return this.expressionArea;
    }

    public void setExpressionArea(String expression) {
        this.expressionArea = expression;
    }

    public String[] getNameList() {
        return this.nameList;
    }

    public void setNameList(String[] names) {
        this.nameList = names;
    }

    public String[] getDescriptionList() {
        return this.descriptionList;
    }

    public void setDescriptionList(String[] descriptions) {
        this.descriptionList = descriptions;
    }

    public String[] getExpressionList() {
        return this.expressionList;
    }

    public void setExpressionList(String[] expressions) {
        this.expressionList = expressions;
    }

    public String[] getStateList() {
        return this.stateList;
    }

    public String[] getFormatList() {
        return this.formatList;
    }

    public void setFormatList(String[] formats) {
        this.formatList = formats;
    }

    public String[] getFunctionList() {
        return this.functionList;
    }

    public String[] getBasePeriodList() {
        return this.basePeriodList;
    }

    public void setStateList(String[] states) {
        this.stateList = states;
    }

    public void setFunctionList(String[] functionList) {
        this.functionList = functionList;
    }

    public void setBasePeriodList(String[] basePeriods) {
        this.basePeriodList = basePeriods;
    }

    public String[] getIdList() {
        return this.idList;
    }

    public void setIdList(String[] names) {
        this.idList = names;
    }

    protected int getCalculatedItemIndex(String calculatedItemId) {
        int itemContained = -1;
        CalculatedItemListInterface calculatedItemList = (CalculatedItemListInterface)this.getSelector().getSelectorModel();
        List items = calculatedItemList.getCalculatedItemList();
        int i = 0;
        for (CalculatedItemInterface item : items) {
            if (item.getId() != null && item.getId().equals(calculatedItemId)) {
                itemContained = i;
                break;
            }
            ++i;
        }
        return itemContained;
    }

    protected void processCalculatedItems() {
        if (this.nameList != null && this.isClientCalculatedItemListValid()) {
            for (int i = 0; i < this.nameList.length; ++i) {
                if (this.stateList[i].equals(ADD_STATE)) {
                    this.addItem(i);
                    continue;
                }
                if (this.stateList[i].equals(UPDATE_STATE)) {
                    this.updateItem(i);
                    continue;
                }
                if (this.stateList[i].equals(REPLACE_STATE)) {
                    this.replaceItem(i);
                    continue;
                }
                if (!this.stateList[i].equals(DELETE_STATE)) continue;
                this.deleteItem(i);
            }
        }
    }

    private boolean isClientCalculatedItemListValid() {
        boolean allItemsValid = true;
        CalculatedItemInterface itemToValidate = null;
        if (this.nameList != null) {
            for (int i = 0; i < this.nameList.length; ++i) {
                if (this.stateList[i].equals(DELETE_STATE)) continue;
                itemToValidate = this.createItem(i);
                if (!itemToValidate.validate()) {
                    this.invalidItemList.add(itemToValidate.getLabel());
                    allItemsValid = false;
                }
                itemToValidate = null;
            }
        }
        return allItemsValid;
    }

    private CalculatedItemInterface createItem(int clientIndex) {
        DataSelectorInterface selector = this.getSelector();
        CalculatedItemListInterface calculatedItemList = (CalculatedItemListInterface)selector.getSelectorModel();
        CalculatedItemInterface calculatedItem = calculatedItemList.newCalculatedItem();
        calculatedItem.setLabel(this.nameList[clientIndex]);
        calculatedItem.setDescription(this.descriptionList[clientIndex]);
        calculatedItem.setExpression(this.expressionList[clientIndex]);
        if (calculatedItem instanceof CalculatedItemV2Interface) {
            ((CalculatedItemV2Interface)calculatedItem).setLocale(this.getLocale());
            ((CalculatedItemV2Interface)calculatedItem).setTimeFunction(this.functionList[clientIndex]);
            ((CalculatedItemV2Interface)calculatedItem).setBasePeriod(this.basePeriodList[clientIndex]);
            if (((CalculatedItemV2Interface)calculatedItem).isTimeBasedItem()) {
                ((CalculatedItemV2Interface)calculatedItem).setMeasureExpression((Object)this.expressionList[clientIndex]);
                Object measureName = ((CalculatedItemV2Interface)calculatedItem).getMeasureExpression();
                if (measureName == null) {
                    this.invalidItemList.add(calculatedItem);
                }
            }
        }
        if (this.formatList[clientIndex] != null && this.formatList[clientIndex].trim().length() > 0) {
            calculatedItem.setFormat(this.formatList[clientIndex]);
        } else {
            calculatedItem.setFormat(null);
        }
        if (!calculatedItemList.getLevelHasMembers()) {
            calculatedItem.setExpressionType(2);
        } else {
            calculatedItem.setExpressionType(-2);
            this.forceFormat(calculatedItem);
        }
        return calculatedItem;
    }

    private String getMeasureNameFromExpression(String text) {
        int startIndex = text.lastIndexOf("(");
        int endIndex = text.lastIndexOf(")");
        return startIndex < 0 || endIndex < 1 ? "" : text.substring(startIndex + 1, endIndex);
    }

    protected void addItem(int clientIndex) {
        CalculatedItemInterface calculatedItem = this.createItem(clientIndex);
        this.calculatedItemList.addCalculatedItem(calculatedItem);
    }

    protected void updateItem(int clientIndex) {
        int serverIndex = this.getCalculatedItemIndex(this.idList[clientIndex]);
        if (serverIndex >= 0) {
            this.calculatedItemList.setSelectionCursor(serverIndex);
            CalculatedItemInterface item = this.calculatedItemList.getSelectedCalculatedItem();
            item.setLabel(this.nameList[clientIndex]);
            item.setDescription(this.descriptionList[clientIndex]);
            item.setExpression(this.expressionList[clientIndex]);
            if (this.functionList.length >= clientIndex && item instanceof CalculatedItemV2Interface) {
                ((CalculatedItemV2Interface)item).setLocale(this.getLocale());
                ((CalculatedItemV2Interface)item).setTimeFunction(this.functionList[clientIndex]);
                ((CalculatedItemV2Interface)item).setBasePeriod(this.basePeriodList[clientIndex]);
                if (((CalculatedItemV2Interface)item).isTimeBasedItem()) {
                    ((CalculatedItemV2Interface)item).setMeasureExpression((Object)this.expressionList[clientIndex]);
                }
            }
            if (this.formatList[clientIndex] != null && this.formatList[clientIndex].trim().length() > 0) {
                item.setFormat(this.formatList[clientIndex]);
            } else {
                item.setFormat(null);
            }
            if (this.calculatedItemList.getLevelHasMembers()) {
                this.forceFormat(item);
            }
        }
    }

    protected void deleteItem(int clientIndex) {
        int serverIndex = this.getCalculatedItemIndex(this.idList[clientIndex]);
        if (serverIndex >= 0) {
            this.calculatedItemList.setSelectionCursor(serverIndex);
            this.calculatedItemList.removeSelectedCalculatedItem();
        }
    }

    private void replaceItem(int clientIndex) {
        this.deleteItem(clientIndex);
        this.addItem(clientIndex);
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        Object dataModel = filter.getAttribute("model");
        if (dataModel instanceof BusinessQueryProviderInterface) {
            BusinessQuery bq = ((BusinessQueryProviderInterface)dataModel).getBusinessQuery();
            if (bq != null && (!bq.isActionSupported(BusinessQueryActionType.RESULT_ITEM) || this.allQueryItemsAreDetailUsage(bq))) {
                return 4;
            }
        } else {
            return 1;
        }
        return 0;
    }

    private boolean allQueryItemsAreDetailUsage(BusinessQuery bquery) {
        boolean returnValue = true;
        List resultItems = bquery.getResultItems();
        DataItem thisitem = null;
        if (resultItems.size() == 0) {
            returnValue = false;
        }
        int count2 = resultItems.size();
        for (int j = 0; j < count2; ++j) {
            thisitem = (DataItem)resultItems.get(j);
            if (thisitem.getUsage() == DataItemActionType.USAGE_DETAIL) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    private boolean getHasMeasuresOnRow() {
        boolean measuresOnRow = false;
        this.model = this.getModel();
        if (this.model != null) {
            BusinessQueryProviderInterface bqpinterface = (BusinessQueryProviderInterface)this.model;
            BusinessQuery bquery = bqpinterface.getBusinessQuery();
            List resultItems = bquery.getResultItems();
            for (DataItem dataItem : resultItems) {
                if (!dataItem.getStructure().equals(StructureOfDataItem.STRUCTURE_MEASURE)) continue;
                try {
                    if (!bquery.getResultItemRole(dataItem).equals(Role.ROW)) continue;
                    measuresOnRow = true;
                    break;
                }
                catch (MetadataException e) {
                    throw new UncheckedException((Throwable)e, null);
                }
            }
        }
        return measuresOnRow;
    }

    private void forceFormat(CalculatedItemInterface calculatedItem) {
        if (calculatedItem.getFormat() == null) {
            String function;
            if (calculatedItem.getExpression().indexOf("/") != -1) {
                calculatedItem.setFormat("BEST12.2");
            } else if (calculatedItem instanceof CalculatedItemV2Interface && ((function = ((CalculatedItemV2Interface)calculatedItem).getTimeFunction()) == "PERCENTCHANGE_PREVIOUS_YEAR" || function == "PERCENTCHANGE_PREVIOUS_PERIOD")) {
                calculatedItem.setFormat("PERCENT10.2");
            }
        }
    }

    private void dumpBusinessQuery(BusinessQuery bquery) {
    }

    private void dumpCalculatedItemList() {
    }

    private void dumpEventInfo(String message) {
    }

    private void dumpInvalidItemList() {
    }

    public String getFormatEntry() {
        return this.formatEntry;
    }

    public void setFormatEntry(String formatEntry) {
        this.formatEntry = formatEntry;
    }

    public void cancel(Object o) {
        super.cancel(o);
        this.closeSelector();
    }
}

