/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.ContentsChangedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.sort.OLAPSortSelectorInterface;
import com.sas.dataselectors.sort.OLAPSortSelectorModelFactory;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.Role;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.swing.visuals.dataselectors.sort.SortedItem;
import com.sas.util.PreorderTreeModelIterator;
import com.sas.util.SortDirectionInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class OLAPSortSelectorCommand
extends BaseSelectorCommand
implements SortDirectionInterface,
ContentsChangedInterface,
CommandStatusInterface {
    private static boolean debug = true;
    protected boolean swing;
    public static final int HIERARCHICAL_ASCENDING = 3;
    public static final int HIERARCHICAL_DESCENDING = 4;
    private OLAPSortSelectorInterface sortAdapter;
    private String[] llSortedItems;
    private String[] llSortedDirections;
    private String llSortHierarchy;
    private String[] cvSortedItems;
    private String[] cvSortedDirections;
    private String cvSortHierarchy;

    public OLAPSortSelectorCommand() {
        this("");
    }

    public OLAPSortSelectorCommand(String name) {
        super(name);
        this.eventInfo = new HashMap(2);
    }

    public OLAPSortSelectorCommand(String name, boolean swing) {
        super(name);
        this.setSwing(swing);
        this.eventInfo = new HashMap(2);
    }

    public OLAPSortSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
        this.eventInfo = new HashMap(2);
    }

    protected void show(Object o) {
        this.sortAdapter = OLAPSortSelectorModelFactory.getAdapter((OLAPDataSetInterface)this.getModel());
        this.selector.setSelectorModel((Object)this.sortAdapter);
        super.show(o);
    }

    protected void commit(Object o) throws IOException {
        try {
            if (this.model instanceof BusinessQueryProviderInterface) {
                BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.model).getBusinessQuery();
                if (!this.swing) {
                    this.updateSortAdapterWithJSPChanges(this.sortAdapter);
                }
                TreeModel sortedLabels = this.sortAdapter.getSortedLevelLabelItems();
                int[] sortedLabelDirections = this.sortAdapter.getSortedLevelLabelDirections();
                boolean levelLabelHier = this.sortAdapter.isLevelLabelHierarchicalSort();
                ArrayList<DataItem> itemList = new ArrayList<DataItem>();
                PreorderTreeModelIterator iterator = new PreorderTreeModelIterator(sortedLabels);
                int i = 0;
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj instanceof DefaultMutableTreeNode) {
                        obj = ((DefaultMutableTreeNode)obj).getUserObject();
                    }
                    if (!(obj instanceof SortedItem)) continue;
                    String id = (String)((SortedItem)obj).getID();
                    DataItem di = (DataItem)businessQuery.getBusinessModel().getBusinessItemByID(id);
                    di.setSortDirection(this.getCurrentDataItemSortType(sortedLabelDirections[i], levelLabelHier));
                    itemList.add(di);
                    ++i;
                }
                TreeModel availableLabels = this.sortAdapter.getAvailableLevelLabelItems();
                iterator = new PreorderTreeModelIterator(availableLabels);
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj instanceof DefaultMutableTreeNode) {
                        obj = ((DefaultMutableTreeNode)obj).getUserObject();
                    }
                    if (!(obj instanceof SortedItem)) continue;
                    String id = (String)((SortedItem)obj).getID();
                    DataItem di = (DataItem)businessQuery.getBusinessModel().getBusinessItemByID(id);
                    di.setSortDirection(DataItemActionType.SORT_NONE);
                }
                TreeModel sortedCellValues = this.sortAdapter.getSortedCellValueItems();
                iterator = new PreorderTreeModelIterator(sortedCellValues);
                i = 0;
                Role sortRole = null;
                int[] sortedCellDirections = this.sortAdapter.getSortedCellValueDirections();
                boolean cellValueHier = this.sortAdapter.isCellValueHierarchicalSort();
                ArrayList rowList = new ArrayList();
                ArrayList<Object> columnList = new ArrayList<Object>();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj instanceof DefaultMutableTreeNode) {
                        obj = ((DefaultMutableTreeNode)obj).getUserObject();
                    }
                    if (!(obj instanceof SortedItem)) continue;
                    Object id = ((SortedItem)obj).getID();
                    if (id instanceof List) {
                        List idList = (List)id;
                        ArrayList<Object> list = columnList;
                        if (((SortedItem)obj).getRole() == 2) {
                            sortRole = Role.COLUMN;
                            list = columnList;
                        } else if (((SortedItem)obj).getRole() == 1) {
                            sortRole = Role.ROW;
                            list = rowList;
                        }
                        int size = idList.size();
                        for (int j = 0; j < size; ++j) {
                            Object element = idList.get(j);
                            if (element instanceof String && this.model instanceof OLAPDataSetInterface) {
                                DataItem di = BusinessQueryToOLAPDataSetAdapter.findDataItem(businessQuery, (OLAPDataSetInterface)this.model, element, 2);
                                if (di == null) {
                                    di = (DataItem)businessQuery.getBusinessModel().getBusinessItemByID((String)element);
                                }
                                if (di == null) {
                                    OLAPDataSetInterface olapModel = (OLAPDataSetInterface)this.model;
                                    TupleInterface[] tuples = null;
                                    tuples = sortRole == Role.ROW ? olapModel.getResultSetMetadata().getTuples(0, -12, -18) : olapModel.getResultSetMetadata().getTuples(1, -12, -18);
                                    if (tuples != null) {
                                        for (int m = 0; m < tuples.length && di == null; ++m) {
                                            TupleElementInterface[] elements = tuples[m].getElements(0, -1);
                                            if (elements == null) continue;
                                            for (int n = 0; n < elements.length && di == null; ++n) {
                                                String name = elements[n].getName();
                                                if (!element.equals(name)) continue;
                                                di = BusinessQueryToOLAPDataSetAdapter.findDataItem(businessQuery, (OLAPDataSetInterface)this.model, elements[n], 1);
                                            }
                                        }
                                    }
                                }
                                if (di != null && di.getStructure() == StructureOfDataItem.STRUCTURE_MEASURE) {
                                    list.add(di);
                                    continue;
                                }
                                list.add(element);
                                continue;
                            }
                            list.add(element);
                        }
                        businessQuery.setSortDirection(this.getCurrentBusinessQuerySortType(sortedCellDirections[i], cellValueHier), sortRole);
                    }
                    ++i;
                }
                businessQuery.setSortCriteria(rowList, Role.ROW);
                businessQuery.setSortCriteria(columnList, Role.COLUMN);
                this.executeQuery(businessQuery);
            }
        }
        catch (Exception e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        super.commit(o);
    }

    private void executeQuery(BusinessQuery businessQuery) throws OLAPException {
        try {
            if (!(this.model instanceof BusinessQueryProviderInterface)) {
                throw new IllegalStateException();
            }
            ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(businessQuery);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventSource = this.model;
        }
        catch (Exception e) {
            throw new OLAPException((Throwable)e);
        }
    }

    private DataItemActionType getCurrentDataItemSortType(int sortType, boolean hier) {
        DataItemActionType currentSortType;
        switch (sortType) {
            case 0: {
                if (hier) {
                    currentSortType = DataItemActionType.SORT_HIERARCHICAL_ASCENDING;
                    break;
                }
                currentSortType = DataItemActionType.SORT_ASCENDING;
                break;
            }
            case 1: {
                if (hier) {
                    currentSortType = DataItemActionType.SORT_HIERARCHICAL_DESCENDING;
                    break;
                }
                currentSortType = DataItemActionType.SORT_DESCENDING;
                break;
            }
            case 3: {
                currentSortType = DataItemActionType.SORT_HIERARCHICAL_ASCENDING;
                break;
            }
            case 4: {
                currentSortType = DataItemActionType.SORT_HIERARCHICAL_DESCENDING;
                break;
            }
            case 2: {
                currentSortType = DataItemActionType.SORT_NONE;
                break;
            }
            default: {
                currentSortType = DataItemActionType.SORT_NONE;
            }
        }
        return currentSortType;
    }

    private BusinessQueryActionType getCurrentBusinessQuerySortType(int sortType, boolean hier) {
        BusinessQueryActionType currentSortType;
        switch (sortType) {
            case 0: {
                if (hier) {
                    currentSortType = BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING;
                    break;
                }
                currentSortType = BusinessQueryActionType.SORT_ASCENDING;
                break;
            }
            case 1: {
                if (hier) {
                    currentSortType = BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING;
                    break;
                }
                currentSortType = BusinessQueryActionType.SORT_DESCENDING;
                break;
            }
            case 3: {
                currentSortType = BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING;
                break;
            }
            case 4: {
                currentSortType = BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING;
                break;
            }
            case 2: {
                currentSortType = BusinessQueryActionType.SORT_NONE;
                break;
            }
            default: {
                currentSortType = BusinessQueryActionType.SORT_NONE;
            }
        }
        return currentSortType;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        Object model = filter.getAttribute("model");
        if (model instanceof BusinessQueryProviderInterface) {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            if (businessQuery.isActionSupported(BusinessQueryActionType.SORT_NONE) || businessQuery.isActionSupported(BusinessQueryActionType.SORT_CRITERIA) || businessQuery.isActionSupported(BusinessQueryActionType.SORT_ASCENDING) || businessQuery.isActionSupported(BusinessQueryActionType.SORT_DESCENDING) || businessQuery.isActionSupported(BusinessQueryActionType.SORT_HIERARCHICAL_ASCENDING) || businessQuery.isActionSupported(BusinessQueryActionType.SORT_HIERARCHICAL_DESCENDING)) {
                return 0;
            }
            try {
                List items = businessQuery.getResultItems(Role.COLUMN);
                items.addAll(businessQuery.getResultItems(Role.ROW));
                int size = items.size();
                for (int i = 0; i < size; ++i) {
                    DataItem di = (DataItem)items.get(i);
                    if (!di.isActionSupported(DataItemActionType.SORT_NONE) && !di.isActionSupported(DataItemActionType.SORT_ASCENDING) && !di.isActionSupported(DataItemActionType.SORT_DESCENDING) && !di.isActionSupported(DataItemActionType.SORT_HIERARCHICAL_ASCENDING) && !di.isActionSupported(DataItemActionType.SORT_HIERARCHICAL_DESCENDING)) continue;
                    return 0;
                }
            }
            catch (MetadataException e) {
                LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        return 4;
    }

    public void setSwing(boolean swing) {
        this.swing = swing;
    }

    public boolean isSwing() {
        return this.swing;
    }

    public String[] getLevelLabelSortedItems() {
        return this.llSortedItems;
    }

    public void setLevelLabelSortedItems(String[] items) {
        this.llSortedItems = items;
    }

    public String[] getLevelLabelSortedDirections() {
        return this.llSortedDirections;
    }

    public void setLevelLabelSortedDirections(String[] directions) {
        this.llSortedDirections = directions;
    }

    public void setLevelLabelSortHierarchy(String value) {
        this.llSortHierarchy = value;
    }

    public String getLevelLabelSortHierarchy() {
        return this.llSortHierarchy;
    }

    public String[] getCellValueSortedItems() {
        return this.cvSortedItems;
    }

    public void setCellValueSortedItems(String[] items) {
        this.cvSortedItems = items;
    }

    public String[] getCellValueSortedDirections() {
        return this.cvSortedDirections;
    }

    public void setCellValueSortedDirections(String[] directions) {
        this.cvSortedDirections = directions;
    }

    public void setCellValueSortHierarchy(String value) {
        this.cvSortHierarchy = value;
    }

    public String getCellValueSortHierarchy() {
        return this.cvSortHierarchy;
    }

    private void updateSortAdapterWithJSPChanges(OLAPSortSelectorInterface adapter) {
    }
}

