/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.commands.dataselectors.RB;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.memberproperties.MemberPropertiesSelectorInterface;
import com.sas.dataselectors.memberproperties.MemberPropertiesSelectorOLAPAdapter;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.DimensionInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.PropertyInterface;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MemberPropertiesCommand
extends BaseSelectorCommand
implements CommandStatusInterface {
    private String RB_KEY = "MemberPropertiesCommand.";
    private boolean swing;
    private List properties;
    private String expandedLevel;

    public MemberPropertiesCommand() {
    }

    public MemberPropertiesCommand(String name) {
        super(name);
    }

    public MemberPropertiesCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    public MemberPropertiesCommand(String name, boolean swing) {
        this(name);
        this.setSwing(swing);
    }

    protected void show(Object o) {
        DataSelectorInterface selector = this.getSelector();
        if (selector == null) {
            throw new IllegalStateException(RB.getStringResource((String)this.RB_KEY, (String)"noSelectorError.txt"));
        }
        MemberPropertiesSelectorInterface selectorModel = MemberPropertiesSelectorOLAPAdapter.createDefaultAdapter((BusinessQueryProviderInterface)this.getModel());
        selector.setSelectorModel((Object)selectorModel);
        this.setSelectorModel(selectorModel);
        selectorModel.setExpandedLevel(this.getExpandedLevel());
        this.eventInfo.clear();
        super.show(o);
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        super.cancel(o);
    }

    protected void commit(Object o) throws IOException {
        MemberPropertiesSelectorInterface selectorModel = (MemberPropertiesSelectorInterface)this.getSelectorModel();
        if (!this.isSwing()) {
            selectorModel.setProperties(this.getProperties());
        }
        this.updateEventInfo(selectorModel.commit());
        super.commit(o);
    }

    private void updateEventInfo(Map infoMap) {
        this.eventSource = this.model;
        this.contentsChanged = true;
        Exception e = (Exception)infoMap.get("EXCEPTION_OCCURRED");
        if (e != null) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
    }

    public int getCommandStatus(ActionSupportFilter actionFilter) {
        DataSelection ds;
        Object model = actionFilter.getAttribute("model");
        if (model == null) {
            return 2;
        }
        if (!(model instanceof BusinessQueryProviderInterface)) {
            return 1;
        }
        if (!(model instanceof OLAPDataSetInterface)) {
            return 16;
        }
        if (((BusinessQueryProviderInterface)model).getBusinessQuery() instanceof DataSelection && !(ds = (DataSelection)((BusinessQueryProviderInterface)model).getBusinessQuery()).getInputStructure().isOLAP()) {
            return 16;
        }
        ds = (DataSelection)((BusinessQueryProviderInterface)model).getBusinessQuery();
        OLAPDataSetInterface olapDataSet = (OLAPDataSetInterface)model;
        try {
            MetadataInterface metadata = olapDataSet.getDatabaseMetadata();
            Filter metaFilter = new Filter();
            metaFilter.setCubeName(olapDataSet.getCubeName());
            Map dimensionNameToUniqueNameMap = this.getDimensionNameToUniqueNameMap(metadata, metaFilter);
            AxisInterface[] axes = olapDataSet.getResultSetMetadata().getAxes(0, -1);
            List visibleDimensions = this.getVisibleDimensionNames(axes, dimensionNameToUniqueNameMap);
            int size = visibleDimensions.size();
            for (int i = 0; i < size; ++i) {
                metaFilter.setUniqueDimensionName((String)visibleDimensions.get(i));
                PropertyInterface[] properties = metadata.getProperties(metaFilter);
                if (properties == null || properties.length <= 0) continue;
                return 0;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return 4;
    }

    private List getVisibleDimensionNames(AxisInterface[] axes, Map dimensionNameToUniqueNameMap) {
        ArrayList visibleDimensions = new ArrayList();
        if (axes == null) {
            return visibleDimensions;
        }
        for (int i = 0; i < axes.length; ++i) {
            try {
                if (axes[i].getAxisNumber() == -1) {
                    continue;
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            String[] dimensionNames = null;
            try {
                dimensionNames = axes[i].getDimensionNames();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            if (dimensionNames == null) continue;
            for (int j = 0; j < dimensionNames.length; ++j) {
                Object uniqueDimensionName = dimensionNameToUniqueNameMap.get(dimensionNames[j]);
                if (uniqueDimensionName == null || visibleDimensions.contains(uniqueDimensionName)) continue;
                visibleDimensions.add(uniqueDimensionName);
            }
        }
        return visibleDimensions;
    }

    private Map getDimensionNameToUniqueNameMap(MetadataInterface metadata, Filter filter) {
        HashMap<String, String> dimensionNameToUniqueNameMap = new HashMap<String, String>();
        try {
            DimensionInterface[] dimensions = metadata.getDimensions(filter);
            for (int i = 0; i < dimensions.length; ++i) {
                if (dimensions[i].getType() == 2) continue;
                dimensionNameToUniqueNameMap.put(dimensions[i].getName(), dimensions[i].getUniqueName());
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return dimensionNameToUniqueNameMap;
    }

    public void setProperties(List properties) {
        this.properties = properties;
    }

    public List getProperties() {
        return this.properties;
    }

    public void setExpandedLevel(String expandedLevel) {
        this.expandedLevel = expandedLevel;
    }

    public String getExpandedLevel() {
        return this.expandedLevel;
    }

    public void setSwing(boolean swing) {
        this.swing = swing;
    }

    public boolean isSwing() {
        return this.swing;
    }
}

