/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.format.DataItemFormatAdapter;
import com.sas.entities.AttributeSetException;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.intelligentquery.IntelligentQueryException;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemActionType;
import com.sas.iquery.metadata.business.StructureOfDataItem;
import com.sas.iquery.metadata.serverprop.formats.SASFormatDescriptionUtil;
import com.sas.swing.visuals.dataselectors.format.FormatAdapterInterface;
import com.sas.swing.visuals.dataselectors.format.FormatTypeAdapterInterface;
import com.sas.swing.visuals.tableview.TableViewUtil;
import com.sas.util.Strings;
import com.sas.util.log.LoggerRepository2;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class FormatSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface,
CommandStatusInterface {
    public static final String RB_KEY = "FormatSelectorCommand.";
    public static final String ERROR_MESSAGE = "errorMessage.";
    public static final String FORMAT_TYPE_CHANGED = "formatTypeChanged";
    public static final String FORMAT_SELECTED = "formatSelected";
    private String action;
    private String formatType;
    private String format;
    private String width;
    private String decimalWidth;
    private String userDefinedFormat;
    protected Map actionInfo = new HashMap();
    public static String mode = "SHOW";
    private DataItem dataItem;
    private boolean isOLAP;

    public FormatSelectorCommand() {
    }

    public FormatSelectorCommand(String name) {
        this(name, null);
    }

    public FormatSelectorCommand(String name, String actionClass) {
        super(name, actionClass);
    }

    protected void show(Object o) {
        mode = "SHOW";
        Object model = this.getModel();
        FormatAdapterInterface adapter = null;
        if (model instanceof FormatAdapterInterface) {
            adapter = (FormatAdapterInterface)model;
        } else {
            BusinessQuery bq = null;
            if (model instanceof BusinessQueryProviderInterface) {
                bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
            }
            if (model instanceof BusinessQuery) {
                bq = (BusinessQuery)model;
            }
            DataItem di = this.getDataItem();
            if (bq != null) {
                adapter = new DataItemFormatAdapter(di);
            }
        }
        DataSelectorInterface selector = this.getSelector();
        if (adapter != null && selector != null) {
            this.setSelectorModel(adapter);
            selector.setSelectorModel((Object)adapter);
        }
        this.eventInfo.clear();
        this.actionInfo.clear();
        super.show(o);
    }

    protected void cleanUp() {
        this.getSelector().setSelectorModel(null);
        this.setSelectorModel(null);
        this.setModel(null);
    }

    protected boolean isSwing() {
        return this.getAttribute("request") == null;
    }

    protected void process(Object o) {
        mode = "PROCESS";
        this.eventInfo.clear();
        super.process(o);
        boolean modified = false;
        String act = this.getAction();
        if (act != null && this.getModel() != null) {
            if (FORMAT_TYPE_CHANGED.equals(act)) {
                this.eventInfo.put(FORMAT_TYPE_CHANGED, this.getFormatType());
                modified = true;
            } else if (FORMAT_SELECTED.equals(act)) {
                this.eventInfo.put(FORMAT_SELECTED, this.getFormat());
                modified = true;
            }
        }
        if (modified) {
            this.contentsChanged = true;
            this.eventSource = this.getModel();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
        }
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        this.cleanUp();
        super.cancel(o);
    }

    protected void commit(Object o) throws IOException {
        mode = "COMMIT";
        this.eventInfo.clear();
        boolean changed = false;
        DataItem di = this.getDataItem();
        FormatAdapterInterface formatAdapter = (FormatAdapterInterface)this.getSelectorModel();
        FormatTypeAdapterInterface formatTypeAdapter = null;
        if (formatAdapter instanceof FormatTypeAdapterInterface) {
            formatTypeAdapter = (FormatTypeAdapterInterface)formatAdapter;
        }
        String formatString = null;
        String f = this.getFormat();
        if ("true".equalsIgnoreCase(this.getUserDefinedFormat())) {
            formatString = f + ".";
        } else if (f != null && f.trim().length() > 0) {
            int iWidth = -1;
            if (this.getWidth() != null) {
                iWidth = new Integer(this.getWidth());
            }
            int iDecimalWidth = -1;
            if (this.getDecimalWidth() != null) {
                iDecimalWidth = new Integer(this.getDecimalWidth());
            }
            formatString = iWidth >= 0 && iDecimalWidth >= 0 ? SASFormatDescriptionUtil.getFormatDescriptionString((String)f, (int)iWidth, (int)iDecimalWidth) : (iWidth >= 0 ? SASFormatDescriptionUtil.getFormatDescriptionString((String)f, (int)iWidth) : SASFormatDescriptionUtil.getFormatDescriptionString((String)f));
        }
        try {
            if (formatTypeAdapter != null) {
                if (!Strings.equal((String)formatTypeAdapter.getFormat(), (String)formatString, (boolean)true, (boolean)true)) {
                    formatTypeAdapter.setFormat(formatString);
                    changed = true;
                }
            } else if (di != null && !Strings.equal((String)di.getFormat(), (String)formatString, (boolean)true, (boolean)true)) {
                di.setFormat(formatString);
                changed = true;
            }
            this.contentsChanged = true;
            this.eventSource = this.getModel();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
            this.eventInfo.put("format", formatString);
            if (this.isOLAP && changed) {
                this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
            }
            if (changed && this.model instanceof BusinessQueryProviderInterface) {
                try {
                    ((BusinessQueryProviderInterface)this.model).refreshBusinessQuery(((BusinessQueryProviderInterface)this.model).getBusinessQuery());
                }
                catch (IntelligentQueryException e) {
                    LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (MetadataException e) {
            LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
        }
        this.cleanUp();
        super.commit(o);
    }

    public void setAction(String value) {
        this.action = value;
    }

    public String getAction() {
        return this.action;
    }

    protected static String getID(Object object) {
        String id = null;
        if (object != null) {
            id = Integer.toHexString(System.identityHashCode(object));
        }
        return id;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        int status = 0;
        Object model = filter.getAttribute("model");
        BusinessQuery bq = null;
        BusinessModel bm = null;
        if (model instanceof BusinessQueryProviderInterface) {
            bq = ((BusinessQueryProviderInterface)model).getBusinessQuery();
        } else if (model instanceof BusinessQuery) {
            bq = (BusinessQuery)model;
        }
        DataItem di = null;
        if (bq != null) {
            bm = bq.getBusinessModel();
            if (!bm.getStructure().isOLAP()) {
                this.isOLAP = false;
                Object columnName = filter.getAttribute("columnName");
                Object column = filter.getAttribute("column");
                String columnId = null;
                if (model instanceof TableModel && column instanceof Integer) {
                    columnId = TableViewUtil.getColumnName((TableModel)((TableModel)model), (int)((Integer)column - 1));
                }
                List dataItems = bm != null ? bm.getObjects(1, DataItem.class) : bq.getResultItems();
                int size = dataItems.size();
                for (int j = 0; j < size; ++j) {
                    DataItem currItem = (DataItem)dataItems.get(j);
                    if (currItem == null) continue;
                    if (columnId != null) {
                        if (currItem.getResultSetID().equals(columnId)) {
                            di = currItem;
                        }
                    } else if (columnName != null && currItem.getLabel().equals(columnName)) {
                        di = currItem;
                    }
                    if (di == null) continue;
                    try {
                        filter.setAttribute("dataItem", (Object)di);
                    }
                    catch (AttributeSetException e) {
                        LoggerRepository2.getLogger((String)((Object)((Object)this)).getClass().getName(), null).error(e.getMessage(), (Throwable)e);
                    }
                    break;
                }
            } else {
                this.isOLAP = true;
                boolean isMeasure = (Boolean)filter.getAttribute("isMeasure");
                if (!isMeasure) {
                    status = 4;
                } else {
                    Object dataItem = filter.getAttribute("dataItem");
                    if (dataItem != null && dataItem instanceof DataItem) {
                        di = (DataItem)dataItem;
                    }
                }
            }
            if (di != null) {
                if (di.isReadOnly()) {
                    status = 4;
                } else if (di.isUnresolved()) {
                    status = 4;
                } else if (!di.isActionSupported(DataItemActionType.OTHER_FORMAT)) {
                    status = 4;
                }
            }
        } else {
            status = 2;
        }
        return status;
    }

    private boolean isMeasure(DataItem dataItem) {
        StructureOfDataItem dataItemStructure = dataItem.getStructure();
        if (dataItemStructure == StructureOfDataItem.STRUCTURE_MEASURE) {
            return true;
        }
        return dataItemStructure == StructureOfDataItem.STRUCTURE_COLUMN && dataItem.getExpressionType() == 2 && dataItem.getUsage() != DataItemActionType.USAGE_CATEGORY;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public DataItem getDataItem() {
        return this.dataItem;
    }

    public void setDataItem(DataItem dataItem) {
        this.dataItem = dataItem;
    }

    public String getFormatType() {
        return this.formatType;
    }

    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getDecimalWidth() {
        return this.decimalWidth;
    }

    public void setDecimalWidth(String decimalWidth) {
        this.decimalWidth = decimalWidth;
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getUserDefinedFormat() {
        return this.userDefinedFormat;
    }

    public void setUserDefinedFormat(String userDefinedFormat) {
        this.userDefinedFormat = userDefinedFormat;
    }
}

