/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commands.dataselectors;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandSupportedInterface;
import com.sas.beans.PropertyChangeSource;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.dataselectors.DataSelectorInterface;
import com.sas.dataselectors.find.FindSelectorInterface;
import com.sas.dataselectors.find.OLAPFindSelectorAdapter;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.BusinessQueryActionType;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.util.log.LoggerRepository2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public class FindSelectorCommand
extends BaseSelectorCommand
implements CommandSupportedInterface,
PropertyChangeListener {
    protected String findType;
    protected String findCondition;
    protected String findValue;
    protected String findDirection;
    protected FindSelectorInterface adapter;
    protected int rowNumber;
    protected int columnNumber;
    protected PropertyChangeSource viewerComponent;
    private int firstFoundRowNumber;
    private int firstFoundColumnNumber;
    private Object previousRowNumber;
    private Object previousColumnNumber;
    private String previousFindDirection;
    private String previousFindType;
    private String previousFindValue;
    private String previousFindCondition;
    private boolean found;

    public FindSelectorCommand() {
        this.setModal(false);
    }

    public FindSelectorCommand(String name) {
        super(name);
    }

    public FindSelectorCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    protected void show(Object o) {
        PropertyChangeSource vwr;
        this.model = this.getModel();
        if (this.model != null) {
            try {
                FindSelectorInterface adapter = null;
                if (this.model instanceof OLAPDataSetInterface) {
                    OLAPDataSetInterface odsinterface = (OLAPDataSetInterface)this.model;
                    adapter = this.createAdapter(odsinterface);
                    adapter.setCurrentRow(this.getRowNumber());
                    adapter.setCurrentColumn(this.getColumnNumber());
                }
                DataSelectorInterface rSelector = this.getSelector();
                rSelector.setSelectorModel(adapter);
            }
            catch (Exception e) {
                LoggerRepository2.getLogger((String)this.getClass().getName(), null).error(e.getMessage(), (Throwable)e);
            }
        }
        if ((vwr = this.getViewerComponent()) != null) {
            vwr.addPropertyChangeListener((PropertyChangeListener)this);
        } else {
            vwr = (PropertyChangeSource)this.getAttribute("viewComponent");
        }
        this.eventInfo.clear();
        super.show(o);
    }

    protected void process(Object o) {
        String findCondition;
        String findValue;
        String findType;
        String findDirection;
        block27: {
            this.eventInfo.clear();
            FindSelectorInterface adapter = (FindSelectorInterface)this.selector.getSelectorModel();
            Map findMap = null;
            this.model = this.getModel();
            int rowNumInt = -1;
            int colNumInt = -1;
            findDirection = this.getFindDirection();
            findType = this.getFindType();
            findValue = this.getFindValue();
            findCondition = this.getFindCondition();
            try {
                int firstFoundRowNumber = this.getFirstFoundRowNumber();
                int firstFoundColumnNumber = this.getFirstFoundColumnNumber();
                findMap = adapter.find(this.getFindType(), this.getFindCondition(), this.getFindValue(), this.getFindDirection());
                Object rowNum = findMap.get("ROW_NUMBER");
                Object colNum = findMap.get("COLUMN_NUMBER");
                if (rowNum != null) {
                    rowNumInt = new Integer(rowNum.toString());
                }
                if (colNum != null) {
                    colNumInt = new Integer(colNum.toString());
                }
                if (!(findDirection.equals(this.previousFindDirection) && findType.equals(this.previousFindType) && findValue.equals(this.previousFindValue) && findCondition.equals(this.previousFindCondition))) {
                    this.found = false;
                }
                if (!findMap.containsKey("ROW_NUMBER") && !findMap.containsKey("COLUMN_NUMBER")) {
                    this.found = false;
                    Object request = this.getAttribute("request");
                    if (request != null) {
                        Class[] types = new Class[]{String.class, Boolean.class};
                        try {
                            Method method = request.getClass().getMethod("setAttribute", types);
                            method.invoke(request, "REFRESH_VIEWER", Boolean.FALSE);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.eventInfo.put("action", "notfound");
                    this.eventSource = this.model;
                    break block27;
                }
                if (!(!this.found || rowNumInt != -1 && firstFoundRowNumber != rowNumInt || colNumInt != -1 && firstFoundColumnNumber != colNumInt)) {
                    this.found = false;
                    this.eventInfo.put("action", "searchwrapped");
                    this.eventSource = this.model;
                    if (rowNumInt != -1) {
                        this.eventInfo.put("ROW", "GOTO");
                        this.eventInfo.put("ROW_NUMBER", this.getPreviousRowNumber());
                        adapter.setCurrentRow(new Integer(this.getPreviousRowNumber().toString()).intValue());
                    }
                    if (colNumInt != -1) {
                        this.eventInfo.put("COLUMN", "GOTO");
                        this.eventInfo.put("COLUMN_NUMBER", this.getPreviousColumnNumber());
                        adapter.setCurrentColumn(new Integer(this.getPreviousColumnNumber().toString()).intValue());
                    }
                } else {
                    if (findType.equalsIgnoreCase("1")) {
                        if (rowNum != null) {
                            this.setPreviousRowNumber(rowNum);
                            if (!this.found) {
                                this.setFirstFoundRowNumber(rowNumInt);
                            }
                        }
                        this.eventInfo.put("ROW", "GOTO");
                        this.eventInfo.put("ROW_NUMBER", rowNum);
                    } else if (findType.equalsIgnoreCase("2")) {
                        if (colNum != null) {
                            this.setPreviousColumnNumber(colNum);
                            if (!this.found) {
                                this.setFirstFoundColumnNumber(colNumInt);
                            }
                        }
                        this.eventInfo.put("COLUMN", "GOTO");
                        this.eventInfo.put("COLUMN_NUMBER", colNum);
                    } else {
                        if (rowNum != null) {
                            this.setPreviousRowNumber(rowNum);
                            if (!this.found) {
                                this.setFirstFoundRowNumber(rowNumInt);
                            }
                        }
                        if (colNum != null) {
                            this.setPreviousColumnNumber(colNum);
                            if (!this.found) {
                                this.setFirstFoundColumnNumber(colNumInt);
                            }
                        }
                        this.eventInfo.put("ROW_COLUMN", "GOTO");
                        if (rowNum != null) {
                            this.eventInfo.put("ROW_NUMBER", rowNum);
                        }
                        if (colNum != null) {
                            this.eventInfo.put("COLUMN_NUMBER", colNum);
                        }
                    }
                    this.eventSource = this.model;
                    this.found = true;
                }
            }
            catch (OLAPException e) {
                this.eventInfo.put("action", "error");
                this.eventSource = this.model;
            }
        }
        this.previousFindDirection = findDirection;
        this.previousFindType = findType;
        this.previousFindValue = findValue;
        this.previousFindCondition = findCondition;
        this.contentsChanged = true;
        this.eventInfo.put("request", this.getAttribute("request"));
        this.eventInfo.put("response", this.getAttribute("response"));
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        this.adapter = null;
        PropertyChangeSource vwr = this.getViewerComponent();
        if (vwr != null) {
            vwr.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.cancel(o);
    }

    protected void commit(Object o) throws IOException {
        this.eventInfo.clear();
        this.adapter = null;
        PropertyChangeSource vwr = this.getViewerComponent();
        if (vwr != null) {
            vwr.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected FindSelectorInterface createAdapter(OLAPDataSetInterface ods) {
        return new OLAPFindSelectorAdapter(ods);
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object dataModel = actionFilter.getAttribute("model");
        if (dataModel instanceof BusinessQueryProviderInterface) {
            BusinessQuery bq = ((BusinessQueryProviderInterface)dataModel).getBusinessQuery();
            return bq.isActionSupported(BusinessQueryActionType.RESULT_ITEM);
        }
        return false;
    }

    public String getFindCondition() {
        return this.findCondition;
    }

    public String getFindDirection() {
        return this.findDirection;
    }

    public String getFindType() {
        return this.findType;
    }

    public String getFindValue() {
        return this.findValue;
    }

    public void setFindCondition(String string) {
        this.findCondition = string;
    }

    public void setFindDirection(String string) {
        this.findDirection = string;
    }

    public void setFindType(String string) {
        this.findType = string;
    }

    public void setFindValue(String string) {
        this.findValue = string;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setColumnNumber(int i) {
        this.columnNumber = i;
    }

    public void setRowNumber(int i) {
        this.rowNumber = i;
    }

    public void setViewerComponent(PropertyChangeSource vwr) {
        this.viewerComponent = vwr;
    }

    public PropertyChangeSource getViewerComponent() {
        return this.viewerComponent;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Integer roworcolumn = (Integer)event.getNewValue();
        FindSelectorInterface adapter = (FindSelectorInterface)this.selector.getSelectorModel();
        if (event.getPropertyName().equalsIgnoreCase("startColumn")) {
            this.setColumnNumber(roworcolumn);
            adapter.setCurrentColumn(this.getColumnNumber());
        } else if (event.getPropertyName().equalsIgnoreCase("startRow")) {
            this.setRowNumber(roworcolumn);
            adapter.setCurrentRow(this.getRowNumber());
        }
    }

    private int getFirstFoundColumnNumber() {
        return this.firstFoundColumnNumber;
    }

    private int getFirstFoundRowNumber() {
        return this.firstFoundRowNumber;
    }

    private void setFirstFoundColumnNumber(int i) {
        this.firstFoundColumnNumber = i;
    }

    private void setFirstFoundRowNumber(int i) {
        this.firstFoundRowNumber = i;
    }

    private Object getPreviousColumnNumber() {
        return this.previousColumnNumber;
    }

    private Object getPreviousRowNumber() {
        return this.previousRowNumber;
    }

    private void setPreviousColumnNumber(Object i) {
        this.previousColumnNumber = i;
    }

    private void setPreviousRowNumber(Object i) {
        this.previousRowNumber = i;
    }
}

