/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.workspace.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.visuals.DBMSNamesPropertiesPanel;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.sql.SQLException;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class GeneralOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(GeneralOptionsTab.class);
    protected WorkspaceFile m_appDefaultsFile = Workspace.getWorkspace().getAppDefaultsFile();
    private OCSAppServerPanel m_appPanel;
    private String originalFQID;
    private JCheckBox saveChanges;
    private JCheckBox verifySpecChar;
    private JCheckBox versionWarningSD;
    private JCheckBox versionWarningDM;
    protected DBMSNamesPropertiesPanel DBMSNamesPanel;

    public GeneralOptionsTab() {
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_tools_options_general");
        this.initializeWidgets();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        this.m_appPanel.doDataExchange(bSaveToModel);
        this.originalFQID = this.m_appPanel.getSelectedServerFQID();
        if (!bSaveToModel) {
            this.saveChanges.setSelected(WAStandardDialog.isUserPreferenceToShowTheDiscardChangesMessage());
            this.verifySpecChar.setSelected(this.m_appDefaultsFile.getPropertyBoolean(VisualUtilities.VERIFY_SPEC_CHARACTERS, true));
            this.versionWarningSD.setSelected(this.m_appDefaultsFile.getPropertyBoolean(VisualUtilities.VERSION_WARNING_SHARED_DIM, true));
            this.versionWarningDM.setSelected(this.m_appDefaultsFile.getPropertyBoolean(VisualUtilities.VERSION_WARNING_DEFAULT_MEM, true));
        } else {
            WAStandardDialog.setUserPreferenceToShowTheDiscardChangesMessage((boolean)this.saveChanges.isSelected());
            this.m_appDefaultsFile.setPropertyBoolean(VisualUtilities.VERIFY_SPEC_CHARACTERS, this.verifySpecChar.isSelected());
            this.m_appDefaultsFile.setPropertyBoolean(VisualUtilities.VERSION_WARNING_SHARED_DIM, this.versionWarningSD.isSelected());
            this.m_appDefaultsFile.setPropertyBoolean(VisualUtilities.VERSION_WARNING_DEFAULT_MEM, this.versionWarningDM.isSelected());
        }
        this.DBMSNamesPanel.doDataExchange(bSaveToModel);
        return true;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.stopListeningForDataChangesTo((WAPanel)this.DBMSNamesPanel);
        this.m_appPanel.saveSettingsAndCleanUp();
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_appPanel.setEditable(bEditable);
    }

    public void initializeWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel msgPanel = new JPanel();
        msgPanel.setLayout(new GridBagLayout());
        msgPanel.setBorder(new TitledBorder(bundle.getString("Options.GeneralMessage.groupbox.title")));
        this.saveChanges = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.saveChanges, bundle.getString("Options.SaveChanges.checkbox.label"));
        msgPanel.add((Component)this.saveChanges, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.verifySpecChar = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.verifySpecChar, bundle.getString("Options.VerifySpecChar.checkbox.label"));
        msgPanel.add((Component)this.verifySpecChar, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.versionWarningSD = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.versionWarningSD, bundle.getString("Common.VersionWarningSD.JBox.label"));
        msgPanel.add((Component)this.versionWarningSD, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.versionWarningDM = new JCheckBox();
        VisualUtilities.setButtonTextAndMnemonic(this.versionWarningDM, bundle.getString("Common.VersionWarningDM.JBox.label"));
        msgPanel.add((Component)this.versionWarningDM, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(msgPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.m_appPanel = new OCSAppServerPanel();
        this.m_appPanel.setBorder(new TitledBorder(bundle.getString("Options.Server.groupbox.title")));
        this.m_appPanel.setUpdateDefault(true);
        this.add((Component)((Object)this.m_appPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel dbmsBorderPanel = new JPanel();
        dbmsBorderPanel.setLayout(new GridBagLayout());
        dbmsBorderPanel.setBorder(new TitledBorder(bundle.getString("Options.GlobalDBMSNames.groupbox.title")));
        this.DBMSNamesPanel = new DBMSNamesPropertiesPanel(null, false, true);
        dbmsBorderPanel.add((Component)this.DBMSNamesPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(dbmsBorderPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        JPanel tempForSpace = new JPanel();
        this.add(tempForSpace, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return this.m_appPanel.validateData();
    }

    class OCSAppServerPanel
    extends WsAppServerPanel {
        private static final long serialVersionUID = 1L;

        OCSAppServerPanel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean test() {
            block20: {
                ServerContextInterface oServer = this.getSelectedOMRServerObject();
                if (oServer == null) {
                    return false;
                }
                WsAppServer srvr = WsAppServer.createAppServer((ServerContextInterface)oServer);
                this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    block19: {
                        srvr.validateDefinition();
                        if (this.willUpdateDefault() && !oServer.getIdentifier().equals(GeneralOptionsTab.this.originalFQID)) {
                            srvr.removeCredentials();
                        }
                        try {
                            srvr.test();
                            String version = srvr.getServerVersion();
                            if (!version.startsWith("9.01") && !version.startsWith("9.00")) break block19;
                            MessageUtil.displayMessage((String)bundle.formatString("AppServer.WrongVersion.fmt.txt", (Object)version));
                            boolean bl = false;
                            return bl;
                        }
                        catch (WsAppServerFailException ex) {
                            ExceptionHandler.handleException((Exception)((Object)ex));
                            break block20;
                        }
                        catch (WsAppServerCodeException e) {
                            ExceptionHandler.handleException((Exception)((Object)e));
                            break block20;
                        }
                        catch (SQLException e) {
                            ExceptionHandler.handleException((Exception)e);
                            break block20;
                        }
                    }
                    MessageUtil.displayMessage((String)bundle.getString("WsAppServerPanel.ConnectionOK.txt"), (int)1);
                    boolean bl = true;
                    return bl;
                }
                catch (WsAppServerFailException ex) {
                    MessageUtil.displayMessage((String)bundle.getString("WsAppServerPanel.InvalidServerDefinition.txt"), (int)0);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException re) {
                    Workspace.handleRemoteException((RemoteException)re);
                }
                catch (ServiceException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                finally {
                    this.getTopLevelAncestor().setCursor(Cursor.getDefaultCursor());
                    srvr.dispose();
                }
            }
            return false;
        }
    }
}

