/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.workspace.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.properties.GenerationPropertyTab;
import com.sas.olapadmin.properties.OAGeneralPropertyTab;
import com.sas.olapadmin.properties.OAGenericGeneralPropertyTab;
import com.sas.olapadmin.properties.PropertiesInputTab;
import com.sas.olapadmin.properties.PropertiesLocationTab;
import com.sas.olapadmin.properties.StructurePropertyTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAPropertyTabGroup;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WorkspaceOMAView;

public class CubeView
extends WorkspaceOMAView {
    private static WAdminResource bundle = new WAdminResource(CubeView.class);

    public WAPropertyTabGroup createView() {
        super.createView();
        WAPropertyTabGroup tabs = null;
        OLAPCube olapCube = null;
        try {
            olapCube = new OLAPCube((Cube)this.m_metadata);
            int errorLevel = olapCube.getErrorLevel();
            if (errorLevel != -1) {
                MessageUtil.displayDetailsMessage((String)bundle.getString("CubeTreeNode.NONEditCubeStructure.MetadataChanges.txt"), (int)0, (String)olapCube.getCubeVerifyMessage().toString());
            } else {
                tabs = new WAPropertyTabGroup();
                tabs.addTab(bundle.getString("General.tab.title"), (WAPropertyTab)new OAGeneralPropertyTab((CMetadata)this.m_metadata, true));
                tabs.addTab(bundle.getString("CubeView.Location.Title.txt"), (WAPropertyTab)new PropertiesLocationTab(olapCube));
                tabs.addTab(bundle.getString("CubeView.Input.Title.txt"), (WAPropertyTab)new PropertiesInputTab(olapCube));
                tabs.addTab(bundle.getString("CubeView.Structure.Title.txt"), (WAPropertyTab)new StructurePropertyTab(olapCube));
                tabs.addTab(bundle.getString("Notes.tab.title"), (WAPropertyTab)new JOMANotesTab(this.m_metadata));
                tabs.addTab(bundle.getString("ExtendedAttributes.tab.title"), (WAPropertyTab)new WAExtAttrPropertyTab((CMetadata)this.m_metadata));
                tabs.addTab(bundle.getString("Advanced.tab.title"), (WAPropertyTab)new OAGenericGeneralPropertyTab((CMetadata)this.m_metadata));
                tabs.addTab(bundle.getString("CubeView.Generation.Title.txt"), (WAPropertyTab)new GenerationPropertyTab(olapCube));
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return tabs;
    }
}

