/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OLAPMemberProperty;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class StructureTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(StructureTreeCellRenderer.class);

    @Override
    public Component getTreeCellRendererComponent(JTree inTree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasTheFocus) {
        super.getTreeCellRendererComponent(inTree, value, sel, expanded, leaf, row, hasTheFocus);
        ImageIcon icon = null;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof OLAPSharedDimension) {
            icon = Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16);
        } else if (userObject instanceof OLAPDimension) {
            icon = Resources.getImageIcon((String)"OLAPDimension.gif", (int)16);
        } else if (userObject instanceof OLAPHierarchy) {
            icon = Resources.getImageIcon((String)"OLAPHierarchy.gif", (int)16);
        } else if (userObject instanceof OLAPLevel) {
            icon = Resources.getImageIcon((String)"OLAPLevel.gif", (int)16);
        } else if (userObject instanceof OLAPMeasure) {
            icon = Resources.getImageIcon((String)"OLAPMeasure.gif", (int)16);
        } else if (userObject instanceof OLAPDefinedMember) {
            OLAPDefinedMember member = (OLAPDefinedMember)userObject;
            String type = member.getType();
            if (type.equals("Calculated Measure")) {
                icon = Resources.getImageIcon((String)"Measure_calculated_shared.gif", (int)16);
            } else if (type.equals("Calculated Member")) {
                icon = Resources.getImageIcon((String)"OLAPMember_calculated.gif", (int)16);
            }
        } else if (userObject instanceof OLAPAggregation) {
            icon = bundle.getImageIcon("StructurePanel.Aggregation.image");
        } else if (userObject instanceof OLAPMemberProperty) {
            icon = bundle.getImageIcon("StructurePanel.MemberProperty.image");
        } else if (userObject instanceof OLAPCube) {
            icon = Resources.getImageIcon((String)"OLAPCube.gif", (int)16);
        } else if (userObject instanceof String) {
            icon = Resources.getImageIcon((String)"Folder.gif", (int)16);
        }
        this.setIcon(icon);
        return this;
    }
}

