/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class RaggedMissingValuesPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(RaggedMissingValuesPanel.class);
    public JCheckBox skipMissingChar;
    public JCheckBox skipMissingNum;
    private WATextArea otherEmptyChar;
    private WATextArea otherEmptyNum;
    private OLAPCube cubeModel;
    private OLAPDimension dimensionModel;
    private JRadioButton charMissingValue;
    private JRadioButton otherCharMissingValue;
    private JRadioButton numericMissingValue;
    private JRadioButton otherNumericMissingValue;
    private ButtonGroup characterGroup;
    private ButtonGroup numericGroup;
    private AbstractOLAPModel olapObject;
    private boolean isDimension;

    public RaggedMissingValuesPanel(AbstractOLAPModel inOLAPObject) {
        this.olapObject = inOLAPObject;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            try {
                String emptyChar = null;
                String emptyNum = null;
                if (this.olapObject instanceof OLAPDimension) {
                    this.isDimension = true;
                }
                if (this.isDimension) {
                    this.dimensionModel = (OLAPDimension)this.olapObject;
                    emptyChar = this.dimensionModel.getEmptyChar();
                    emptyNum = this.dimensionModel.getEmptyNum();
                } else {
                    this.cubeModel = (OLAPCube)this.olapObject;
                    emptyChar = this.cubeModel.getEmptyChar();
                    emptyNum = this.cubeModel.getEmptyNum();
                }
                if (emptyChar != null) {
                    this.skipMissingChar.setSelected(true);
                    if (!ModelUtilities.isBlank((String)emptyChar)) {
                        this.otherCharMissingValue.setSelected(true);
                        this.otherEmptyChar.setText(emptyChar);
                    } else {
                        this.charMissingValue.setSelected(true);
                    }
                } else {
                    this.skipMissingChar.setSelected(false);
                    this.disableCharacterSettings();
                }
                if (emptyNum != null) {
                    this.skipMissingNum.setSelected(true);
                    if (!emptyNum.equals(".")) {
                        this.otherNumericMissingValue.setSelected(true);
                        this.otherEmptyNum.setText(emptyNum);
                    } else {
                        this.numericMissingValue.setSelected(true);
                    }
                } else {
                    this.skipMissingNum.setSelected(false);
                    this.disableNumericSettings();
                }
            }
            catch (OLAPException oError) {
                return ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    public void saveDataToModel() {
        String emptyNumValue;
        String emptyCharValue;
        String emptyChar = null;
        String emptyNum = null;
        boolean charValue = this.skipMissingChar.isSelected();
        boolean numValue = this.skipMissingNum.isSelected();
        if (charValue && this.charMissingValue.isSelected()) {
            emptyChar = " ";
        } else if (charValue && this.otherCharMissingValue.isSelected() && (emptyCharValue = this.otherEmptyChar.getText()) != null) {
            emptyChar = emptyCharValue;
        }
        if (numValue && this.numericMissingValue.isSelected()) {
            emptyNum = ".";
        } else if (numValue && this.otherNumericMissingValue.isSelected() && (emptyNumValue = this.otherEmptyNum.getText()) != null) {
            emptyNum = emptyNumValue;
        }
        if (!this.isDimension) {
            this.cubeModel.setEmptyChar(emptyChar);
            this.cubeModel.setEmptyNum(emptyNum);
        } else {
            try {
                this.dimensionModel.setEmptyChar(emptyChar);
                this.dimensionModel.setEmptyNum(emptyNum);
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
    }

    private void _layoutWidgets() {
        this.skipMissingChar = new JCheckBox();
        this.skipMissingNum = new JCheckBox();
        this.skipMissingChar.setName("RaggedSkipMissingChar");
        this.skipMissingNum.setName("RaggedSkipMissingNum");
        if (this.olapObject instanceof OLAPCube) {
            VisualUtilities.setButtonTextAndMnemonic(this.skipMissingChar, bundle.getString("RaggedMissing.Skip.CharactersMembers.checkbox.label"));
            VisualUtilities.setButtonTextAndMnemonic(this.skipMissingNum, bundle.getString("RaggedMissing.Skip.NumericMembers.checkbox.label"));
        } else {
            VisualUtilities.setButtonTextAndMnemonic(this.skipMissingChar, bundle.getString("RaggedMissing.Skip.Dimension.CharactersMembers.checkbox.label"));
            VisualUtilities.setButtonTextAndMnemonic(this.skipMissingNum, bundle.getString("RaggedMissing.Skip.Dimension.NumericMembers.checkbox.label"));
        }
        this.charMissingValue = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.charMissingValue, bundle.getString("RaggedMissing.Blank.Space.radio.label"));
        this.otherCharMissingValue = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.otherCharMissingValue, bundle.getString("RaggedMissing.Character.Other.radio.label"));
        this.numericMissingValue = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.numericMissingValue, bundle.getString("RaggedMissing.Numeric.Period.radio.label"));
        this.otherNumericMissingValue = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.otherNumericMissingValue, bundle.getString("RaggedMissing.Numeric.Other.radio.label"));
        this.characterGroup = new ButtonGroup();
        this.numericGroup = new ButtonGroup();
        this.characterGroup.add(this.charMissingValue);
        this.characterGroup.add(this.otherCharMissingValue);
        this.numericGroup.add(this.numericMissingValue);
        this.numericGroup.add(this.otherNumericMissingValue);
        this.charMissingValue.setSelected(true);
        this.numericMissingValue.setSelected(true);
        this.otherEmptyNum = new WATextArea(2, 1);
        this.otherEmptyChar = new WATextArea(2, 1);
        this.otherEmptyChar.setLineWrap(true);
        this.otherEmptyChar.setWrapStyleWord(true);
        JScrollPane otherScrollChar = new JScrollPane((Component)this.otherEmptyChar);
        this.otherEmptyNum.setLineWrap(true);
        this.otherEmptyNum.setWrapStyleWord(true);
        JScrollPane otherScrollNum = new JScrollPane((Component)this.otherEmptyNum);
        this.otherEmptyChar.setName("CubeEmptyChar");
        this.otherEmptyNum.setName("CubeEmptyNum");
        this.otherEmptyChar.setToolTipText(bundle.getString("RaggedMissing.Character.Other.TextArea.tip"));
        this.otherEmptyNum.setToolTipText(bundle.getString("RaggedMissing.Numeric.Other.TextArea.tip"));
        OtherListener otherEmptyCharAction = new OtherListener();
        this.otherEmptyChar.getDocument().addDocumentListener(otherEmptyCharAction);
        OtherListener otherEmptyNumAction = new OtherListener();
        this.otherEmptyNum.getDocument().addDocumentListener(otherEmptyNumAction);
        numericNoneListener numericNoneAction = new numericNoneListener();
        this.skipMissingNum.addActionListener(numericNoneAction);
        charNoneListener charNoneAction = new charNoneListener();
        this.skipMissingChar.addActionListener(charNoneAction);
        this.add(this.skipMissingChar, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this.charMissingValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 5), 0, 0));
        this.add(this.otherCharMissingValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 5), 0, 0));
        this.add(otherScrollChar, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 36, 5, 5), 0, 0));
        this.add(this.skipMissingNum, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.numericMissingValue, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 5), 0, 0));
        this.add(this.otherNumericMissingValue, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 5), 0, 0));
        this.add(otherScrollNum, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 36, 0, 5), 0, 0));
    }

    private void disableCharacterSettings() {
        this.otherEmptyChar.setEditable(false);
        this.otherEmptyChar.setBehavior(2);
        this.charMissingValue.setEnabled(false);
        this.otherCharMissingValue.setEnabled(false);
        this.otherEmptyChar.setBackground((Color)SystemColor.control);
        this.otherEmptyChar.setEnabled(false);
    }

    private void disableNumericSettings() {
        this.otherEmptyNum.setEditable(false);
        this.otherEmptyNum.setBehavior(2);
        this.numericMissingValue.setEnabled(false);
        this.otherNumericMissingValue.setEnabled(false);
        this.otherEmptyNum.setBackground((Color)SystemColor.control);
        this.otherEmptyNum.setEnabled(false);
        this.otherEmptyNum.setEnabled(true);
    }

    public class OtherListener
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.changeOtherSetting(arg0);
        }

        private void changeOtherSetting(DocumentEvent arg0) {
            Document document = RaggedMissingValuesPanel.this.otherEmptyChar.getDocument();
            Document argDoc = arg0.getDocument();
            if (argDoc.equals(document)) {
                String value = RaggedMissingValuesPanel.this.otherEmptyChar.getText().trim();
                if (value.length() > 0) {
                    RaggedMissingValuesPanel.this.otherCharMissingValue.setSelected(true);
                } else {
                    RaggedMissingValuesPanel.this.charMissingValue.setSelected(true);
                }
            } else {
                String value = RaggedMissingValuesPanel.this.otherEmptyNum.getText().trim();
                if (value.length() > 0) {
                    RaggedMissingValuesPanel.this.otherNumericMissingValue.setSelected(true);
                } else {
                    RaggedMissingValuesPanel.this.numericMissingValue.setSelected(true);
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.changeOtherSetting(arg0);
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.changeOtherSetting(arg0);
        }
    }

    public class numericNoneListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            if (RaggedMissingValuesPanel.this.skipMissingNum.isSelected()) {
                RaggedMissingValuesPanel.this.otherEmptyNum.setEditable(true);
                RaggedMissingValuesPanel.this.otherEmptyNum.setBehavior(0);
                RaggedMissingValuesPanel.this.numericMissingValue.setEnabled(true);
                RaggedMissingValuesPanel.this.otherNumericMissingValue.setEnabled(true);
                RaggedMissingValuesPanel.this.otherEmptyNum.setBackground((Color)SystemColor.text);
                RaggedMissingValuesPanel.this.otherEmptyNum.setEnabled(true);
            } else {
                RaggedMissingValuesPanel.this.disableNumericSettings();
            }
        }
    }

    public class charNoneListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent event) {
            if (RaggedMissingValuesPanel.this.skipMissingChar.isSelected()) {
                RaggedMissingValuesPanel.this.otherEmptyChar.setEditable(true);
                RaggedMissingValuesPanel.this.otherEmptyChar.setBehavior(0);
                RaggedMissingValuesPanel.this.charMissingValue.setEnabled(true);
                RaggedMissingValuesPanel.this.otherCharMissingValue.setEnabled(true);
                RaggedMissingValuesPanel.this.otherEmptyChar.setBackground((Color)SystemColor.text);
                RaggedMissingValuesPanel.this.otherEmptyChar.setEnabled(true);
            } else {
                RaggedMissingValuesPanel.this.disableCharacterSettings();
            }
        }
    }
}

