/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.actions.PropertiesAction;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.OLAPTable;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeLoadTableMapDialog;
import com.sas.olapadmin.designer.visuals.CubeTableOptionsPanel;
import com.sas.olapadmin.designer.visuals.SharedDimTableMapDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.DrillTableChangeEvent;
import com.sas.olapadmin.utilities.studio.DrillTableSelectionListener;
import com.sas.olapadmin.utilities.studio.OLAPAbstractTreeModel;
import com.sas.olapadmin.utilities.studio.OLAPFolderTreeModel;
import com.sas.olapadmin.utilities.studio.OLAPInventoryTreeModel;
import com.sas.olapadmin.utilities.studio.OLAPTabbedTreePanel;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.swing.visuals.ButtonBorderRollOverHandler;
import com.sas.visuals.Resources;
import com.sas.wadmin.viewdata2.impl.PhysicalTablePanel;
import com.sas.wadmin.visuals.SourceDesigner;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.ISimpleObjectHierarchyModel;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleBrowseObjectImpl;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.models.tree.CategoryTreeNode;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.visuals.objectselector.ObjectSelectorFilterFactory;
import com.sas.workspace.visuals.tree.FoldersTree;
import com.sas.workspace.visuals.tree.IBaseTree;
import com.sas.workspace.visuals.tree.InventoryTree;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PhysicalTableSelector
extends WAPanel
implements TableSet.Listener {
    private static WAdminResource m_bundle = new WAdminResource(PhysicalTableSelector.class);
    static final long serialVersionUID = 1L;
    private OLAPCube m_cube;
    private OLAPSharedDimension sharedDim;
    private OLAPDimension olapDim;
    private TableSet m_tableSet;
    private List m_tablesToSelect;
    private String m_strTableOptions;
    private String m_strDrillTableOptions;
    private SimpleBrowseObject m_lastSelectedTable;
    private SimpleBrowseObject m_currentMaxSelectedOne;
    private List m_exclusionTables;
    private boolean m_enableSelector;
    private boolean m_displayOptions;
    private boolean m_excludeMLStables;
    private int m_maxToSelect;
    public static final int MAX_SELECTED_ONE = 1;
    public static final int MAX_SELECTED_UNLIMITED = -1;
    private static final String TABLE = "PhysicalTable";
    private OLAPTabbedTreePanel treePanel;
    private JTree drillTree;
    private JTree genericTree;
    private JButton deleteGeneric;
    private JButton deleteDrill;
    private JButton tableOptionsGeneric;
    private JButton tableOptionsDrill;
    private DefaultTreeModel drillTableModel;
    private DefaultTreeModel genericTableModel;
    private JButton m_propertiesBtn;
    private JButton m_defineTablesBtn;
    private JButton m_viewDataBtn;
    private JButton m_mapTableBtn;
    private boolean m_displayMapButton;
    private JPanel m_buttons;
    private JScrollPane scroll;
    private JScrollPane scrollDrill;
    private JLabel genericLabel;
    private JLabel drillLabel;
    private JButton arrowButton;
    private JButton arrowButton2;
    private ISimpleObjectFilter selectableObjectsFilter;
    private boolean hasBeenShown;
    private boolean m_inputDrill;
    private List librariesAdded;
    private PhysicalTable drillTableToSelect;
    private FoldersTree foldersTree;
    private InventoryTree inventoryTree;
    private JLabel availableLabel;
    private List usedTables;
    private GenericListener genericListener;
    private MeasureSet measureSet;
    private List listeners;
    private boolean treatAsDrillThru;
    private boolean isShared;
    private JPanel selectorsPanel;
    private boolean onlyOneLibrary;
    public boolean dataChanged;

    public PhysicalTableSelector() {
        this(null, 1, true, false, false, true, false);
    }

    public PhysicalTableSelector(int maxSelect) {
        this(null, maxSelect, true, false, false, true, false);
    }

    public PhysicalTableSelector(OLAPCube incube) {
        this((AbstractOLAPModel)incube, 1, true, true, false, true, true);
    }

    public PhysicalTableSelector(OLAPCube incube, int maxSelect) {
        this((AbstractOLAPModel)incube, maxSelect, true, true, false, true, true);
    }

    public PhysicalTableSelector(OLAPCube incube, boolean enableSelector) {
        this((AbstractOLAPModel)incube, 1, enableSelector, true, false, true, true);
    }

    public PhysicalTableSelector(AbstractOLAPModel inObject, int maxSelect, boolean enableSelector, boolean displayOptionsButton, boolean excludeMLStables, boolean displayMapButton, boolean inputDrill) {
        if (inObject instanceof OLAPCube) {
            this.m_cube = (OLAPCube)inObject;
        } else if (inObject instanceof OLAPSharedDimension) {
            this.sharedDim = (OLAPSharedDimension)inObject;
            this.isShared = true;
        } else if (inObject instanceof OLAPDimension) {
            this.olapDim = (OLAPDimension)inObject;
            this.onlyOneLibrary = true;
            this.m_cube = this.olapDim.getOwningCube();
        }
        this.m_maxToSelect = maxSelect;
        this.m_enableSelector = enableSelector;
        this.m_displayOptions = displayOptionsButton;
        this.m_exclusionTables = new ArrayList();
        this.m_excludeMLStables = excludeMLStables;
        this.m_displayMapButton = displayMapButton;
        this.m_tablesToSelect = new ArrayList();
        this.m_inputDrill = inputDrill;
        this.librariesAdded = new ArrayList();
        this.listeners = new ArrayList();
        this.initialize();
        this.layoutWidgets();
    }

    public synchronized void addDrillTableSelectionListener(DrillTableSelectionListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeDrillTableSelectionListener(DrillTableSelectionListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    public synchronized void fireDrillTableSelectionChanged(DrillTableChangeEvent e) {
        ArrayList listenerList = new ArrayList();
        listenerList.addAll(this.listeners);
        for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            DrillTableSelectionListener listener = (DrillTableSelectionListener)listenerList.get(listenerIndex);
            listener.drillTableChanged(e);
        }
    }

    public void setTreatAsDrillThru(boolean newSetting) {
        this.treatAsDrillThru = newSetting;
    }

    private DefaultMutableTreeNode getFirstLeaf(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf()) {
            return node;
        }
        return this.getFirstLeaf((DefaultMutableTreeNode)node.getChildAt(0));
    }

    public void reloadTree() {
        boolean isInventoryTreeDisplayed = this.inventoryTree.isShowing();
        OLAPAbstractTreeModel inventoryModel = (OLAPAbstractTreeModel)this.inventoryTree.getModel();
        OLAPAbstractTreeModel foldersModel = (OLAPAbstractTreeModel)this.foldersTree.getModel();
        OLAPAbstractTreeModel tempModel = null;
        DefaultMutableTreeNode root = null;
        InventoryTree tree = null;
        if (isInventoryTreeDisplayed) {
            root = (DefaultMutableTreeNode)this.inventoryTree.getModel().getRoot();
            tree = this.inventoryTree;
            tempModel = inventoryModel;
        } else {
            root = (DefaultMutableTreeNode)this.foldersTree.getModel().getRoot();
            tree = this.foldersTree;
            tempModel = foldersModel;
        }
        DefaultMutableTreeNode rootFolder = (DefaultMutableTreeNode)foldersModel.getRoot();
        foldersModel.removeAllChildren((ITreeNode)rootFolder);
        DefaultMutableTreeNode rootInventory = (DefaultMutableTreeNode)inventoryModel.getRoot();
        foldersModel.removeAllChildren((ITreeNode)rootInventory);
        inventoryModel.addChildren((ITreeNode)rootInventory);
        foldersModel.addChildren((ITreeNode)rootFolder);
        inventoryModel.reload();
        foldersModel.reload();
        this.expandAll((JTree)tree, new TreePath(tempModel.getRoot()));
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    public void clearAndPopulate() {
        this.usedTables.clear();
        OLAPAbstractTreeModel inventoryModel = (OLAPAbstractTreeModel)this.inventoryTree.getModel();
        OLAPAbstractTreeModel foldersModel = (OLAPAbstractTreeModel)this.foldersTree.getModel();
        DefaultMutableTreeNode rootFolder = (DefaultMutableTreeNode)foldersModel.getRoot();
        foldersModel.removeAllChildren((ITreeNode)rootFolder);
        DefaultMutableTreeNode rootInventory = (DefaultMutableTreeNode)inventoryModel.getRoot();
        foldersModel.removeAllChildren((ITreeNode)rootInventory);
        inventoryModel.addChildren((ITreeNode)rootInventory);
        foldersModel.addChildren((ITreeNode)rootFolder);
        inventoryModel.reload();
        foldersModel.reload();
        TreePath[] listOfSelectedNodes = this.genericTree.getSelectionPaths();
        if (listOfSelectedNodes != null) {
            for (int i = listOfSelectedNodes.length - 1; i > -1; --i) {
                String id;
                TreePath selectedPath = listOfSelectedNodes[i];
                SimpleBrowseObjectTreeNode selectedNode = (SimpleBrowseObjectTreeNode)selectedPath.getLastPathComponent();
                SimpleBrowseObjectTreeNode foundNode = this.findNode((DefaultMutableTreeNode)selectedNode, id = selectedNode.getID(), this.genericTree);
                if (foundNode != null) continue;
                SimpleBrowseObjectTreeNode parentNode = (SimpleBrowseObjectTreeNode)selectedNode.getParent();
                int numberOfChildren = parentNode.getChildCount();
                if (numberOfChildren < 2) {
                    this.genericTableModel.removeNodeFromParent((MutableTreeNode)parentNode);
                    continue;
                }
                this.genericTableModel.removeNodeFromParent((MutableTreeNode)selectedNode);
            }
        }
    }

    public void clearTreeSelections() {
        this.usedTables.clear();
        DefaultTreeModel treeModel = (DefaultTreeModel)this.genericTree.getModel();
        DefaultMutableTreeNode rootFolder = (DefaultMutableTreeNode)treeModel.getRoot();
        int nChildren = treeModel.getChildCount(rootFolder);
        for (int iChildren = nChildren - 1; iChildren >= 0; --iChildren) {
            DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)rootFolder.getChildAt(iChildren);
            nextNode.removeAllChildren();
        }
        rootFolder.removeAllChildren();
        treeModel.reload();
    }

    public void setStarGenericLabel() {
        VisualUtilities.setLabelTextAndMnemonic(this.genericLabel, m_bundle.getString("PhysicalTableSelector.FactTable.control.label"));
        this.selectorsPanel.remove(this.genericLabel);
        this.selectorsPanel.add((Component)this.genericLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 6, 0), 0, 0));
    }

    public void setGenericLabel() {
        VisualUtilities.setLabelTextAndMnemonic(this.genericLabel, m_bundle.getString("PhysicalTableSelector.BaseTable.control.label"));
        this.selectorsPanel.remove(this.genericLabel);
        this.selectorsPanel.add((Component)this.genericLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 6, 0), 0, 0));
    }

    public PhysicalTable getSelectedTable() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.genericTableModel.getRoot();
        DefaultMutableTreeNode leaf = this.getFirstLeaf(root);
        PhysicalTable table = null;
        try {
            SimpleBrowseObjectTreeNode node;
            SimpleBrowseObject selectedTable;
            if (leaf != null && leaf instanceof SimpleBrowseObjectTreeNode && (selectedTable = (node = (SimpleBrowseObjectTreeNode)leaf).getSimpleBrowseObject()).getMetadataType().equals(TABLE)) {
                String id = selectedTable.getID();
                table = this.m_tableSet.getPhysicalTable(id);
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return table;
    }

    public PhysicalTable getSelectedDrillTable() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.drillTableModel.getRoot();
        DefaultMutableTreeNode leaf = this.getFirstLeaf(root);
        PhysicalTable table = null;
        try {
            SimpleBrowseObjectTreeNode node;
            SimpleBrowseObject selectedTable;
            if (leaf != null && leaf instanceof SimpleBrowseObjectTreeNode && (selectedTable = (node = (SimpleBrowseObjectTreeNode)leaf).getSimpleBrowseObject()).getMetadataType().equals(TABLE)) {
                String id = selectedTable.getID();
                table = this.m_tableSet.getPhysicalTable(id);
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return table;
    }

    public List getSelectedTables() {
        ArrayList<PhysicalTable> list = new ArrayList<PhysicalTable>();
        try {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.genericTableModel.getRoot();
            int numSelectedLibraries = root.getChildCount();
            for (int i = 0; i < numSelectedLibraries; ++i) {
                SimpleBrowseObjectTreeNode libraryNode = (SimpleBrowseObjectTreeNode)root.getChildAt(i);
                int numSelectedTables = libraryNode.getChildCount();
                for (int j = 0; j < numSelectedTables; ++j) {
                    SimpleBrowseObjectTreeNode tableNode = (SimpleBrowseObjectTreeNode)libraryNode.getChildAt(j);
                    SimpleBrowseObject selectedTable = tableNode.getSimpleBrowseObject();
                    String id = selectedTable.getID();
                    PhysicalTable physicalTable = this.m_tableSet.getPhysicalTable(id);
                    if (physicalTable == null) continue;
                    list.add(physicalTable);
                }
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return list;
    }

    public String getOptions() {
        return this.m_strTableOptions;
    }

    public String getDrillOptions() {
        return this.m_strDrillTableOptions;
    }

    public void setMapTableButton(boolean enabled) {
        if (this.m_displayMapButton) {
            this.m_mapTableBtn.setEnabled(enabled);
        }
    }

    public void setDrillOptions(String options) {
        this.m_strDrillTableOptions = options;
    }

    public void setMLS(boolean inMLS) {
        this.m_excludeMLStables = inMLS;
        this.treePanel.setMLS(inMLS);
    }

    public void setOptions(String options) {
        this.m_strTableOptions = options;
    }

    public void initializeDrillTable(PhysicalTable table) {
        this.drillTableToSelect = table;
    }

    public void initializeSelectedTable(PhysicalTable table) {
        this.m_tablesToSelect.clear();
        this.m_tablesToSelect.add(table);
    }

    public void initializeSelectedTables(List tables) {
        if (tables != null) {
            this.m_tablesToSelect = tables;
        }
    }

    public void initializeSelectedOLAPTables(OLAPList tables) {
        if (tables == null) {
            this.initializeSelectedTables((List)tables);
        } else {
            ArrayList<PhysicalTable> list = new ArrayList<PhysicalTable>();
            for (int i = 0; i < tables.size(); ++i) {
                OLAPTable table = (OLAPTable)tables.get(i);
                list.add(i, table.getTable());
            }
            this.initializeSelectedTables(list);
        }
    }

    public void setExclusionTables(List tables) {
        this.m_exclusionTables = tables;
        int size = this.m_exclusionTables.size();
        for (int i = 0; i < size; ++i) {
            this.usedTables.add(this.m_exclusionTables.get(i));
        }
    }

    public void removeExclusionTables() throws RemoteException {
        if (this.m_exclusionTables != null) {
            int size = this.m_exclusionTables.size();
            for (int i = 0; i < size; ++i) {
                String id = (String)this.m_exclusionTables.get(i);
                int whereIsIt = this.usedTables.indexOf(id);
                if (whereIsIt <= -1) continue;
                this.usedTables.remove(whereIsIt);
            }
            this.m_exclusionTables.clear();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.findAndMoveSelectedTables();
        this.selectDrillTable();
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (this.m_displayMapButton) {
            this.m_mapTableBtn.setEnabled(false);
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        if (this.m_cube != null) {
            this.m_tableSet = this.m_cube.getTableSet();
        } else if (this.sharedDim != null) {
            this.m_tableSet = this.sharedDim.getTableSet();
        }
        this.setStorePopulated(true);
    }

    public boolean isOnlyOneLibrary() {
        return this.onlyOneLibrary;
    }

    public void saveSettingsAndCleanUp() {
        this.treePanel.dispose();
    }

    private void findAndMoveSelectedTable(PhysicalTable table, DefaultTreeModel selectedModel) throws MdException, RemoteException {
        if (table == null || selectedModel == null) {
            return;
        }
        DefaultMutableTreeNode selectedRoot = (DefaultMutableTreeNode)selectedModel.getRoot();
        SASLibrary library = LibraryUtil.getLibrary((DataTable)table, null);
        if (library != null) {
            String id = library.getId();
            boolean found = false;
            SimpleBrowseObjectTreeNode newLibraryNode = null;
            int size = this.librariesAdded.size();
            for (int i = 0; i < size && !found; ++i) {
                SimpleBrowseObjectTreeNode nextLibraryNode = (SimpleBrowseObjectTreeNode)this.librariesAdded.get(i);
                String libraryID = nextLibraryNode.getID();
                if (!libraryID.equals(id)) continue;
                newLibraryNode = nextLibraryNode;
                found = true;
            }
            SimpleBrowseObjectTreeNode libraryNode = null;
            OLAPInventoryTreeModel model = this.treePanel.getModel();
            CategoryTreeNode libraryRoot = model.getLibraryNode();
            SimpleBrowseObjectTreeNode selectedLibraryNode = this.findLibraryNode((DefaultMutableTreeNode)libraryRoot, id, (JTree)this.inventoryTree);
            if (selectedLibraryNode != null && selectedLibraryNode instanceof SimpleBrowseObjectTreeNode) {
                libraryNode = selectedLibraryNode;
                if (newLibraryNode == null) {
                    newLibraryNode = new SimpleBrowseObjectTreeNode(libraryNode.getSimpleBrowseObject());
                    this.librariesAdded.add(newLibraryNode);
                }
            }
            String tableId = table.getId();
            this.usedTables.add(tableId);
            SimpleBrowseObjectTreeNode selectedTableNode = this.findNode((DefaultMutableTreeNode)libraryNode, tableId, (JTree)this.treePanel.getInventoryTree());
            if (selectedTableNode != null) {
                SimpleBrowseObjectTreeNode newTableNode = new SimpleBrowseObjectTreeNode(selectedTableNode.getSimpleBrowseObject());
                if (!found) {
                    selectedModel.insertNodeInto((MutableTreeNode)newLibraryNode, selectedRoot, selectedRoot.getChildCount());
                    newLibraryNode.setAllowsChildren(true);
                }
                selectedModel.insertNodeInto((MutableTreeNode)newTableNode, (MutableTreeNode)newLibraryNode, newLibraryNode.getChildCount());
            }
        }
    }

    private void putFocusOnFirstTable() {
        DefaultMutableTreeNode t = (DefaultMutableTreeNode)this.genericTableModel.getRoot();
        DefaultMutableTreeNode l = t.getFirstLeaf();
        this.genericTree.setSelectionPath(new TreePath(l.getPath()));
    }

    private void findAndMoveSelectedTables() throws MdException, RemoteException {
        int i;
        if (this.m_tablesToSelect == null) {
            return;
        }
        this.librariesAdded.clear();
        for (i = 0; i < this.m_tablesToSelect.size(); ++i) {
            this.findAndMoveSelectedTable((PhysicalTable)this.m_tablesToSelect.get(i), this.genericTableModel);
        }
        this.m_tablesToSelect.clear();
        int size = this.librariesAdded.size();
        for (i = 0; i < size; ++i) {
            SimpleBrowseObjectTreeNode nextNode = (SimpleBrowseObjectTreeNode)this.librariesAdded.get(i);
            this.genericTree.expandPath(new TreePath(nextNode.getPath()));
        }
    }

    private void selectDrillTable() throws MdException, RemoteException {
        if (this.drillTableToSelect == null) {
            return;
        }
        this.librariesAdded.clear();
        this.findAndMoveSelectedTable(this.drillTableToSelect, this.drillTableModel);
        int size = this.librariesAdded.size();
        for (int i = 0; i < size; ++i) {
            SimpleBrowseObjectTreeNode nextNode = (SimpleBrowseObjectTreeNode)this.librariesAdded.get(i);
            this.drillTree.expandPath(new TreePath(nextNode.getPath()));
        }
    }

    public void sasLibrariesCreated() {
        this.setDataChanged(true);
    }

    public void physicalTablesCreated() {
        this.setDataChanged(true);
    }

    public void setAdditionalHierarchyModel(ISimpleObjectHierarchyModel model) {
        this.treePanel.setAdditionalHierarchyModel(model);
        if (this.hasBeenShown) {
            this.treePanel.refreshTrees();
        }
    }

    public void setVisibleTypes(String[] aPublicTypes) {
        this.setVisibleObjectsFilter(ObjectSelectorFilterFactory.createObjectFilter((String[])aPublicTypes));
    }

    public void setVisibleObjectsFilter(ISimpleObjectFilter filter) {
        this.treePanel.setNodeFilter(filter);
        if (this.hasBeenShown) {
            this.treePanel.refreshTrees();
        }
    }

    public void setInventoryTypes(String[] aVisibleTypes) {
        this.setInventoryTypesFilter(ObjectSelectorFilterFactory.createTypeFilter((String[])aVisibleTypes));
    }

    public void setInventoryTypesFilter(IPublicTypeFilter filter) {
        this.treePanel.setInventoryTypesFilter(filter);
        if (this.hasBeenShown) {
            this.treePanel.refreshTrees();
        }
    }

    public void setSelectableTypes(String[] aSelectableTypes) {
        this.selectableObjectsFilter = ObjectSelectorFilterFactory.createObjectFilter((String[])aSelectableTypes);
    }

    protected void initialize() {
        try {
            this.hasBeenShown = true;
            if (!this.onlyOneLibrary && this.m_cube != null) {
                this.treePanel = new OLAPTabbedTreePanel(Workspace.getWorkspace().getUserContext(), false, true, this.m_excludeMLStables, this.m_maxToSelect, (AbstractOLAPModel)this.m_cube);
            } else if (this.sharedDim != null) {
                this.treePanel = new OLAPTabbedTreePanel(Workspace.getWorkspace().getUserContext(), false, true, this.m_excludeMLStables, this.m_maxToSelect, (AbstractOLAPModel)this.sharedDim);
            } else if (this.olapDim != null) {
                this.treePanel = new OLAPTabbedTreePanel(Workspace.getWorkspace().getUserContext(), false, true, this.m_excludeMLStables, this.m_maxToSelect, (AbstractOLAPModel)this.olapDim);
            }
            this.usedTables = this.treePanel.getUsedTables();
            if (this.m_cube != null) {
                this.m_tableSet = this.m_cube.getTableSet();
                this.measureSet = this.m_cube.getMeasureSet();
            } else if (this.sharedDim != null) {
                this.m_tableSet = this.sharedDim.getTableSet();
            }
            String[] aSelectableTypes = new String[]{"Table"};
            String[] aVisibleTypes = new String[]{"Table", "Library"};
            this.setSelectableTypes(aSelectableTypes);
            this.setVisibleTypes(aVisibleTypes);
            this.setInventoryTypes(aVisibleTypes);
            this.treePanel.setEnabled(this.m_enableSelector);
            this.treePanel.setPreferredSize(new Dimension(150, 250));
            this.treePanel.setToolTipText(m_bundle.getString("PhysicalTableSelector.Selector.ToolTip.txt"));
            this.foldersTree = this.treePanel.getFolderTree();
            this.inventoryTree = this.treePanel.getInventoryTree();
            this.arrowButton = new JButton(Resources.getImageIcon((String)"ArrowRightAdd.gif", (int)16));
            this.arrowButton.setName("ArrowRightAdd");
            this.arrowButton.setToolTipText(m_bundle.getString("PhysicalTableSelector.ArrowRightAdd.tip"));
            this.arrowButton.setPreferredSize(new Dimension(25, 25));
            this.arrowButton.setEnabled(false);
            this.foldersTree.addMouseListener((MouseListener)new TreePanelMouseAdapter());
            this.inventoryTree.addMouseListener((MouseListener)new TreePanelMouseAdapter());
            this.genericListener = new GenericListener();
            this.foldersTree.addTreeSelectionListener((TreeSelectionListener)this.genericListener);
            this.inventoryTree.addTreeSelectionListener((TreeSelectionListener)this.genericListener);
            this.genericTree = new JTree();
            this.genericTree.addFocusListener(new TreeFocusListener());
            this.scroll = new JScrollPane(this.genericTree);
            this.genericLabel = new JLabel();
            this.genericLabel.setLabelFor(this.genericTree);
            this.genericTree.setRootVisible(false);
            this.genericTree.setShowsRootHandles(true);
            this.genericTableModel = new DefaultTreeModel(new DefaultMutableTreeNode(m_bundle.getString("PhysicalTableSelector.TreeRootNode.Selected.txt")));
            this.genericTree.setModel(this.genericTableModel);
            this.genericTableModel.addTreeModelListener(new cTreeModelListener());
            this.genericTree.setName("InputTreePhysicalTable");
            this.genericTree.setShowsRootHandles(false);
            TableSelectorTreeCellRenderer myTreeCellRenderer = new TableSelectorTreeCellRenderer();
            this.genericTree.setCellRenderer(myTreeCellRenderer);
            this.genericTree.addTreeSelectionListener(this.genericListener);
            if (this.m_inputDrill) {
                TableSet tableSet = this.m_cube.getTableSet();
                if (tableSet.isLoadStarSchema()) {
                    VisualUtilities.setLabelTextAndMnemonic(this.genericLabel, m_bundle.getString("PhysicalTableSelector.FactTable.control.label"));
                } else {
                    VisualUtilities.setLabelTextAndMnemonic(this.genericLabel, m_bundle.getString("PhysicalTableSelector.BaseTable.control.label"));
                }
                this.drillLabel = new JLabel();
                VisualUtilities.setLabelTextAndMnemonic(this.drillLabel, m_bundle.getString("PhysicalTableSelector.DrillThroughTable.control.label"));
                this.drillTree = new JTree();
                this.drillTree.addFocusListener(new TreeFocusListener());
                this.drillLabel.setLabelFor(this.drillTree);
                this.scrollDrill = new JScrollPane(this.drillTree);
                this.drillTree.setRootVisible(false);
                this.drillTableModel = new DefaultTreeModel(new DefaultMutableTreeNode(m_bundle.getString("PhysicalTableSelector.TreeRootNode.Selected.txt")));
                this.drillTree.setModel(this.drillTableModel);
                this.drillTree.setName("DrillTreePhysicalTable");
                this.drillTree.setCellRenderer(myTreeCellRenderer);
                this.drillTree.addTreeSelectionListener(this.genericListener);
                this.drillTree.setShowsRootHandles(false);
                this.genericTree.getSelectionModel().setSelectionMode(1);
                this.drillTree.getSelectionModel().setSelectionMode(1);
            } else if (this.m_maxToSelect == 1) {
                VisualUtilities.setLabelTextAndMnemonic(this.genericLabel, m_bundle.getString("PhysicalTableSelector.SelectedSingleTable.Label.txt"));
                this.genericTree.getSelectionModel().setSelectionMode(1);
            } else {
                VisualUtilities.setLabelTextAndMnemonic(this.genericLabel, m_bundle.getString("PhysicalTableSelector.SelectedMultipleTables.Label.txt"));
                this.genericTree.getSelectionModel().setSelectionMode(4);
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        this.availableLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(this.availableLabel, m_bundle.getString("PhysicalTableSelector.Available.Label.txt"));
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridBagLayout());
        this.m_propertiesBtn = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.m_propertiesBtn, m_bundle.getString("PhysicalTableSelector.Button.TableProperties.txt"));
        this.m_propertiesBtn.setToolTipText(m_bundle.getString("PhysicalTableSelector.Button.TableProperties.ToolTip.txt"));
        this.m_propertiesBtn.addActionListener(new cTablePropertiesListener());
        this.m_propertiesBtn.setEnabled(false);
        this.m_defineTablesBtn = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.m_defineTablesBtn, m_bundle.getString("PhysicalTableSelector.Button.DefineTable.txt"));
        this.m_defineTablesBtn.setToolTipText(m_bundle.getString("PhysicalTableSelector.Button.DefineTable.ToolTip.txt"));
        this.m_defineTablesBtn.addActionListener(new cDefineTableListener());
        this.m_defineTablesBtn.setEnabled(this.m_enableSelector);
        this.m_viewDataBtn = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.m_viewDataBtn, m_bundle.getString("PhysicalTableSelector.Button.ViewData.txt"));
        this.m_viewDataBtn.setToolTipText(m_bundle.getString("PhysicalTableSelector.Button.ViewData.ToolTip.txt"));
        this.m_viewDataBtn.addActionListener(new cViewDataListener());
        this.m_viewDataBtn.setEnabled(false);
        if (this.m_displayMapButton) {
            this.m_mapTableBtn = new JButton();
            VisualUtilities.setButtonTextAndMnemonic(this.m_mapTableBtn, m_bundle.getString("PhysicalTableSelector.Button.MapTable.txt"));
            this.m_mapTableBtn.setToolTipText(m_bundle.getString("PhysicalTableSelector.Button.MapTable.ToolTip.txt"));
            this.m_mapTableBtn.addActionListener(new cMapTableListener());
            this.m_mapTableBtn.setEnabled(false);
        }
        this.m_tableSet.getListeners().add(this);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        GenericArrowListener arrowListener = new GenericArrowListener();
        this.m_buttons = new JPanel();
        this.m_buttons.setLayout(new GridBagLayout());
        this.selectorsPanel = new JPanel();
        JPanel tabbedPanel = new JPanel();
        tabbedPanel.setLayout(new GridBagLayout());
        this.selectorsPanel.setLayout(new GridBagLayout());
        Border brdrOuter = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        ButtonBorderRollOverHandler handler = new ButtonBorderRollOverHandler();
        handler.addButton((AbstractButton)this.arrowButton);
        tabbedPanel.add((Component)this.availableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 6, 0), 0, 0));
        this.availableLabel.setLabelFor(this.treePanel);
        tabbedPanel.add((Component)this.treePanel, new GridBagConstraints(0, 1, 2, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.arrowButton.addActionListener(arrowListener);
        this.arrowButton.setToolTipText(m_bundle.getString("PhysicalTableSelector.ArrowRightAdd.tip"));
        this.deleteGeneric = new JButton(Resources.getImageIcon((String)"Delete.gif", (int)16));
        this.deleteGeneric.setName("DeleteGeneric");
        this.deleteGeneric.setToolTipText(m_bundle.getString("PhysicalTableSelector.DeleteATable.tip"));
        this.deleteGeneric.addActionListener(new DeleteTableListener());
        this.deleteGeneric.setPreferredSize(new Dimension(25, 25));
        handler.addButton((AbstractButton)this.deleteGeneric);
        this.deleteGeneric.setEnabled(false);
        this.tableOptionsGeneric = new JButton(Resources.getImageIcon((String)"Options.gif", (int)16));
        this.tableOptionsGeneric.setName("tableOptionsGeneric");
        this.tableOptionsGeneric.setToolTipText(m_bundle.getString("PhysicalTableSelector.TableOptions.tip"));
        this.tableOptionsGeneric.addActionListener(new TableOptionsListener());
        this.tableOptionsGeneric.setPreferredSize(new Dimension(25, 25));
        handler.addButton((AbstractButton)this.tableOptionsGeneric);
        this.tableOptionsGeneric.setEnabled(false);
        if (this.m_inputDrill) {
            this.scroll.setPreferredSize(new Dimension(150, 100));
            Border brdrInner = this.scroll.getBorder();
            this.scroll.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
            this.arrowButton2 = new JButton(Resources.getImageIcon((String)"ArrowRightAdd.gif", (int)16));
            this.arrowButton2.setName("ArrowRightAdd");
            this.arrowButton2.setToolTipText(m_bundle.getString("PhysicalTableSelector.ArrowRightAdd.tip"));
            this.arrowButton2.addActionListener(arrowListener);
            this.arrowButton2.setPreferredSize(new Dimension(25, 25));
            this.arrowButton2.setEnabled(false);
            handler.addButton((AbstractButton)this.arrowButton2);
            this.scrollDrill.setPreferredSize(new Dimension(150, 100));
            Border brdrInnerDrill = this.scrollDrill.getBorder();
            this.scrollDrill.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInnerDrill));
            this.deleteDrill = new JButton(Resources.getImageIcon((String)"Delete.gif", (int)16));
            this.deleteDrill.setName("DeleteDrill");
            this.deleteDrill.setToolTipText(m_bundle.getString("PhysicalTableSelector.DeleteATable.tip"));
            this.deleteDrill.addActionListener(new DeleteTableListener());
            this.deleteDrill.setPreferredSize(new Dimension(25, 25));
            handler.addButton((AbstractButton)this.deleteDrill);
            this.deleteDrill.setEnabled(false);
            this.tableOptionsDrill = new JButton(Resources.getImageIcon((String)"Options.gif", (int)16));
            this.tableOptionsDrill.setName("tableOptionsDrill");
            this.tableOptionsDrill.setToolTipText(m_bundle.getString("PhysicalTableSelector.TableOptions.tip"));
            this.tableOptionsDrill.addActionListener(new TableOptionsListener());
            this.tableOptionsDrill.setPreferredSize(new Dimension(25, 25));
            handler.addButton((AbstractButton)this.tableOptionsDrill);
            this.tableOptionsDrill.setEnabled(false);
            this.selectorsPanel.add((Component)this.arrowButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.genericLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 6, 0), 0, 0));
            this.selectorsPanel.add((Component)this.scroll, new GridBagConstraints(2, 3, 2, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.deleteGeneric, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.tableOptionsGeneric, new GridBagConstraints(5, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(50, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.arrowButton2, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(25, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.drillLabel, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 6, 0), 0, 0));
            this.selectorsPanel.add((Component)this.scrollDrill, new GridBagConstraints(2, 8, 2, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.deleteDrill, new GridBagConstraints(5, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.selectorsPanel.add((Component)this.tableOptionsDrill, new GridBagConstraints(5, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(50, 0, 0, 0), 0, 0));
        } else {
            this.scroll.setPreferredSize(new Dimension(150, 250));
            Border brdrInner = this.scroll.getBorder();
            this.scroll.setBorder(BorderFactory.createCompoundBorder(brdrOuter, brdrInner));
            this.selectorsPanel.add((Component)this.arrowButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 8), 0, 0));
            this.selectorsPanel.add((Component)this.genericLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 6, 0), 0, 0));
            this.selectorsPanel.add((Component)this.scroll, new GridBagConstraints(1, 1, 2, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 6, 0), 0, 0));
            this.selectorsPanel.add((Component)this.deleteGeneric, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            if (this.m_displayOptions) {
                this.selectorsPanel.add((Component)this.tableOptionsGeneric, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.add(tabbedPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.selectorsPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_buttons.add((Component)this.m_propertiesBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_buttons.add((Component)this.m_viewDataBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_buttons.add((Component)this.m_defineTablesBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_displayMapButton) {
            this.m_buttons.add((Component)this.m_mapTableBtn, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
        this.add(this.m_buttons, new GridBagConstraints(0, 4, 6, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private SimpleBrowseObjectTreeNode findLibraryNode(DefaultMutableTreeNode startingNode, String sFQID, JTree selectedTree) {
        TreePath libraryPath = new TreePath(startingNode.getPath());
        if (startingNode.getChildCount() < 1) {
            selectedTree.expandPath(libraryPath);
        }
        Enumeration<TreeNode> enumNodes = startingNode.breadthFirstEnumeration();
        SimpleBrowseObjectTreeNode libraryNode = null;
        boolean found = false;
        while (enumNodes.hasMoreElements() && !found) {
            SimpleBrowseObjectTreeNode simpleNode;
            DefaultMutableTreeNode nodeCurrent = (DefaultMutableTreeNode)enumNodes.nextElement();
            if (!(nodeCurrent instanceof SimpleBrowseObjectTreeNode) || !sFQID.equals((simpleNode = (SimpleBrowseObjectTreeNode)nodeCurrent).getID())) continue;
            libraryNode = simpleNode;
            found = true;
        }
        return libraryNode;
    }

    private SimpleBrowseObjectTreeNode findNode(DefaultMutableTreeNode node, String inId, JTree selectedTree) {
        if (node == null) {
            return null;
        }
        TreePath libraryPath = new TreePath(node.getPath());
        boolean isLibraryExpanded = selectedTree.isExpanded(libraryPath);
        if (node.getChildCount() < 1 && !isLibraryExpanded) {
            selectedTree.expandPath(libraryPath);
        }
        int numChildNodes = node.getChildCount();
        SimpleBrowseObjectTreeNode foundNode = null;
        for (int i = 0; i < numChildNodes && foundNode == null; ++i) {
            SimpleBrowseObjectTreeNode simpleChildNode;
            String id;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (!(childNode instanceof SimpleBrowseObjectTreeNode) || !inId.equals(id = (simpleChildNode = (SimpleBrowseObjectTreeNode)childNode).getID())) continue;
            foundNode = simpleChildNode;
        }
        return foundNode;
    }

    public SimpleBrowseObject[] getLibrary(SimpleBrowseObject simpleObject) {
        ArrayList<SimpleBrowseObjectImpl> lSimpleParents = new ArrayList<SimpleBrowseObjectImpl>();
        try {
            Filter filter = new Filter();
            filter.setOMRTemplate("<Templates><DataTable><SourceTransformations/><TablePackage/><TargetTransformations/></DataTable><DatabaseSchema><UsedByPackages/></DatabaseSchema></Templates>");
            filter.setOMRFlags(16);
            String sKey = simpleObject.getID() + "/" + simpleObject.getMetadataType();
            BrowseMetadataInterface table = Workspace.getWorkspace().getUserContext().getAuthServer().browseFetch(sKey, (FilterInterface)filter);
            List lLibraries = null;
            List lTablePackages = (List)table.get("TablePackage");
            if (lTablePackages != null && lTablePackages.size() > 0) {
                BrowseMetadataInterface tablePackage = (BrowseMetadataInterface)lTablePackages.get(0);
                lLibraries = "DatabaseSchema".equals(tablePackage.getNativeType()) ? (List)tablePackage.get("UsedByPackages") : lTablePackages;
            }
            if (lLibraries != null && !lLibraries.isEmpty()) {
                for (int i = 0; i < lLibraries.size(); ++i) {
                    BrowseMetadataInterface library = (BrowseMetadataInterface)lLibraries.get(i);
                    lSimpleParents.add(new SimpleBrowseObjectImpl(library));
                }
            }
        }
        catch (ServiceException ex) {
            MessageUtil.displayServiceExceptionMessage((ServiceException)ex);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        return lSimpleParents.toArray(new SimpleBrowseObject[lSimpleParents.size()]);
    }

    public void unSelectPaths(JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null && paths.length > 0) {
            tree.removeTreeSelectionListener(this.genericListener);
            tree.removeSelectionPaths(paths);
            tree.addTreeSelectionListener(this.genericListener);
        }
    }

    private void disableOrEnableButtons(SimpleBrowseObjectTreeNode lastSelectedNode, JTree tree) {
        SimpleBrowseObject simpleBrowse = lastSelectedNode.getSimpleBrowseObject();
        if (simpleBrowse.getMetadataType().equals(TABLE)) {
            this.m_propertiesBtn.setEnabled(true);
            this.m_viewDataBtn.setEnabled(true);
            this.m_lastSelectedTable = simpleBrowse;
            if (tree.equals(this.genericTree)) {
                this.arrowButton.setEnabled(false);
                if (this.arrowButton2 != null) {
                    this.arrowButton2.setEnabled(false);
                }
                this.deleteGeneric.setEnabled(true);
                this.tableOptionsGeneric.setEnabled(true);
                if (this.deleteDrill != null) {
                    this.deleteDrill.setEnabled(false);
                    this.tableOptionsDrill.setEnabled(false);
                }
            } else if (tree.equals(this.drillTree)) {
                this.arrowButton.setEnabled(false);
                if (this.arrowButton2 != null) {
                    this.arrowButton2.setEnabled(false);
                }
                this.deleteDrill.setEnabled(true);
                this.tableOptionsDrill.setEnabled(true);
                this.deleteGeneric.setEnabled(false);
                this.tableOptionsGeneric.setEnabled(false);
            } else {
                if (this.m_maxToSelect == -1) {
                    int selectedCount = tree.getSelectionCount();
                    if (selectedCount == 1) {
                        String id = simpleBrowse.getID();
                        boolean found = false;
                        int size = this.usedTables.size();
                        for (int i = 0; i < size && !found; ++i) {
                            String checkId = (String)this.usedTables.get(i);
                            if (!checkId.equals(id)) continue;
                            found = true;
                        }
                        if (found) {
                            this.arrowButton.setEnabled(false);
                        } else {
                            this.arrowButton.setEnabled(true);
                        }
                    } else {
                        this.arrowButton.setEnabled(true);
                    }
                }
                if (this.m_maxToSelect == 1) {
                    DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.genericTableModel.getRoot();
                    this.arrowButton.setEnabled(root.getChildCount() <= 0);
                    if (this.m_inputDrill) {
                        root = (DefaultMutableTreeNode)this.drillTableModel.getRoot();
                        this.arrowButton2.setEnabled(root.getChildCount() <= 0);
                    }
                }
                this.deleteGeneric.setEnabled(false);
                this.tableOptionsGeneric.setEnabled(false);
                if (this.m_inputDrill) {
                    this.deleteDrill.setEnabled(false);
                    this.tableOptionsDrill.setEnabled(false);
                }
            }
        } else {
            this.m_propertiesBtn.setEnabled(false);
            this.m_viewDataBtn.setEnabled(false);
            this.deleteGeneric.setEnabled(false);
            this.tableOptionsGeneric.setEnabled(false);
            if (tree.equals(this.drillTree)) {
                this.tableOptionsDrill.setEnabled(false);
                this.deleteDrill.setEnabled(false);
            }
            this.m_lastSelectedTable = null;
        }
    }

    private final class TreePanelMouseAdapter
    extends MouseAdapter {
        private TreePanelMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                return;
            }
        }
    }

    private final class GenericListener
    implements TreeSelectionListener {
        private GenericListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            JTree tree = (JTree)e.getSource();
            int selectedCount = tree.getSelectionCount();
            if (tree.equals(PhysicalTableSelector.this.genericTree)) {
                PhysicalTableSelector.this.unSelectPaths((JTree)PhysicalTableSelector.this.foldersTree);
                PhysicalTableSelector.this.unSelectPaths((JTree)PhysicalTableSelector.this.inventoryTree);
                if (PhysicalTableSelector.this.m_inputDrill) {
                    PhysicalTableSelector.this.unSelectPaths(PhysicalTableSelector.this.drillTree);
                    PhysicalTableSelector.this.deleteDrill.setEnabled(false);
                }
                if (selectedCount > 1) {
                    PhysicalTableSelector.this.deleteGeneric.setEnabled(true);
                    PhysicalTableSelector.this.tableOptionsGeneric.setEnabled(false);
                } else if (selectedCount == 1) {
                    PhysicalTableSelector.this.deleteGeneric.setEnabled(true);
                    PhysicalTableSelector.this.tableOptionsGeneric.setEnabled(true);
                } else if (selectedCount < 1) {
                    PhysicalTableSelector.this.deleteGeneric.setEnabled(false);
                    PhysicalTableSelector.this.tableOptionsGeneric.setEnabled(false);
                }
            } else if (tree.equals(PhysicalTableSelector.this.inventoryTree)) {
                PhysicalTableSelector.this.unSelectPaths((JTree)PhysicalTableSelector.this.foldersTree);
                PhysicalTableSelector.this.unSelectPaths(PhysicalTableSelector.this.genericTree);
                PhysicalTableSelector.this.deleteGeneric.setEnabled(false);
                if (PhysicalTableSelector.this.m_inputDrill) {
                    PhysicalTableSelector.this.unSelectPaths(PhysicalTableSelector.this.drillTree);
                    PhysicalTableSelector.this.deleteDrill.setEnabled(false);
                }
            } else if (tree.equals(PhysicalTableSelector.this.foldersTree)) {
                PhysicalTableSelector.this.unSelectPaths((JTree)PhysicalTableSelector.this.inventoryTree);
                PhysicalTableSelector.this.unSelectPaths(PhysicalTableSelector.this.genericTree);
                PhysicalTableSelector.this.deleteGeneric.setEnabled(false);
                if (PhysicalTableSelector.this.m_inputDrill) {
                    PhysicalTableSelector.this.unSelectPaths(PhysicalTableSelector.this.drillTree);
                    PhysicalTableSelector.this.deleteDrill.setEnabled(false);
                }
            } else if (tree.equals(PhysicalTableSelector.this.drillTree)) {
                PhysicalTableSelector.this.unSelectPaths((JTree)PhysicalTableSelector.this.foldersTree);
                PhysicalTableSelector.this.unSelectPaths((JTree)PhysicalTableSelector.this.inventoryTree);
                PhysicalTableSelector.this.unSelectPaths(PhysicalTableSelector.this.genericTree);
                if (selectedCount > 1) {
                    PhysicalTableSelector.this.deleteDrill.setEnabled(true);
                    PhysicalTableSelector.this.tableOptionsDrill.setEnabled(false);
                } else if (selectedCount == 1) {
                    PhysicalTableSelector.this.deleteDrill.setEnabled(true);
                    PhysicalTableSelector.this.tableOptionsDrill.setEnabled(true);
                } else if (selectedCount < 1) {
                    PhysicalTableSelector.this.deleteDrill.setEnabled(false);
                    PhysicalTableSelector.this.tableOptionsDrill.setEnabled(false);
                }
            }
            if (selectedCount == 1) {
                Object lastSelectedNode = tree.getLastSelectedPathComponent();
                if (lastSelectedNode instanceof SimpleBrowseObjectTreeNode) {
                    SimpleBrowseObjectTreeNode simpleBrowseObject = (SimpleBrowseObjectTreeNode)lastSelectedNode;
                    PhysicalTableSelector.this.disableOrEnableButtons(simpleBrowseObject, tree);
                } else {
                    PhysicalTableSelector.this.m_propertiesBtn.setEnabled(false);
                    PhysicalTableSelector.this.m_viewDataBtn.setEnabled(false);
                    PhysicalTableSelector.this.m_lastSelectedTable = null;
                    PhysicalTableSelector.this.arrowButton.setEnabled(false);
                    if (PhysicalTableSelector.this.arrowButton2 != null) {
                        PhysicalTableSelector.this.arrowButton2.setEnabled(false);
                    }
                }
            } else {
                PhysicalTableSelector.this.m_propertiesBtn.setEnabled(false);
                PhysicalTableSelector.this.m_viewDataBtn.setEnabled(false);
                PhysicalTableSelector.this.m_lastSelectedTable = null;
                if (PhysicalTableSelector.this.m_maxToSelect == -1) {
                    PhysicalTableSelector.this.arrowButton.setEnabled(true);
                } else {
                    PhysicalTableSelector.this.arrowButton.setEnabled(false);
                    if (PhysicalTableSelector.this.arrowButton2 != null) {
                        PhysicalTableSelector.this.arrowButton2.setEnabled(false);
                    }
                }
            }
        }
    }

    public class TreeFocusListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            JTree sourceTree;
            Component obj = e.getComponent();
            if (obj instanceof JTree && (sourceTree = (JTree)obj).getMaxSelectionRow() < 0) {
                sourceTree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected class cTreeModelListener
    implements TreeModelListener {
        protected cTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            DefaultTreeModel selectedModel = (DefaultTreeModel)e.getSource();
            if ((PhysicalTableSelector.this.m_inputDrill || PhysicalTableSelector.this.isShared) && selectedModel.equals(PhysicalTableSelector.this.genericTableModel)) {
                if (PhysicalTableSelector.this.m_displayMapButton) {
                    PhysicalTableSelector.this.m_mapTableBtn.setEnabled(false);
                }
                try {
                    SharedDimensionTable sharedTable;
                    if (!PhysicalTableSelector.this.isShared) {
                        LoadTable loadTable = PhysicalTableSelector.this.m_tableSet.getLoadTable();
                        if (loadTable != null) {
                            loadTable.clearMap();
                        }
                    } else if (PhysicalTableSelector.this.sharedDim != null && (sharedTable = PhysicalTableSelector.this.sharedDim.getSharedDimensionTable()) != null) {
                        sharedTable.clearMap();
                    }
                    PhysicalTableSelector.this.m_currentMaxSelectedOne = null;
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            DefaultTreeModel selectedModel = (DefaultTreeModel)e.getSource();
            if ((PhysicalTableSelector.this.m_inputDrill || PhysicalTableSelector.this.isShared) && selectedModel.equals(PhysicalTableSelector.this.genericTableModel)) {
                Object[] nodesInserted = e.getChildren();
                SimpleBrowseObjectTreeNode node = (SimpleBrowseObjectTreeNode)nodesInserted[0];
                SimpleBrowseObject userObject = node.getSimpleBrowseObject();
                try {
                    if (!PhysicalTableSelector.this.isShared && PhysicalTableSelector.this.m_cube.hasStructure() && userObject.getPublicType().equals("Table")) {
                        LoadTable loadTable = PhysicalTableSelector.this.m_tableSet.getLoadTable();
                        PhysicalTableSelector.this.m_currentMaxSelectedOne = userObject;
                        PhysicalTable table = null;
                        if (PhysicalTableSelector.this.m_currentMaxSelectedOne != null && userObject.getMetadataType().equals(PhysicalTableSelector.TABLE)) {
                            String id = PhysicalTableSelector.this.m_currentMaxSelectedOne.getID();
                            table = PhysicalTableSelector.this.m_tableSet.getPhysicalTable(id);
                        }
                        if (loadTable != null && !loadTable.isSimilar(table) && PhysicalTableSelector.this.m_displayMapButton) {
                            PhysicalTableSelector.this.m_mapTableBtn.setEnabled(true);
                        } else {
                            PhysicalTableSelector.this.m_currentMaxSelectedOne = null;
                        }
                    } else if (PhysicalTableSelector.this.isShared && PhysicalTableSelector.this.sharedDim.hasStructure() && userObject.getMetadataType().equals(PhysicalTableSelector.TABLE)) {
                        SharedDimensionTable sharedDimTable = PhysicalTableSelector.this.sharedDim.getSharedDimensionTable();
                        PhysicalTableSelector.this.m_currentMaxSelectedOne = userObject;
                        PhysicalTable table = null;
                        if (PhysicalTableSelector.this.m_currentMaxSelectedOne != null && userObject.getMetadataType().equals(PhysicalTableSelector.TABLE)) {
                            String id = PhysicalTableSelector.this.m_currentMaxSelectedOne.getID();
                            table = PhysicalTableSelector.this.m_tableSet.getPhysicalTable(id);
                        }
                        if (sharedDimTable != null && !sharedDimTable.isSimilar(PhysicalTableSelector.this.sharedDim, table) && PhysicalTableSelector.this.m_displayMapButton) {
                            PhysicalTableSelector.this.m_mapTableBtn.setEnabled(true);
                        } else if (PhysicalTableSelector.this.m_displayMapButton) {
                            PhysicalTableSelector.this.m_mapTableBtn.setEnabled(false);
                        }
                    }
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                }
            }
        }
    }

    protected class TableSelectorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        static final long serialVersionUID = 1L;

        protected TableSelectorTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus1) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus1);
            DefaultMutableTreeNode defaultTreeNode = (DefaultMutableTreeNode)value;
            if (defaultTreeNode instanceof SimpleBrowseObjectTreeNode) {
                SimpleBrowseObjectTreeNode treeNode = (SimpleBrowseObjectTreeNode)defaultTreeNode;
                SimpleBrowseObject object = treeNode.getSimpleBrowseObject();
                if (object.getPublicType().equals("Library")) {
                    this.setIcon(WsAbstractIconFactory.getInstance().getIconForPublicType("Library"));
                } else if (object.getPublicType().equals("Table")) {
                    this.setIcon(WsAbstractIconFactory.getInstance().getIconForPublicType("Table"));
                } else {
                    this.setIcon(m_bundle.getImageIcon("PhysicalTableSelector.RepositoryIcon.image"));
                }
            }
            return this;
        }
    }

    protected class cTablePropertiesListener
    implements ActionListener {
        protected cTablePropertiesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SimpleObjectImpl obj = new SimpleObjectImpl(PhysicalTableSelector.this.m_lastSelectedTable.getName(), PhysicalTableSelector.this.m_lastSelectedTable.getID(), PhysicalTableSelector.this.m_lastSelectedTable.getMetadataType(), PhysicalTableSelector.this.m_lastSelectedTable.getPublicType());
            PropertiesAction.showTablePropertySheet((Window)Workspace.getWorkspace(), (SimpleObject)obj, false);
        }
    }

    protected class cDefineTableListener
    implements ActionListener {
        protected cDefineTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (Utilities.isConnectedToMetadataServer((boolean)true)) {
                Workspace m_workspace = Workspace.getWorkspace();
                SourceDesigner waSourceDlg = new SourceDesigner((Frame)m_workspace, m_bundle.getString("Common.SourceDesigner.Title.txt"), null, false);
                waSourceDlg.setHelpProduct("wdb");
                waSourceDlg.show();
                if (PhysicalTableSelector.this.hasDataChanged()) {
                    PhysicalTableSelector.this.setDataChanged(false);
                    PhysicalTableSelector.this.reloadTree();
                }
            }
        }
    }

    protected class cViewDataListener
    implements ActionListener {
        protected cViewDataListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                WAStandardDialog parent = (WAStandardDialog)PhysicalTableSelector.this.getTopLevelAncestor();
                String id = PhysicalTableSelector.this.m_lastSelectedTable.getID();
                PhysicalTable table = PhysicalTableSelector.this.m_tableSet.getPhysicalTable(id);
                PhysicalTablePanel pnl2 = new PhysicalTablePanel(table, false);
                WAStandardDialog dlg = null;
                dlg = new WAStandardDialog((Dialog)parent, m_bundle.formatString("PhysicalTableSelector.ViewData.Title.fmt.txt", (Object)PhysicalTableSelector.this.m_lastSelectedTable.getName()), true, (WAPanel)pnl2);
                dlg.setApplyButtonVisible(false);
                dlg.setOKButtonVisible(false);
                dlg.setCancelButtonVisible(false);
                dlg.setCloseButtonVisible(true);
                dlg.setHelpButtonVisible(true);
                dlg.setHelpProduct("wdb");
                dlg.setResizable(true);
                dlg.setPreferredSize(new Dimension(700, 700));
                dlg.show();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
    }

    protected class cMapTableListener
    implements ActionListener {
        protected cMapTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                SharedDimensionTable dimTable;
                if (!PhysicalTableSelector.this.isShared) {
                    LoadTable loadTable = PhysicalTableSelector.this.m_tableSet.getLoadTable();
                    if (loadTable != null) {
                        String id = PhysicalTableSelector.this.m_currentMaxSelectedOne.getID();
                        PhysicalTable table = PhysicalTableSelector.this.m_tableSet.getPhysicalTable(id);
                        loadTable.mapTable(table);
                        WAStandardDialog parent = (WAStandardDialog)PhysicalTableSelector.this.getTopLevelAncestor();
                        CubeLoadTableMapDialog tableMapDlg = new CubeLoadTableMapDialog((Dialog)parent, (AbstractOLAPModel)PhysicalTableSelector.this.m_cube, table);
                        tableMapDlg.show();
                    }
                } else if (PhysicalTableSelector.this.sharedDim != null && (dimTable = PhysicalTableSelector.this.sharedDim.getSharedDimensionTable()) != null) {
                    String id = PhysicalTableSelector.this.m_currentMaxSelectedOne.getID();
                    PhysicalTable table = PhysicalTableSelector.this.m_tableSet.getPhysicalTable(id);
                    dimTable.mapTable(table);
                    WAStandardDialog parent = (WAStandardDialog)PhysicalTableSelector.this.getTopLevelAncestor();
                    SharedDimTableMapDialog tableMapDlg = new SharedDimTableMapDialog((Dialog)parent, (AbstractOLAPModel)PhysicalTableSelector.this.sharedDim, table);
                    tableMapDlg.show();
                }
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
    }

    private class GenericArrowListener
    implements ActionListener {
        private GenericArrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            IBaseTree tree = PhysicalTableSelector.this.treePanel.getSelectedTree();
            ITreeNode[] nodes = tree.getSelectedNodes();
            boolean genericButtonSelected = event.getSource().equals(PhysicalTableSelector.this.arrowButton);
            DefaultMutableTreeNode root = null;
            DefaultTreeModel selectedModel = null;
            JTree currentTree = null;
            JButton button = (JButton)event.getSource();
            if (genericButtonSelected) {
                root = (DefaultMutableTreeNode)PhysicalTableSelector.this.genericTableModel.getRoot();
                selectedModel = PhysicalTableSelector.this.genericTableModel;
                currentTree = PhysicalTableSelector.this.genericTree;
            } else {
                root = (DefaultMutableTreeNode)PhysicalTableSelector.this.drillTableModel.getRoot();
                selectedModel = PhysicalTableSelector.this.drillTableModel;
                currentTree = PhysicalTableSelector.this.drillTree;
            }
            if (nodes != null) {
                if (PhysicalTableSelector.this.m_maxToSelect == 1 && nodes.length > 1) {
                    MessageUtil.displayMessage((String)m_bundle.getString("PhysicalTableSelector.TooManyTablesSelected.Error.txt"), (int)1);
                    return;
                }
                if (PhysicalTableSelector.this.m_maxToSelect == 1 && selectedModel.getChildCount(root) > 0) {
                    MessageUtil.displayMessage((String)m_bundle.getString("PhysicalTableSelector.TooManyTablesSelected.Error.txt"), (int)1);
                    return;
                }
                PhysicalTableSelector.this.librariesAdded.clear();
                boolean tableChosen = false;
                int size = nodes.length;
                for (int i = 0; i < size; ++i) {
                    SimpleBrowseObjectTreeNode selectedTableNode;
                    SimpleBrowseObjectTreeNode selectedNode;
                    SimpleBrowseObject selectedBrowseObject;
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes[i];
                    if (!(node instanceof SimpleBrowseObjectTreeNode) || !(selectedBrowseObject = (selectedNode = (SimpleBrowseObjectTreeNode)node).getSimpleBrowseObject()).getPublicType().equals("Table")) continue;
                    String tableId = selectedNode.getID();
                    if (PhysicalTableSelector.this.usedTables.contains(tableId) && PhysicalTableSelector.this.m_maxToSelect == -1) continue;
                    tableChosen = true;
                    PhysicalTableSelector.this.dataChanged = true;
                    SimpleBrowseObject[] libraries = PhysicalTableSelector.this.getLibrary(selectedBrowseObject);
                    if (libraries.length <= 0) continue;
                    SimpleBrowseObject libraryThere = libraries[0];
                    String id = libraryThere.getID();
                    SimpleBrowseObjectTreeNode selectedLibraryNode = PhysicalTableSelector.this.findLibraryNode((DefaultMutableTreeNode)selectedModel.getRoot(), id, currentTree);
                    if (selectedLibraryNode == null) {
                        selectedLibraryNode = new SimpleBrowseObjectTreeNode(libraries[0]);
                        selectedModel.insertNodeInto((MutableTreeNode)selectedLibraryNode, root, root.getChildCount());
                        selectedLibraryNode.setAllowsChildren(true);
                    }
                    if (!PhysicalTableSelector.this.librariesAdded.contains(selectedLibraryNode)) {
                        PhysicalTableSelector.this.librariesAdded.add(selectedLibraryNode);
                    }
                    if ((selectedTableNode = PhysicalTableSelector.this.findNode((DefaultMutableTreeNode)selectedLibraryNode, tableId, currentTree)) == null) {
                        selectedTableNode = new SimpleBrowseObjectTreeNode(selectedBrowseObject);
                        selectedModel.insertNodeInto((MutableTreeNode)selectedTableNode, (MutableTreeNode)selectedLibraryNode, selectedLibraryNode.getChildCount());
                        String fqid = selectedBrowseObject.getID();
                        PhysicalTableSelector.this.usedTables.add(fqid);
                    }
                    if (PhysicalTableSelector.this.m_maxToSelect == -1) {
                        selectedNode.setEditable(false);
                        DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                        treeModel.reload(selectedNode.getParent());
                        continue;
                    }
                    button.setEnabled(false);
                }
                if (!tableChosen) {
                    MessageUtil.displayMessage((String)m_bundle.getString("PhysicalTableSelector.OnlyATableSelected.Error.txt"), (int)1);
                    return;
                }
                int sizeOfLibraries = PhysicalTableSelector.this.librariesAdded.size();
                if (sizeOfLibraries > 0 && PhysicalTableSelector.this.m_inputDrill) {
                    if (genericButtonSelected) {
                        PhysicalTableSelector.this.arrowButton.setEnabled(false);
                    } else {
                        DrillTableChangeEvent drillEvent = new DrillTableChangeEvent(this, true);
                        PhysicalTableSelector.this.fireDrillTableSelectionChanged(drillEvent);
                        PhysicalTableSelector.this.arrowButton2.setEnabled(false);
                    }
                }
                if (PhysicalTableSelector.this.treatAsDrillThru && genericButtonSelected) {
                    DrillTableChangeEvent drillEvent = new DrillTableChangeEvent(this, true);
                    PhysicalTableSelector.this.fireDrillTableSelectionChanged(drillEvent);
                }
                int size2 = PhysicalTableSelector.this.librariesAdded.size();
                for (int i = 0; i < size2; ++i) {
                    SimpleBrowseObjectTreeNode nextNode = (SimpleBrowseObjectTreeNode)PhysicalTableSelector.this.librariesAdded.get(i);
                    TreePath libraryPath = new TreePath(nextNode.getPath());
                    currentTree.collapsePath(libraryPath);
                    currentTree.expandPath(libraryPath);
                }
            }
        }
    }

    private class DeleteTableListener
    implements ActionListener {
        private DeleteTableListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int i;
            DrillTableChangeEvent drillEvent;
            PhysicalTableSelector.this.librariesAdded.clear();
            boolean genericDeleteSelected = event.getSource().equals(PhysicalTableSelector.this.deleteGeneric);
            TreePath[] chosenPaths = null;
            DefaultTreeModel genericModel = null;
            JTree currentTree = null;
            if (genericDeleteSelected) {
                chosenPaths = PhysicalTableSelector.this.genericTree.getSelectionPaths();
                genericModel = PhysicalTableSelector.this.genericTableModel;
                PhysicalTableSelector.this.arrowButton.setEnabled(true);
                currentTree = PhysicalTableSelector.this.genericTree;
                if ((PhysicalTableSelector.this.m_inputDrill || PhysicalTableSelector.this.sharedDim != null) && chosenPaths != null && chosenPaths.length == 1) {
                    try {
                        if (PhysicalTableSelector.this.m_inputDrill && PhysicalTableSelector.this.measureSet.getMeasures().size() > 0) {
                            MessageUtil.displayMessage((String)m_bundle.getString("PhysicalTableSelector.Warning.MappingMeasures.txt"), (String)m_bundle.getString("PhysicalTableSelector.MappingMeasures.window.title"), (int)2);
                        } else if (PhysicalTableSelector.this.sharedDim != null && PhysicalTableSelector.this.sharedDim.hasStructure() && PhysicalTableSelector.this.m_displayMapButton) {
                            MessageUtil.displayMessage((String)m_bundle.getString("PhysicalTableSelector.Warning.MappingLevels.txt"), (String)m_bundle.getString("PhysicalTableSelector.MappingLevels.window.title"), (int)2);
                        }
                    }
                    catch (OLAPException oError) {
                        ExceptionHandler.handleException((Exception)((Object)oError));
                    }
                }
                if (PhysicalTableSelector.this.treatAsDrillThru) {
                    drillEvent = new DrillTableChangeEvent(this, false);
                    PhysicalTableSelector.this.fireDrillTableSelectionChanged(drillEvent);
                }
            } else {
                chosenPaths = PhysicalTableSelector.this.drillTree.getSelectionPaths();
                genericModel = PhysicalTableSelector.this.drillTableModel;
                PhysicalTableSelector.this.arrowButton2.setEnabled(true);
                currentTree = PhysicalTableSelector.this.drillTree;
                drillEvent = new DrillTableChangeEvent(this, false);
                PhysicalTableSelector.this.fireDrillTableSelectionChanged(drillEvent);
            }
            PhysicalTableSelector.this.dataChanged = true;
            int size = chosenPaths.length;
            for (i = 0; i < size; ++i) {
                SimpleBrowseObjectTreeNode selectedNode;
                SimpleBrowseObject selectedBrowseObject;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)chosenPaths[i].getLastPathComponent();
                if (node == null) {
                    return;
                }
                if (!(node instanceof SimpleBrowseObjectTreeNode) || !(selectedBrowseObject = (selectedNode = (SimpleBrowseObjectTreeNode)node).getSimpleBrowseObject()).getPublicType().equals("Table")) continue;
                String fqid = selectedBrowseObject.getID();
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectedNode.getParent();
                if (!PhysicalTableSelector.this.librariesAdded.contains(parentNode)) {
                    PhysicalTableSelector.this.librariesAdded.add(parentNode);
                }
                SimpleBrowseObjectTreeNode simpleBrowseObject = (SimpleBrowseObjectTreeNode)parentNode;
                SimpleBrowseObject browseObject = simpleBrowseObject.getSimpleBrowseObject();
                String parentId = browseObject.getID();
                PhysicalTableSelector.this.usedTables.remove(fqid);
                if (PhysicalTableSelector.this.m_maxToSelect == -1) {
                    InventoryTree tree = PhysicalTableSelector.this.treePanel.getInventoryTree();
                    OLAPInventoryTreeModel model = (OLAPInventoryTreeModel)tree.getModel();
                    List listOfNodes = model.findNodes(fqid);
                    int sizeNodes = listOfNodes.size();
                    for (int t = 0; t < sizeNodes; ++t) {
                        SimpleBrowseObjectTreeNode inventoryUnGray = (SimpleBrowseObjectTreeNode)listOfNodes.get(t);
                        inventoryUnGray.setEditable(true);
                        model.reload((TreeNode)inventoryUnGray);
                    }
                    FoldersTree folderTree = PhysicalTableSelector.this.treePanel.getFolderTree();
                    OLAPFolderTreeModel folderModel = (OLAPFolderTreeModel)folderTree.getModel();
                    List listOfFolderNodes = folderModel.findNodes(fqid);
                    int sizeNodes2 = listOfFolderNodes.size();
                    for (int t = 0; t < sizeNodes2; ++t) {
                        SimpleBrowseObjectTreeNode folderUnGray = (SimpleBrowseObjectTreeNode)listOfFolderNodes.get(t);
                        folderUnGray.setEditable(true);
                        folderModel.reload((TreeNode)folderUnGray);
                    }
                }
                genericModel.removeNodeFromParent((MutableTreeNode)selectedNode);
                if (parentNode.getChildCount() != 0) continue;
                genericModel.removeNodeFromParent(parentNode);
            }
            size = PhysicalTableSelector.this.librariesAdded.size();
            for (i = 0; i < size; ++i) {
                SimpleBrowseObjectTreeNode nextNode = (SimpleBrowseObjectTreeNode)PhysicalTableSelector.this.librariesAdded.get(i);
                TreePath libraryPath = new TreePath(nextNode.getPath());
                currentTree.collapsePath(libraryPath);
                currentTree.expandPath(libraryPath);
            }
        }
    }

    private class TableOptionsListener
    implements ActionListener {
        private TableOptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CubeTableOptionsPanel pnl = null;
            WAStandardDialog dlg = null;
            WAStandardDialog parent = (WAStandardDialog)PhysicalTableSelector.this.getTopLevelAncestor();
            boolean genericOptionsSelected = event.getSource().equals(PhysicalTableSelector.this.tableOptionsGeneric);
            if (genericOptionsSelected) {
                pnl = new CubeTableOptionsPanel(PhysicalTableSelector.this.m_strTableOptions);
                dlg = new WAStandardDialog((Dialog)parent, m_bundle.getString("PhysicalTableSelector.TableOptionsDialog.Title.txt"), true, (WAPanel)pnl);
            } else {
                pnl = new CubeTableOptionsPanel(PhysicalTableSelector.this.m_strDrillTableOptions);
                dlg = new WAStandardDialog((Dialog)parent, m_bundle.getString("PhysicalTableSelected.TableOptions.Drill.window.title"), true, (WAPanel)pnl);
            }
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                PhysicalTableSelector.this.dataChanged = true;
                if (genericOptionsSelected) {
                    PhysicalTableSelector.this.m_strTableOptions = pnl.getOptions();
                } else {
                    PhysicalTableSelector.this.m_strDrillTableOptions = pnl.getOptions();
                }
            }
        }
    }
}

