/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PerformanceOptionsPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(PerformanceOptionsPanel.class);
    public static final String ON = bundle.getString("PerformanceOptions.on_value.txt");
    public static final String OFF = bundle.getString("PerformanceOptions.off_value.txt");
    private Vector dataPaths;
    private Vector indexPaths;
    private WAIntTextField partsizeText;
    private WAIntTextField segsizeText;
    private WAComboBox datapathText;
    private WAComboBox indexpathText;
    private WAIntTextField indexsortsizeText;
    private WAIntTextField maxthreadsText;
    private WAIntTextField concurrentText;
    private WAComboBox compressSelection;
    private WAComboBox indexSelection;
    private Integer originalIndexSortSize;
    private Integer originalConcurrent;
    private Integer originalMaxThreads;
    private boolean tuning;
    private Integer currentIndexSortSize;
    private Integer currentConcurrent;
    private Integer currentMaxThreads;
    private List sharedOptions;
    private boolean isAggregationTuning;
    private JSpinner asyncindexSpin;

    public PerformanceOptionsPanel(AbstractOLAPModel olapObject, Vector inputDataPaths, Vector inputIndexPaths, boolean istuning, Integer oindexSortSize, Integer oconcurrent, Integer omaxThreads, List optionList, boolean isAggrTuning) {
        this.dataPaths = inputDataPaths;
        this.indexPaths = inputIndexPaths;
        this.originalIndexSortSize = oindexSortSize;
        this.originalConcurrent = oconcurrent;
        this.originalMaxThreads = omaxThreads;
        this.tuning = istuning;
        this.sharedOptions = optionList;
        this.isAggregationTuning = isAggrTuning;
        this.layoutWidgets(olapObject);
    }

    public boolean validateData() {
        boolean dataOK = true;
        if (this.tuning) {
            String value = this.getIndexSortSize();
            if (Utilities.isBlank((String)value) && this.originalIndexSortSize != null) {
                dataOK = false;
                this.indexsortsizeText.setText(this.currentIndexSortSize.toString());
            }
            if (Utilities.isBlank((String)(value = this.getConcurrent())) && this.originalConcurrent != null) {
                dataOK = false;
                this.concurrentText.setText(this.currentConcurrent.toString());
            }
            if (Utilities.isBlank((String)(value = this.getMaxThreads())) && this.originalMaxThreads != null) {
                dataOK = false;
                this.maxthreadsText.setText(this.currentMaxThreads.toString());
            }
            if (!dataOK) {
                MessageUtil.displayMessage((String)bundle.getString("PerformanceOptions.CannotSetDefault.txt"), (int)0);
            }
        }
        return dataOK;
    }

    protected void layoutWidgets(AbstractOLAPModel olapObject) {
        String label;
        this.setLayout(new GridBagLayout());
        int numberOfTuningAggregationsToAdd = 0;
        if (olapObject instanceof OLAPCube) {
            if (this.isAggregationTuning) {
                OLAPCube oCube = (OLAPCube)olapObject;
                numberOfTuningAggregationsToAdd = oCube.getAggregationSet().getAddedAggregations().size();
            }
            JLabel indexsortsizeLabel = new JLabel();
            label = bundle.getString("PerformanceOptions.IndexSortSize.txt");
            VisualUtilities.setLabelTextAndMnemonic(indexsortsizeLabel, label);
            this.indexsortsizeText = new WAIntTextField();
            this.indexsortsizeText.setHorizontalAlignment(2);
            this.indexsortsizeText.setColumns(10);
            this.indexsortsizeText.setMaxCharacters(10);
            indexsortsizeLabel.setLabelFor((Component)this.indexsortsizeText);
            this.indexsortsizeText.setName("PerformanceOptionsIndexSortSizeField");
            this.add(indexsortsizeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.indexsortsizeText, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
            if (this.isAggregationTuning && numberOfTuningAggregationsToAdd == 0) {
                indexsortsizeLabel.setEnabled(false);
                this.indexsortsizeText.setEnabled(false);
            }
            JLabel maxthreadsLabel = new JLabel();
            label = bundle.getString("PerformanceOptions.MaxThreads.txt");
            VisualUtilities.setLabelTextAndMnemonic(maxthreadsLabel, label);
            this.maxthreadsText = new WAIntTextField();
            this.maxthreadsText.setHorizontalAlignment(2);
            this.maxthreadsText.setColumns(10);
            this.maxthreadsText.setMaxCharacters(10);
            maxthreadsLabel.setLabelFor((Component)this.maxthreadsText);
            this.maxthreadsText.setName("PerformanceOptionsMaxThreadsField");
            this.add(maxthreadsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.maxthreadsText, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
            if (this.isAggregationTuning && numberOfTuningAggregationsToAdd == 0) {
                maxthreadsLabel.setEnabled(false);
                this.maxthreadsText.setEnabled(false);
            }
            JLabel concurrentLabel = new JLabel();
            label = bundle.getString("PerformanceOptions.Concurrent.txt");
            VisualUtilities.setLabelTextAndMnemonic(concurrentLabel, label);
            this.concurrentText = new WAIntTextField();
            this.concurrentText.setHorizontalAlignment(2);
            this.concurrentText.setColumns(10);
            this.concurrentText.setMaxCharacters(10);
            concurrentLabel.setLabelFor((Component)this.concurrentText);
            this.concurrentText.setName("PerformanceOptionsConcurrentField");
            this.add(concurrentLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
            this.add((Component)this.concurrentText, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
            if (this.isAggregationTuning && numberOfTuningAggregationsToAdd == 0) {
                concurrentLabel.setEnabled(false);
                this.concurrentText.setEnabled(false);
            }
        }
        JLabel datapathLabel = new JLabel();
        label = bundle.getString("PerformanceOptions.DataPath.txt");
        VisualUtilities.setLabelTextAndMnemonic(datapathLabel, label);
        this.add(datapathLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.datapathText = new WAComboBox();
        if (this.dataPaths != null) {
            this.datapathText.addItems(this.dataPaths.toArray());
        }
        this.datapathText.getTextComponent().setHorizontalAlignment(2);
        this.datapathText.setEditable(true);
        datapathLabel.setLabelFor((Component)this.datapathText);
        this.datapathText.setName("PerformanceOptionsDataPathField");
        datapathLabel.setEnabled(!this.tuning);
        this.datapathText.setEnabled(!this.tuning);
        this.add((Component)this.datapathText, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        JLabel partsizeLabel = new JLabel();
        label = bundle.getString("PerformanceOptions.Partsize.txt");
        VisualUtilities.setLabelTextAndMnemonic(partsizeLabel, label);
        this.partsizeText = new WAIntTextField();
        this.partsizeText.setHorizontalAlignment(2);
        this.partsizeText.setColumns(10);
        this.partsizeText.setMaxCharacters(10);
        partsizeLabel.setLabelFor((Component)this.partsizeText);
        this.partsizeText.setName("PerformanceOptionsPartSizeField");
        partsizeLabel.setEnabled(!this.tuning);
        this.partsizeText.setEnabled(!this.tuning);
        this.add(partsizeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.partsizeText, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        this.compressSelection = new WAComboBox();
        JLabel compressLabel = new JLabel();
        this.compressSelection.setName("compressCombo");
        label = bundle.getString("PerformanceOptions.Compress.txt");
        VisualUtilities.setLabelTextAndMnemonic(compressLabel, label);
        compressLabel.setLabelFor((Component)this.compressSelection);
        compressLabel.setEnabled(!this.tuning);
        this.compressSelection.setEnabled(!this.tuning);
        this.add(compressLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.compressSelection, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        this.indexSelection = new WAComboBox();
        JLabel indexLabel = new JLabel();
        this.indexSelection.setName("indexCombo");
        label = bundle.getString("PerformanceOptions.Index.txt");
        VisualUtilities.setLabelTextAndMnemonic(indexLabel, label);
        indexLabel.setLabelFor((Component)this.indexSelection);
        indexLabel.setEnabled(!this.tuning);
        this.indexSelection.setEnabled(!this.tuning);
        this.add(indexLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.indexSelection, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        JLabel indexpathLabel = new JLabel();
        label = bundle.getString("PerformanceOptions.IndexPath.txt");
        VisualUtilities.setLabelTextAndMnemonic(indexpathLabel, label);
        indexpathLabel.setEnabled(!this.tuning);
        this.add(indexpathLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.indexpathText = new WAComboBox();
        if (this.indexPaths != null) {
            this.indexpathText.addItems(this.indexPaths.toArray());
        }
        this.indexpathText.getTextComponent().setHorizontalAlignment(2);
        this.indexpathText.setEditable(true);
        indexpathLabel.setLabelFor((Component)this.indexpathText);
        this.indexpathText.setName("PerformanceOptionsIndexPathField");
        indexpathLabel.setEnabled(!this.tuning);
        this.indexpathText.setEnabled(!this.tuning);
        this.add((Component)this.indexpathText, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        JLabel segsizeLabel = new JLabel();
        label = bundle.getString("PerformanceOptions.Segsize.txt");
        VisualUtilities.setLabelTextAndMnemonic(segsizeLabel, label);
        this.segsizeText = new WAIntTextField();
        this.segsizeText.setHorizontalAlignment(2);
        this.segsizeText.setColumns(10);
        this.segsizeText.setMaxCharacters(10);
        segsizeLabel.setLabelFor((Component)this.segsizeText);
        this.segsizeText.setName("PerformanceOptionsSegSizeField");
        segsizeLabel.setEnabled(!this.tuning);
        this.segsizeText.setEnabled(!this.tuning);
        this.add(segsizeLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)this.segsizeText, new GridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 10, 0), 0, 0));
        if (olapObject instanceof OLAPCube) {
            JLabel asyncindexLabel = new JLabel();
            label = bundle.getString("PerformanceOptions.Asyncindex.txt");
            VisualUtilities.setLabelTextAndMnemonic(asyncindexLabel, label);
            SpinnerNumberModel spinModel = new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1);
            this.asyncindexSpin = new JSpinner(spinModel);
            asyncindexLabel.setLabelFor(this.asyncindexSpin);
            this.asyncindexSpin.setName("PerformanceOptionsAsyncindexField");
            asyncindexLabel.setEnabled(!this.tuning);
            this.asyncindexSpin.setEnabled(!this.tuning);
            this.add(asyncindexLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            asyncindexLabel.setLabelFor(this.asyncindexSpin);
            this.add(this.asyncindexSpin, new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 10, 0, 0), 0, 0));
        }
        try {
            if (olapObject instanceof OLAPCube) {
                this.compressSelection.insertItemAt((Object)ON, 0);
                this.compressSelection.insertItemAt((Object)OFF, 1);
                this.indexSelection.insertItemAt((Object)ON, 0);
                this.indexSelection.insertItemAt((Object)OFF, 1);
                this.setValues((OLAPCube)olapObject);
            } else {
                this.compressSelection.insertItemAt((Object)" ", 0);
                this.compressSelection.insertItemAt((Object)ON, 1);
                this.compressSelection.insertItemAt((Object)OFF, 2);
                this.indexSelection.insertItemAt((Object)" ", 0);
                this.indexSelection.insertItemAt((Object)ON, 1);
                this.indexSelection.insertItemAt((Object)OFF, 2);
                this.setValues((OLAPAggregation)olapObject, null);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    private void updatePathVector(Vector pathVector, String newpath) {
        if (pathVector != null && newpath != null && !pathVector.contains(newpath)) {
            pathVector.add(0, newpath);
            if (pathVector.size() > VisualUtilities.MAX_PATHS) {
                pathVector.remove(VisualUtilities.MAX_PATHS);
            }
        }
    }

    public void setValues(OLAPAggregation aggregation, HashMap aggrValues) throws OLAPException {
        this.partsizeText.setText("");
        this.segsizeText.setText("");
        if (aggregation != null) {
            Integer partsize = null;
            if (aggrValues == null || !aggrValues.containsKey("PARTSIZE")) {
                partsize = aggregation.getPerformanceOptionPartsize();
            } else if (aggrValues.containsKey("PARTSIZE")) {
                partsize = (Integer)aggrValues.get("PARTSIZE");
            }
            if (partsize != null) {
                this.partsizeText.setText(partsize.toString());
            }
            Integer segsize = null;
            if (aggrValues == null || !aggrValues.containsKey("SEGSIZE")) {
                segsize = aggregation.getPerformanceOptionSegsize();
            } else if (aggrValues.containsKey("SEGSIZE")) {
                segsize = (Integer)aggrValues.get("SEGSIZE");
            }
            if (segsize != null) {
                this.segsizeText.setText(segsize.toString());
            }
            String datapath = null;
            if (aggrValues == null || !aggrValues.containsKey("DATAPATH")) {
                datapath = aggregation.getPerformanceOptionDatapath();
            } else if (aggrValues.containsKey("DATAPATH")) {
                datapath = (String)aggrValues.get("DATAPATH");
            }
            this.datapathText.removeAllItems();
            this.updatePathVector(this.dataPaths, datapath);
            if (this.dataPaths != null) {
                this.datapathText.addItems(this.dataPaths.toArray());
            }
            if (datapath != null) {
                this.datapathText.setSelectedItem((Object)datapath);
            } else {
                this.datapathText.setSelectedIndex(-1);
            }
            this.indexpathText.removeAllItems();
            String indexpath = null;
            if (aggrValues == null || !aggrValues.containsKey("INDEXPATH")) {
                indexpath = aggregation.getPerformanceOptionIndexpath();
            } else if (aggrValues.containsKey("INDEXPATH")) {
                indexpath = (String)aggrValues.get("INDEXPATH");
            }
            this.updatePathVector(this.indexPaths, indexpath);
            if (this.indexPaths != null) {
                this.indexpathText.addItems(this.indexPaths.toArray());
            }
            if (indexpath != null) {
                this.indexpathText.setSelectedItem((Object)indexpath);
            } else {
                this.indexpathText.setSelectedIndex(-1);
            }
            Boolean compress = null;
            if (aggrValues == null || !aggrValues.containsKey("COMPRESS")) {
                compress = aggregation.getPerformanceOptionCompress();
            } else if (aggrValues.containsKey("COMPRESS")) {
                compress = (Boolean)aggrValues.get("COMPRESS");
            }
            if (compress != null) {
                if (compress.booleanValue()) {
                    this.compressSelection.setSelectedItem((Object)ON);
                } else {
                    this.compressSelection.setSelectedItem((Object)OFF);
                }
            } else {
                this.compressSelection.setSelectedIndex(0);
            }
            Boolean index = null;
            if (aggrValues == null || !aggrValues.containsKey("INDEX")) {
                index = aggregation.getPerformanceOptionIndex();
            } else if (aggrValues.containsKey("INDEX")) {
                index = (Boolean)aggrValues.get("INDEX");
            }
            if (index != null) {
                if (index.booleanValue()) {
                    this.indexSelection.setSelectedItem((Object)ON);
                } else {
                    this.indexSelection.setSelectedItem((Object)OFF);
                }
            } else {
                this.indexSelection.setSelectedIndex(0);
            }
        }
    }

    public void setValues(OLAPCube cube) throws OLAPException {
        Integer segsize;
        Integer partsize;
        this.currentIndexSortSize = cube.getPerformanceOptionIndexSortSize();
        if (this.currentIndexSortSize != null) {
            this.indexsortsizeText.setText(this.currentIndexSortSize.toString());
        }
        this.currentMaxThreads = cube.getPerformanceOptionMaxThreads();
        if (this.currentMaxThreads != null) {
            this.maxthreadsText.setText(this.currentMaxThreads.toString());
        }
        this.currentConcurrent = cube.getPerformanceOptionConcurrent();
        if (this.currentConcurrent != null) {
            this.concurrentText.setText(this.currentConcurrent.toString());
        }
        if ((partsize = cube.getPerformanceOptionPartsize()) != null) {
            this.partsizeText.setText(partsize.toString());
        }
        if ((segsize = cube.getPerformanceOptionSegsize()) != null) {
            this.segsizeText.setText(segsize.toString());
        }
        String datapath = cube.getPerformanceOptionDatapath();
        this.datapathText.removeAllItems();
        this.updatePathVector(this.dataPaths, datapath);
        if (this.dataPaths != null) {
            this.datapathText.addItems(this.dataPaths.toArray());
        }
        if (datapath != null) {
            this.datapathText.setSelectedItem((Object)datapath);
        } else {
            this.datapathText.setSelectedIndex(-1);
        }
        String indexpath = cube.getPerformanceOptionIndexpath();
        this.indexpathText.removeAllItems();
        this.updatePathVector(this.indexPaths, indexpath);
        if (this.indexPaths != null) {
            this.indexpathText.addItems(this.indexPaths.toArray());
        }
        if (indexpath != null) {
            this.indexpathText.setSelectedItem((Object)indexpath);
        } else {
            this.indexpathText.setSelectedIndex(-1);
        }
        Boolean compress = cube.getPerformanceOptionCompress();
        if (compress == null) {
            this.compressSelection.setSelectedItem((Object)OFF);
        } else if (compress.booleanValue()) {
            this.compressSelection.setSelectedItem((Object)ON);
        } else {
            this.compressSelection.setSelectedItem((Object)OFF);
        }
        Boolean index = cube.getPerformanceOptionIndex();
        if (index == null) {
            this.indexSelection.setSelectedItem((Object)ON);
        } else if (index.booleanValue()) {
            this.indexSelection.setSelectedItem((Object)ON);
        } else {
            this.indexSelection.setSelectedItem((Object)OFF);
        }
        Integer asyncindexlimit = cube.getPerformanceOptionAsyncIndexLimit();
        if (asyncindexlimit != null) {
            this.asyncindexSpin.setValue(asyncindexlimit);
        }
    }

    public String getPartsize() {
        return this.partsizeText.getText();
    }

    public String getSegsize() {
        return this.segsizeText.getText();
    }

    public String getDatapath() {
        return this.datapathText.getText();
    }

    public String getIndexpath() {
        return this.indexpathText.getText();
    }

    public String getIndexSortSize() {
        return this.indexsortsizeText.getText();
    }

    public String getMaxThreads() {
        return this.maxthreadsText.getText();
    }

    public String getConcurrent() {
        return this.concurrentText.getText();
    }

    public String getCompress() {
        return (String)this.compressSelection.getSelectedItem();
    }

    public String getIndex() {
        return (String)this.indexSelection.getSelectedItem();
    }

    public String getAsyncIndexLimit() {
        return this.asyncindexSpin.getValue().toString();
    }

    public void refreshDropDownLists(OLAPCube cube) {
        try {
            int currentIndex = this.compressSelection.getSelectedIndex();
            if (this.compressSelection.getItemCount() > 2) {
                this.compressSelection.removeItemAt(0);
            }
            Boolean cubeCompress = null;
            if (this.sharedOptions != null && this.sharedOptions.size() > 0) {
                int index = this.sharedOptions.indexOf("COMPRESS");
                cubeCompress = (Boolean)this.sharedOptions.get(index + 1);
            } else {
                cubeCompress = cube.getPerformanceOptionCompress();
            }
            String value = cubeCompress != null && cubeCompress != false ? bundle.getString("PerformanceOptions.on_value.txt") : bundle.getString("PerformanceOptions.off_value.txt");
            String global = bundle.formatString("PerformanceOptions.global_value.fmt.txt", (Object)value);
            this.compressSelection.insertItemAt((Object)global, 0);
            this.compressSelection.setSelectedIndex(currentIndex);
            currentIndex = this.indexSelection.getSelectedIndex();
            if (this.indexSelection.getItemCount() > 2) {
                this.indexSelection.removeItemAt(0);
            }
            Boolean cubeIndex = null;
            if (this.sharedOptions != null && this.sharedOptions.size() > 0) {
                int index = this.sharedOptions.indexOf("INDEX");
                cubeIndex = (Boolean)this.sharedOptions.get(index + 1);
            } else {
                cubeIndex = cube.getPerformanceOptionIndex();
            }
            value = cubeIndex == null || cubeIndex != false ? bundle.getString("PerformanceOptions.on_value.txt") : bundle.getString("PerformanceOptions.off_value.txt");
            global = bundle.formatString("PerformanceOptions.global_value.fmt.txt", (Object)value);
            this.indexSelection.insertItemAt((Object)global, 0);
            this.indexSelection.setSelectedIndex(currentIndex);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }
}

