/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.utilities.studio;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.PerformanceOptionsPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;

public class PerformanceDefaultOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(PerformanceDefaultOptionsTab.class);
    private OLAPCube olapCube;
    private Vector dataPaths;
    private Vector indexPaths;
    private PerformanceOptionsPanel options;
    private boolean isTuning;
    private List sharedOptions;
    private boolean isAggregationTuning = false;

    public PerformanceDefaultOptionsTab(OLAPCube inputOlapCube, Vector globalDataPaths, Vector globalIndexPaths, boolean tuning, Integer oIndexSortSize, Integer oConcurrent, Integer oMaxThreads, List optionList, boolean isAggrTuning) {
        this.dataPaths = globalDataPaths;
        this.indexPaths = globalIndexPaths;
        this.olapCube = inputOlapCube;
        this.isTuning = tuning;
        this.sharedOptions = optionList;
        this.isAggregationTuning = isAggrTuning;
        this.initialize(tuning, oIndexSortSize, oConcurrent, oMaxThreads);
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    public void moveDataToStore() {
        if (this.sharedOptions != null) {
            this.sharedOptions.clear();
            this.sharedOptions.add("COMPRESS");
            String stringValue = this.options.getCompress();
            Boolean value = null;
            if (stringValue != null) {
                value = stringValue.equals(PerformanceOptionsPanel.ON);
            }
            this.sharedOptions.add(value);
            this.sharedOptions.add("INDEX");
            stringValue = this.options.getIndex();
            value = null;
            if (stringValue != null) {
                value = stringValue.equals(PerformanceOptionsPanel.ON);
            }
            this.sharedOptions.add(value);
        }
    }

    public void initialize(boolean tuning, Integer oIndexSortSize, Integer oConcurrent, Integer oMaxThreads) {
        this.setLayout(new GridBagLayout());
        JLabel topField = new JLabel(bundle.getString("PerformanceOptions.Default.instructions.txt"));
        this.add(topField, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.options = new PerformanceOptionsPanel((AbstractOLAPModel)this.olapCube, this.dataPaths, this.indexPaths, tuning, oIndexSortSize, oConcurrent, oMaxThreads, this.sharedOptions, this.isAggregationTuning);
        this.options.setName("optionsTable");
        this.add((Component)((Object)this.options), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_perf_global");
    }

    public boolean validateData() {
        boolean inputValid = this.options.validateData();
        if (inputValid) {
            try {
                String value = this.options.getIndexSortSize();
                if (!ModelUtilities.isBlank((String)value)) {
                    this.olapCube.verifyPerformanceOptionIndexsortsize(Integer.valueOf(value));
                }
                if (!ModelUtilities.isBlank((String)(value = this.options.getConcurrent()))) {
                    this.olapCube.verifyPerformanceOptionConcurrent(Integer.valueOf(value));
                }
                if (!ModelUtilities.isBlank((String)(value = this.options.getMaxThreads()))) {
                    this.olapCube.verifyPerformanceOptionMaxthreads(Integer.valueOf(value));
                }
                if (!this.isTuning) {
                    value = this.options.getPartsize();
                    if (!ModelUtilities.isBlank((String)value)) {
                        this.olapCube.verifyPerformanceOptionPartsize(Integer.valueOf(value));
                    }
                    if (!ModelUtilities.isBlank((String)(value = this.options.getSegsize()))) {
                        this.olapCube.verifyPerformanceOptionSegsize(Integer.valueOf(value));
                    }
                    if (!ModelUtilities.isBlank((String)(value = this.options.getAsyncIndexLimit()))) {
                        this.olapCube.verifyPerformanceOptionAsyncIndexLimit(Integer.valueOf(value));
                    }
                }
            }
            catch (IllegalArgumentException error) {
                MessageUtil.displayMessage((String)error.getLocalizedMessage(), (int)0);
                inputValid = false;
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        }
        return inputValid;
    }

    public void onParentOK() {
        String value = null;
        Integer newValue = null;
        try {
            value = this.options.getIndexSortSize();
            Integer indexsortsize = this.olapCube.getPerformanceOptionIndexSortSize();
            if (!ModelUtilities.isBlank((String)value)) {
                newValue = Integer.valueOf(value);
                if (!newValue.equals(indexsortsize)) {
                    this.olapCube.setPerformanceOptionIndexSortSize(newValue);
                }
            } else if (indexsortsize != null) {
                this.olapCube.setPerformanceOptionIndexSortSize(null);
            }
            value = this.options.getMaxThreads();
            Integer maxthreads = this.olapCube.getPerformanceOptionMaxThreads();
            if (!ModelUtilities.isBlank((String)value)) {
                newValue = Integer.valueOf(value);
                if (!newValue.equals(maxthreads)) {
                    this.olapCube.setPerformanceOptionMaxThreads(newValue);
                }
            } else if (maxthreads != null) {
                this.olapCube.setPerformanceOptionMaxThreads(null);
            }
            value = this.options.getConcurrent();
            Integer concurrent = this.olapCube.getPerformanceOptionConcurrent();
            if (!ModelUtilities.isBlank((String)value)) {
                newValue = Integer.valueOf(value);
                if (!newValue.equals(concurrent)) {
                    this.olapCube.setPerformanceOptionConcurrent(newValue);
                }
            } else if (concurrent != null) {
                this.olapCube.setPerformanceOptionConcurrent(null);
            }
            if (!this.isTuning) {
                value = this.options.getPartsize();
                Integer partsize = this.olapCube.getPerformanceOptionPartsize();
                if (!ModelUtilities.isBlank((String)value)) {
                    newValue = Integer.valueOf(value);
                    if (!newValue.equals(partsize)) {
                        this.olapCube.setPerformanceOptionPartsize(newValue);
                    }
                } else if (partsize != null) {
                    this.olapCube.setPerformanceOptionPartsize(null);
                }
                value = this.options.getSegsize();
                Integer segsize = this.olapCube.getPerformanceOptionSegsize();
                if (!ModelUtilities.isBlank((String)value)) {
                    newValue = Integer.valueOf(value);
                    if (!newValue.equals(segsize)) {
                        this.olapCube.setPerformanceOptionSegsize(newValue);
                    }
                } else if (segsize != null) {
                    this.olapCube.setPerformanceOptionSegsize(null);
                }
                value = this.options.getIndexpath();
                String indexpath = this.olapCube.getPerformanceOptionIndexpath();
                if (!ModelUtilities.isBlank((String)value)) {
                    if (!value.equals(indexpath)) {
                        this.olapCube.setPerformanceOptionIndexpath(value);
                        this.indexPaths.remove(value);
                        this.indexPaths.insertElementAt(ModelUtilities.trim((String)value), 0);
                        if (this.indexPaths.size() > VisualUtilities.MAX_PATHS) {
                            this.indexPaths.remove(VisualUtilities.MAX_PATHS);
                        }
                    }
                } else {
                    this.olapCube.setPerformanceOptionIndexpath(null);
                }
                value = this.options.getDatapath();
                String datapath = this.olapCube.getPerformanceOptionDatapath();
                if (!ModelUtilities.isBlank((String)value)) {
                    if (!value.equals(datapath)) {
                        this.olapCube.setPerformanceOptionDatapath(value);
                        this.dataPaths.remove(value);
                        this.dataPaths.insertElementAt(value, 0);
                        if (this.dataPaths.size() > VisualUtilities.MAX_PATHS) {
                            this.dataPaths.remove(VisualUtilities.MAX_PATHS);
                        }
                    }
                } else {
                    this.olapCube.setPerformanceOptionDatapath(null);
                }
                value = this.options.getCompress();
                Boolean compress = this.olapCube.getPerformanceOptionCompress();
                Boolean newSetting = value.equals(PerformanceOptionsPanel.ON);
                if (!newSetting.equals(compress)) {
                    this.olapCube.setPerformanceOptionCompress(newSetting);
                }
                value = this.options.getIndex();
                Boolean index = this.olapCube.getPerformanceOptionIndex();
                newSetting = value.equals(PerformanceOptionsPanel.ON);
                if (!newSetting.equals(index)) {
                    this.olapCube.setPerformanceOptionIndex(newSetting);
                }
                value = this.options.getAsyncIndexLimit();
                Integer asyncindexlimit = this.olapCube.getPerformanceOptionAsyncIndexLimit();
                if (!ModelUtilities.isBlank((String)value)) {
                    newValue = Integer.valueOf(value);
                    if (!newValue.equals(asyncindexlimit)) {
                        this.olapCube.setPerformanceOptionAsyncIndexLimit(newValue);
                    }
                } else if (asyncindexlimit != null) {
                    this.olapCube.setPerformanceOptionAsyncIndexLimit(null);
                }
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }
}

